<?php

if(!defined('ABSPATH')){
    exit;
}

return array(
    'af' => array(
        'code' => 'af',
        'locale' => 'af',
        'alt' => 'af_ZA',
        'name' => 'Afrikaans',
        'native' => 'Afrikaans',
        'dir' => 'ltr',
        'flag' => 'za',
        'continent' => 'Africa',
        'countries' => array(
            'na',
            'za',
        ),
        'currencies' => array(
            'NAD',
            'ZAR',
        ),
    ),
    'ar' => array(
        'code' => 'ar',
        'locale' => 'ar',
        'alt' => 'ar_AR',
        'name' => 'Arabic',
        'native' => 'العربية',
        'dir' => 'rtl',
        'flag' => 'ps',
        'continent' => 'Asia',
        'countries' => array(
            'ae',
            'bh',
            'dj',
            'dz',
            'eg',
            'er',
            'il',
            'iq',
            'jo',
            'km',
            'kw',
            'lb',
            'ly',
            'mr',
            'om',
            'ps',
            'qa',
            'sa',
            'sd',
            'so',
            'sy',
            'td',
            'tn',
            'ye',
        ),
        'currencies' => array(
            'AED',
            'BHD',
            'DJF',
            'DZD',
            'EGP',
            'ERN',
            'ILS',
            'IQD',
            'JOD',
            'KMF',
            'KWD',
            'LBP',
            'LYD',
            'MRO',
            'OMR',
            'QAR',
            'SAR',
            'SDG',
            'SOS',
            'SYP',
            'TND',
            'XAF',
            'YER',
        ),
    ),
    'ary' => array(
        'code' => 'ar',
        'locale' => 'ary',
        'alt' => 'ar_AR',
        'name' => 'Arabic',
        'native' => 'العربية المغربية',
        'dir' => 'rtl',
        'flag' => 'ma',
        'continent' => 'Africa',
        'countries' => array(
            'ma',
        ),
        'currencies' => array(
            'MAD',
        ),
    ),
    'as' => array(
        'code' => 'as',
        'locale' => 'as',
        'alt' => 'as_IN',
        'name' => 'Assamese',
        'native' => 'অসমীয়া',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'az' => array(
        'code' => 'az',
        'locale' => 'az',
        'alt' => 'az_AZ',
        'name' => 'Azerbaijani',
        'native' => 'Azərbaycan',
        'dir' => 'ltr',
        'flag' => 'az',
        'continent' => 'Asia',
        'countries' => array(
            'az',
        ),
        'currencies' => array(
            'AZN',
        ),
    ),
    'azb' => array(
        'code' => 'az',
        'locale' => 'azb',
        'alt' => 'azb',
        'name' => 'Azerbaijani',
        'native' => 'گؤنئی آذربایجان',
        'dir' => 'rtl',
        'flag' => 'az',
        'continent' => 'Asia',
        'countries' => array(
            'az',
        ),
        'currencies' => array(
            'AZN',
        ),
    ),
    'bel' => array(
        'code' => 'be',
        'locale' => 'bel',
        'alt' => 'be_BY',
        'name' => 'Belarusian',
        'native' => 'Беларуская мова',
        'dir' => 'ltr',
        'flag' => 'by',
        'continent' => 'Europe',
        'countries' => array(
            'by',
        ),
        'currencies' => array(
            'BYN',
            'BYR',
        ),
    ),
    'bg_BG' => array(
        'code' => 'bg',
        'locale' => 'bg_BG',
        'alt' => 'bg_BG',
        'name' => 'Bulgarian',
        'native' => 'български',
        'dir' => 'ltr',
        'flag' => 'bg',
        'continent' => 'Europe',
        'countries' => array(
            'bg',
        ),
        'currencies' => array(
            'BGN',
        ),
    ),
    'bn_BD' => array(
        'code' => 'bn',
        'locale' => 'bn_BD',
        'alt' => 'bn_IN',
        'name' => 'Bengali',
        'native' => 'বাংলা',
        'dir' => 'ltr',
        'flag' => 'bd',
        'continent' => 'Asia',
        'countries' => array(
            'bd',
        ),
        'currencies' => array(
            'BDT',
        ),
    ),
    'bo' => array(
        'code' => 'bo',
        'locale' => 'bo',
        'alt' => 'bo',
        'name' => 'Tibetan',
        'native' => 'བོད་ཡིག',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
        ),
        'currencies' => array(
            'CNY',
        ),
    ),
    'bs_BA' => array(
        'code' => 'bs',
        'locale' => 'bs_BA',
        'alt' => 'bs_BA',
        'name' => 'Bosnian',
        'native' => 'Bosanski',
        'dir' => 'ltr',
        'flag' => 'ba',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'me',
        ),
        'currencies' => array(
            'BAM',
            'EUR',
        ),
    ),
    'ca' => array(
        'code' => 'ca',
        'locale' => 'ca',
        'alt' => 'ca_ES',
        'name' => 'Catalan',
        'native' => 'Català',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'ad',
            'es',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'ceb' => array(
        'code' => 'ceb',
        'locale' => 'ceb',
        'alt' => 'cx_PH',
        'name' => 'Cebuano',
        'native' => 'Cebuano',
        'dir' => 'ltr',
        'flag' => 'ph',
        'continent' => 'Asia',
        'countries' => array(
            'ph',
        ),
        'currencies' => array(
            'PHP',
        ),
    ),
    'ckb' => array(
        'code' => 'ku',
        'locale' => 'ckb',
        'alt' => 'cb_IQ',
        'name' => 'Kurdish',
        'native' => 'کوردی',
        'dir' => 'rtl',
        'flag' => 'ir',
        'continent' => 'Asia',
        'countries' => array(
            'iq',
            'ir',
        ),
        'currencies' => array(
            'IQD',
            'IRR',
        ),
    ),
    'cs_CZ' => array(
        'code' => 'cs',
        'locale' => 'cs_CZ',
        'alt' => 'cs_CZ',
        'name' => 'Czech',
        'native' => 'Čeština',
        'dir' => 'ltr',
        'flag' => 'cz',
        'continent' => 'Europe',
        'countries' => array(
            'cz',
        ),
        'currencies' => array(
            'CZK',
        ),
    ),
    'cy' => array(
        'code' => 'cy',
        'locale' => 'cy',
        'alt' => 'cy_GB',
        'name' => 'Welsh',
        'native' => 'Cymraeg',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'GBP',
        ),
    ),
    'da_DK' => array(
        'code' => 'da',
        'locale' => 'da_DK',
        'alt' => 'da_DK',
        'name' => 'Danish',
        'native' => 'Dansk',
        'dir' => 'ltr',
        'flag' => 'dk',
        'continent' => 'Europe',
        'countries' => array(
            'dk',
        ),
        'currencies' => array(
            'DKK',
        ),
    ),
    'de_AT' => array(
        'code' => 'de',
        'locale' => 'de_AT',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'at',
        'continent' => 'Europe',
        'countries' => array(
            'at',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'de_CH' => array(
        'code' => 'de',
        'locale' => 'de_CH',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'ch',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
        ),
        'currencies' => array(
            'CHF',
        ),
    ),
    'de_CH_informal' => array(
        'code' => 'de',
        'locale' => 'de_CH_informal',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'ch',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
        ),
        'currencies' => array(
            'CHF',
        ),
    ),
    'de_DE' => array(
        'code' => 'de',
        'locale' => 'de_DE',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'be',
            'de',
            'li',
            'lu',
            'va',
        ),
        'currencies' => array(
            'CHF',
            'EUR',
        ),
    ),
    'de_DE_formal' => array(
        'code' => 'de',
        'locale' => 'de_DE_formal',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'dsb' => array(
        'code' => 'dsb',
        'locale' => 'dsb',
        'alt' => 'dsb',
        'name' => 'Lower Sorbian',
        'native' => 'Dolnoserbšćina',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'dzo' => array(
        'code' => 'dz',
        'locale' => 'dzo',
        'alt' => 'dzo',
        'name' => 'Dzongkha',
        'native' => 'རྫོང་ཁ',
        'dir' => 'ltr',
        'flag' => 'bt',
        'continent' => 'Asia',
        'countries' => array(
            'bt',
        ),
        'currencies' => array(
            'BTN',
            'INR',
        ),
    ),
    'el' => array(
        'code' => 'el',
        'locale' => 'el',
        'alt' => 'el_GR',
        'name' => 'Greek',
        'native' => 'Ελληνικά',
        'dir' => 'ltr',
        'flag' => 'gr',
        'continent' => 'Europe',
        'countries' => array(
            'cy',
            'gr',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'en_AU' => array(
        'code' => 'en',
        'locale' => 'en_AU',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'au',
        'continent' => 'Oceania',
        'countries' => array(
            'au',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'en_CA' => array(
        'code' => 'en',
        'locale' => 'en_CA',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'ca',
        'continent' => 'America',
        'countries' => array(
            'ca',
        ),
        'currencies' => array(
            'CAD',
        ),
    ),
    'en_GB' => array(
        'code' => 'en',
        'locale' => 'en_GB',
        'alt' => 'en_GB',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'GBP',
        ),
    ),
    'en_NZ' => array(
        'code' => 'en',
        'locale' => 'en_NZ',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'nz',
        'continent' => 'Oceania',
        'countries' => array(
            'nz',
        ),
        'currencies' => array(
            'NZD',
        ),
    ),
    'en_US' => array(
        'code' => 'en',
        'locale' => 'en_US',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'us',
        'continent' => 'America',
        'countries' => array(
            'ag',
            'ai',
            'as',
            'bb',
            'bm',
            'bs',
            'bw',
            'bz',
            'cc',
            'ck',
            'cm',
            'cx',
            'dm',
            'er',
            'et',
            'fj',
            'fk',
            'fm',
            'fo',
            'gd',
            'gh',
            'gi',
            'gl',
            'gm',
            'gu',
            'gy',
            'hk',
            'ie',
            'im',
            'in',
            'je',
            'jm',
            'ke',
            'ki',
            'kn',
            'ky',
            'lc',
            'lr',
            'ls',
            'mh',
            'mp',
            'ms',
            'mt',
            'mu',
            'mv',
            'mw',
            'na',
            'nf',
            'ng',
            'nr',
            'nu',
            'pg',
            'ph',
            'pk',
            'pr',
            'pw',
            'rw',
            'sb',
            'sc',
            'sd',
            'sg',
            'sh',
            'sl',
            'sz',
            'tc',
            'tk',
            'to',
            'tt',
            'tv',
            'tz',
            'ug',
            'us',
            'vc',
            'vg',
            'vi',
            'vu',
            'ws',
            'zm',
            'zw',
        ),
        'currencies' => array(
            'AUD',
            'BBD',
            'BMD',
            'BND',
            'BSD',
            'BWP',
            'BZD',
            'CKD',
            'CNY',
            'DKK',
            'ERN',
            'ETB',
            'EUR',
            'FJD',
            'FKP',
            'GBP',
            'GHS',
            'GIP',
            'GMD',
            'GYD',
            'HKD',
            'IMP[G]',
            'INR',
            'JEP[G]',
            'JMD',
            'JPY',
            'KES',
            'KYD',
            'LRD',
            'LSL',
            'MUR',
            'MVR',
            'MWK',
            'NAD',
            'NGN',
            'NZD',
            'PGK',
            'PHP',
            'PKR',
            'RWF',
            'SBD',
            'SCR',
            'SDG',
            'SGD',
            'SHP',
            'SLL',
            'SZL',
            'TOP',
            'TTD',
            'TVD[G]',
            'TZS',
            'UGX',
            'USD',
            'VUV',
            'WST',
            'XAF',
            'XCD',
            'ZAR',
            'ZMW',
        ),
    ),
    'en_ZA' => array(
        'code' => 'en',
        'locale' => 'en_ZA',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'za',
        'continent' => 'Africa',
        'countries' => array(
            'za',
        ),
        'currencies' => array(
            'ZAR',
        ),
    ),
    'es_AR' => array(
        'code' => 'es',
        'locale' => 'es_AR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'ar',
        'continent' => 'America',
        'countries' => array(
            'ar',
        ),
        'currencies' => array(
            'ARS',
        ),
    ),
    'es_CL' => array(
        'code' => 'es',
        'locale' => 'es_CL',
        'alt' => 'es_CL',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'cl',
        'continent' => 'America',
        'countries' => array(
            'cl',
        ),
        'currencies' => array(
            'CLP',
        ),
    ),
    'es_CO' => array(
        'code' => 'es',
        'locale' => 'es_CO',
        'alt' => 'es_CO',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'co',
        'continent' => 'America',
        'countries' => array(
            'co',
        ),
        'currencies' => array(
            'COP',
        ),
    ),
    'es_CR' => array(
        'code' => 'es',
        'locale' => 'es_CR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'cr',
        'continent' => 'America',
        'countries' => array(
            'cr',
        ),
        'currencies' => array(
            'CRC',
        ),
    ),
    'es_EC' => array(
        'code' => 'es',
        'locale' => 'es_EC',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'ec',
        'continent' => 'America',
        'countries' => array(
            'ec',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'es_ES' => array(
        'code' => 'es',
        'locale' => 'es_ES',
        'alt' => 'es_ES',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'bo',
            'bz',
            'cu',
            'do',
            'eh',
            'es',
            'gq',
            'gu',
            'hn',
            'ni',
            'pa',
            'py',
            'sv',
        ),
        'currencies' => array(
            'BOB',
            'BZD',
            'CUC',
            'CUP',
            'DOP',
            'DZD',
            'EUR',
            'HNL',
            'MAD',
            'NIO',
            'PAB',
            'PYG',
            'USD',
            'XAF',
        ),
    ),
    'es_GT' => array(
        'code' => 'es',
        'locale' => 'es_GT',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'gt',
        'continent' => 'America',
        'countries' => array(
            'gt',
        ),
        'currencies' => array(
            'GTQ',
        ),
    ),
    'es_MX' => array(
        'code' => 'es',
        'locale' => 'es_MX',
        'alt' => 'es_MX',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'mx',
        'continent' => 'America',
        'countries' => array(
            'mx',
        ),
        'currencies' => array(
            'MXN',
        ),
    ),
    'es_PE' => array(
        'code' => 'es',
        'locale' => 'es_PE',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'pe',
        'continent' => 'America',
        'countries' => array(
            'pe',
        ),
        'currencies' => array(
            'PEN',
        ),
    ),
    'es_PR' => array(
        'code' => 'es',
        'locale' => 'es_PR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'pr',
        'continent' => 'America',
        'countries' => array(
            'pr',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'es_UY' => array(
        'code' => 'es',
        'locale' => 'es_UY',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'uy',
        'continent' => 'America',
        'countries' => array(
            'uy',
        ),
        'currencies' => array(
            'UYU',
        ),
    ),
    'es_VE' => array(
        'code' => 'es',
        'locale' => 'es_VE',
        'alt' => 'es_VE',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 've',
        'continent' => 'America',
        'countries' => array(
            've',
        ),
        'currencies' => array(
            'VEF',
        ),
    ),
    'et' => array(
        'code' => 'et',
        'locale' => 'et',
        'alt' => 'et_EE',
        'name' => 'Estonian',
        'native' => 'Eesti',
        'dir' => 'ltr',
        'flag' => 'ee',
        'continent' => 'Europe',
        'countries' => array(
            'ee',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'eu' => array(
        'code' => 'eu',
        'locale' => 'eu',
        'alt' => 'eu_ES',
        'name' => 'Basque',
        'native' => 'Euskara',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'fr',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'fa_AF' => array(
        'code' => 'fa',
        'locale' => 'fa_AF',
        'alt' => 'fa_IR',
        'name' => 'Persian',
        'native' => 'فارسی',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'AFN',
        ),
    ),
    'fa_IR' => array(
        'code' => 'fa',
        'locale' => 'fa_IR',
        'alt' => 'fa_IR',
        'name' => 'Persian',
        'native' => 'فارسی',
        'dir' => 'rtl',
        'flag' => 'ir',
        'continent' => 'Asia',
        'countries' => array(
            'ir',
        ),
        'currencies' => array(
            'IRR',
        ),
    ),
    'fi' => array(
        'code' => 'fi',
        'locale' => 'fi',
        'alt' => 'fi_FI',
        'name' => 'Finnish',
        'native' => 'Suomi',
        'dir' => 'ltr',
        'flag' => 'fi',
        'continent' => 'Europe',
        'countries' => array(
            'fi',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'fr_BE' => array(
        'code' => 'fr',
        'locale' => 'fr_BE',
        'alt' => 'fr_FR',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'be',
        'continent' => 'Europe',
        'countries' => array(
            'be',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'fr_CA' => array(
        'code' => 'fr',
        'locale' => 'fr_CA',
        'alt' => 'fr_CA',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'ca',
        'continent' => 'America',
        'countries' => array(
            'ca',
        ),
        'currencies' => array(
            'CAD',
        ),
    ),
    'fr_FR' => array(
        'code' => 'fr',
        'locale' => 'fr_FR',
        'alt' => 'fr_FR',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'bf',
            'bi',
            'bj',
            'bl',
            'cd',
            'cf',
            'cg',
            'ch',
            'ci',
            'cm',
            'dj',
            'fr',
            'ga',
            'gf',
            'gn',
            'gp',
            'gq',
            'ht',
            'je',
            'km',
            'lb',
            'lu',
            'mc',
            'mg',
            'ml',
            'mq',
            'nc',
            'ne',
            'pf',
            'pm',
            're',
            'rw',
            'sc',
            'sn',
            'td',
            'tg',
            'va',
            'vu',
            'wf',
            'yt',
        ),
        'currencies' => array(
            'BIF',
            'CDF',
            'CHF',
            'DJF',
            'EUR',
            'GBP',
            'GNF',
            'HTG',
            'JEP[G]',
            'KMF',
            'LBP',
            'MGA',
            'RWF',
            'SCR',
            'VUV',
            'XAF',
            'XOF',
            'XPF',
        ),
    ),
    'fur' => array(
        'code' => 'fur',
        'locale' => 'fur',
        'alt' => 'fur',
        'name' => 'Fur',
        'native' => 'Furlan',
        'dir' => 'ltr',
        'flag' => 'it',
        'continent' => 'Europe',
        'countries' => array(
            'it',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'gd' => array(
        'code' => 'gd',
        'locale' => 'gd',
        'alt' => 'gd',
        'name' => 'Scottish Gaelic',
        'native' => 'Gàidhlig',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'GBP',
        ),
    ),
    'gl_ES' => array(
        'code' => 'gl',
        'locale' => 'gl_ES',
        'alt' => 'gl_ES',
        'name' => 'Galician',
        'native' => 'Galego',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'es',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'gu' => array(
        'code' => 'gu',
        'locale' => 'gu',
        'alt' => 'gu_IN',
        'name' => 'Gujarati',
        'native' => 'ગુજરાતી',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'haz' => array(
        'code' => 'haz',
        'locale' => 'haz',
        'alt' => 'haz',
        'name' => 'Hazaragi',
        'native' => 'هزاره گی',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'AFN',
        ),
    ),
    'he_IL' => array(
        'code' => 'he',
        'locale' => 'he_IL',
        'alt' => 'he_IL',
        'name' => 'Hebrew',
        'native' => 'עברית',
        'dir' => 'rtl',
        'flag' => 'il',
        'continent' => 'Asia',
        'countries' => array(
            'il',
        ),
        'currencies' => array(
            'ILS',
        ),
    ),
    'hi_IN' => array(
        'code' => 'hi',
        'locale' => 'hi_IN',
        'alt' => 'hi_IN',
        'name' => 'Hindi',
        'native' => 'हिन्दी',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'fj',
            'in',
        ),
        'currencies' => array(
            'FJD',
            'INR',
        ),
    ),
    'hr' => array(
        'code' => 'hr',
        'locale' => 'hr',
        'alt' => 'hr_HR',
        'name' => 'Croatian',
        'native' => 'Hrvatski',
        'dir' => 'ltr',
        'flag' => 'hr',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'hr',
            'me',
        ),
        'currencies' => array(
            'BAM',
            'EUR',
            'HRK',
        ),
    ),
    'hsb' => array(
        'code' => 'hsb',
        'locale' => 'hsb',
        'alt' => 'hsb',
        'name' => 'Upper Sorbian',
        'native' => 'Hornjoserbšćina',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'hu_HU' => array(
        'code' => 'hu',
        'locale' => 'hu_HU',
        'alt' => 'hu_HU',
        'name' => 'Hungarian',
        'native' => 'Magyar',
        'dir' => 'ltr',
        'flag' => 'hu',
        'continent' => 'Europe',
        'countries' => array(
            'hu',
        ),
        'currencies' => array(
            'HUF',
        ),
    ),
    'hy' => array(
        'code' => 'hy',
        'locale' => 'hy',
        'alt' => 'hy_AM',
        'name' => 'Armenian',
        'native' => 'Հայերեն',
        'dir' => 'ltr',
        'flag' => 'am',
        'continent' => 'Asia',
        'countries' => array(
            'am',
            'cy',
        ),
        'currencies' => array(
            'AMD',
            'EUR',
        ),
    ),
    'id_ID' => array(
        'code' => 'id',
        'locale' => 'id_ID',
        'alt' => 'id_ID',
        'name' => 'Indonesian',
        'native' => 'Bahasa Indonesia',
        'dir' => 'ltr',
        'flag' => 'id',
        'continent' => 'Asia',
        'countries' => array(
            'id',
        ),
        'currencies' => array(
            'IDR',
        ),
    ),
    'is_IS' => array(
        'code' => 'is',
        'locale' => 'is_IS',
        'alt' => 'is_IS',
        'name' => 'Icelandic',
        'native' => 'Íslenska',
        'dir' => 'ltr',
        'flag' => 'is',
        'continent' => 'Europe',
        'countries' => array(
            'is',
        ),
        'currencies' => array(
            'ISK',
        ),
    ),
    'it_IT' => array(
        'code' => 'it',
        'locale' => 'it_IT',
        'alt' => 'it_IT',
        'name' => 'Italian',
        'native' => 'Italiano',
        'dir' => 'ltr',
        'flag' => 'it',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
            'it',
            'sm',
            'va',
        ),
        'currencies' => array(
            'CHF',
            'EUR',
        ),
    ),
    'ja' => array(
        'code' => 'ja',
        'locale' => 'ja',
        'alt' => 'ja_JP',
        'name' => 'Japanese',
        'native' => '日本語',
        'dir' => 'ltr',
        'flag' => 'jp',
        'continent' => 'Asia',
        'countries' => array(
            'jp',
        ),
        'currencies' => array(
            'JPY',
        ),
    ),
    'jv_ID' => array(
        'code' => 'jv',
        'locale' => 'jv_ID',
        'alt' => 'jv_ID',
        'name' => 'Javanese',
        'native' => 'Basa Jawa',
        'dir' => 'ltr',
        'flag' => 'id',
        'continent' => 'Asia',
        'countries' => array(
            'id',
        ),
        'currencies' => array(
            'IDR',
        ),
    ),
    'ka_GE' => array(
        'code' => 'ka',
        'locale' => 'ka_GE',
        'alt' => 'ka_GE',
        'name' => 'Georgian',
        'native' => 'ქართული',
        'dir' => 'ltr',
        'flag' => 'ge',
        'continent' => 'Asia',
        'countries' => array(
            'ge',
        ),
        'currencies' => array(
            'GEL',
        ),
    ),
    'kab' => array(
        'code' => 'kab',
        'locale' => 'kab',
        'alt' => 'kab',
        'name' => 'Kabyle',
        'native' => 'Taqbaylit',
        'dir' => 'ltr',
        'flag' => 'dz',
        'continent' => 'Africa',
        'countries' => array(
            'dz',
        ),
        'currencies' => array(
            'DZD',
        ),
    ),
    'kk' => array(
        'code' => 'kk',
        'locale' => 'kk',
        'alt' => 'kk_KZ',
        'name' => 'Kazakh',
        'native' => 'Қазақ тілі',
        'dir' => 'ltr',
        'flag' => 'kz',
        'continent' => 'Asia',
        'countries' => array(
            'kz',
        ),
        'currencies' => array(
            'KZT',
        ),
    ),
    'km' => array(
        'code' => 'km',
        'locale' => 'km',
        'alt' => 'km_KH',
        'name' => 'Khmer',
        'native' => 'ភាសាខ្មែរ',
        'dir' => 'ltr',
        'flag' => 'kh',
        'continent' => 'Asia',
        'countries' => array(
            'kh',
        ),
        'currencies' => array(
            'KHR',
            'USD',
        ),
    ),
    'kn' => array(
        'code' => 'kn',
        'locale' => 'kn',
        'alt' => 'kn_IN',
        'name' => 'Kannada',
        'native' => 'ಕನ್ನಡ',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'ko_KR' => array(
        'code' => 'ko',
        'locale' => 'ko_KR',
        'alt' => 'ko_KR',
        'name' => 'Korean',
        'native' => '한국어',
        'dir' => 'ltr',
        'flag' => 'kr',
        'continent' => 'Asia',
        'countries' => array(
            'kp',
            'kr',
        ),
        'currencies' => array(
            'KPW',
            'KRW',
        ),
    ),
    'lo' => array(
        'code' => 'lo',
        'locale' => 'lo',
        'alt' => 'lo_LA',
        'name' => 'Lao',
        'native' => 'ພາສາລາວ',
        'dir' => 'ltr',
        'flag' => 'la',
        'continent' => 'Asia',
        'countries' => array(
            'la',
        ),
        'currencies' => array(
            'LAK',
        ),
    ),
    'lt_LT' => array(
        'code' => 'lt',
        'locale' => 'lt_LT',
        'alt' => 'lt_LT',
        'name' => 'Lithuanian',
        'native' => 'Lietuviškai',
        'dir' => 'ltr',
        'flag' => 'lt',
        'continent' => 'Europe',
        'countries' => array(
            'lt',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'lv' => array(
        'code' => 'lv',
        'locale' => 'lv',
        'alt' => 'lv_LV',
        'name' => 'Latvian',
        'native' => 'Latviešu valoda',
        'dir' => 'ltr',
        'flag' => 'lv',
        'continent' => 'Europe',
        'countries' => array(
            'lv',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'mk_MK' => array(
        'code' => 'mk',
        'locale' => 'mk_MK',
        'alt' => 'mk_MK',
        'name' => 'Macedonian',
        'native' => 'македонски јазик',
        'dir' => 'ltr',
        'flag' => 'mk',
        'continent' => 'Europe',
        'countries' => array(
            'mk',
        ),
        'currencies' => array(
            'MKD',
        ),
    ),
    'ml_IN' => array(
        'code' => 'ml',
        'locale' => 'ml_IN',
        'alt' => 'ml_IN',
        'name' => 'Malayalam',
        'native' => 'മലയാളം',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'mn' => array(
        'code' => 'mn',
        'locale' => 'mn',
        'alt' => 'mn_MN',
        'name' => 'Mongolian',
        'native' => 'Монгол хэл',
        'dir' => 'ltr',
        'flag' => 'mn',
        'continent' => 'Asia',
        'countries' => array(
            'mn',
        ),
        'currencies' => array(
            'MNT',
        ),
    ),
    'mr' => array(
        'code' => 'mr',
        'locale' => 'mr',
        'alt' => 'mr_IN',
        'name' => 'Marathi',
        'native' => 'मराठी',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'ms_MY' => array(
        'code' => 'ms',
        'locale' => 'ms_MY',
        'alt' => 'ms_MY',
        'name' => 'Malay',
        'native' => 'Bahasa Melayu',
        'dir' => 'ltr',
        'flag' => 'my',
        'continent' => 'Asia',
        'countries' => array(
            'bn',
            'my',
            'sg',
        ),
        'currencies' => array(
            'BND',
            'MYR',
            'SGD',
        ),
    ),
    'my_MM' => array(
        'code' => 'my',
        'locale' => 'my_MM',
        'alt' => 'my_MM',
        'name' => 'Burmese',
        'native' => 'ဗမာစာ',
        'dir' => 'ltr',
        'flag' => 'mm',
        'continent' => 'Asia',
        'countries' => array(
            'mm',
        ),
        'currencies' => array(
            'MMK',
        ),
    ),
    'nb_NO' => array(
        'code' => 'nb',
        'locale' => 'nb_NO',
        'alt' => 'nb_NO',
        'name' => 'Norwegian Bokmal',
        'native' => 'Norsk Bokmål',
        'dir' => 'ltr',
        'flag' => 'no',
        'continent' => 'Europe',
        'countries' => array(
            'no',
        ),
        'currencies' => array(
            'NOK',
        ),
    ),
    'ne_NP' => array(
        'code' => 'ne',
        'locale' => 'ne_NP',
        'alt' => 'ne_NP',
        'name' => 'Nepali',
        'native' => 'नेपाली',
        'dir' => 'ltr',
        'flag' => 'np',
        'continent' => 'Asia',
        'countries' => array(
            'np',
        ),
        'currencies' => array(
            'NPR',
        ),
    ),
    'nl_BE' => array(
        'code' => 'nl',
        'locale' => 'nl_BE',
        'alt' => 'nl_BE',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'be',
        'continent' => 'Europe',
        'countries' => array(
            'be',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'nl_NL' => array(
        'code' => 'nl',
        'locale' => 'nl_NL',
        'alt' => 'nl_NL',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'nl',
        'continent' => 'Europe',
        'countries' => array(
            'aw',
            'nl',
            'sr',
        ),
        'currencies' => array(
            'AWG',
            'EUR',
            'SRD',
        ),
    ),
    'nl_NL_formal' => array(
        'code' => 'nl',
        'locale' => 'nl_NL_formal',
        'alt' => 'nl_NL',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'nl',
        'continent' => 'Europe',
        'countries' => array(
            'nl',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'nn_NO' => array(
        'code' => 'nn',
        'locale' => 'nn_NO',
        'alt' => 'nn_NO',
        'name' => 'Norwegian Nynorsk',
        'native' => 'Norsk Nynorsk',
        'dir' => 'ltr',
        'flag' => 'no',
        'continent' => 'Europe',
        'countries' => array(
            'no',
        ),
        'currencies' => array(
            'NOK',
        ),
    ),
    'oci' => array(
        'code' => 'oc',
        'locale' => 'oci',
        'alt' => 'oci',
        'name' => 'Occitan',
        'native' => 'Occitan',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'fr',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'pa_IN' => array(
        'code' => 'pa',
        'locale' => 'pa_IN',
        'alt' => 'pa_IN',
        'name' => 'Panjabi',
        'native' => 'ਪੰਜਾਬੀ',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'aw',
            'in',
        ),
        'currencies' => array(
            'AWG',
            'INR',
        ),
    ),
    'pl_PL' => array(
        'code' => 'pl',
        'locale' => 'pl_PL',
        'alt' => 'pl_PL',
        'name' => 'Polish',
        'native' => 'Polski',
        'dir' => 'ltr',
        'flag' => 'pl',
        'continent' => 'Europe',
        'countries' => array(
            'pl',
        ),
        'currencies' => array(
            'PLN',
        ),
    ),
    'ps' => array(
        'code' => 'ps',
        'locale' => 'ps',
        'alt' => 'ps_AF',
        'name' => 'Pashto',
        'native' => 'پښتو',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'AFN',
        ),
    ),
    'pt_AO' => array(
        'code' => 'pt',
        'locale' => 'pt_AO',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'ao',
        'continent' => 'Africa',
        'countries' => array(
            'ao',
        ),
        'currencies' => array(
            'AOA',
        ),
    ),
    'pt_BR' => array(
        'code' => 'pt',
        'locale' => 'pt_BR',
        'alt' => 'pt_BR',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'br',
        'continent' => 'America',
        'countries' => array(
            'br',
        ),
        'currencies' => array(
            'BRL',
        ),
    ),
    'pt_PT' => array(
        'code' => 'pt',
        'locale' => 'pt_PT',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'pt',
        'continent' => 'Europe',
        'countries' => array(
            'cv',
            'gw',
            'mo',
            'mz',
            'pt',
            'st',
            'tl',
        ),
        'currencies' => array(
            'CVE',
            'EUR',
            'MOP',
            'MZN',
            'STD',
            'USD',
            'XOF',
        ),
    ),
    'pt_PT_ao90' => array(
        'code' => 'pt',
        'locale' => 'pt_PT_ao90',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'pt',
        'continent' => 'Europe',
        'countries' => array(
            'pt',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'rhg' => array(
        'code' => 'rhg',
        'locale' => 'rhg',
        'alt' => 'rhg',
        'name' => 'Rohingya',
        'native' => 'Ruáinga',
        'dir' => 'ltr',
        'flag' => 'mm',
        'continent' => 'Asia',
        'countries' => array(
            'mm',
        ),
        'currencies' => array(
            'MMK',
        ),
    ),
    'ro_RO' => array(
        'code' => 'ro',
        'locale' => 'ro_RO',
        'alt' => 'ro_RO',
        'name' => 'Romanian',
        'native' => 'Română',
        'dir' => 'ltr',
        'flag' => 'ro',
        'continent' => 'Europe',
        'countries' => array(
            'md',
            'ro',
        ),
        'currencies' => array(
            'MDL',
            'RON',
        ),
    ),
    'ru_RU' => array(
        'code' => 'ru',
        'locale' => 'ru_RU',
        'alt' => 'ru_RU',
        'name' => 'Russian',
        'native' => 'Русский',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'am',
            'by',
            'kg',
            'kz',
            'ru',
            'tj',
            'tm',
            'uz',
        ),
        'currencies' => array(
            'AMD',
            'BYN',
            'BYR',
            'KGS',
            'KZT',
            'RUB',
            'TJS',
            'TMT',
            'UZS',
        ),
    ),
    'sah' => array(
        'code' => 'sah',
        'locale' => 'sah',
        'alt' => 'sah',
        'name' => 'Yakut',
        'native' => 'Сахалыы',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'ru',
        ),
        'currencies' => array(
            'RUB',
        ),
    ),
    'si_LK' => array(
        'code' => 'si',
        'locale' => 'si_LK',
        'alt' => 'si_LK',
        'name' => 'Sinhala',
        'native' => 'සිංහල',
        'dir' => 'ltr',
        'flag' => 'lk',
        'continent' => 'Asia',
        'countries' => array(
            'lk',
        ),
        'currencies' => array(
            'LKR',
        ),
    ),
    'sk_SK' => array(
        'code' => 'sk',
        'locale' => 'sk_SK',
        'alt' => 'sk_SK',
        'name' => 'Slovak',
        'native' => 'Slovenčina',
        'dir' => 'ltr',
        'flag' => 'sk',
        'continent' => 'Europe',
        'countries' => array(
            'cz',
            'sk',
        ),
        'currencies' => array(
            'CZK',
            'EUR',
        ),
    ),
    'skr' => array(
        'code' => 'skr',
        'locale' => 'skr',
        'alt' => 'skr',
        'name' => 'Saraiki',
        'native' => 'سرائیکی',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'pk',
        ),
        'currencies' => array(
            'PKR',
        ),
    ),
    'sl_SI' => array(
        'code' => 'sl',
        'locale' => 'sl_SI',
        'alt' => 'sl_SI',
        'name' => 'Slovenian',
        'native' => 'Slovenščina',
        'dir' => 'ltr',
        'flag' => 'si',
        'continent' => 'Europe',
        'countries' => array(
            'si',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'snd' => array(
        'code' => 'sd',
        'locale' => 'snd',
        'alt' => 'snd',
        'name' => 'Sindhi',
        'native' => 'سنڌي',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'pk',
        ),
        'currencies' => array(
            'PKR',
        ),
    ),
    'sq' => array(
        'code' => 'sq',
        'locale' => 'sq',
        'alt' => 'sq_AL',
        'name' => 'Albanian',
        'native' => 'Shqip',
        'dir' => 'ltr',
        'flag' => 'al',
        'continent' => 'Europe',
        'countries' => array(
            'al',
            'me',
        ),
        'currencies' => array(
            'ALL',
            'EUR',
        ),
    ),
    'sr_RS' => array(
        'code' => 'sr',
        'locale' => 'sr_RS',
        'alt' => 'sr_RS',
        'name' => 'Serbian',
        'native' => 'Српски језик',
        'dir' => 'ltr',
        'flag' => 'rs',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'me',
            'rs',
        ),
        'currencies' => array(
            'BAM',
            'EUR',
            'RSD',
        ),
    ),
    'sv_SE' => array(
        'code' => 'sv',
        'locale' => 'sv_SE',
        'alt' => 'sv_SE',
        'name' => 'Swedish',
        'native' => 'Svenska',
        'dir' => 'ltr',
        'flag' => 'se',
        'continent' => 'Europe',
        'countries' => array(
            'fi',
            'se',
        ),
        'currencies' => array(
            'EUR',
            'SEK',
        ),
    ),
    'sw' => array(
        'code' => 'sw',
        'locale' => 'sw',
        'alt' => 'sw_KE',
        'name' => 'Swahili',
        'native' => 'Kiswahili',
        'dir' => 'ltr',
        'flag' => 'ke',
        'continent' => 'Africa',
        'countries' => array(
            'cd',
            'ke',
            'tz',
            'ug',
        ),
        'currencies' => array(
            'CDF',
            'KES',
            'TZS',
            'UGX',
        ),
    ),
    'szl' => array(
        'code' => 'szl',
        'locale' => 'szl',
        'alt' => 'sz_PL',
        'name' => 'Silesian',
        'native' => 'Ślōnskŏ gŏdka',
        'dir' => 'ltr',
        'flag' => 'pl',
        'continent' => 'Europe',
        'countries' => array(
            'pl',
        ),
        'currencies' => array(
            'PLN',
        ),
    ),
    'ta_IN' => array(
        'code' => 'ta',
        'locale' => 'ta_IN',
        'alt' => 'ta_IN',
        'name' => 'Tamil',
        'native' => 'தமிழ்',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
            'sg',
        ),
        'currencies' => array(
            'BND',
            'INR',
            'SGD',
        ),
    ),
    'ta_LK' => array(
        'code' => 'ta',
        'locale' => 'ta_LK',
        'alt' => 'ta_IN',
        'name' => 'Tamil',
        'native' => 'தமிழ்',
        'dir' => 'ltr',
        'flag' => 'lk',
        'continent' => 'Asia',
        'countries' => array(
            'lk',
            'sg',
        ),
        'currencies' => array(
            'BND',
            'LKR',
            'SGD',
        ),
    ),
    'tah' => array(
        'code' => 'ty',
        'locale' => 'tah',
        'alt' => 'tah',
        'name' => 'Tahitian',
        'native' => 'Reo Tahiti',
        'dir' => 'ltr',
        'flag' => 'pf',
        'continent' => 'Oceania',
        'countries' => array(
            'pf',
        ),
        'currencies' => array(
            'XPF',
        ),
    ),
    'te' => array(
        'code' => 'te',
        'locale' => 'te',
        'alt' => 'te_IN',
        'name' => 'Telugu',
        'native' => 'తెలుగు',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'th' => array(
        'code' => 'th',
        'locale' => 'th',
        'alt' => 'th_TH',
        'name' => 'Thai',
        'native' => 'ไทย',
        'dir' => 'ltr',
        'flag' => 'th',
        'continent' => 'Asia',
        'countries' => array(
            'th',
        ),
        'currencies' => array(
            'THB',
        ),
    ),
    'tl' => array(
        'code' => 'tl',
        'locale' => 'tl',
        'alt' => 'tl_PH',
        'name' => 'Tagalog',
        'native' => 'Tagalog',
        'dir' => 'ltr',
        'flag' => 'ph',
        'continent' => 'Asia',
        'countries' => array(
            'ph',
        ),
        'currencies' => array(
            'PHP',
        ),
    ),
    'tr_TR' => array(
        'code' => 'tr',
        'locale' => 'tr_TR',
        'alt' => 'tr_TR',
        'name' => 'Turkish',
        'native' => 'Türkçe',
        'dir' => 'ltr',
        'flag' => 'tr',
        'continent' => 'Asia',
        'countries' => array(
            'cy',
            'tr',
        ),
        'currencies' => array(
            'EUR',
            'TRY',
        ),
    ),
    'tt_RU' => array(
        'code' => 'tt',
        'locale' => 'tt_RU',
        'alt' => 'tt_RU',
        'name' => 'Tatar',
        'native' => 'Татар теле',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'ru',
        ),
        'currencies' => array(
            'RUB',
        ),
    ),
    'ug_CN' => array(
        'code' => 'ug',
        'locale' => 'ug_CN',
        'alt' => 'ug_CN',
        'name' => 'Uighur',
        'native' => 'Uyƣurqə',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
        ),
        'currencies' => array(
            'CNY',
        ),
    ),
    'uk' => array(
        'code' => 'uk',
        'locale' => 'uk',
        'alt' => 'uk_UA',
        'name' => 'Ukrainian',
        'native' => 'Українська',
        'dir' => 'ltr',
        'flag' => 'ua',
        'continent' => 'Europe',
        'countries' => array(
            'ua',
        ),
        'currencies' => array(
            'UAH',
        ),
    ),
    'ur' => array(
        'code' => 'ur',
        'locale' => 'ur',
        'alt' => 'ur_PK',
        'name' => 'Urdu',
        'native' => 'اردو',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'fj',
            'pk',
        ),
        'currencies' => array(
            'FJD',
            'PKR',
        ),
    ),
    'uz_UZ' => array(
        'code' => 'uz',
        'locale' => 'uz_UZ',
        'alt' => 'uz_UZ',
        'name' => 'Uzbek',
        'native' => 'Oʻzbek',
        'dir' => 'ltr',
        'flag' => 'uz',
        'continent' => 'Asia',
        'countries' => array(
            'af',
            'uz',
        ),
        'currencies' => array(
            'AFN',
            'UZS',
        ),
    ),
    'vi' => array(
        'code' => 'vi',
        'locale' => 'vi',
        'alt' => 'vi_VN',
        'name' => 'Vietnamese',
        'native' => 'Tiếng Việt',
        'dir' => 'ltr',
        'flag' => 'vn',
        'continent' => 'Asia',
        'countries' => array(
            'vn',
        ),
        'currencies' => array(
            'VND',
        ),
    ),
    'zh_CN' => array(
        'code' => 'zh',
        'locale' => 'zh_CN',
        'alt' => 'zh_CN',
        'name' => 'Chinese',
        'native' => '中文 (中国)',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
            'mo',
            'sg',
        ),
        'currencies' => array(
            'BND',
            'CNY',
            'MOP',
            'SGD',
        ),
    ),
    'zh_HK' => array(
        'code' => 'zh',
        'locale' => 'zh_HK',
        'alt' => 'zh_HK',
        'name' => 'Chinese',
        'native' => '中文 (香港)',
        'dir' => 'ltr',
        'flag' => 'hk',
        'continent' => 'Asia',
        'countries' => array(
            'hk',
            'mo',
            'sg',
        ),
        'currencies' => array(
            'BND',
            'HKD',
            'MOP',
            'SGD',
        ),
    ),
    'zh_TW' => array(
        'code' => 'zh',
        'locale' => 'zh_TW',
        'alt' => 'zh_TW',
        'name' => 'Chinese',
        'native' => '中文 (台灣)',
        'dir' => 'ltr',
        'flag' => 'tw',
        'continent' => 'Asia',
        'countries' => array(
            'mo',
            'sg',
            'tw',
        ),
        'currencies' => array(
            'BND',
            'MOP',
            'SGD',
            'TWD',
        ),
    ),
);