<?php

if(!defined('ABSPATH')){
    exit;
}

return array(
    'af' => array(
        'code' => 'af',
        'locale' => 'af',
        'alt' => 'af_ZA',
        'name' => 'Afrikaans',
        'native' => 'Afrikaans',
        'dir' => 'ltr',
        'flag' => 'za',
        'continent' => 'Africa',
        'countries' => array(
            'na',
            'za',
        ),
        'currencies' => array(
            'af',
            'en_US',
            'en_ZA',
        ),
    ),
    'ar' => array(
        'code' => 'ar',
        'locale' => 'ar',
        'alt' => 'ar_AR',
        'name' => 'Arabic',
        'native' => 'العربية',
        'dir' => 'rtl',
        'flag' => 'ps',
        'continent' => 'Asia',
        'countries' => array(
            'ae',
            'bh',
            'dj',
            'dz',
            'eg',
            'er',
            'il',
            'iq',
            'jo',
            'km',
            'kw',
            'lb',
            'ly',
            'mr',
            'om',
            'ps',
            'qa',
            'sa',
            'sd',
            'so',
            'sy',
            'td',
            'tn',
            'ye',
        ),
        'currencies' => array(
            'ar',
            'ckb',
            'en_US',
            'fr_FR',
            'he_IL',
            'kab',
        ),
    ),
    'ary' => array(
        'code' => 'ar',
        'locale' => 'ary',
        'alt' => 'ar_AR',
        'name' => 'Arabic',
        'native' => 'العربية المغربية',
        'dir' => 'rtl',
        'flag' => 'ma',
        'continent' => 'Africa',
        'countries' => array(
            'ma',
        ),
        'currencies' => array(
            'ary',
        ),
    ),
    'as' => array(
        'code' => 'as',
        'locale' => 'as',
        'alt' => 'as_IN',
        'name' => 'Assamese',
        'native' => 'অসমীয়া',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'az' => array(
        'code' => 'az',
        'locale' => 'az',
        'alt' => 'az_AZ',
        'name' => 'Azerbaijani',
        'native' => 'Azərbaycan',
        'dir' => 'ltr',
        'flag' => 'az',
        'continent' => 'Asia',
        'countries' => array(
            'az',
        ),
        'currencies' => array(
            'az',
            'azb',
        ),
    ),
    'azb' => array(
        'code' => 'az',
        'locale' => 'azb',
        'alt' => 'azb',
        'name' => 'Azerbaijani',
        'native' => 'گؤنئی آذربایجان',
        'dir' => 'rtl',
        'flag' => 'az',
        'continent' => 'Asia',
        'countries' => array(
            'az',
        ),
        'currencies' => array(
            'az',
            'azb',
        ),
    ),
    'bel' => array(
        'code' => 'be',
        'locale' => 'bel',
        'alt' => 'be_BY',
        'name' => 'Belarusian',
        'native' => 'Беларуская мова',
        'dir' => 'ltr',
        'flag' => 'by',
        'continent' => 'Europe',
        'countries' => array(
            'by',
        ),
        'currencies' => array(
            'bel',
            'ru_RU',
        ),
    ),
    'bg_BG' => array(
        'code' => 'bg',
        'locale' => 'bg_BG',
        'alt' => 'bg_BG',
        'name' => 'Bulgarian',
        'native' => 'български',
        'dir' => 'ltr',
        'flag' => 'bg',
        'continent' => 'Europe',
        'countries' => array(
            'bg',
        ),
        'currencies' => array(
            'bg_BG',
        ),
    ),
    'bn_BD' => array(
        'code' => 'bn',
        'locale' => 'bn_BD',
        'alt' => 'bn_IN',
        'name' => 'Bengali',
        'native' => 'বাংলা',
        'dir' => 'ltr',
        'flag' => 'bd',
        'continent' => 'Asia',
        'countries' => array(
            'bd',
        ),
        'currencies' => array(
            'bn_BD',
        ),
    ),
    'bo' => array(
        'code' => 'bo',
        'locale' => 'bo',
        'alt' => 'bo',
        'name' => 'Tibetan',
        'native' => 'བོད་ཡིག',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
        ),
        'currencies' => array(
            'bo',
            'ug_CN',
            'zh_CN',
        ),
    ),
    'bs_BA' => array(
        'code' => 'bs',
        'locale' => 'bs_BA',
        'alt' => 'bs_BA',
        'name' => 'Bosnian',
        'native' => 'Bosanski',
        'dir' => 'ltr',
        'flag' => 'ba',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'me',
        ),
        'currencies' => array(
            'bs_BA',
            'hr',
            'sq',
            'sr_RS',
        ),
    ),
    'ca' => array(
        'code' => 'ca',
        'locale' => 'ca',
        'alt' => 'ca_ES',
        'name' => 'Catalan',
        'native' => 'Català',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'ad',
            'es',
        ),
        'currencies' => array(
            'ca',
            'es_ES',
            'gl_ES',
        ),
    ),
    'ceb' => array(
        'code' => 'ceb',
        'locale' => 'ceb',
        'alt' => 'cx_PH',
        'name' => 'Cebuano',
        'native' => 'Cebuano',
        'dir' => 'ltr',
        'flag' => 'ph',
        'continent' => 'Asia',
        'countries' => array(
            'ph',
        ),
        'currencies' => array(
            'ceb',
            'en_US',
            'tl',
        ),
    ),
    'cs_CZ' => array(
        'code' => 'cs',
        'locale' => 'cs_CZ',
        'alt' => 'cs_CZ',
        'name' => 'Czech',
        'native' => 'Čeština',
        'dir' => 'ltr',
        'flag' => 'cz',
        'continent' => 'Europe',
        'countries' => array(
            'cz',
        ),
        'currencies' => array(
            'cs_CZ',
            'sk_SK',
        ),
    ),
    'cy' => array(
        'code' => 'cy',
        'locale' => 'cy',
        'alt' => 'cy_GB',
        'name' => 'Welsh',
        'native' => 'Cymraeg',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'cy',
            'en_GB',
            'gd',
        ),
    ),
    'da_DK' => array(
        'code' => 'da',
        'locale' => 'da_DK',
        'alt' => 'da_DK',
        'name' => 'Danish',
        'native' => 'Dansk',
        'dir' => 'ltr',
        'flag' => 'dk',
        'continent' => 'Europe',
        'countries' => array(
            'dk',
        ),
        'currencies' => array(
            'da_DK',
        ),
    ),
    'de_DE' => array(
        'code' => 'de',
        'locale' => 'de_DE',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'be',
            'de',
            'li',
            'lu',
            'va',
        ),
        'currencies' => array(
            'de_DE',
            'de_DE_formal',
            'dsb',
            'fr_BE',
            'fr_FR',
            'hsb',
            'it_IT',
            'nl_BE',
        ),
    ),
    'de_DE_formal' => array(
        'code' => 'de',
        'locale' => 'de_DE_formal',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'de_DE',
            'de_DE_formal',
            'dsb',
            'hsb',
        ),
    ),
    'de_CH' => array(
        'code' => 'de',
        'locale' => 'de_CH',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'ch',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
        ),
        'currencies' => array(
            'de_CH',
            'de_CH_informal',
            'fr_FR',
            'it_IT',
        ),
    ),
    'de_CH_informal' => array(
        'code' => 'de',
        'locale' => 'de_CH_informal',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'ch',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
        ),
        'currencies' => array(
            'de_CH',
            'de_CH_informal',
            'fr_FR',
            'it_IT',
        ),
    ),
    'de_AT' => array(
        'code' => 'de',
        'locale' => 'de_AT',
        'alt' => 'de_DE',
        'name' => 'German',
        'native' => 'Deutsch',
        'dir' => 'ltr',
        'flag' => 'at',
        'continent' => 'Europe',
        'countries' => array(
            'at',
        ),
        'currencies' => array(
            'de_AT',
        ),
    ),
    'dsb' => array(
        'code' => 'dsb',
        'locale' => 'dsb',
        'alt' => 'dsb',
        'name' => 'Lower Sorbian',
        'native' => 'Dolnoserbšćina',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'de_DE',
            'de_DE_formal',
            'dsb',
            'hsb',
        ),
    ),
    'dzo' => array(
        'code' => 'dz',
        'locale' => 'dzo',
        'alt' => 'dzo',
        'name' => 'Dzongkha',
        'native' => 'རྫོང་ཁ',
        'dir' => 'ltr',
        'flag' => 'bt',
        'continent' => 'Asia',
        'countries' => array(
            'bt',
        ),
        'currencies' => array(
            'dzo',
        ),
    ),
    'el' => array(
        'code' => 'el',
        'locale' => 'el',
        'alt' => 'el_GR',
        'name' => 'Greek',
        'native' => 'Ελληνικά',
        'dir' => 'ltr',
        'flag' => 'gr',
        'continent' => 'Europe',
        'countries' => array(
            'cy',
            'gr',
        ),
        'currencies' => array(
            'el',
            'hy',
            'tr_TR',
        ),
    ),
    'en_NZ' => array(
        'code' => 'en',
        'locale' => 'en_NZ',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'nz',
        'continent' => 'Oceania',
        'countries' => array(
            'nz',
        ),
        'currencies' => array(
            'en_NZ',
        ),
    ),
    'en_ZA' => array(
        'code' => 'en',
        'locale' => 'en_ZA',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'za',
        'continent' => 'Africa',
        'countries' => array(
            'za',
        ),
        'currencies' => array(
            'af',
            'en_ZA',
        ),
    ),
    'en_US' => array(
        'code' => 'en',
        'locale' => 'en_US',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'us',
        'continent' => 'America',
        'countries' => array(
            'ag',
            'ai',
            'as',
            'bb',
            'bm',
            'bs',
            'bw',
            'bz',
            'cc',
            'ck',
            'cm',
            'cx',
            'dm',
            'er',
            'et',
            'fj',
            'fk',
            'fm',
            'fo',
            'gd',
            'gh',
            'gi',
            'gl',
            'gm',
            'gu',
            'gy',
            'hk',
            'ie',
            'im',
            'in',
            'je',
            'jm',
            'ke',
            'ki',
            'kn',
            'ky',
            'lc',
            'lr',
            'ls',
            'mh',
            'mp',
            'ms',
            'mt',
            'mu',
            'mv',
            'mw',
            'na',
            'nf',
            'ng',
            'nr',
            'nu',
            'pg',
            'ph',
            'pk',
            'pr',
            'pw',
            'rw',
            'sb',
            'sc',
            'sd',
            'sg',
            'sh',
            'sl',
            'sz',
            'tc',
            'tk',
            'to',
            'tt',
            'tv',
            'tz',
            'ug',
            'us',
            'vc',
            'vg',
            'vi',
            'vu',
            'ws',
            'zm',
            'zw',
        ),
        'currencies' => array(
            'af',
            'ar',
            'as',
            'ceb',
            'en_US',
            'es_ES',
            'es_PR',
            'fr_FR',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'ms_MY',
            'pa_IN',
            'skr',
            'snd',
            'sw',
            'ta_IN',
            'ta_LK',
            'te',
            'tl',
            'ur',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'en_GB' => array(
        'code' => 'en',
        'locale' => 'en_GB',
        'alt' => 'en_GB',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'cy',
            'en_GB',
            'gd',
        ),
    ),
    'en_CA' => array(
        'code' => 'en',
        'locale' => 'en_CA',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'ca',
        'continent' => 'America',
        'countries' => array(
            'ca',
        ),
        'currencies' => array(
            'en_CA',
            'fr_CA',
        ),
    ),
    'en_AU' => array(
        'code' => 'en',
        'locale' => 'en_AU',
        'alt' => 'en_US',
        'name' => 'English',
        'native' => 'English',
        'dir' => 'ltr',
        'flag' => 'au',
        'continent' => 'Oceania',
        'countries' => array(
            'au',
        ),
        'currencies' => array(
            'en_AU',
        ),
    ),
    'es_GT' => array(
        'code' => 'es',
        'locale' => 'es_GT',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'gt',
        'continent' => 'America',
        'countries' => array(
            'gt',
        ),
        'currencies' => array(
            'es_GT',
        ),
    ),
    'es_VE' => array(
        'code' => 'es',
        'locale' => 'es_VE',
        'alt' => 'es_VE',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 've',
        'continent' => 'America',
        'countries' => array(
            've',
        ),
        'currencies' => array(
            'es_VE',
        ),
    ),
    'es_UY' => array(
        'code' => 'es',
        'locale' => 'es_UY',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'uy',
        'continent' => 'America',
        'countries' => array(
            'uy',
        ),
        'currencies' => array(
            'es_UY',
        ),
    ),
    'es_PR' => array(
        'code' => 'es',
        'locale' => 'es_PR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'pr',
        'continent' => 'America',
        'countries' => array(
            'pr',
        ),
        'currencies' => array(
            'en_US',
            'es_PR',
        ),
    ),
    'es_PE' => array(
        'code' => 'es',
        'locale' => 'es_PE',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'pe',
        'continent' => 'America',
        'countries' => array(
            'pe',
        ),
        'currencies' => array(
            'es_PE',
        ),
    ),
    'es_MX' => array(
        'code' => 'es',
        'locale' => 'es_MX',
        'alt' => 'es_MX',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'mx',
        'continent' => 'America',
        'countries' => array(
            'mx',
        ),
        'currencies' => array(
            'es_MX',
        ),
    ),
    'es_AR' => array(
        'code' => 'es',
        'locale' => 'es_AR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'ar',
        'continent' => 'America',
        'countries' => array(
            'ar',
        ),
        'currencies' => array(
            'es_AR',
        ),
    ),
    'es_ES' => array(
        'code' => 'es',
        'locale' => 'es_ES',
        'alt' => 'es_ES',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'bo',
            'bz',
            'cu',
            'do',
            'eh',
            'es',
            'gq',
            'gu',
            'hn',
            'ni',
            'pa',
            'py',
            'sv',
        ),
        'currencies' => array(
            'ca',
            'en_US',
            'es_ES',
            'fr_FR',
            'gl_ES',
        ),
    ),
    'es_EC' => array(
        'code' => 'es',
        'locale' => 'es_EC',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'ec',
        'continent' => 'America',
        'countries' => array(
            'ec',
        ),
        'currencies' => array(
            'es_EC',
        ),
    ),
    'es_CR' => array(
        'code' => 'es',
        'locale' => 'es_CR',
        'alt' => 'es_LA',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'cr',
        'continent' => 'America',
        'countries' => array(
            'cr',
        ),
        'currencies' => array(
            'es_CR',
        ),
    ),
    'es_CO' => array(
        'code' => 'es',
        'locale' => 'es_CO',
        'alt' => 'es_CO',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'co',
        'continent' => 'America',
        'countries' => array(
            'co',
        ),
        'currencies' => array(
            'es_CO',
        ),
    ),
    'es_CL' => array(
        'code' => 'es',
        'locale' => 'es_CL',
        'alt' => 'es_CL',
        'name' => 'Spanish',
        'native' => 'Español',
        'dir' => 'ltr',
        'flag' => 'cl',
        'continent' => 'America',
        'countries' => array(
            'cl',
        ),
        'currencies' => array(
            'es_CL',
        ),
    ),
    'et' => array(
        'code' => 'et',
        'locale' => 'et',
        'alt' => 'et_EE',
        'name' => 'Estonian',
        'native' => 'Eesti',
        'dir' => 'ltr',
        'flag' => 'ee',
        'continent' => 'Europe',
        'countries' => array(
            'ee',
        ),
        'currencies' => array(
            'et',
        ),
    ),
    'eu' => array(
        'code' => 'eu',
        'locale' => 'eu',
        'alt' => 'eu_ES',
        'name' => 'Basque',
        'native' => 'Euskara',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'fr',
        ),
        'currencies' => array(
            'eu',
            'fr_FR',
            'oci',
        ),
    ),
    'fa_AF' => array(
        'code' => 'fa',
        'locale' => 'fa_AF',
        'alt' => 'fa_IR',
        'name' => 'Persian',
        'native' => 'فارسی',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'fa_AF',
            'haz',
            'ps',
            'uz_UZ',
        ),
    ),
    'fa_IR' => array(
        'code' => 'fa',
        'locale' => 'fa_IR',
        'alt' => 'fa_IR',
        'name' => 'Persian',
        'native' => 'فارسی',
        'dir' => 'rtl',
        'flag' => 'ir',
        'continent' => 'Asia',
        'countries' => array(
            'ir',
        ),
        'currencies' => array(
            'ckb',
            'fa_IR',
        ),
    ),
    'fi' => array(
        'code' => 'fi',
        'locale' => 'fi',
        'alt' => 'fi_FI',
        'name' => 'Finnish',
        'native' => 'Suomi',
        'dir' => 'ltr',
        'flag' => 'fi',
        'continent' => 'Europe',
        'countries' => array(
            'fi',
        ),
        'currencies' => array(
            'fi',
            'sv_SE',
        ),
    ),
    'fr_FR' => array(
        'code' => 'fr',
        'locale' => 'fr_FR',
        'alt' => 'fr_FR',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'bf',
            'bi',
            'bj',
            'bl',
            'cd',
            'cf',
            'cg',
            'ch',
            'ci',
            'cm',
            'dj',
            'fr',
            'ga',
            'gf',
            'gn',
            'gp',
            'gq',
            'ht',
            'je',
            'km',
            'lb',
            'lu',
            'mc',
            'mg',
            'ml',
            'mq',
            'nc',
            'ne',
            'pf',
            'pm',
            're',
            'rw',
            'sc',
            'sn',
            'td',
            'tg',
            'va',
            'vu',
            'wf',
            'yt',
        ),
        'currencies' => array(
            'ar',
            'de_CH',
            'de_CH_informal',
            'de_DE',
            'en_US',
            'es_ES',
            'eu',
            'fr_FR',
            'it_IT',
            'oci',
            'sw',
            'tah',
        ),
    ),
    'fr_CA' => array(
        'code' => 'fr',
        'locale' => 'fr_CA',
        'alt' => 'fr_CA',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'ca',
        'continent' => 'America',
        'countries' => array(
            'ca',
        ),
        'currencies' => array(
            'en_CA',
            'fr_CA',
        ),
    ),
    'fr_BE' => array(
        'code' => 'fr',
        'locale' => 'fr_BE',
        'alt' => 'fr_FR',
        'name' => 'French',
        'native' => 'Français',
        'dir' => 'ltr',
        'flag' => 'be',
        'continent' => 'Europe',
        'countries' => array(
            'be',
        ),
        'currencies' => array(
            'de_DE',
            'fr_BE',
            'nl_BE',
        ),
    ),
    'fur' => array(
        'code' => 'fur',
        'locale' => 'fur',
        'alt' => 'fur',
        'name' => 'Fur',
        'native' => 'Furlan',
        'dir' => 'ltr',
        'flag' => 'it',
        'continent' => 'Europe',
        'countries' => array(
            'it',
        ),
        'currencies' => array(
            'fur',
            'it_IT',
        ),
    ),
    'gd' => array(
        'code' => 'gd',
        'locale' => 'gd',
        'alt' => 'gd',
        'name' => 'Scottish Gaelic',
        'native' => 'Gàidhlig',
        'dir' => 'ltr',
        'flag' => 'gb',
        'continent' => 'Europe',
        'countries' => array(
            'gb',
        ),
        'currencies' => array(
            'cy',
            'en_GB',
            'gd',
        ),
    ),
    'gl_ES' => array(
        'code' => 'gl',
        'locale' => 'gl_ES',
        'alt' => 'gl_ES',
        'name' => 'Galician',
        'native' => 'Galego',
        'dir' => 'ltr',
        'flag' => 'es',
        'continent' => 'Europe',
        'countries' => array(
            'es',
        ),
        'currencies' => array(
            'ca',
            'es_ES',
            'gl_ES',
        ),
    ),
    'gu' => array(
        'code' => 'gu',
        'locale' => 'gu',
        'alt' => 'gu_IN',
        'name' => 'Gujarati',
        'native' => 'ગુજરાતી',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'haz' => array(
        'code' => 'haz',
        'locale' => 'haz',
        'alt' => 'haz',
        'name' => 'Hazaragi',
        'native' => 'هزاره گی',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'fa_AF',
            'haz',
            'ps',
            'uz_UZ',
        ),
    ),
    'he_IL' => array(
        'code' => 'he',
        'locale' => 'he_IL',
        'alt' => 'he_IL',
        'name' => 'Hebrew',
        'native' => 'עברית',
        'dir' => 'rtl',
        'flag' => 'il',
        'continent' => 'Asia',
        'countries' => array(
            'il',
        ),
        'currencies' => array(
            'ar',
            'he_IL',
        ),
    ),
    'hi_IN' => array(
        'code' => 'hi',
        'locale' => 'hi_IN',
        'alt' => 'hi_IN',
        'name' => 'Hindi',
        'native' => 'हिन्दी',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'fj',
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
            'ur',
        ),
    ),
    'hr' => array(
        'code' => 'hr',
        'locale' => 'hr',
        'alt' => 'hr_HR',
        'name' => 'Croatian',
        'native' => 'Hrvatski',
        'dir' => 'ltr',
        'flag' => 'hr',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'hr',
            'me',
        ),
        'currencies' => array(
            'bs_BA',
            'hr',
            'sq',
            'sr_RS',
        ),
    ),
    'hsb' => array(
        'code' => 'hsb',
        'locale' => 'hsb',
        'alt' => 'hsb',
        'name' => 'Upper Sorbian',
        'native' => 'Hornjoserbšćina',
        'dir' => 'ltr',
        'flag' => 'de',
        'continent' => 'Europe',
        'countries' => array(
            'de',
        ),
        'currencies' => array(
            'de_DE',
            'de_DE_formal',
            'dsb',
            'hsb',
        ),
    ),
    'hu_HU' => array(
        'code' => 'hu',
        'locale' => 'hu_HU',
        'alt' => 'hu_HU',
        'name' => 'Hungarian',
        'native' => 'Magyar',
        'dir' => 'ltr',
        'flag' => 'hu',
        'continent' => 'Europe',
        'countries' => array(
            'hu',
        ),
        'currencies' => array(
            'hu_HU',
        ),
    ),
    'hy' => array(
        'code' => 'hy',
        'locale' => 'hy',
        'alt' => 'hy_AM',
        'name' => 'Armenian',
        'native' => 'Հայերեն',
        'dir' => 'ltr',
        'flag' => 'am',
        'continent' => 'Asia',
        'countries' => array(
            'am',
            'cy',
        ),
        'currencies' => array(
            'el',
            'hy',
            'ru_RU',
            'tr_TR',
        ),
    ),
    'id_ID' => array(
        'code' => 'id',
        'locale' => 'id_ID',
        'alt' => 'id_ID',
        'name' => 'Indonesian',
        'native' => 'Bahasa Indonesia',
        'dir' => 'ltr',
        'flag' => 'id',
        'continent' => 'Asia',
        'countries' => array(
            'id',
        ),
        'currencies' => array(
            'id_ID',
            'jv_ID',
        ),
    ),
    'is_IS' => array(
        'code' => 'is',
        'locale' => 'is_IS',
        'alt' => 'is_IS',
        'name' => 'Icelandic',
        'native' => 'Íslenska',
        'dir' => 'ltr',
        'flag' => 'is',
        'continent' => 'Europe',
        'countries' => array(
            'is',
        ),
        'currencies' => array(
            'is_IS',
        ),
    ),
    'it_IT' => array(
        'code' => 'it',
        'locale' => 'it_IT',
        'alt' => 'it_IT',
        'name' => 'Italian',
        'native' => 'Italiano',
        'dir' => 'ltr',
        'flag' => 'it',
        'continent' => 'Europe',
        'countries' => array(
            'ch',
            'it',
            'sm',
            'va',
        ),
        'currencies' => array(
            'de_CH',
            'de_CH_informal',
            'de_DE',
            'fr_FR',
            'fur',
            'it_IT',
        ),
    ),
    'ja' => array(
        'code' => 'ja',
        'locale' => 'ja',
        'alt' => 'ja_JP',
        'name' => 'Japanese',
        'native' => '日本語',
        'dir' => 'ltr',
        'flag' => 'jp',
        'continent' => 'Asia',
        'countries' => array(
            'jp',
        ),
        'currencies' => array(
            'ja',
        ),
    ),
    'jv_ID' => array(
        'code' => 'jv',
        'locale' => 'jv_ID',
        'alt' => 'jv_ID',
        'name' => 'Javanese',
        'native' => 'Basa Jawa',
        'dir' => 'ltr',
        'flag' => 'id',
        'continent' => 'Asia',
        'countries' => array(
            'id',
        ),
        'currencies' => array(
            'id_ID',
            'jv_ID',
        ),
    ),
    'ka_GE' => array(
        'code' => 'ka',
        'locale' => 'ka_GE',
        'alt' => 'ka_GE',
        'name' => 'Georgian',
        'native' => 'ქართული',
        'dir' => 'ltr',
        'flag' => 'ge',
        'continent' => 'Asia',
        'countries' => array(
            'ge',
        ),
        'currencies' => array(
            'ka_GE',
        ),
    ),
    'kab' => array(
        'code' => 'kab',
        'locale' => 'kab',
        'alt' => 'kab',
        'name' => 'Kabyle',
        'native' => 'Taqbaylit',
        'dir' => 'ltr',
        'flag' => 'dz',
        'continent' => 'Africa',
        'countries' => array(
            'dz',
        ),
        'currencies' => array(
            'ar',
            'kab',
        ),
    ),
    'kk' => array(
        'code' => 'kk',
        'locale' => 'kk',
        'alt' => 'kk_KZ',
        'name' => 'Kazakh',
        'native' => 'Қазақ тілі',
        'dir' => 'ltr',
        'flag' => 'kz',
        'continent' => 'Asia',
        'countries' => array(
            'kz',
        ),
        'currencies' => array(
            'kk',
            'ru_RU',
        ),
    ),
    'km' => array(
        'code' => 'km',
        'locale' => 'km',
        'alt' => 'km_KH',
        'name' => 'Khmer',
        'native' => 'ភាសាខ្មែរ',
        'dir' => 'ltr',
        'flag' => 'kh',
        'continent' => 'Asia',
        'countries' => array(
            'kh',
        ),
        'currencies' => array(
            'km',
        ),
    ),
    'kn' => array(
        'code' => 'kn',
        'locale' => 'kn',
        'alt' => 'kn_IN',
        'name' => 'Kannada',
        'native' => 'ಕನ್ನಡ',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'ko_KR' => array(
        'code' => 'ko',
        'locale' => 'ko_KR',
        'alt' => 'ko_KR',
        'name' => 'Korean',
        'native' => '한국어',
        'dir' => 'ltr',
        'flag' => 'kr',
        'continent' => 'Asia',
        'countries' => array(
            'kp',
            'kr',
        ),
        'currencies' => array(
            'ko_KR',
        ),
    ),
    'ckb' => array(
        'code' => 'ku',
        'locale' => 'ckb',
        'alt' => 'cb_IQ',
        'name' => 'Kurdish',
        'native' => 'کوردی',
        'dir' => 'rtl',
        'flag' => 'ir',
        'continent' => 'Asia',
        'countries' => array(
            'iq',
            'ir',
        ),
        'currencies' => array(
            'ar',
            'ckb',
            'fa_IR',
        ),
    ),
    'lo' => array(
        'code' => 'lo',
        'locale' => 'lo',
        'alt' => 'lo_LA',
        'name' => 'Lao',
        'native' => 'ພາສາລາວ',
        'dir' => 'ltr',
        'flag' => 'la',
        'continent' => 'Asia',
        'countries' => array(
            'la',
        ),
        'currencies' => array(
            'lo',
        ),
    ),
    'lt_LT' => array(
        'code' => 'lt',
        'locale' => 'lt_LT',
        'alt' => 'lt_LT',
        'name' => 'Lithuanian',
        'native' => 'Lietuviškai',
        'dir' => 'ltr',
        'flag' => 'lt',
        'continent' => 'Europe',
        'countries' => array(
            'lt',
        ),
        'currencies' => array(
            'lt_LT',
        ),
    ),
    'lv' => array(
        'code' => 'lv',
        'locale' => 'lv',
        'alt' => 'lv_LV',
        'name' => 'Latvian',
        'native' => 'Latviešu valoda',
        'dir' => 'ltr',
        'flag' => 'lv',
        'continent' => 'Europe',
        'countries' => array(
            'lv',
        ),
        'currencies' => array(
            'lv',
        ),
    ),
    'mk_MK' => array(
        'code' => 'mk',
        'locale' => 'mk_MK',
        'alt' => 'mk_MK',
        'name' => 'Macedonian',
        'native' => 'македонски јазик',
        'dir' => 'ltr',
        'flag' => 'mk',
        'continent' => 'Europe',
        'countries' => array(
            'mk',
        ),
        'currencies' => array(
            'mk_MK',
        ),
    ),
    'ml_IN' => array(
        'code' => 'ml',
        'locale' => 'ml_IN',
        'alt' => 'ml_IN',
        'name' => 'Malayalam',
        'native' => 'മലയാളം',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'mn' => array(
        'code' => 'mn',
        'locale' => 'mn',
        'alt' => 'mn_MN',
        'name' => 'Mongolian',
        'native' => 'Монгол хэл',
        'dir' => 'ltr',
        'flag' => 'mn',
        'continent' => 'Asia',
        'countries' => array(
            'mn',
        ),
        'currencies' => array(
            'mn',
        ),
    ),
    'mr' => array(
        'code' => 'mr',
        'locale' => 'mr',
        'alt' => 'mr_IN',
        'name' => 'Marathi',
        'native' => 'मराठी',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'ms_MY' => array(
        'code' => 'ms',
        'locale' => 'ms_MY',
        'alt' => 'ms_MY',
        'name' => 'Malay',
        'native' => 'Bahasa Melayu',
        'dir' => 'ltr',
        'flag' => 'my',
        'continent' => 'Asia',
        'countries' => array(
            'bn',
            'my',
            'sg',
        ),
        'currencies' => array(
            'en_US',
            'ms_MY',
            'ta_IN',
            'ta_LK',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'my_MM' => array(
        'code' => 'my',
        'locale' => 'my_MM',
        'alt' => 'my_MM',
        'name' => 'Burmese',
        'native' => 'ဗမာစာ',
        'dir' => 'ltr',
        'flag' => 'mm',
        'continent' => 'Asia',
        'countries' => array(
            'mm',
        ),
        'currencies' => array(
            'my_MM',
            'rhg',
        ),
    ),
    'nb_NO' => array(
        'code' => 'nb',
        'locale' => 'nb_NO',
        'alt' => 'nb_NO',
        'name' => 'Norwegian Bokmal',
        'native' => 'Norsk Bokmål',
        'dir' => 'ltr',
        'flag' => 'no',
        'continent' => 'Europe',
        'countries' => array(
            'no',
        ),
        'currencies' => array(
            'nb_NO',
            'nn_NO',
        ),
    ),
    'ne_NP' => array(
        'code' => 'ne',
        'locale' => 'ne_NP',
        'alt' => 'ne_NP',
        'name' => 'Nepali',
        'native' => 'नेपाली',
        'dir' => 'ltr',
        'flag' => 'np',
        'continent' => 'Asia',
        'countries' => array(
            'np',
        ),
        'currencies' => array(
            'ne_NP',
        ),
    ),
    'nl_BE' => array(
        'code' => 'nl',
        'locale' => 'nl_BE',
        'alt' => 'nl_BE',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'be',
        'continent' => 'Europe',
        'countries' => array(
            'be',
        ),
        'currencies' => array(
            'de_DE',
            'fr_BE',
            'nl_BE',
        ),
    ),
    'nl_NL' => array(
        'code' => 'nl',
        'locale' => 'nl_NL',
        'alt' => 'nl_NL',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'nl',
        'continent' => 'Europe',
        'countries' => array(
            'aw',
            'nl',
            'sr',
        ),
        'currencies' => array(
            'nl_NL',
            'nl_NL_formal',
            'pa_IN',
        ),
    ),
    'nl_NL_formal' => array(
        'code' => 'nl',
        'locale' => 'nl_NL_formal',
        'alt' => 'nl_NL',
        'name' => 'Dutch',
        'native' => 'Nederlands',
        'dir' => 'ltr',
        'flag' => 'nl',
        'continent' => 'Europe',
        'countries' => array(
            'nl',
        ),
        'currencies' => array(
            'nl_NL',
            'nl_NL_formal',
        ),
    ),
    'nn_NO' => array(
        'code' => 'nn',
        'locale' => 'nn_NO',
        'alt' => 'nn_NO',
        'name' => 'Norwegian Nynorsk',
        'native' => 'Norsk Nynorsk',
        'dir' => 'ltr',
        'flag' => 'no',
        'continent' => 'Europe',
        'countries' => array(
            'no',
        ),
        'currencies' => array(
            'nb_NO',
            'nn_NO',
        ),
    ),
    'oci' => array(
        'code' => 'oc',
        'locale' => 'oci',
        'alt' => 'oci',
        'name' => 'Occitan',
        'native' => 'Occitan',
        'dir' => 'ltr',
        'flag' => 'fr',
        'continent' => 'Europe',
        'countries' => array(
            'fr',
        ),
        'currencies' => array(
            'eu',
            'fr_FR',
            'oci',
        ),
    ),
    'pa_IN' => array(
        'code' => 'pa',
        'locale' => 'pa_IN',
        'alt' => 'pa_IN',
        'name' => 'Panjabi',
        'native' => 'ਪੰਜਾਬੀ',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'aw',
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'nl_NL',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'pl_PL' => array(
        'code' => 'pl',
        'locale' => 'pl_PL',
        'alt' => 'pl_PL',
        'name' => 'Polish',
        'native' => 'Polski',
        'dir' => 'ltr',
        'flag' => 'pl',
        'continent' => 'Europe',
        'countries' => array(
            'pl',
        ),
        'currencies' => array(
            'pl_PL',
            'szl',
        ),
    ),
    'ps' => array(
        'code' => 'ps',
        'locale' => 'ps',
        'alt' => 'ps_AF',
        'name' => 'Pashto',
        'native' => 'پښتو',
        'dir' => 'rtl',
        'flag' => 'af',
        'continent' => 'Asia',
        'countries' => array(
            'af',
        ),
        'currencies' => array(
            'fa_AF',
            'haz',
            'ps',
            'uz_UZ',
        ),
    ),
    'pt_PT_ao90' => array(
        'code' => 'pt',
        'locale' => 'pt_PT_ao90',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'pt',
        'continent' => 'Europe',
        'countries' => array(
            'pt',
        ),
        'currencies' => array(
            'pt_PT',
            'pt_PT_ao90',
        ),
    ),
    'pt_PT' => array(
        'code' => 'pt',
        'locale' => 'pt_PT',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'pt',
        'continent' => 'Europe',
        'countries' => array(
            'cv',
            'gw',
            'mo',
            'mz',
            'pt',
            'st',
            'tl',
        ),
        'currencies' => array(
            'pt_PT',
            'pt_PT_ao90',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'pt_BR' => array(
        'code' => 'pt',
        'locale' => 'pt_BR',
        'alt' => 'pt_BR',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'br',
        'continent' => 'America',
        'countries' => array(
            'br',
        ),
        'currencies' => array(
            'pt_BR',
        ),
    ),
    'pt_AO' => array(
        'code' => 'pt',
        'locale' => 'pt_AO',
        'alt' => 'pt_PT',
        'name' => 'Portuguese',
        'native' => 'Português',
        'dir' => 'ltr',
        'flag' => 'ao',
        'continent' => 'Africa',
        'countries' => array(
            'ao',
        ),
        'currencies' => array(
            'pt_AO',
        ),
    ),
    'rhg' => array(
        'code' => 'rhg',
        'locale' => 'rhg',
        'alt' => 'rhg',
        'name' => 'Rohingya',
        'native' => 'Ruáinga',
        'dir' => 'ltr',
        'flag' => 'mm',
        'continent' => 'Asia',
        'countries' => array(
            'mm',
        ),
        'currencies' => array(
            'my_MM',
            'rhg',
        ),
    ),
    'ro_RO' => array(
        'code' => 'ro',
        'locale' => 'ro_RO',
        'alt' => 'ro_RO',
        'name' => 'Romanian',
        'native' => 'Română',
        'dir' => 'ltr',
        'flag' => 'ro',
        'continent' => 'Europe',
        'countries' => array(
            'md',
            'ro',
        ),
        'currencies' => array(
            'ro_RO',
        ),
    ),
    'ru_RU' => array(
        'code' => 'ru',
        'locale' => 'ru_RU',
        'alt' => 'ru_RU',
        'name' => 'Russian',
        'native' => 'Русский',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'am',
            'by',
            'kg',
            'kz',
            'ru',
            'tj',
            'tm',
            'uz',
        ),
        'currencies' => array(
            'bel',
            'hy',
            'kk',
            'ru_RU',
            'sah',
            'tt_RU',
            'uz_UZ',
        ),
    ),
    'sah' => array(
        'code' => 'sah',
        'locale' => 'sah',
        'alt' => 'sah',
        'name' => 'Yakut',
        'native' => 'Сахалыы',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'ru',
        ),
        'currencies' => array(
            'ru_RU',
            'sah',
            'tt_RU',
        ),
    ),
    'snd' => array(
        'code' => 'sd',
        'locale' => 'snd',
        'alt' => 'snd',
        'name' => 'Sindhi',
        'native' => 'سنڌي',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'pk',
        ),
        'currencies' => array(
            'en_US',
            'skr',
            'snd',
            'ur',
        ),
    ),
    'si_LK' => array(
        'code' => 'si',
        'locale' => 'si_LK',
        'alt' => 'si_LK',
        'name' => 'Sinhala',
        'native' => 'සිංහල',
        'dir' => 'ltr',
        'flag' => 'lk',
        'continent' => 'Asia',
        'countries' => array(
            'lk',
        ),
        'currencies' => array(
            'si_LK',
            'ta_LK',
        ),
    ),
    'sk_SK' => array(
        'code' => 'sk',
        'locale' => 'sk_SK',
        'alt' => 'sk_SK',
        'name' => 'Slovak',
        'native' => 'Slovenčina',
        'dir' => 'ltr',
        'flag' => 'sk',
        'continent' => 'Europe',
        'countries' => array(
            'cz',
            'sk',
        ),
        'currencies' => array(
            'cs_CZ',
            'sk_SK',
        ),
    ),
    'skr' => array(
        'code' => 'skr',
        'locale' => 'skr',
        'alt' => 'skr',
        'name' => 'Saraiki',
        'native' => 'سرائیکی',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'pk',
        ),
        'currencies' => array(
            'en_US',
            'skr',
            'snd',
            'ur',
        ),
    ),
    'sl_SI' => array(
        'code' => 'sl',
        'locale' => 'sl_SI',
        'alt' => 'sl_SI',
        'name' => 'Slovenian',
        'native' => 'Slovenščina',
        'dir' => 'ltr',
        'flag' => 'si',
        'continent' => 'Europe',
        'countries' => array(
            'si',
        ),
        'currencies' => array(
            'sl_SI',
        ),
    ),
    'sq' => array(
        'code' => 'sq',
        'locale' => 'sq',
        'alt' => 'sq_AL',
        'name' => 'Albanian',
        'native' => 'Shqip',
        'dir' => 'ltr',
        'flag' => 'al',
        'continent' => 'Europe',
        'countries' => array(
            'al',
            'me',
        ),
        'currencies' => array(
            'bs_BA',
            'hr',
            'sq',
            'sr_RS',
        ),
    ),
    'sr_RS' => array(
        'code' => 'sr',
        'locale' => 'sr_RS',
        'alt' => 'sr_RS',
        'name' => 'Serbian',
        'native' => 'Српски језик',
        'dir' => 'ltr',
        'flag' => 'rs',
        'continent' => 'Europe',
        'countries' => array(
            'ba',
            'me',
            'rs',
        ),
        'currencies' => array(
            'bs_BA',
            'hr',
            'sq',
            'sr_RS',
        ),
    ),
    'sv_SE' => array(
        'code' => 'sv',
        'locale' => 'sv_SE',
        'alt' => 'sv_SE',
        'name' => 'Swedish',
        'native' => 'Svenska',
        'dir' => 'ltr',
        'flag' => 'se',
        'continent' => 'Europe',
        'countries' => array(
            'fi',
            'se',
        ),
        'currencies' => array(
            'fi',
            'sv_SE',
        ),
    ),
    'sw' => array(
        'code' => 'sw',
        'locale' => 'sw',
        'alt' => 'sw_KE',
        'name' => 'Swahili',
        'native' => 'Kiswahili',
        'dir' => 'ltr',
        'flag' => 'ke',
        'continent' => 'Africa',
        'countries' => array(
            'cd',
            'ke',
            'tz',
            'ug',
        ),
        'currencies' => array(
            'en_US',
            'fr_FR',
            'sw',
        ),
    ),
    'szl' => array(
        'code' => 'szl',
        'locale' => 'szl',
        'alt' => 'sz_PL',
        'name' => 'Silesian',
        'native' => 'Ślōnskŏ gŏdka',
        'dir' => 'ltr',
        'flag' => 'pl',
        'continent' => 'Europe',
        'countries' => array(
            'pl',
        ),
        'currencies' => array(
            'pl_PL',
            'szl',
        ),
    ),
    'ta_IN' => array(
        'code' => 'ta',
        'locale' => 'ta_IN',
        'alt' => 'ta_IN',
        'name' => 'Tamil',
        'native' => 'தமிழ்',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
            'sg',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'ms_MY',
            'pa_IN',
            'ta_IN',
            'ta_LK',
            'te',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'ta_LK' => array(
        'code' => 'ta',
        'locale' => 'ta_LK',
        'alt' => 'ta_IN',
        'name' => 'Tamil',
        'native' => 'தமிழ்',
        'dir' => 'ltr',
        'flag' => 'lk',
        'continent' => 'Asia',
        'countries' => array(
            'lk',
            'sg',
        ),
        'currencies' => array(
            'en_US',
            'ms_MY',
            'si_LK',
            'ta_IN',
            'ta_LK',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'te' => array(
        'code' => 'te',
        'locale' => 'te',
        'alt' => 'te_IN',
        'name' => 'Telugu',
        'native' => 'తెలుగు',
        'dir' => 'ltr',
        'flag' => 'in',
        'continent' => 'Asia',
        'countries' => array(
            'in',
        ),
        'currencies' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
    ),
    'th' => array(
        'code' => 'th',
        'locale' => 'th',
        'alt' => 'th_TH',
        'name' => 'Thai',
        'native' => 'ไทย',
        'dir' => 'ltr',
        'flag' => 'th',
        'continent' => 'Asia',
        'countries' => array(
            'th',
        ),
        'currencies' => array(
            'th',
        ),
    ),
    'tl' => array(
        'code' => 'tl',
        'locale' => 'tl',
        'alt' => 'tl_PH',
        'name' => 'Tagalog',
        'native' => 'Tagalog',
        'dir' => 'ltr',
        'flag' => 'ph',
        'continent' => 'Asia',
        'countries' => array(
            'ph',
        ),
        'currencies' => array(
            'ceb',
            'en_US',
            'tl',
        ),
    ),
    'tr_TR' => array(
        'code' => 'tr',
        'locale' => 'tr_TR',
        'alt' => 'tr_TR',
        'name' => 'Turkish',
        'native' => 'Türkçe',
        'dir' => 'ltr',
        'flag' => 'tr',
        'continent' => 'Asia',
        'countries' => array(
            'cy',
            'tr',
        ),
        'currencies' => array(
            'el',
            'hy',
            'tr_TR',
        ),
    ),
    'tt_RU' => array(
        'code' => 'tt',
        'locale' => 'tt_RU',
        'alt' => 'tt_RU',
        'name' => 'Tatar',
        'native' => 'Татар теле',
        'dir' => 'ltr',
        'flag' => 'ru',
        'continent' => 'Europe',
        'countries' => array(
            'ru',
        ),
        'currencies' => array(
            'ru_RU',
            'sah',
            'tt_RU',
        ),
    ),
    'tah' => array(
        'code' => 'ty',
        'locale' => 'tah',
        'alt' => 'tah',
        'name' => 'Tahitian',
        'native' => 'Reo Tahiti',
        'dir' => 'ltr',
        'flag' => 'pf',
        'continent' => 'Oceania',
        'countries' => array(
            'pf',
        ),
        'currencies' => array(
            'fr_FR',
            'tah',
        ),
    ),
    'ug_CN' => array(
        'code' => 'ug',
        'locale' => 'ug_CN',
        'alt' => 'ug_CN',
        'name' => 'Uighur',
        'native' => 'Uyƣurqə',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
        ),
        'currencies' => array(
            'bo',
            'ug_CN',
            'zh_CN',
        ),
    ),
    'uk' => array(
        'code' => 'uk',
        'locale' => 'uk',
        'alt' => 'uk_UA',
        'name' => 'Ukrainian',
        'native' => 'Українська',
        'dir' => 'ltr',
        'flag' => 'ua',
        'continent' => 'Europe',
        'countries' => array(
            'ua',
        ),
        'currencies' => array(
            'uk',
        ),
    ),
    'ur' => array(
        'code' => 'ur',
        'locale' => 'ur',
        'alt' => 'ur_PK',
        'name' => 'Urdu',
        'native' => 'اردو',
        'dir' => 'rtl',
        'flag' => 'pk',
        'continent' => 'Asia',
        'countries' => array(
            'fj',
            'pk',
        ),
        'currencies' => array(
            'en_US',
            'hi_IN',
            'skr',
            'snd',
            'ur',
        ),
    ),
    'uz_UZ' => array(
        'code' => 'uz',
        'locale' => 'uz_UZ',
        'alt' => 'uz_UZ',
        'name' => 'Uzbek',
        'native' => 'Oʻzbek',
        'dir' => 'ltr',
        'flag' => 'uz',
        'continent' => 'Asia',
        'countries' => array(
            'af',
            'uz',
        ),
        'currencies' => array(
            'fa_AF',
            'haz',
            'ps',
            'ru_RU',
            'uz_UZ',
        ),
    ),
    'vi' => array(
        'code' => 'vi',
        'locale' => 'vi',
        'alt' => 'vi_VN',
        'name' => 'Vietnamese',
        'native' => 'Tiếng Việt',
        'dir' => 'ltr',
        'flag' => 'vn',
        'continent' => 'Asia',
        'countries' => array(
            'vn',
        ),
        'currencies' => array(
            'vi',
        ),
    ),
    'zh_CN' => array(
        'code' => 'zh',
        'locale' => 'zh_CN',
        'alt' => 'zh_CN',
        'name' => 'Chinese',
        'native' => '中文 (中国)',
        'dir' => 'ltr',
        'flag' => 'cn',
        'continent' => 'Asia',
        'countries' => array(
            'cn',
            'mo',
            'sg',
        ),
        'currencies' => array(
            'bo',
            'en_US',
            'ms_MY',
            'pt_PT',
            'ta_IN',
            'ta_LK',
            'ug_CN',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'zh_HK' => array(
        'code' => 'zh',
        'locale' => 'zh_HK',
        'alt' => 'zh_HK',
        'name' => 'Chinese',
        'native' => '中文 (香港)',
        'dir' => 'ltr',
        'flag' => 'hk',
        'continent' => 'Asia',
        'countries' => array(
            'hk',
            'mo',
            'sg',
        ),
        'currencies' => array(
            'en_US',
            'ms_MY',
            'pt_PT',
            'ta_IN',
            'ta_LK',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
    'zh_TW' => array(
        'code' => 'zh',
        'locale' => 'zh_TW',
        'alt' => 'zh_TW',
        'name' => 'Chinese',
        'native' => '中文 (台灣)',
        'dir' => 'ltr',
        'flag' => 'tw',
        'continent' => 'Asia',
        'countries' => array(
            'mo',
            'sg',
            'tw',
        ),
        'currencies' => array(
            'en_US',
            'ms_MY',
            'pt_PT',
            'ta_IN',
            'ta_LK',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
    ),
);