# Admin and Site Enhancements (ASE)

Contributors: qriouslad  
Donate link: https://bowo.io/asenha-sp-rdm  
Tags: enhancements, tweaks, optimizations, tools  
Requires at least: 4.6  
Tested up to: 6.7.1  
Stable tag: 7.6.6  
Requires PHP: 5.6  
License: GPLv2 or later  
License URI: http://www.gnu.org/licenses/gpl-2.0.html

![](.wordpress-org/banner-772x250.png)

Duplicate post, post order, image resize, email via SMTP, admin menu editor, custom css / code, disable gutenberg and much more in a single plugin.

## Description

Admin and Site Enhancements (ASE) helps you to **easily enhance** various admin workflows and site aspects while **replacing multiple plugins** doing it.

**Pro version** with Lifetime Deal (LTD) is available at [www.wpase.com](https://www.wpase.com/rdme-to-web).

Here's a quick walkthrough of ASE Free at v7.1.5 by Jakson.

https://www.youtube.com/watch?v=ZEiIKfz2p2Q

Here's a detailed walkthrough of ASE Free at v7.0.3 by Pascal Claro.

https://www.youtube.com/watch?v=bX-2gmpCEMU

[**See more video reviews >>**](https://www.wpase.com/video-reviews/)

### What Users Say

_"ASE easily **replaces a dozen or more plugins** I install on **every website project**. Super lightweight and easy to use."_ ~[NetzzJD](https://wordpress.org/support/topic/amazing-must-have-plugin-2/)

_"**I bought the lifetime deal and was blown away by the quality**, and the free version replaces SO many other plugins too. LOVE THIS!"_ ~[Jacob Wonder](https://wordpress.org/support/topic/amazing-plugin-2545/)

_"ASE is an amazing plugin! **Time and money saver**. Thank you!"_ ~[Iulian Baciu](https://wordpress.org/support/topic/amazing-plugin-precious/)

[**See more reviews >>**](https://www.wpase.com/)

### FEATURES & MODULES

**65 modules** in total:  
**55 free modules** (28 has Pro features) | **10 Pro modules**

[**See all features >>**](https://www.wpase.com/features/)

### Content Management

* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Custom Content Types**. Conveniently register and edit custom post types (CPT), custom taxonomies, custom field groups and options pages that integrates with Bricks, Breakdance, Oxygen and Elementor, and also compatible with Gutenberg and various block themes and plugins. This is an alternative for ACF Pro, Meta Box, Toolset, Pods or JetEngine.
* **Content Duplication**. One-click duplication of pages, posts and CPTs. [ASE Pro](https://www.wpase.com/rdme-to-web) enables duplication only for certain user roles and post types, and adds location option for duplication link.
* **Content Order**. Enable custom ordering of various post types that are hierarchical or support page attributes, in wp-admin. [ASE Pro](https://www.wpase.com/rdme-to-web) enables ordering of post types that are non-hierarchical and does not support page attributes, including media / attachments. It also enable toggling taxonomy terms and / or excerpt on the ordering page and applying the custom order on the frontend including for adjacent posts navigation.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Terms Order**. Enable custom ordering of terms from various taxonomies in wp-admin and on the frontend.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Media Categories**. Add categories for the media library and enable drag-and-drop categorization of media items.
* **Media Replacement**. Easily replace any type of media file with a new one while ensuring no existing links will break. [ASE Pro](https://www.wpase.com/rdme-to-web) allows replacing media from the grid view of media library as well.
* **SVG Upload**. Allow some or all user roles to upload SVG files, which will then be sanitized to keep things secure.
* **AVIF Upload**. Enable uploading AVIF files in the Media Library.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Public Preview for Drafts**. Enable public preview for draft posts from some or all public post types.
* **External Permalinks**. Enable pages, posts and/or custom post types to have permalinks that point to external URLs.
* **Open All External Links in New Tab**. Force all links to external sites to open in new browser tab via target="\_blank" attribute.
* **Allow Custom Navigation Menu Items to Open in New Tab**. Allow custom navigation menu items to have links that open in new browser tab via target="\_blank" attribute.
* **Auto-Publish Posts with Missed Schedule**. Trigger publishing of scheduled posts of all types marked with "missed schedule", anytime the site is visited.

### Admin Interface

* **Clean Up Admin Bar**. Remove various default elements from the admin bar. [ASE Pro](https://www.wpase.com/rdme-to-web) enables removal of admin bar items from other plugins.
* **Hide Admin Notices**. Clean up admin pages by moving notices into a separate panel easily accessible via the admin bar. [ASE Pro](https://www.wpase.com/rdme-to-web) adds the option to also hide notices for non-admins.
* **Disable Dashboard Widgets**. Clean up and speed up the dashboard by completely disabling some or all widgets.
* **Hide Admin Bar**. Hide admin bar on the frontend for all or some user roles. [ASE Pro](https://www.wpase.com/rdme-to-web) also allows hiding the admin bar on the backend for all or some user roles.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Admin Logo**. White label your admin area by making your branding stand out. Upload your brand logo in the admin bar or the (top of) admin menu.
* **Wider Admin Menu**. Give the admin menu more room to better accommodate wider items.
* **Admin Menu Editor / Organizer**. Customize the order of the admin menu and optionally change menu item title or hide some items. [ASE Pro](https://www.wpase.com/rdme-to-web) enables always hiding menu items for some or all user roles and reorder submenu items.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Admin Columns Manager**. Manage and organize columns in the admin listing for pages, posts and custom post types. Currently supports ASE, ACF and Meta Box custom fields.
* **Show Custom Taxonomy Filters**. Show additional filter(s) on list tables for hierarchical, custom taxonomies. [ASE Pro](https://www.wpase.com/rdme-to-web) adds option to show additional filter(s) for non-hierarchical taxonomies.
* **Enhance List Tables**. Improve the usefulness of listing pages of various post types by adding / removing columns and elements, e.g. featured image, excerpt, last modified, ID, media file size columns.
* **Various Admin UI Enhancements**: Various, smaller enhancements for different parts of the admin interface.
  * **Media Library Infinite Scrolling**: Re-enable infinite scrolling in the grid view of the media library.
  * **Display Active Plugins First**: Display active / activated plugins at the top of the Installed Plugins list.
  * **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Preserve Taxonomy Hierarchy**: Preserve the visual hierarchy of taxonomy terms checklist in the classic editor.
  * **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Enable Dashboard Columns Settings**: Enable manual settings of dashboard columns layout in Screen Options. You can choose between 1 to 4 columns.
  * **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Add User Role Slug(s) to Admin Body Classes**: Useful for when you need to modify the admin area only for certain user role(s).
  * **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Add Usermame to Admin Body Classes**: Useful for when you need to modify the admin area only for certain user(s).
  
* **Custom Admin Footer Text**: Customize the text you see on the footer of wp-admin pages. [ASE Pro](https://www.wpase.com/rdme-to-web) enables media upload / insertion.

### Log In/Out & Register

* **Change Login URL**. Make the login URL more memorable and secure by customizing it. [ASE Pro](https://www.wpase.com/rdme-to-web) adds compatibility with login process in WooCommerce pages, i.e. account and checkout, and custom 404 redirect on default login URLs.
* **Login ID Type**. Restrict login ID to username or email address only.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Login Page Customizer**. Easily customize the design of the login page.
* **Site Identity on Login Page**. Use the site icon and URL to replace the default WordPress logo with link to wordpress.org on the login page.
* **Log In/Out Menu**. Enable log in, log out and dynamic log in/out menu item for addition to any menu.
* **Registration Column**. Show users registration date. [ASE Pro](https://www.wpase.com/rdme-to-web) makes the column sortable.
* **Last Login Column**. Log when users on the site last logged in and display the date and time in the users list table. [ASE Pro](https://www.wpase.com/rdme-to-web) makes the column sortable.
* **Redirect After Login / Logout**. Set custom redirect URL for all or some user roles after login / logout. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to set separate redirect URL for each role.

### Custom Code

* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Code Snippets Manager**. Conveniently add and manage CSS / SCSS, JS, HTML and PHP code snippets to modify your site's content, design, behaviour and functionalities.
* **Custom Admin CSS**.
* **Custom Frontend CSS**.
* **Insert &lt;head&gt;, &lt;body&gt; and &lt;footer&gt; Code**. Easily insert &lt;meta&gt;, &lt;link&gt;, &lt;script&gt; and &lt;style&gt; tags for tracking, analytics, etc.
* **Custom Body Class**.
* **Manage ads.txt and app-ads.txt**.
* **Manage robots.txt**.

### Disable Components

* **Disable Gutenberg**. Disable the Gutenberg block editor for some or all applicable post types. Optionally disable frontend block assets. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to disable only on / except on certain post types, or on all post types.
* **Disable Comments**. Disable comments for some or all public post types. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to disable only on / except on certain post types, or on all post types.
* **Disable REST API**. Disable REST API access for non-authenticated users and remove URL traces from &lt;head&gt;, HTTP headers and WP RSD endpoint. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to enable access only for some, authenticated user roles, e.g. administrators.
* **Disable Feeds**. Disable all RSS, Atom and RDF feeds.
* **Disable All Updates**. Completely disable core, theme and plugin updates and auto-updates. Will also disable update checks, notices and emails.
* **Disable Smaller Components**. Prevent smaller components from running or loading. Those are generator &lt;meta&gt; tag, version number, Windows Live Writer (WLW) manifest &lt;link&gt; tag, Really Simple Discovery (RSD) &lt;link&gt; tag, WordPress shortlink &lt;link&gt; tag in &lt;head&gt;, and also dashicons CSS and JS files, emoji support, jQuery Migrate, block-based widgets settings screen, native lazy load of images and plugin / theme editor.

### Security

* **Limit Login Attempts**. Prevent brute force attacks by limiting the number of failed login attempts allowed per IP address. [ASE Pro](https://www.wpase.com/rdme-to-web) adds IP whitelisting, which is also useful to unblock users.
* **Obfuscate Author Slugs**. Obfuscate publicly exposed author page URLs that shows the user slugs / usernames.
* **Email Address Obfuscator**. Obfuscate email address to prevent spam bots from harvesting them,. [ASE Pro](https://www.wpase.com/rdme-to-web) enables output of obfuscated mailto: link and also auto-obfuscation of email addresses in post content.
* **Disable XML-RPC**. Protect your site from brute force, DOS and DDOS attacks via XML-RPC. Also disables trackbacks and pingbacks.

### Optimizations

* **Image Upload Control**. Resize newly uploaded, large images to a smaller dimension and delete originally uploaded files. BMPs and non-transparent PNGs will be converted to JPGs and resized. [ASE Pro](https://www.wpase.com/rdme-to-web) enables conversion to WebP with custom conversion quality.
* **Revisions Control**. Prevent bloating the database by limiting the number of revisions to keep for some or all post types supporting revisions.
* **Heartbeat Control**. Modify the interval of the WordPress heartbeat API or disable it on admin pages, post creation/edit screens and/or the frontend.

### Utilities

* **Email Delivery**. Set custom sender name and email. Optionally use external SMTP service to ensure notification and transactional emails from your site are being delivered to inboxes. [ASE Pro](https://www.wpase.com/rdme-to-web) adds the option to specify a custom reply-to name and email, Bcc address(es), disable authentication and the option to log email delivery.
* **[[ASE Pro](https://www.wpase.com/rdme-to-web)] Local User Avatar**. Enable usage of any image from WordPress Media Library as user avatars.
* **Multiple User Roles**. Enable assignment of multiple roles during user account creation and editing.
* **Image Sizes Panel**. Display a panel showing and linking to all available sizes when viewing an image in the media library. [ASE Pro](https://www.wpase.com/rdme-to-web) adds a convenient button to copy the image URL on click.
* **View Admin as Role**. View admin pages and the site (logged-in) as one of the non-administrator user roles.
* **Password Protection**. Password-protect the entire site to hide the content from public view and search engine bots / crawlers. [ASE Pro](https://www.wpase.com/rdme-to-web) adds IP whitelisting and bypassing via URL parameter, and also applies design elements from the Login Page Customizer module.
* **Maintenance Mode**. Show a simple maintenance message. [ASE Pro](https://www.wpase.com/rdme-to-web) adds option to set custom page and browser tab title, use WYSIWYG editor, use pattern, image, solid color background, apply custom CSS, and also add the option to use an existing page created with the block / classic editor or a page builder as the maintenance page. It also adds an option to allow non-admins to access the frontend.
* **Redirect 404**. Perform 301 (permanent) redirect to the homepage for all 404 (not found) pages. [ASE Pro](https://www.wpase.com/rdme-to-web) adds option to set custom redirect URL.
* **Display System Summary**. Show web server software, PHP version, database software and server IP address in the "At a Glance" dashboard widget. [ASE Pro](https://www.wpase.com/rdme-to-web) also shows the size of the site, database and root, wp-content, plugins, themes and upload folders.
* **Search Engines Visibility Status**. Show admin bar status and admin notice when search engines are set to be discouraged from indexing the site. [ASE Pro](https://www.wpase.com/rdme-to-web) adds a way to prevent dev / staging sites from having search engine visibility enabled.

[**See all features >>**](https://www.wpase.com/features/)

### ASE Pro

**Lifetime Deal (LTD)** is available at [www.wpase.com](https://www.wpase.com/rdme-to-web).

## Screenshots

1. Content Management
   ![Content Management](.wordpress-org/screenshot-1.png)
2. Admin Interface
   ![Admin Interface](.wordpress-org/screenshot-2.png)
3. Log In | Log Out
   ![Log In | Log Out](.wordpress-org/screenshot-3.png)
4. Custom Code
   ![Custom Code](.wordpress-org/screenshot-4.png)
5. Disable Components
   ![Disable Components](.wordpress-org/screenshot-5.png)
6. Security
   ![Security](.wordpress-org/screenshot-6.png)
7. Optimizations
   ![Optimizations](.wordpress-org/screenshot-7.png)
8. Utilities
   ![Utilities](.wordpress-org/screenshot-8.png)
9. Admin Menu Organizer module
   ![Admin Menu Organizer module](.wordpress-org/screenshot-9.png)
10. Email Delivery module
   ![Email Delivery module](.wordpress-org/screenshot-10.png)

## Frequently Asked Questions

### How Do I Reset ASE Settings / Configuration?

If for whatever reason you need to remove ASE and reset the settings / configuration, please follow these steps:

1. Access your website via FTP and delete ASE plugin folder at /wp-content/plugins/admin-site-enhancements/
2. Login to your site via the default URL, /wp-admin/ or /wp-login.php
3. Install [SQL Buddy](https://wordpress.org/plugins/sql-buddy/) plugin, open it, and click on the wp_options table
4. Use the small filter icon at the top of wp_options table rows, and filter for “option_name” => “contains” => “admin_site_enhancements”. You should get 3 options . Click on each one and hit the “Delete” icon in the bottom-right corner.
5. Re-install and re-configure ASE as needed.

You can skip step 1 and 2 if you still have access to your wp-admin dashboard.

### Does ASE Work With Multisite?

ASE does not officially support multisite. Please use at your own risk. That said, several users have reported that it works fine on their multisite when activated on each sub-site and not through network activation.

## Changelog

**Admin and Site Enhancements (ASE) v1.0.0** was released on October 17, 2022. Since then, there have been **76 _major_ releases** (e.g. 1.1.0 ) and **131 _minor_ releases** (e.g. 4.9.1). 

Each **_major release_** usually corresponds with the addition of one new module/feature. Each module/feature usually is the equivalent of one (or more) single-purpose plugin. Each **_minor release_** usually contain one or more bugfix or improvements to existing modules/features.

[**Upgrade to ASE Pro**](https://www.wpase.com/chnlg-to-web). Lifetime Deal (LTD) available.

### 7.6.6 (2025.01.13) - ASE Free and Pro

* **[IMPROVED in Pro] Admin Interface >> Admin Logo**: 
  * add option to show the **admin menu logo in the backend** and show the **admin bar logo in the frontend**. Props to Max Z. for suggesting this.
  * add option to link the admin bar logo to the dashboard when it is shown on the frontend. Props to Max Z. for suggesting this.

* **[IMPROVED and FIXED in Pro] Custom Code >> Code Snippets Manager**: 
  * add option to **execute PHP snippet via a secure URL**.
  * add option to **set the load / execution priority / order** for all snippet types.
  * improved reliability of mechanism to record error when creating / updating PHP snippets
  * fixed fatal error when creating non-PHP snippet in a certain scenario

* **[IMPROVED in Pro] Admin Interface >> Various Admin UI Enhancements**: add an option to open all admin page links in new tab. Useful for people who prefer this workflow by default, instead of pressing the Ctrl or Command button while clicking on a link. Props to Rick A. for suggesting this improvement.

* **[FIXED in Free and Pro] Admin Interface >> Hide Admin Notices**: fixed notices being displayed on Pods plugin's admin screen.

* **[FIXED in Pro] Utilities >> Display System Summary**: fix fatal error in a certain scenario when trying to load the dashboard widget. This has to do with a symlinked directory present in the WP root folder that links to a destination not defined in open_basedir. Props to Rado R. for reporting the issue in details and facilitating the troubleshooting process.

* **[FIXED in Pro] ASE Settings >> Export | Import**: fixed a bug where export was not working as expected. Props to David R. for reporting the issue.

* **[TRANSLATION in Free and Pro]** ASE is now being translated into 29 languages:
  * **Added new/improved translation** for:
    * Free: updated Norwegian, Portuguese (Brazil), Albanian
    * Pro: updated Czech, Spanish (Spain), French, Hungarian, Norwegian, Dutch, Polish, Portuguese (Brazil), Vietnamese
  * **More strings have been internationalized**. @Translators, please visit the respective project pages for the Free and Pro versions to translate the new strings, if you havent' done so already.
  * **Interested to help translate or improve the translation?** Please go to [https://translate.wpase.com](https://translate.wpase.com) for more info.
  * **Chinese (China)**: ASE Free and Pro (completed). Props to [@bricksvip](https://profiles.wordpress.org/bricksvip/) et al.
  * **Portuguese (Brazil)**: ASE Free and ASE Pro (completed). Props to [Dennis F.](https://profiles.wordpress.org/dnn/), [denisgomesfranco](https://profiles.wordpress.org/denisgomesfranco/), [Denison C.](https://profiles.wordpress.org/denisoncarlos/) and [@ofmarconi](https://profiles.wordpress.org/ofmarconi/).
  * **Hungarian**: ASE Free and Pro (completed). Props to [R. József G.](https://profiles.wordpress.org/radicsjg/) et al.
  * **Vietnamese**: ASE Free and Pro (completed). Props to [Hoang N.Q.](https://profiles.wordpress.org/nguyenquanghoang/) et al.
  * **Italian**: ASE Free and Pro (completed). Props to [Fabio P.](https://profiles.wordpress.org/fabioperri/) et. al.
  * **Dutch**: ASE Free and Pro (completed). Props to [Toine R](https://profiles.wordpress.org/toineenzo/) and [Peter S.](https://profiles.wordpress.org/psmits1567/) et al.
  * **Korean**: ASE Free and Pro (completed). Props to [@chazmlab](https://profiles.wordpress.org/chazmlab/) et al.
  * **German (Formal)**: ASE Free and Pro (completed). Props to [@markussss](https://profiles.wordpress.org/markussss/), Bastian S. et al.
  * **French**: ASE Free and Pro (completed). Props to [Stéphan G.](https://profiles.wordpress.org/gongonzo/), [@jeanfrancoisdelvin](https://profiles.wordpress.org/jeanfrancoisdelvin/), [@srossignol](https://profiles.wordpress.org/srossignol/), [@lucashw](https://profiles.wordpress.org/lucashw/), [@skippy43](https://profiles.wordpress.org/skippy43/), [@anlip](https://profiles.wordpress.org/anlip/), [@agencefacton](https://profiles.wordpress.org/agencefacton/), [@injsbx](https://profiles.wordpress.org/injsbx/) et al.
  * **Polish**: ASE Free and Pro (completed). Props to [@kosmity](https://profiles.wordpress.org/kosmity/) and [Dariusz Z.](https://profiles.wordpress.org/dariobros/) et al.
  * **Norwegian**: ASE Free and Pro (completed). Props to [Alf O.F.](https://profiles.wordpress.org/skoen/) et al.
  * **Czech**: ASE Free and Pro (completed). Props to Jan S. et al.
  * **Spanish**: ASE Free and Pro (completed). Props to [@marcorubiol](https://profiles.wordpress.org/marcorubiol/) et al.
  * **Slovak**: ASE Free and Pro (completed). Props to [Dominik K.](https://profiles.wordpress.org/dominokozmali/) et al.
  * **Indonesian**: ASE Free and Pro (completed). Props to [@pakacil](https://profiles.wordpress.org/pakacil/), [Wawan S.](https://profiles.wordpress.org/ahmad-rafiansyah/) et al.
  * **Portuguese (Portugal)**: ASE Free (completed) | ASE Pro (partial). Props to [Ricardo C.](https://profiles.wordpress.org/madebyuh/) et al.
  * **Ukrainian**: ASE Free (completed) | ASE Pro (partial). Props to [Irina](https://profiles.wordpress.org/irinashl/) et al.
  * **Urdu**: ASE Free (completed) | ASE Pro (partial). Props to [Ayyaz A.](https://profiles.wordpress.org/ayyazahmad/) et al.
  * **Swedish**: ASE Free (completed) | ASE Pro (partial). Props to [Robert M.](https://profiles.wordpress.org/robertmichalski/) and [Tor-Bjorn F.](https://profiles.wordpress.org/tobifjellner/).
  * **Danish**: ASE Free (completed) | ASE Pro (partial). Props to [Morten E.L.](https://profiles.wordpress.org/ellegaarddk/), [Helgi P.](https://profiles.wordpress.org/helgipetersen/) and [Kurt M.A.](https://profiles.wordpress.org/moskjaer/) et al.
  * **Arabic**: ASE Free (completed) | ASE Pro (completed). Props to [Mohammed J.](https://profiles.wordpress.org/ih4xz/), Yaser M., et al.
  * **Romanian**: ASE Free (completed) | ASE Pro (partial). Props to [Dan C.](https://profiles.wordpress.org/dancaragea/), [@ravishi](https://profiles.wordpress.org/ravishi/) et al.
  * **Turkish**: ASE Free (completed). Props to [@saeead](https://wordpress.org/support/users/saeead/), [@serdaroztrk](https://profiles.wordpress.org/serdaroztrk/) et al.
  * **Chinese (Taiwan)**: ASE Free (completed). Props to [@gordon168](https://profiles.wordpress.org/gordon168/) and [Hedula](https://profiles.wordpress.org/hedula/).
  * **Spanish (Chile)**: ASE Free (completed). Props to [@srgio](https://profiles.wordpress.org/srgio/).
  * **Serbian**: ASE Free (partial). Props to [Igor E.](https://wordpress.org/support/users/igorel/).
  * **Albanian**: ASE Free (partial). Props to [@algertpateqi](https://profiles.wordpress.org/algertpateqi/).
  * **Persian**: ASE Free (completed). Props to [@saeead](https://profiles.wordpress.org/saeead/) et al.
  * **Russian**: ASE Free (completed). Props to [@sergey369](https://profiles.wordpress.org/sergey369/), [@pfgr](https://profiles.wordpress.org/pfgr/) et al.
  
[**See the full changelog >>**](https://www.wpase.com/documentation/changelog/)