# Advanced Forms

[Documentation](https://advancedforms.github.io) | [Install](https://wordpress.org/plugins/advanced-forms/) | [Purchase Pro](https://hookturn.io/downloads/advanced-forms-pro) | [Support](#support)
 
Advanced Forms is a WordPress plugin for creating front-end forms using [Advanced Custom Fields](https://advancedcustomfields.com). It supports all ACF field types, including repeaters and flexible content fields, and provides the same field editing interface you are already familiar with. Advanced Forms is available on the [plugin directory](https://wordpress.org/plugins/advanced-forms/).

- **Email notifications**: Configure an unlimited number of email notifications, including support for dynamic recipients and field includes.
- **AJAX submissions**: Use AJAX for a better user experience with faster submissions and no page reloads.
- **Entries**: Save form submissions as entries with all fields.
- **Spam protection**: Every form is protected against spam using a honeypot. If you need more sophisticated spam protection, Advanced Forms Pro includes support for reCAPTCHA.
- **Restrictions**: Place limits on your form using the built-in restrictions or [create your own](https://advancedforms.github.io/guides/advanced/adding-custom-restrictions/):
    + Limit the total number of submissions
    + Limit your form to only logged-in users
    + Limit the time when your form can be used
- **User-friendly UI**: Create forms either through the admin UI or programmatically for easy integration.
- **Gutenberg support**: Add forms to your site using Gutenberg blocks.
- **Developer-friendly**: Designed for developers with a large variety of hooks and helper functions and [comprehensive documentation](https://advancedforms.github.io).

## Pro

On top of that, **Advanced Forms Pro** offers even more features for advanced use cases. You can purchase a license through [Hookturn](https://hookturn.io/downloads/advanced-forms-pro/) which can be used on an unlimited number of sites.

- **Priority support**: Get direct support with an average response time of 1-2 days.
- **Post editing**: Set up forms to create and edit posts. Configure the post title, content and status and automatically map your existing ACF fields.
- **User editing**: Register new users or let people edit their user profile with automatic mapping of your user fields.
- **Calculated fields**: Give your users immediate feedback as they fill out your form. Calculated fields update live with the values from other fields. Calculated fields are also [fully programmable](https://advancedforms.github.io/pro/configuration/using-calculated-fields/) for more complex calculations.
- **Slack**: Get a message in [Slack](https://slack.com) for each form submission, including all form data.
- **Mailchimp**: Create a form to sign users up for your [Mailchimp](https://mailchimp.com) mailing list.
- **Zapier**: Connect your form to thousands of third-party services using [Zapier](https://zapier.com).
- **Google reCAPTCHA**: Protect your forms against spam using an invisible captcha.

## Support

If you need help, have a feature request, or think you've found a bug, don't hesitate to reach out. Either create a ticket on the [WordPress Support Forums](https://wordpress.org/support/plugin/advanced-forms/) or an issue on [Github](http://github.com/advancedforms/advanced-forms/issues).

For Pro users, please send an email to [support@hookturn.io](mailto:support@hookturn.io?subject=Advanced%20Forms) and we'll respond as fast as we can, most often within 1-2 days.