<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

use AmeliaBooking\Infrastructure\Licence;

/**
 * Class BackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class BackendStrings
{
    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getCommonStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add'                                 => __('Add', 'wpamelia'),
            'active'                              => __('Active', 'wpamelia'),
            'all'                                 => __('All', 'wpamelia'),
            'all_extras'                          => __('All Extras', 'wpamelia'),
            'all_locations'                       => __('All Locations', 'wpamelia'),
            'all_packages'                        => __('All Packages', 'wpamelia'),
            'all_events'                          => __('All Events', 'wpamelia'),
            'amount_fixed'                        => __('Fixed amount', 'wpamelia'),
            'amount_percentage'                   => __('Percentage', 'wpamelia'),
            'amount_type'                         => __('Amount type', 'wpamelia'),
            'apply_coupon'                        => __('Apply Coupon:', 'wpamelia'),
            'available'                           => __('Available', 'wpamelia'),
            'badge_color'                         => __('Badge Color', 'wpamelia'),
            'badge_label'                         => __('Badge Label', 'wpamelia'),
            'booking'                             => __('Booking', 'wpamelia'),
            'bookings'                            => __('Bookings', 'wpamelia'),
            'canceled_by_admin'                   => __('Canceled By Admin', 'wpamelia'),
            'canceled_by_attendee'                => __('Canceled By Attendee', 'wpamelia'),
            'confirm'                             => __('Confirm', 'wpamelia'),
            'create'                              => __('Create', 'wpamelia'),
            'csv_delimiter_semicolon'             => __('Semicolon (;)', 'wpamelia'),
            'coupon'                              => __('Coupon', 'wpamelia'),
            'coupon_unknown'                      => __('The coupon you entered is not valid', 'wpamelia'),
            'create_new_badge'                    => __('Create New Badge', 'wpamelia'),
            'customer_already_booked'             => __('Customer has already booked this appointment', 'wpamelia'),
            'date_specific'                       => __('Specific Date', 'wpamelia'),
            'enter_email_then_press_enter_to_add' => __('Enter email, then press Enter to add', 'wpamelia'),
            'expired'                             => __('Expired', 'wpamelia'),
            'expires_on'                          => __('Expires on', 'wpamelia'),
            'discard'                             => __('Discard', 'wpamelia'),
            'discount'                            => __('Discount (%)', 'wpamelia'),
            'expiration_date'                     => __('Expiration date', 'wpamelia'),
            'event_tickets'                       => __('Tickets', 'wpamelia'),
            'fixed_amount'                        => __('Fixed amount', 'wpamelia'),
            'fully_booked'                        => __('Fully Booked', 'wpamelia'),
            'google_meet_link'                    => __('Google Meet Link', 'wpamelia'),
            'import'                              => __('Import', 'wpamelia'),
            'lesson_space_new_space'              => __('New Space', 'wpamelia'),
            'appointment_space_name_tt'           => __('Name of the space(room) that will be created for appointments.<br/>You can find available placeholders on the Notifications page.<br/>If left empty, space will be named after appointment ID.', 'wpamelia'),
            'event_space_name_tt'                 => __('Name of the space(room) that will be created for events.<br/>You can find available placeholders on the Notifications page.<br/>If left empty, space will be named after event period ID.', 'wpamelia'),
            'lesson_space_link'                   => __('Lesson Space Link', 'wpamelia'),
            'lesson_space_pending_tt'             => __('Enable this option if you want to create spaces for appointments with pending status.', 'wpamelia'),
            'manage_badges'                       => __('Manage Badges', 'wpamelia'),
            'manage_employee_badges'              => __('Manage Employee Badges', 'wpamelia'),
            'microsoft_teams_link'                => __('Microsoft Teams Link', 'wpamelia'),
            'no_employees_yet'                    => __('You don\'t have any employees here yet...', 'wpamelia'),
            'on_site_tooltip'                     => __('Here you can enable/disable On-Site payments for this service', 'wpamelia'),
            'package'                             => __('Package', 'wpamelia'),
            'package_price'                       => __('Package Price', 'wpamelia'),
            'payment_warning'                     => __('You have disabled all available payment methods. This means that default payment method from general settings will be used.', 'wpamelia'),
            'payment_warning_settings'            => __('Some services/events have all payment methods disabled. This means that default payment method will be used for those services/events.', 'wpamelia'),
            'percentage'                          => __('Percentage', 'wpamelia'),
            'period'                              => __('Period', 'wpamelia'),
            'php_version_message'                 => __('<p>The <strong>Amelia</strong> plugin requires PHP version 5.5 or greater.</p>', 'wpamelia'),
            'php_version_title'                   => __('Plugin Activation Error', 'wpamelia'),
            'pick_a_date'                         => __('Pick a date range', 'wpamelia'),
            'elementor_popup_notice'              => __('Please use the built-in Elementor shortcode widget instead of Amelia widget when adding Amelia to a popup', 'wpamelia'),
            'profile'                             => __('Hide Employee Profile', 'wpamelia'),
            'recurring'                           => __('Recurring', 'wpamelia'),
            'recurring_type_daily'                => __('Daily', 'wpamelia'),
            'recurring_type_monthly'              => __('Monthly', 'wpamelia'),
            'recurring_type_weekly'               => __('Weekly', 'wpamelia'),
            'recurring_type_yearly'               => __('Yearly', 'wpamelia'),
            'refund'                              => __('Refund', 'wpamelia'),
            'refunded'                            => __('Refunded', 'wpamelia'),
            'rescheduled'                         => __('Rescheduled', 'wpamelia'),
            'resource'                            => __('Resource', 'wpamelia'),
            'required_field'                      => __('This field is required', 'wpamelia'),
            'package_appointments'                => __('Package Appointments', 'wpamelia'),
            'package_status'                      => __('Package Status', 'wpamelia'),
            'recurring_every'                     => __('Every:', 'wpamelia'),
            'schedule'                            => __('Schedule', 'wpamelia'),
            'select_cycle_warning'                => __('Please select repeat period', 'wpamelia'),

            'select_interval_warning'             => __('Please select repeat interval', 'wpamelia'),
            'select_time'                         => __('Select Time', 'wpamelia'),
            'shared'                              => __('Shared', 'wpamelia'),
            'sort'                                => __('Sort', 'wpamelia'),
            'total_number_of_people'              => __('Total Number of People:', 'wpamelia'),
            'type'                                => __('Type', 'wpamelia'),
            'unique'                              => __('Unique', 'wpamelia'),
            'zoom_join_link'                      => __('Zoom Join Link (Participants)', 'wpamelia'),
            'zoom_start_link'                     => __('Zoom Start Link (Host)', 'wpamelia'),
            'zoom_user'                           => __('Zoom User', 'wpamelia'),
            'zoom_user_placeholder'               => __('Select Zoom User', 'wpamelia'),
            'zoom_warning'                        => __('Certain employees that are assigned to the service are not connected to Zoom users. Please go to employees\' profiles and connect them to Zoom users in order to use this integration properly.', 'wpamelia'),
            'unlimited'                           => __('Unlimited', 'wpamelia'),
            'waiting_list_empty'                  => __('Waiting list is empty', 'wpamelia'),
            'wc_order'                            => __('Order', 'wpamelia'),
            'wc_order_id'                         => __('Woocommerce Order Id', 'wpamelia'),
            'wc_order_id_export'                  => __('Woo Order Id', 'wpamelia'),
            'tax'                                 => __('Tax', 'wpamelia'),

            'customize_dialog_heading'            => __('New Event List 2.0 Booking Form', 'wpamelia'),
            'customize_dialog_sub_heading'        => __('Introducing Event List 2.0 - A Fresh, Modern, and User-Friendly Booking Form! Enjoy the new filters and search functionality, simplifying event discovery and streamlining the booking process. Explore new customization options by going to the Customize page or use <strong>[ameliaeventlistbooking]</strong> for a faster and personalized look.', 'wpamelia'),
            'customize_dialog_faster'             => __('Faster Pages', 'wpamelia'),
            'customize_dialog_easy'               => __('Easy Customization', 'wpamelia'),
            'customize_dialog_friendly'           => __('More User-Friendly Design', 'wpamelia'),
            'customize_dialog_go_to'              => __('Go to the Customize Event List 2.0 page', 'wpamelia'),
            'customize_dialog_check'              => __('Check it out Event List 2.0', 'wpamelia'),
            'customize_dialog_close'              => __('Close', 'wpamelia'),

            'survey_heading'                      => __('Quick Survey', 'wpamelia'),
            'survey_close'                        => __('Close forever', 'wpamelia'),
            'survey_maybe'                        => __('Maybe later', 'wpamelia'),
            'survey_sure'                         => __('Yes, Sure!', 'wpamelia'),
            'survey_content'                      => __('<div>Hey there!</div><span>We would like to know you a little bit better! Could you spare a minute or two to answer a few questions?</span>', 'wpamelia'),

            'whats_new_heading'                   => __('New update is here!', 'wpamelia'),
            'whats_new_go_to'                     => __('Go to the What\'s New page', 'wpamelia'),
            'warning'                             => __('Warning', 'wpamelia'),
            'waiting_list_capacity_warning'       => __('By approving this attendee, you have exceeded the event capacity.', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getCommonStrings());
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getSettingsStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'activation_activated'                   => __('Plugin has been activated', 'wpamelia'),
            'activation_deactivated'                 => __('Plugin has been deactivated', 'wpamelia'),
            'activation_envato_failed'               => __('It seems that Envato API is currently busy (please try again) or you don\'t have a valid purchase of Amelia', 'wpamelia'),
            'activation_settings_domains_limit'      => __('You have reached maximum number of registered domains', 'wpamelia'),
            'activation_settings_invalid_code'       => __('The purchase code is invalid or it has expired', 'wpamelia'),
            'activation_settings_hidden_code'        => __('Your purchase code has been hidden for security reasons. You can find it on your store page', 'wpamelia'),
            'add_metaData'                           => __('Add New MetaData', 'wpamelia'),
            'add_new_role'                           => __('Add New Role', 'wpamelia'),
            'allow_customer_delete_profile_tooltip'  => __('Enable this option if you want to allow your customers to delete their profile data (bookings won\'t be deleted).', 'wpamelia'),
            'amelia_role'                            => __('Amelia Role', 'wpamelia'),
            'appointments'                           => __('Appointments', 'wpamelia'),
            'bcc_email_placeholder'                  => __('Please enter email address', 'wpamelia'),
            'bcc_sms_placeholder'                    => __('Please enter phone number', 'wpamelia'),
            'codecanyon_purchase_code'               => __('CodeCanyon Purchase Code', 'wpamelia'),
            'cart'                                   => __('Cart', 'wpamelia'),
            'analytics_event_tooltip'                => __('Name of the event (standard or custom)', 'wpamelia'),
            'employee_selection_logic_round_robin'   => __('Round Robin', 'wpamelia'),
            'employee_selection_logic_highest_price' => __('Highest price', 'wpamelia'),
            'employee_selection_logic_lowest_price'  => __('Lowest price', 'wpamelia'),
            'empty_package_email'                    => __('Notify selected employees about empty package purchases', 'wpamelia'),
            'empty_package_email_tooltip'            => __('These employees will receive the package purchased e-mail notification when it is purchased without any appointments booked.', 'wpamelia'),
            'enable_google_meet_tooltip'             => __('Enable this option if you want to include Google Meet in your event.', 'wpamelia'),
            'enable_microsoft_teams_tooltip'         => __('Enable this option if you want to include Microsoft Teams in your event.', 'wpamelia'),
            'custom_fields'                          => __('Custom Fields', 'wpamelia'),
            'custom_fields_description'              => __('Add/edit custom fields', 'wpamelia'),
            'custom_fields_settings'                 => __('Custom fields settings', 'wpamelia'),
            'customers_as_attendees_tooltip'         => __('Enable this option if you want your employees to see<br/>in the event customers that attend the appointment.', 'wpamelia'),
            'customer_cabinet_tooltip'               => __('Enter here URL of the page with [ameliacustomerpanel] shortcode if you want to send it to your customers in notifications.<br/>Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'employee_cabinet_tooltip'               => __('Enter here URL of the page with [ameliaemployeepanel] shortcode if you want to send it to your employees in notifications.<br/>Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'dashboard'                              => __('Dashboard', 'wpamelia'),
            'day1'                                   => __('1 day', 'wpamelia'),
            'days2'                                  => __('2 days', 'wpamelia'),
            'days3'                                  => __('3 days', 'wpamelia'),
            'days4'                                  => __('4 days', 'wpamelia'),
            'days5'                                  => __('5 days', 'wpamelia'),
            'days6'                                  => __('6 days', 'wpamelia'),
            'days_off_settings'                      => __('Days Off Settings', 'wpamelia'),
            'days_off_settings_description'          => __('Use these settings to set company working hours and days off which will be applied for every employee', 'wpamelia'),
            'deactivate'                             => __('Deactivate', 'wpamelia'),
            'description_mollie'                     => __('Description for Mollie', 'wpamelia'),
            'description_paypal'                     => __('Description for PayPal', 'wpamelia'),
            'description_razorpay'                   => __('Description for Razorpay', 'wpamelia'),
            'name_razorpay'                          => __('Name for Razorpay', 'wpamelia'),
            'description_stripe'                     => __('Description for Stripe', 'wpamelia'),
            'description_wc'                         => __('Description for WooCommerce', 'wpamelia'),
            'enabled'                                => __('Enabled', 'wpamelia'),
            'endpoint'                               => __('Endpoint', 'wpamelia'),
            'endpoint_tooltip'                       => __('Enter here an endpoint if you are using Mailgun from EU countries', 'wpamelia'),
            'enter_valid_url_warning'                => __('Please enter a valid URL with protocol (http:// or https://)', 'wpamelia'),
            'envato_api_activated'                   => __('Activated with Envato', 'wpamelia'),
            'event_description'                      => __('Event Description', 'wpamelia'),
            'event_description_tooltip'              => __('Description of the event that will be displayed in the Google Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_description_tooltip_outlook'      => __('Description of the event that will be displayed in the Outlook Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_description_tooltip_apple'        => __('Description of the event that will be displayed in the Apple Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_title'                            => __('Event Title', 'wpamelia'),
            'event_title_tooltip'                    => __('Title of the event that will be displayed in the Google Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_title_tooltip_outlook'            => __('Title of the event that will be displayed in the Outlook Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'event_title_tooltip_apple'              => __('Title of the event that will be displayed in the Apple Calendar.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'meeting_title_tooltip'                  => __('Title of the meeting that will be displayed in the Zoom.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'meeting_agenda_tooltip'                 => __('Agenda of the meeting that will be displayed in the Zoom.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'api_key'                                => __('API key', 'wpamelia'),
            'api_key_copied'                         => __('Copied!', 'wpamelia'),
            'api_key_permissions'                    => __('API key Permissions', 'wpamelia'),
            'new_api_key'                            => __('New API key', 'wpamelia'),
            'api_key_last_4_characters'              => __('Last 4 characters', 'wpamelia'),
            'api_key_expiration_date'                => __('Expiration Date', 'wpamelia'),
            'generate_api_key'                       => __('Generate API key', 'wpamelia'),
            'generate_api_key_warning'               => __('Copy your API key because it won’t be visible again.', 'wpamelia'),
            'google_calendar_settings'               => __('Google Calendar Settings', 'wpamelia'),
            'google_calendar_settings_description'   => __("Allow synchronizing employee's calendar with Google Calendar for smoother personal scheduling", 'wpamelia'),
            'zoom_settings'                          => __('Zoom Settings', 'wpamelia'),
            'google_credentials_obtain'              => __('Click here to see how to obtain<br/>Google Client ID and Secret', 'wpamelia'),
            'outlook_credentials_obtain'             => __('Click here to see how to obtain<br/>Outlook Application (client) ID and Secret', 'wpamelia'),
            'apple_credentials_obtain'               => __('Click here to see how to obtain<br/>iCloud Email Address and iCloud App-specific Password', 'wpamelia'),
            'marketing_add_tracking'                 => __('Add Tracking', 'wpamelia'),
            'marketing_field_warning'                => __('Please fill out this field.', 'wpamelia'),
            'google_analytics_category'              => __('Category', 'wpamelia'),
            'analytics_event'                        => __('Event', 'wpamelia'),
            'google_analytics_action'                => __('Action', 'wpamelia'),
            'google_analytics_label'                 => __('Label', 'wpamelia'),
            'google_analytics_value'                 => __('Value', 'wpamelia'),
            'marketing_type_warning'                 => __('Please select type.', 'wpamelia'),
            'marketing_delete_confirmation'          => __('Are you sure you want to delete this Event', 'wpamelia'),
            'google_redirect_uri_tooltip'            => __('This is the path in your application that users are redirected to after<br/>they have authenticated with Google. Add this URI in your Google<br/>project credentials under "Authorized redirect URIs".', 'wpamelia'),
            'outlook_redirect_uri_tooltip'           => __('This is the path in your application that users are redirected to after<br/>they have authenticated with Outlook. Add this URI in your Outlook<br/>application under "Redirect URIs".', 'wpamelia'),
            'apple_redirect_uri_tooltip'             => __('This is the path in your application that users are redirected to after<br/>they have authenticated with Apple. Add this URI in your Apple<br/>project credentials under "Redirect URIs".', 'wpamelia'),
            'zoom_credentials_obtain'                => __('Click here to see how to obtain<br/>Zoom API Key and Secret', 'wpamelia'),
            'zoom_credentials_tooltip'               => __('Click here to see how to obtain<br/>Zoom Application ID, Client ID and Client Secret', 'wpamelia'),
            'iplocate_api_key'                       => __('IPLocate Api Key', 'wpamelia'),
            'iplocate_api_key_tooltip'               => __('Please sign up for an API key at iplocate.io/signup for 1000 free API requests/day.<br/> The limit for access without an API key has been reduced to 50 requests/day.', 'wpamelia'),
            'limit_app_per_customer_from'            => __('Time period is calculated from', 'wpamelia'),
            'limit_app_per_customer_from_tt'         => __('‘Booking date and time’ will set the limit based on the date when the booking is created, regardless of the appointment date and time.<br>The ‘Appointment date and time’ option will set the limit based on the appointment scheduled date.', 'wpamelia'),
            'limit_app_per_employee'                 => __('Limit appointments per employee', 'wpamelia'),
            'limit_app_per_employee_tt'              => __('Set this option if you want to limit the number of appointments that an employee can have daily no matter how many appointments ‘fit’ inside the working hours', 'wpamelia'),
            'limit_app_booking_date'                 => __('Appointment date and time', 'wpamelia'),
            'limit_app_date_booked'                  => __('Booking date and time', 'wpamelia'),
            'limit_events_per_customer_from'         => __('Time period is calculated from', 'wpamelia'),
            'limit_events_per_customer_from_tt'      => __('‘Booking date and time’ will set the limit based on the date when the booking is created, regardless of the event’s date and time.<br>The ‘Event start date and time’ will set it based on the event’s start date and time.', 'wpamelia'),
            'limit_events_booking_date'              => __('Event start date and time', 'wpamelia'),
            'limit_events_booking_date_tt'           => __('Limit will be based on the event date, not based on the date when booking is created.', 'wpamelia'),
            'limit_events_date_booked'               => __('Booking date and time', 'wpamelia'),
            'limit_events_date_booked_tt'            => __('Limit will be based on the date when booking is created, regardless of the event date and time.', 'wpamelia'),
            'number_of_events'                       => __('Number of events', 'wpamelia'),
            'insert_pending_appointments_tooltip'    => __('Enable this option if you want your employees to see<br/>appointments with pending status in their calendar.', 'wpamelia'),
            'pending_appointments_meetings_tooltip'  => __('Enable this option if you want to create zoom meetings for appointments with pending status.', 'wpamelia'),
            'instructions'                           => __('Instructions', 'wpamelia'),
            'labels_settings_web_hooks'              => __('Use these settings to register URLs to which booking information will be sent when booking action occurs.', 'wpamelia'),
            'limit_number_of_fetched_events'         => __('Limit Number of Fetched Events', 'wpamelia'),
            'live_api_key'                           => __('Live API Key', 'wpamelia'),
            'live_client_id'                         => __('Live Client ID', 'wpamelia'),
            'live_key_id'                            => __('Live Key ID', 'wpamelia'),
            'live_key_secret'                        => __('Live Key Secret', 'wpamelia'),
            'live_publishable_key'                   => __('Live Publishable Key', 'wpamelia'),
            'live_secret'                            => __('Live Secret', 'wpamelia'),
            'live_secret_key'                        => __('Live Secret Key', 'wpamelia'),
            'mailgun_api_key'                        => __('Mailgun API Key', 'wpamelia'),
            'mailgun_api_key_warning'                => __('Please enter Mailgun API key', 'wpamelia'),
            'mailgun_domain'                         => __('Mailgun Domain', 'wpamelia'),
            'mailgun_domain_warning'                 => __('Please enter Mailgun Domain', 'wpamelia'),
            'metadata_value_tooltip'                 => __('You can find available placeholders on the Notifications page', 'wpamelia'),
            'mollie'                                 => __('Mollie', 'wpamelia'),
            'mollie_service'                         => __('Mollie Service', 'wpamelia'),
            'mollie_test_api_key_error'              => __('Please enter test API Key', 'wpamelia'),
            'mollie_live_api_key_error'              => __('Please enter live API Key', 'wpamelia'),
            'months3'                                => __('3 months', 'wpamelia'),
            'months6'                                => __('6 months', 'wpamelia'),
            'name'                                   => __('Name', 'wpamelia'),
            'number_of_appointments'                 => __('Number of appointments', 'wpamelia'),
            'number_of_events_returned_tooltip'      => __('Maximum number of events returned on one result page.<br/>It is recommended to use smaller number of returned<br/>events if your server performance is not so good.', 'wpamelia'),
            'number_of_packages'                     => __('Number of packages', 'wpamelia'),
            'outlook_email_warning'                  => __('Outlook Mailer is not fully configured. Please complete the account setup in the Outlook Integration settings.', 'wpamelia'),
            'payment_from_customer_panel'            => __('Allow customer to pay via Customers Panel', 'wpamelia'),
            'payment_links_change_status'            => __('Update booking status automatically', 'wpamelia'),
            'payment_links_change_status_tooltip'    => __('Update booking status to approved after succesfull payment from link', 'wpamelia'),
            'payment_links_redirect'                 => __('Redirect URL after Payment', 'wpamelia'),
            'payment_links_redirect_tooltip'         => __('Customer will be redirected to this URL once the payment from the link is processed.', 'wpamelia'),
            'payment_links_warning'                  => __('Please note: For this option to work you need to add new payment link placeholders to the message templates', 'wpamelia'),
            'payPal'                                 => __('PayPal', 'wpamelia'),
            'payPal_live_client_id_error'            => __('Please enter live ClientId', 'wpamelia'),
            'payPal_live_secret_error'               => __('Please enter live Secret', 'wpamelia'),
            'payPal_service'                         => __('PayPal Service', 'wpamelia'),
            'payPal_test_client_id_error'            => __('Please enter test ClientId', 'wpamelia'),
            'payPal_test_secret_error'               => __('Please enter test Secret', 'wpamelia'),
            'plugin_not_activated'                   => __('To receive automatic updates license activation is required. Please visit %s to activate Amelia.', 'wpamelia'),
            'razorpay'                               => __('Razorpay', 'wpamelia'),
            'razorpay_live_client_id_error'          => __('Please enter live key id', 'wpamelia'),
            'razorpay_live_secret_error'             => __('Please enter live key secret', 'wpamelia'),
            'razorpay_service'                       => __('Razorpay Service', 'wpamelia'),
            'razorpay_test_client_id_error'          => __('Please enter test key id', 'wpamelia'),
            'razorpay_test_secret_error'             => __('Please enter test key secret', 'wpamelia'),
            'recaptcha_invisible'                    => __('Add "Invisible Google reCaptcha"', 'wpamelia'),
            'recaptcha_invisible_tooltip'            => __('If you enable this option Google reCAPTCHA will stay visible in the bottom right corner<br>but the plugin will check the user automatically, without the need to mark the checkbox.', 'wpamelia'),
            'recaptcha_site_key'                     => __('Google reCAPTCHA Site Key', 'wpamelia'),
            'recaptcha_site_key_tooltip'             => __('Paste here the Site Key that you have got once you have signed up for the API key pair on Google reCAPTCHA.', 'wpamelia'),
            'recaptcha_secret'                       => __('Google reCAPTCHA Secret Key', 'wpamelia'),
            'recaptcha_secret_tooltip'               => __('Paste here the Secret Key that you have got once you have signed up for the API key pair on Google reCAPTCHA.', 'wpamelia'),
            'recaptcha_site_key_error'               => __('Please enter site key', 'wpamelia'),
            'recaptcha_secret_error'                 => __('Please enter secret', 'wpamelia'),
            'redirect_url_after_app_or_package_tt'   => __('Customer will be redirected to this URL once he schedules the appointment or package.', 'wpamelia'),
            'remove_google_busy_slots_tooltip'       => __('Enable this option if you want to remove busy slots in<br/>Google Calendar from Employee\'s working schedule.', 'wpamelia'),
            'remove_outlook_busy_slots_tooltip'      => __('Enable this option if you want to remove busy slots in<br/>Outlook Calendar from Employee\'s working schedule.', 'wpamelia'),
            'remove_apple_busy_slots_tooltip'        => __('Enable this option if you want to remove busy slots in<br/>Apple Calendar from Employee\'s working schedule.', 'wpamelia'),
            'include_buffer_time_google_tooltip'     => __('If you disable this option buffer time for scheduled appointments<br/>will not be added to the Google Calendar events.', 'wpamelia'),
            'include_buffer_time_outlook_tooltip'    => __('If you disable this option buffer time for scheduled appointments<br/>will not be added to the Outlook Calendar events.', 'wpamelia'),
            'include_buffer_time_apple_tooltip'      => __('If you disable this option buffer time for scheduled appointments<br/>will not be added to the Apple Calendar events.', 'wpamelia'),
            'package_placeholders'                   => __('Package placeholders', 'wpamelia'),
            'package_placeholders_tooltip'           => __('Placeholders for package appointments that will be sent in email.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'recurring_placeholders'                 => __('Recurring placeholders', 'wpamelia'),
            'recurring_placeholders_tooltip'         => __('Placeholders for recurring appointments that will be sent in email.<br/>You can find available placeholders on the Notifications page.', 'wpamelia'),
            'require_cabinet_password_tooltip'       => __('If you disable this option, your customers will be able to access customer panel with link that is sent to their email account.', 'wpamelia'),
            'rest_api_clientid'                      => __('Rest App Client ID', 'wpamelia'),
            'rest_api_secret'                        => __('Rest App Secret', 'wpamelia'),
            'sandbox_mode'                           => __('Sandbox Mode', 'wpamelia'),
            'select_value_warning'                   => __('Please select option', 'wpamelia'),
            'send_event_invitation_email_tooltip'    => __('Enable this option if you want your customers to<br/>receive an email about the event.', 'wpamelia'),
            'set_metaData_and_description'           => __('Set MetaData and Description', 'wpamelia'),
            'settings_lower'                         => __('settings', 'wpamelia'),
            'show_attendees_tooltip'                 => __('Enable this option if you want your customers to see<br/>all attendees in the appointment in their google calendar.', 'wpamelia'),
            'smtp_host'                              => __('SMTP Host', 'wpamelia'),
            'smtp_host_warning'                      => __('Please enter SMTP host', 'wpamelia'),
            'smtp_password'                          => __('SMTP Password', 'wpamelia'),
            'smtp_password_warning'                  => __('Please enter SMTP password', 'wpamelia'),
            'smtp_port'                              => __('SMTP Port', 'wpamelia'),
            'smtp_port_warning'                      => __('Please enter SMTP port', 'wpamelia'),
            'smtp_secure'                            => __('SMTP Secure', 'wpamelia'),
            'smtp_secure_disabled'                   => __('Disabled', 'wpamelia'),
            'smtp_secure_ssl'                        => __('SSL', 'wpamelia'),
            'smtp_secure_tls'                        => __('TLS', 'wpamelia'),
            'smtp_username'                          => __('SMTP Username', 'wpamelia'),
            'smtp_username_warning'                  => __('Please enter SMTP username', 'wpamelia'),
            'social_login_google_configuration'      => __('Click here to see how to configure Google social login.', 'wpamelia'),
            'social_login_facebook_configuration'    => __('Click here to see how to configure Facebook social login.', 'wpamelia'),
            'stripe'                                 => __('Stripe', 'wpamelia'),
            'stripe_address_fields'                  => __('Add Stripe Address Fields', 'wpamelia'),
            'stripe_live_publishable_key_error'      => __('Please enter live publishable key', 'wpamelia'),
            'stripe_live_secret_key_error'           => __('Please enter live secret key', 'wpamelia'),
            'stripe_service'                         => __('Stripe Service', 'wpamelia'),
            'stripe_ssl_warning'                     => __('SSL (HTTPS) is not enabled. You will not be able to process live Stripe transactions until SSL is enabled.', 'wpamelia'),
            'stripe_test_publishable_key_error'      => __('Please enter test publishable key', 'wpamelia'),
            'stripe_test_secret_key_error'           => __('Please enter test secret key', 'wpamelia'),
            'tax_include'                            => __('Include Taxes', 'wpamelia'),
            'tax_include_tooltip'                    => __('Tax will be included in price calculation.', 'wpamelia'),
            'tax_exclude'                            => __('Exclude Taxes', 'wpamelia'),
            'tax_exclude_tooltip'                    => __('Tax will be excluded from price calculation and showed separately.', 'wpamelia'),
            'template_for_event_title'               => __('Template for Event Title', 'wpamelia'),
            'test_api_key'                           => __('Test API Key', 'wpamelia'),
            'test_client_id'                         => __('Test Client ID', 'wpamelia'),
            'test_key_id'                            => __('Test Key ID', 'wpamelia'),
            'test_key_secret'                        => __('Test Key Secret', 'wpamelia'),
            'test_mode'                              => __('Test Mode', 'wpamelia'),
            'test_publishable_key'                   => __('Test Publishable Key', 'wpamelia'),
            'test_secret'                            => __('Test Secret', 'wpamelia'),
            'test_secret_key'                        => __('Test Secret Key', 'wpamelia'),
            'time_frame'                             => __('Time frame', 'wpamelia'),
            'tracking_ViewContent'                   => __('Load Page', 'wpamelia'),
            'tracking_SelectCategory'                => __('Select Category', 'wpamelia'),
            'tracking_SelectService'                 => __('Select Service', 'wpamelia'),
            'tracking_SelectEmployee'                => __('Select Employee', 'wpamelia'),
            'tracking_SelectLocation'                => __('Select Location', 'wpamelia'),
            'tracking_SelectPackage'                 => __('Select Package', 'wpamelia'),
            'tracking_SelectEvent'                   => __('Select Event', 'wpamelia'),
            'tracking_Purchase'                      => __('Complete Booking With Payment', 'wpamelia'),
            'tracking_Schedule'                      => __('Complete Booking Without Payment', 'wpamelia'),
            'tracking_InitiateCheckout'              => __('Show Checkout Form', 'wpamelia'),
            'tracking_InitInfoStep'                  => __('Show Customer Information Form', 'wpamelia'),
            'tracking_type_tooltip'                  => __('Select action on which event will be called', 'wpamelia'),
            'tracking_parameter_name'                => __('Property Name', 'wpamelia'),
            'tracking_event_parameter'               => __('Event Parameter', 'wpamelia'),
            'tracking_parameter_name_tooltip'        => __('Name of the property (standard or custom) for pixel event', 'wpamelia'),
            'tracking_parameter_value'               => __('Property Value', 'wpamelia'),
            'two_way_sync'                           => __('2 Way Sync', 'wpamelia'),
            'unable_to_deactivate_plugin'            => __('Unable to deactivate plugin. Please try again later.', 'wpamelia'),
            'url'                                    => __('URL', 'wpamelia'),
            'value'                                  => __('Value', 'wpamelia'),
            'view_api_keys_settings'                 => __('View API keys Settings', 'wpamelia'),
            'view_appointments_and_events_settings'  => __('View Appointments and Events Settings', 'wpamelia'),
            'view_days_off_settings'                 => __('View Working Hours & Days Off Settings', 'wpamelia'),
            'view_google_calendar_settings'          => __('View Google Calendar Settings', 'wpamelia'),
            'view_web_hooks_settings'                => __('View Web Hooks Settings', 'wpamelia'),
            'wc'                                     => __('Enable integration with WooCommerce', 'wpamelia'),
            'wc_name'                                => __('WooCommerce', 'wpamelia'),
            'wc_product'                             => __('Select WooCommerce product', 'wpamelia'),
            'wc_product_tooltip'                     => __('Here you can choose the product that will be used for WooCommerce integration.', 'wpamelia'),
            'wc_service'                             => __('WooCommerce Service', 'wpamelia'),
            'wc_on_site_if_free'                     => __('Hide WooCommerce cart when price is 0', 'wpamelia'),
            'wc_redirect_page'                       => __('Redirect page', 'wpamelia'),
            'wc_redirect_page_1'                     => __('WooCommerce Thank you page', 'wpamelia'),
            'wc_redirect_page_2'                     => __('Amelia Add to calendar page', 'wpamelia'),
            'wc_page'                                => __('Default Page', 'wpamelia'),
            'wc_page_cart'                           => __('Cart', 'wpamelia'),
            'wc_page_checkout'                       => __('Checkout', 'wpamelia'),
            'wc_rules_add'                           => __('Add Rule', 'wpamelia'),
            'wc_rules_delete_confirmation'           => __('Are you sure you want to delete this rule', 'wpamelia'),
            'wc_status_draft'                        => __('Draft', 'wpamelia'),
            'wc_status_pending'                      => __('Pending Payment', 'wpamelia'),
            'wc_status_processing'                   => __('Processing', 'wpamelia'),
            'wc_status_on_hold'                      => __('On Hold', 'wpamelia'),
            'wc_status_completed'                    => __('Completed', 'wpamelia'),
            'wc_status_cancelled'                    => __('Cancelled', 'wpamelia'),
            'wc_status_refunded'                     => __('Refunded', 'wpamelia'),
            'wc_status_failed'                       => __('Failed', 'wpamelia'),
            'wc_status_update_order'                 => __('Apply on', 'wpamelia'),
            'wc_status_update_order_yes'             => __('Order update', 'wpamelia'),
            'wc_status_update_order_no'              => __('Order creation', 'wpamelia'),
            'wc_status_update'                       => __('Update', 'wpamelia'),
            'wc_status_update_tooltip'               => __('Apply after Order update', 'wpamelia'),
            'booking_status'                         => __('Booking Status', 'wpamelia'),
            'web_hooks_settings'                     => __('Web Hooks Settings', 'wpamelia'),
            'web_hook_delete_confirmation'           => __('Are you sure you want to delete this web hook', 'wpamelia'),
            'web_hook_action'                        => __('Action', 'wpamelia'),
            'web_hook_action_warning'                => __('Please select action', 'wpamelia'),
            'web_hook_name_warning'                  => __('Please enter name', 'wpamelia'),
            'web_hook_booking_type'                  => __('Type', 'wpamelia'),
            'web_hook_booking_type_warning'          => __('Please enter booking type', 'wpamelia'),
            'web_hook_booking_completed'             => __('Booking Completed', 'wpamelia'),
            'web_hook_booking_rescheduled'           => __('Booking Rescheduled', 'wpamelia'),
            'web_hook_booking_canceled'              => __('Booking Canceled', 'wpamelia'),
            'web_hook_booking_status_updated'        => __('Booking Status Changed', 'wpamelia'),
            'web_hook_package_purchased'             => __('Package Purchased', 'wpamelia'),
            'web_hook_package_canceled'              => __('Package Canceled', 'wpamelia'),
            'web_hook_package_tooltip'               => __('This Web Hook is triggered when the customer purchases a package without booking any appointments', 'wpamelia'),
            'week1'                                  => __('1 week', 'wpamelia'),
            'weeks2'                                 => __('2 weeks', 'wpamelia'),
            'weeks3'                                 => __('3 weeks', 'wpamelia'),
            'weeks4'                                 => __('4 weeks', 'wpamelia'),
            'work_hours_days_off'                    => __('Working Hours & Days Off', 'wpamelia'),
            'wp_role'                                => __('WP Role', 'wpamelia'),
            'whats_new'                              => __('What\'s New', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getSettingsStrings());
    }

    /**
     * Returns the array for the email notifications strings
     *
     * @return array
     */
    public static function getNotificationsStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'accepted'                               => __('Accepted', 'wpamelia'),
            'after'                                  => __('After', 'wpamelia'),
            'already_have_an_account'                => __('Already have an account?', 'wpamelia'),
            'amount_colon'                           => __('Amount:', 'wpamelia'),
            'before'                                 => __('Before', 'wpamelia'),
            'cant_checkout'                          => __('This payment cannot be completed', 'wpamelia'),
            'cant_recharge_balance'                  => __('This payment cannot be completed and your account has not been charged', 'wpamelia'),
            'choose_ph'                              => __('Choose Placeholder', 'wpamelia'),
            'choose_type'                            => __('Choose Type', 'wpamelia'),
            'choose_when'                            => __('Choose when', 'wpamelia'),
            'configure'                              => __('Configure', 'wpamelia'),
            'configure_placeholder'                  => __('Configure placeholder', 'wpamelia'),
            'configure_placeholder_here'             => __('Configure placeholder here', 'wpamelia'),
            'cron_instruction'                       => __('To send this notification please add the following line in your cron', 'wpamelia'),
            'custom_amount'                          => __('Custom Amount', 'wpamelia'),
            'custom_notification'                    => __('Custom Notification', 'wpamelia'),
            'default_content_customer'               => __('Dear <b>%customer_full_name%</b>, <br><br>Thank you for choosing our company, <br> <b>%company_name%</b>', 'wpamelia'),
            'default_content_customer_sms'           => __('Dear %customer_full_name%, 
            
Thank you for choosing our company, 
%company_name%', 'wpamelia'),
            'default_content_employee'               => __('Hi <b>%employee_full_name%</b>, <br><br>Thank you, <br> <b>%company_name%</b>', 'wpamelia'),
            'default_content_employee_sms'           => __('Hi %employee_full_name%, 
            
Thank you, 
%company_name%', 'wpamelia'),
            'delivered'                              => __('Delivered', 'wpamelia'),
            'details_changed'                        => __('Details Changed', 'wpamelia'),
            'delete_message'                         => __('Are you sure you want to delete this notification? <br> You can\'t undo this action', 'wpamelia'),
            'duplicate_of'                           => __('Duplicate of ', 'wpamelia'),
            'edit_notification'                      => __('Edit Notification', 'wpamelia'),
            'email'                                  => __('Email', 'wpamelia'),
            'email_placeholders'                     => __('Email Placeholders', 'wpamelia'),
            'email_taken'                            => __('This email address is already being used', 'wpamelia'),
            'enter_image_link'                       => __('Enter image link', 'wpamelia'),
            'enter_name_warning'                     => __('Please enter name', 'wpamelia'),
            'enter_number'                           => __('Enter number', 'wpamelia'),
            'enter_recipient_email_warning'          => __('Please enter recipient email', 'wpamelia'),
            'enter_valid_email_warning'              => __('Please enter a valid email address', 'wpamelia'),
            'enter_valid_phone_warning'              => __('Please enter a valid phone number', 'wpamelia'),
            'failed'                                 => __('Failed', 'wpamelia'),
            'invalid_token'                          => __('Invalid Token', 'wpamelia'),
            'loading'                                => __('Loading...', 'wpamelia'),
            'manage_languages'                       => __('Manage languages', 'wpamelia'),
            'dont_send_scheduled_email'              => __('Avoid sending reminder notifications if a booking is created within the set time before the appointment/event.', 'wpamelia'),
            'no_messages'                            => __('There are no SMS messages...', 'wpamelia'),
            'notification_enabled'                   => __('Notification is enabled', 'wpamelia'),
            'notification_name'                      => __('Notification name', 'wpamelia'),
            'notification_name_enter'                => __('Enter notification name', 'wpamelia'),
            'notification_not_saved'                 => __('Notification has not been saved', 'wpamelia'),
            'notification_not_deleted'               => __('Notification has not been deleted', 'wpamelia'),
            'notification_deleted'                   => __('Notification has been deleted', 'wpamelia'),
            'notification_scheduled'                 => __('Scheduled notification', 'wpamelia'),
            'notification_appointment_status'        => __('Appointment status', 'wpamelia'),
            'notification_event_action'              => __('Event action', 'wpamelia'),
            'notification_triggered'                 => __('Action triggered notification', 'wpamelia'),
            'notification_type'                      => __('Notification Type', 'wpamelia'),
            'package_placeholder_label'              => __('Package Appointments List', 'wpamelia'),
            'paddle'                                 => __('Paddle', 'wpamelia'),
            'password'                               => __('Password', 'wpamelia'),
            'past_event'                             => __('Past event', 'wpamelia'),
            'password_has_been_changed'              => __('Password has been changed', 'wpamelia'),
            'password_length'                        => __('Password must have a length between 5 and 40 characters', 'wpamelia'),
            'password_reset_success'                 => __('Your password has been reset successfully', 'wpamelia'),
            'password_whitespace'                    => __('Password must not contain whitespace', 'wpamelia'),
            'passwords_do_not_match'                 => __('Passwords do not match', 'wpamelia'),
            'payment_history_error'                  => __('Unable to retrieve payments results', 'wpamelia'),
            'payment_id'                             => __('Payment ID', 'wpamelia'),
            'payment_id_colon'                       => __('Payment ID:', 'wpamelia'),
            'payments_lower'                         => __('payments', 'wpamelia'),
            'payPal'                                 => __('PayPal', 'wpamelia'),
            'ph_appointment_cancel_url'              => __('Cancel Appointment Link', 'wpamelia'),
            'ph_appointment_approve_url'             => __('Approve Appointment Link', 'wpamelia'),
            'ph_appointment_reject_url'              => __('Reject Appointment Link', 'wpamelia'),
            'ph_initial_appointment_date'            => __('Initial Date of the appointment', 'wpamelia'),
            'ph_initial_appointment_date_time'       => __('Initial Date & Time of the appointment', 'wpamelia'),
            'ph_initial_appointment_start_time'      => __('Initial Start time of the appointment', 'wpamelia'),
            'ph_initial_appointment_end_time'        => __('Initial End time of the appointment', 'wpamelia'),
            'ph_appointment_deposit_payment'         => __('Appointment deposit', 'wpamelia'),
            'ph_payment_link_mollie'                 => __('Payment link for Mollie', 'wpamelia'),
            'ph_payment_link_paypal'                 => __('Payment link for PayPal', 'wpamelia'),
            'ph_payment_link_razorpay'               => __('Payment link for Razorpay', 'wpamelia'),
            'ph_payment_link_stripe'                 => __('Payment link for Stripe', 'wpamelia'),
            'ph_payment_link_square'                 => __('Payment link for Square', 'wpamelia'),
            'ph_payment_link_woocommerce'            => __('Payment link for WooCommerce', 'wpamelia'),
            'ph_cart_appointments_details'           => __('Cart appointments details', 'wpamelia'),
            'ph_coupon_used'                         => __('Used Coupon', 'wpamelia'),
            'ph_customer_cabinet_url'                => __('Customer Panel Access Link', 'wpamelia'),
            'ph_employee_cabinet_url'                => __('Employee Panel Access Link', 'wpamelia'),
            'ph_employee_password'                   => __('Employee Password', 'wpamelia'),
            'ph_employee_photo'                      => __('Employee photo', 'wpamelia'),
            'ph_event_cancel_url'                    => __('Cancel Event Link', 'wpamelia'),
            'ph_event_tickets'                       => __('Event tickets', 'wpamelia'),
            'ph_event_deposit_payment'               => __('Event deposit', 'wpamelia'),
            'ph_initial_event_start_date'            => __('Initial Start date of the event', 'wpamelia'),
            'ph_initial_event_start_date_time'       => __('Initial Start date & time of the event', 'wpamelia'),
            'ph_initial_event_start_time'            => __('Initial Start time of the event', 'wpamelia'),
            'ph_initial_event_end_date'              => __('Initial End date of the event', 'wpamelia'),
            'ph_initial_event_end_date_time'         => __('Initial End date & time of the event', 'wpamelia'),
            'ph_initial_event_end_time'              => __('Initial End time of the event', 'wpamelia'),
            'ph_extras_details'                      => __('Selected extras details', 'wpamelia'),
            'ph_extras'                              => __('Selected extras', 'wpamelia'),
            'ph_cart_details_setup'                  => __('Cart appointments details placeholder set up', 'wpamelia'),
            'ph_group_appointment_details'           => __('Group appointment details', 'wpamelia'),
            'ph_group_appointment_setup'             => __('Group appointment details placeholder set up', 'wpamelia'),
            'ph_group_event_setup'                   => __('Group event details placeholder set up', 'wpamelia'),
            'ph_group_appointments_tooltip'          => __('Set what details you want to send to your customers/employees about their booking.', 'wpamelia'),
            'ph_lesson_space_url'                    => __('Lesson space link to join space', 'wpamelia'),
            'ph_lesson_space_url_date'               => __('Date periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_lesson_space_url_date_time'          => __('Date & Time periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_location_address'                    => __('Location address', 'wpamelia'),
            'ph_location_description'                => __('Location description', 'wpamelia'),
            'ph_location_id'                         => __('Location ID', 'wpamelia'),
            'ph_location_name'                       => __('Location name', 'wpamelia'),
            'ph_location_phone'                      => __('Location phone', 'wpamelia'),
            'ph_package_appointments_details'        => __('Package appointments details', 'wpamelia'),
            'ph_package_name'                        => __('Package name', 'wpamelia'),
            'ph_package_description'                 => __('Package description', 'wpamelia'),
            'ph_package_details_setup'               => __('Package appointments list placeholder set up', 'wpamelia'),
            'ph_package_duration'                    => __('Package duration', 'wpamelia'),
            'ph_package_price'                       => __('Package price description', 'wpamelia'),
            'ph_package_deposit_payment'             => __('Package deposit', 'wpamelia'),
            'ph_payment_price'                       => __('Payment price', 'wpamelia'),
            'ph_package_tooltip'                     => __('Set what details you want to send to your customers/employees about their packages.', 'wpamelia'),
            'ph_recurring_appointments_details'      => __('Recurring appointments details', 'wpamelia'),
            'ph_recurring_details_setup'             => __('Recurring appointments details placeholder set up', 'wpamelia'),
            'ph_reservation_description'             => __('Service or Event description', 'wpamelia'),
            'ph_reservation_name'                    => __('Service or Event name', 'wpamelia'),
            'ph_zoom_host_url'                       => __('Zoom Start Meeting (Hosts) Link', 'wpamelia'),
            'ph_zoom_host_url_date'                  => __('Date periods of the event with Zoom start links', 'wpamelia'),
            'ph_zoom_host_url_date_date'             => __('Date & Time periods of the event with Zoom start links', 'wpamelia'),
            'ph_zoom_join_url'                       => __('Zoom Join Meeting (Participants) Link', 'wpamelia'),
            'ph_zoom_join_url_date'                  => __('Date periods of the event with Zoom join links', 'wpamelia'),
            'ph_zoom_join_url_date_date'             => __('Date & Time periods of the event with Zoom join links', 'wpamelia'),
            'ph_google_meet_url_date'                => __('Date periods of the event with Google Meet join links', 'wpamelia'),
            'ph_google_meet_url_date_date'           => __('Date & Time periods of the event with Google Meet join links', 'wpamelia'),
            'ph_google_meet_url'                     => __('Google Meet Join Link', 'wpamelia'),
            'ph_microsoft_teams_url'                 => __('Microsoft Teams Join Link', 'wpamelia'),
            'ph_microsoft_teams_url_date'            => __('Date periods of the event with Microsoft Teams join links', 'wpamelia'),
            'ph_microsoft_teams_url_date_date'       => __('Date & Time periods of the event with Microsoft Teams join links', 'wpamelia'),
            'packagePlaceholders'                    => __('Package', 'wpamelia'),
            'cartPlaceholders'                       => __('Cart', 'wpamelia'),
            'customFieldsPlaceholders'               => __('Custom fields', 'wpamelia'),
            'couponsPlaceholders'                    => __('Coupon', 'wpamelia'),
            'group_ph_warning'                       => __('Once set, this placeholder applies to all types of notifications where it is added', 'wpamelia'),
            'placeholder'                            => __('Placeholder', 'wpamelia'),
            'placeholders'                           => __('Placeholders', 'wpamelia'),
            'prepared'                               => __('Prepared', 'wpamelia'),
            'pricing_error'                          => __('Unable to retrieve pricing', 'wpamelia'),
            'recharge_custom_amount'                 => __('Recharge Custom Amount', 'wpamelia'),
            'recipient_phone'                        => __('Recipient Phone', 'wpamelia'),
            'recipients'                             => __('Recipients', 'wpamelia'),
            'recovery_email_sent'                    => __('Account recovery email has been sent', 'wpamelia'),
            'reset_password'                         => __('Reset Password', 'wpamelia'),
            'same_day'                               => __('On the same day', 'wpamelia'),
            'scheduled_after_appointment'            => __('Scheduled After Appointment', 'wpamelia'),
            'scheduled_after_event'                  => __('Scheduled After Event', 'wpamelia'),
            'scheduled_before'                       => __('Scheduled For Before Appointment', 'wpamelia'),
            'scheduled_for'                          => __('Scheduled For', 'wpamelia'),
            'segment_colon'                          => __('Segment:', 'wpamelia'),
            'segment_tooltip'                        => __('GSM (standard Latin) segments contain 160 characters, while UCS-2 (non-GSM - Cyrillic, emoji, non-standard symbols) contain 70 characters, etc.', 'wpamelia'),
            'segment_tooltip_mobile'                 => __('Prices are showed for one segment which can contain from 70 characters (when non-standard Latin or Cyrillic letters, emoji, etc. are used) to 160 characters.', 'wpamelia'),
            'select_email_template_warning'          => __('Please select email template', 'wpamelia'),
            'send_only_this'                         => __('Send only this notification', 'wpamelia'),
            'send_only_this_tooltip'                 => __('If this is selected the default notification will not be sent for the selected services', 'wpamelia'),
            'send_only_this_tooltip_event'           => __('If this is selected the default notification will not be sent for the selected events', 'wpamelia'),
            'send_test_whatsapp'                     => __('Send Test WhatsApp Message', 'wpamelia'),
            'sender_id_invalid_characters_error'     => __('Special characters are not allowed', 'wpamelia'),
            'sender_id_length_error'                 => __('Sender ID supports up to 11 characters', 'wpamelia'),
            'sender_id_letter_error'                 => __('Your ID must include at least one letter', 'wpamelia'),
            'sender_id_required'                     => __('Alpha Sender ID can\'t be empty', 'wpamelia'),
            'sender_id_saved'                        => __('Alpha Sender ID has been saved', 'wpamelia'),
            'sent'                                   => __('Sent', 'wpamelia'),
            'show_email_codes'                       => __('</> Show Email Placeholders', 'wpamelia'),
            'show_sms_codes'                         => __('</> Show SMS Placeholders', 'wpamelia'),
            'sms_placeholders'                       => __('SMS Placeholders', 'wpamelia'),
            'test_whatsapp_error'                    => __('WhatsApp message has not been sent', 'wpamelia'),
            'test_whatsapp_success'                  => __('WhatsApp message has been sent', 'wpamelia'),
            'test_sms_error'                         => __('SMS has not been sent', 'wpamelia'),
            'test_sms_success'                       => __('SMS has been sent', 'wpamelia'),
            'time'                                   => __('Time', 'wpamelia'),
            'token_expired'                          => __('Token has been expired', 'wpamelia'),
            'type'                                   => __('Type', 'wpamelia'),
            'type_colon'                             => __('Type:', 'wpamelia'),
            'undelivered'                            => __('Undelivered', 'wpamelia'),
            'use_placeholder'                        => __('Use placeholder:', 'wpamelia'),
            'view_message'                           => __('View Message', 'wpamelia'),
            'whatsapp_auto_reply_token_tt'           => __('This is a unique hash created for security reasons.<br>Copy this token into the WhatsApp “Verify token“ field when creating a webhook. ', 'wpamelia'),
            'whatsapp_auto_reply_msg_tt'             => __('This message is sent once the customer tries to answer the message via WhatsApp<br> in order to notify that the messages sent via WhatsApp are without a reply option. ', 'wpamelia'),
            'whatsapp_choose_template'               => __('Choose template ', 'wpamelia'),
            'whatsapp_default_language_tooltip'      => __('Only templates that are in the default language will be displayed on the backend. <br> If the template doesn\'t exist in customer\'s language it will be sent in the default language.', 'wpamelia'),
            'whatsapp_enter_access_token'            => __('Enter Permanent access token ', 'wpamelia'),
            'whatsapp_enter_business_id'             => __('Enter Business ID', 'wpamelia'),
            'whatsapp_choose_language'               => __('Choose default language', 'wpamelia'),
            'whatsapp_enter_phone_id'                => __('Enter Phone number ID', 'wpamelia'),
            'whatsapp_header'                        => __('Header', 'wpamelia'),
            'whatsapp_header_image'                  => __('Image:', 'wpamelia'),
            'whatsapp_header_location_name'          => __('Location name:', 'wpamelia'),
            'whatsapp_header_location_address'       => __('Location address:', 'wpamelia'),
            'whatsapp_header_location_latitude'      => __('Location latitude:', 'wpamelia'),
            'whatsapp_header_location_longitude'     => __('Location longitude:', 'wpamelia'),
            'whatsapp_notice_header'                 => __('The message header needs to be set on the Facebook Developers Settings. The character limit is 60 with the replaced placeholders.', 'wpamelia'),
            'whatsapp_notice_body'                   => __('The message body needs to be set on the Facebook Developers Settings', 'wpamelia'),
            'whatsapp_notice_ph'                     => __('Line breaks will be replaced with semicolons since new rows are not supported in WhatsApp parameters', 'wpamelia'),
            'whatsapp_select_ph'                     => __('Please select placeholder', 'wpamelia'),
            'whatsapp_status_tooltip'                => __('This is the status in whatsapp.', 'wpamelia'),
            'whatsapp_template_name'                 => __('Template name', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getNotificationsStrings());
    }

    /**
     * Returns the array for the common strings
     *
     * @return array
     */
    public static function getDashboardStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'average_bookings'              => __('Average Bookings', 'wpamelia'),
            'average_bookings_tooltip'      => __('Shows the average number of bookings per day<br/>for the selected date range.', 'wpamelia'),
            'no_today_appointments'         => __('There are no appointments for today', 'wpamelia'),
            'packages_purchased_count'      => __('Times bought', 'wpamelia'),
            'pending_appointments_tooltip'  => __('Shows the number of pending appointments<br/>in the selected date range.', 'wpamelia'),
            'today_appointments'            => __('Today\'s appointments', 'wpamelia'),
            'promo_live_qa'                 => __('LIVE Q&A', 'wpamelia'),
            'promo_text1'                   => __('with Amelia Support', 'wpamelia'),
            'only_on_our'                   => __('only on our', 'wpamelia'),
            'youtube'                       => __('YouTube', 'wpamelia'),
            'channel'                       => __('channel', 'wpamelia'),
            'not_show'                      => __("Don't show again", 'wpamelia'),
            'promo_date'                    => __("1. November at 4Pm cest", 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getDashboardStrings());
    }

    /**
     * Returns the array for the schedule modal
     *
     * @return array
     */
    public static function getScheduleStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_break'                           => __('Add Break', 'wpamelia'),
            'add_day_off_placeholder'             => __('Enter holiday or day off name', 'wpamelia'),
            'company_days_off'                    => __('Company Days off', 'wpamelia'),
            'company_days_off_settings'           => __('Company Days Off Settings', 'wpamelia'),
            'company_work_hours_settings'         => __('Company Working Hours Settings', 'wpamelia'),
            'confirm_global_change_working_hours' => __('You will change working hours setting which is also set for each employee separately. Do you want to update it for all employees?', 'wpamelia'),
            'days_off_date_warning'               => __('Please enter date', 'wpamelia'),
            'days_off_name_warning'               => __('Please enter name', 'wpamelia'),
            'edit_company_days_off'               => __('Edit Company Days off', 'wpamelia'),
            'employee_days_off'                   => __('Employee Days off', 'wpamelia'),
            'pick_a_date_or_range'                => __('Pick a date or range', 'wpamelia'),
            'pick_a_year'                         => __('Pick a year', 'wpamelia'),
            'reflects_on'                         => __('Reflects on', 'wpamelia'),
            'set_break_time'                      => __('Set Break Time', 'wpamelia'),
            'set_work_time'                       => __('Set Work Time', 'wpamelia'),
            'work_hours_days_off_settings'        => __('Working Hours & Days Off Settings', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getScheduleStrings());
    }

    /**
     * Returns the array for the entities modal
     *
     * @return array
     */
    public static function getEntityFormStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'delete'          => __('Delete', 'wpamelia'),
            'duplicate'       => __('Duplicate', 'wpamelia'),
            'loader_message'  => __('Please Wait', 'wpamelia'),
            'visible'         => __('Visible', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getEntityFormStrings());
    }

    /**
     * Returns the array for the location page
     *
     * @return array
     */
    public static function getLocationStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'address'                        => __('Address', 'wpamelia'),
            'click_add_locations'            => __('Start by clicking the Add Location button', 'wpamelia'),
            'confirm_delete_location'        => __('Are you sure you want to delete this location?', 'wpamelia'),
            'confirm_duplicate_location'     => __('Are you sure you want to duplicate this location?', 'wpamelia'),
            'confirm_hide_location'          => __('Are you sure you want to hide this location?', 'wpamelia'),
            'confirm_show_location'          => __('Are you sure you want to show this location?', 'wpamelia'),
            'edit_location'                  => __('Edit Location', 'wpamelia'),
            'enter_location_address_warning' => __('Please enter address', 'wpamelia'),
            'enter_location_name_warning'    => __('Please enter name', 'wpamelia'),
            'google_maps_notice'             => __('To enable Google maps, enter the Google Map API key in General Settings', 'wpamelia'),
            'latitude'                       => __('Latitude', 'wpamelia'),
            'location_address'               => __('Location Address', 'wpamelia'),
            'location_deleted'               => __('Location has been deleted', 'wpamelia'),
            'location_hidden'                => __('Your Location is hidden', 'wpamelia'),
            'location_saved'                 => __('Location has been saved', 'wpamelia'),
            'location_visible'               => __('Your Location is visible', 'wpamelia'),
            'locations_lower'                => __('locations', 'wpamelia'),
            'longitude'                      => __('Longitude', 'wpamelia'),
            'map'                            => __('Map', 'wpamelia'),
            'new_location'                   => __('New Location', 'wpamelia'),
            'no_locations_yet'               => __('You don\'t have any locations here yet...', 'wpamelia'),
            'not_right_address'              => __('This is not the right address?', 'wpamelia'),
            'pin_icon'                       => __('Pin Icon', 'wpamelia'),
            'pin_orange'                     => __('Orange', 'wpamelia'),
            'pin_purple'                     => __('Purple', 'wpamelia'),
            'pin_red'                        => __('Red', 'wpamelia'),
            'pin_green'                      => __('Green', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getLocationStrings());
    }

    /**
     * Returns the array for the service page
     *
     * @return array
     */
    public static function getServiceStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_duration'                       => __('Add Duration', 'wpamelia'),
            'all_employees'                      => __('All Employees', 'wpamelia'),
            'all_locations'                      => __('All Locations', 'wpamelia'),
            'all_services'                       => __('All Services', 'wpamelia'),
            'available_images'                   => __('Available Images', 'wpamelia'),
            'book_package'                       => __('Book Package', 'wpamelia'),
            'bringing_anyone'                    => __('Show "Bringing anyone with you" option', 'wpamelia'),
            'bringing_anyone_tooltip'            => __('Hide this option to allow only individual people to<br/>book a group appointment without the possibility<br/>to come with somebody.', 'wpamelia'),
            'categories_delete_fail'             => __('Unable to delete category', 'wpamelia'),
            'categories_positions_saved_fail'    => __('Unable to save categories positions', 'wpamelia'),
            'category'                           => __('Category', 'wpamelia'),
            'category_add_fail'                  => __('Unable to add category', 'wpamelia'),
            'category_saved_fail'                => __('Unable to save category', 'wpamelia'),
            'confirm_delete_resource'            => __('Are you sure you want to delete this resource?', 'wpamelia'),
            'confirm_delete_resource_plural'     => __('Are you sure you want to delete these resources?', 'wpamelia'),
            'confirm_duplicate_resource'         => __('Are you sure you want to duplicate this resource?', 'wpamelia'),
            'confirm_hide_resource'              => __('Are you sure you want to hide this resource?', 'wpamelia'),
            'confirm_show_resource'              => __('Are you sure you want to show this resource?', 'wpamelia'),
            'confirm_delete_package'             => __('Are you sure you want to delete this package?', 'wpamelia'),
            'confirm_duplicate_package'          => __('Are you sure you want to duplicate this package?', 'wpamelia'),
            'confirm_hide_package'               => __('Are you sure you want to hide this package?', 'wpamelia'),
            'confirm_show_package'               => __('Are you sure you want to show this package?', 'wpamelia'),
            'delete_extra_confirmation'          => __('Are you sure you want to delete this extra', 'wpamelia'),
            'custom_pricing_enabled'             => __('Custom Duration & Pricing', 'wpamelia'),
            'edit_package'                       => __('Edit Package', 'wpamelia'),
            'edit_resource'                      => __('Edit Resource', 'wpamelia'),
            'enter_extra_name_warning'           => __('Please enter extra name', 'wpamelia'),
            'enter_extra_price_warning'          => __('Please enter extra price', 'wpamelia'),
            'enter_non_negative_price_warning'   => __('Price must be non-negative number', 'wpamelia'),
            'enter_name_warning'                 => __('Please enter name', 'wpamelia'),
            'enter_service_price_warning'        => __('Please enter price', 'wpamelia'),
            'extra_delete_fail'                  => __('Unable to delete extra', 'wpamelia'),
            'maximum_quantity'                   => __('Maximum Quantity', 'wpamelia'),
            'aggregated_price'                   => __('The price will multiply by the number of people', 'wpamelia'),
            'aggregated_price_tooltip'           => __('If you disable this option the price will be the same<br/>regardless of how many customers book in the group appointment.', 'wpamelia'),
            'new_package'                        => __('New Package', 'wpamelia'),
            'new_package_booking'                => __('New Package Booking', 'wpamelia'),
            'new_resource'                       => __('New Resource', 'wpamelia'),
            'no_categories_yet'                  => __('You don\'t have any categories here yet...', 'wpamelia'),
            'notify_customer'                    => __('Notify the customer', 'wpamelia'),
            'notify_customers_package_tooltip'   => __('Check this checkbox if you want your customer to<br/>receive an email about the booked package.', 'wpamelia'),
            'package_appointment_left'           => __('Appointment slots left to be booked.', 'wpamelia'),
            'package_book_appointment'           => __('Book Appointment', 'wpamelia'),
            'package_booking_saved'              => __('Package Booking has been saved', 'wpamelia'),
            'package_canceled_info'              => __('This package is canceled. <br>To book an appointment, please reopen it first.', 'wpamelia'),
            'package_choose_employees'           => __('Allow customers to choose employee on the customer panel', 'wpamelia'),
            'package_choose_employees_tooltip'   => __('If the option is disabled the initial booking will determine the employee for this service in the entire package', 'wpamelia'),
            'package_date_purchased'             => __('Date Purchased', 'wpamelia'),
            'package_details'                    => __('Package Details', 'wpamelia'),
            'package_hidden'                     => __('Package is hidden', 'wpamelia'),
            'package_saved'                      => __('Package has been saved', 'wpamelia'),
            'package_visible'                    => __('Package is visible', 'wpamelia'),
            'package_deleted'                    => __('Package has been deleted', 'wpamelia'),
            'packages_sorting'                   => __('Sort Packages:', 'wpamelia'),
            'package_payment_status'             => __('Payment Status', 'wpamelia'),
            'package_price_calculated'           => __('Calculated price', 'wpamelia'),
            'package_price_calculated_text'      => __('Calculated price for package', 'wpamelia'),
            'package_price_custom'               => __('Custom price', 'wpamelia'),
            'packages_positions_saved'           => __('Packages positions has been saved', 'wpamelia'),
            'packages_positions_saved_fail'      => __('Unable to save packages positions', 'wpamelia'),
            'package_total'                      => __('Total', 'wpamelia'),
            'package_to_be_booked'               => __('to be booked', 'wpamelia'),
            'period'                             => __('Period', 'wpamelia'),
            'pricing'                            => __('Pricing', 'wpamelia'),
            'purchased_packages'                 => __('Manage Packages', 'wpamelia'),
            'purchased_packages_pagination'      => __('purchased packages', 'wpamelia'),
            'resource_additional_people'         => __('Enable Resource usage for a group booking', 'wpamelia'),
            'resource_additional_people_tooltip' => __('Enable this option if you want to count resource quantity usage for each additional person added during the booking', 'wpamelia'),
            'resource_deleted'                   => __('Resource has been deleted', 'wpamelia'),
            'resource_hidden'                    => __('Resource is hidden', 'wpamelia'),
            'resource_name_ph'                   => __('e.g. Chair', 'wpamelia'),
            'resource_name_required'             => __('Please enter the name of the resource', 'wpamelia'),
            'resource_name_tooltip'              => __('The resource and its name is not visible during the booking, so this name is only for you for easier management', 'wpamelia'),
            'resource_not_deleted'               => __('Resource has not been deleted', 'wpamelia'),
            'resource_included_in'               => __('Resources will be included in:', 'wpamelia'),
            'resource_info'                      => __('(Selecting services, employees, locations and events which are mutually connected and can be booked in the same appointment, will lead to multiple usages of this resource per such appointment.)', 'wpamelia'),
            'resource_saved'                     => __('Resource has been saved', 'wpamelia'),
            'resource_search_placeholder'        => __('Search Resources...', 'wpamelia'),
            'resource_shared'                    => __('Resource quantity is shared among the selected items', 'wpamelia'),
            'resource_shared_tooltip'            => __('The resource quantity will be shared among all selected services, employees, and locations. ', 'wpamelia'),
            'resource_separate1'                 => __('Resource quantity is unique for selected item type', 'wpamelia'),
            'resource_separate_tooltip1'         => __('The resource quantity will be counted for each selected service/location separately.', 'wpamelia'),
            'resource_separate2'                 => __('Resource quantity is unique for selected services', 'wpamelia'),
            'resource_separate_tooltip2'         => __('The resource quantity will be counted for each selected service separately.', 'wpamelia'),
            'resource_view_less'                 => __('View less', 'wpamelia'),
            'resource_view_more'                 => __('View more', 'wpamelia'),
            'resource_visible'                   => __('Resource is visible', 'wpamelia'),
            'resource_quantity'                  => __('Quantity', 'wpamelia'),
            'resources_deleted'                  => __('Resources have been deleted', 'wpamelia'),
            'resources_not_deleted'              => __('Resources have not been deleted', 'wpamelia'),
            'schedule_package_total'             => __('Number of appointments', 'wpamelia'),
            'schedule_package_total_tooltip'     => __('A number of appointments included in the package for this service.', 'wpamelia'),
            'schedule_package_sum_total_tooltip' => __('A number of appointments included in the package.', 'wpamelia'),
            'schedule_package_minimum'           => __('Minimum bookings required', 'wpamelia'),
            'schedule_package_minimum_tooltip'   => __('A minimum number of appointments a customer needs to schedule at the moment of booking.', 'wpamelia'),
            'schedule_package_maximum'           => __('Maximum bookings required', 'wpamelia'),
            'schedule_package_maximum_tooltip'   => __('A maximum number of appointments a customer can schedule at the moment of booking.', 'wpamelia'),
            'search_resources'                   => __('Search for a Resource...', 'wpamelia'),
            'select_customer'                    => __('Select Customer', 'wpamelia'),
            'select_package_service_warning'     => __('Please select at least one service', 'wpamelia'),
            'select_service_employee_warning'    => __('Please select select at least one employee', 'wpamelia'),
            'service_details'                    => __('Service Details', 'wpamelia'),
            'service_recurring_sub'              => __('Handle unavailable recurring dates', 'wpamelia'),
            'service_recurring_sub_tooltip'      => __('Set how an alternate date should be suggested to the customer<br>if the desired date has no available time-slots for booking.', 'wpamelia'),
            'service_recurring_sub_future'       => __('Recommend the closest date after', 'wpamelia'),
            'service_recurring_sub_past'         => __('Recommend the closest date before ', 'wpamelia'),
            'service_recurring_sub_both'         => __('Recommend the closest date before or after', 'wpamelia'),
            'service_recurring_payment'          => __('Handle recurring appointment payments', 'wpamelia'),
            'service_recurring_payment_tooltip'  => __('Set how you want payments to be processed.<br>If you choose to request payment only for the first appointment customers will be able to pay the rest on-site.', 'wpamelia'),
            'service_recurring_payment_none'     => __('Customers will have to pay only for the first appointment', 'wpamelia'),
            'service_recurring_payment_all'      => __('Customers will have to pay for all appointments at once', 'wpamelia'),
            'shared_capacity'                    => __('Total Number of Appointments', 'wpamelia'),
            'shared_capacity_tooltip'            => __('If this option is disabled, you can set the total number of appointments per service. When it is enabled, you can set the total number of appointments per package.', 'wpamelia'),
            'time'                               => __('Time', 'wpamelia'),
            'update_for_all'                     => __('Update for all', 'wpamelia'),
            'mandatory_extra_enable'             => __('Set extra as a mandatory field', 'wpamelia'),
            'min_required_extras'                => __('Minimum required extras', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getServiceStrings());
    }

    /**
     * Returns the array for the user page
     *
     * @return array
     */
    public static function getUserStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'birthday'                 => __('Birthday', 'wpamelia'),
            'dont_import'              => __('Don\'t import', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getUserStrings());
    }

    /**
     * Returns the array for the employee page
     *
     * @return array
     */
    public static function getEmployeeStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'activity'                              => __('Status', 'wpamelia'),
            'add_employee'                          => __('Add Employee', 'wpamelia'),
            'available'                             => __('Available', 'wpamelia'),
            'away'                                  => __('Away', 'wpamelia'),
            'apple_client_id'                       => __('iCloud Email Address', 'wpamelia'),
            'apple_app_specific_password'           => __('iCloud App-specific Password', 'wpamelia'),
            'apple_calendar_select'                 => __('Choose Apple Calendar', 'wpamelia'),
            'break'                                 => __('On Break', 'wpamelia'),
            'busy'                                  => __('Busy', 'wpamelia'),
            'click_add_employee'                    => __('Start by clicking the Add Employee button', 'wpamelia'),
            'confirm_delete_employee'               => __('Are you sure you want to delete this employee?', 'wpamelia'),
            'confirm_duplicate_employee'            => __('Are you sure you want to duplicate this employee?', 'wpamelia'),
            'confirm_hide_employee'                 => __('Are you sure you want to hide this employee?', 'wpamelia'),
            'confirm_show_employee'                 => __('Are you sure you want to show this employee?', 'wpamelia'),
            'connect'                               => __('Connect', 'wpamelia'),
            'dayoff'                                => __('Day Off', 'wpamelia'),
            'disconnect'                            => __('Disconnect', 'wpamelia'),
            'edit_employee'                         => __('Edit Employee', 'wpamelia'),
            'employee_deleted'                      => __('Employee has been deleted', 'wpamelia'),
            'employee_hidden'                       => __('Employee is hidden', 'wpamelia'),
            'employee_not_deleted'                  => __('Employee can not be deleted because of the future appointment', 'wpamelia'),
            'employee_search_placeholder'           => __('Search Employees...', 'wpamelia'),
            'employee_visible'                      => __('Employee is visible', 'wpamelia'),
            'employees_deleted'                     => __('Employees have been deleted', 'wpamelia'),
            'employees_lower'                       => __('employees', 'wpamelia'),
            'employees_not_deleted'                 => __('Employees could not be deleted because of the future appointment', 'wpamelia'),
            'enter_location_warning'                => __('Please select location', 'wpamelia'),
            'google_sign_in'                        => __('Sign in with Google', 'wpamelia'),
            'google_sign_out'                       => __('Sign out from Google', 'wpamelia'),
            'outlook_sign_in'                       => __('Sign in with Outlook', 'wpamelia'),
            'outlook_sign_out'                      => __('Sign out from Outlook', 'wpamelia'),
            'apple_disconnect'                      => __('Disconnect from Apple', 'wpamelia'),
            'apple_connect'                         => __('Connect to Apple Calendar', 'wpamelia'),
            'apple_connect_employee_calendar'       => __('Connect to your personal Apple Calendar', 'wpamelia'),
            'google_calendar_error'                 => __('Unable to connect to Google Calendar', 'wpamelia'),
            'google_calendar_tooltip'               => __('Here you can connect employee with Google Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'outlook_calendar_tooltip'              => __('Here you can connect employee with Outlook Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'apple_calendar_tooltip'                => __('Here you can connect employee with Apple Calendar,<br/>so once the booking is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'apple_calendar_employee_tooltip'       => __('Here, you can connect your personal Apple Calendar,<br/>so once the booking is scheduled,<br/>it will be automatically added to your calendar of choice.', 'wpamelia'),
            'apple_calendar_overridden_by_employee' => __('Overridden by employee', 'wpamelia'),
            'apple_calendar_disconnect_employee'    => __('Disconnect Employee', 'wpamelia'),
            'connect_to_apple_calendar'             => __('Connect Account', 'wpamelia'),
            'new_employee'                          => __('New Employee', 'wpamelia'),
            'mandatory_service_remove_fail_all'     => __('This employee is the only provider on', 'wpamelia'),
            'mandatory_service_remove_fail'         => __('This employee is the only provider for this service', 'wpamelia'),
            'period_location_filter'                => __('Applied for default employee location', 'wpamelia'),
            'period_location_filter1_tooltip'       => __('Select specific location for this period.', 'wpamelia'),
            'period_location_filter2_tooltip'       => __('Select specific location for each period.', 'wpamelia'),
            'service_provider_remove_fail_all'      => __('Provider has appointments for', 'wpamelia'),
            'password'                              => __('Password', 'wpamelia'),
            'enter_employee_panel_password'         => __('Enter to set or reset password', 'wpamelia'),
            'enter_employee_icloud_id'              => __('Enter Apple Calendar iCloud Id', 'wpamelia'),
            'enter_employee_app_specific_pass'      => __('Enter Apple Calendar app specific password', 'wpamelia'),
            'send_employee_panel_access_email'      => __('Send Employee Panel Access Email', 'wpamelia'),
            'new_password_length'                   => __('Password must be longer than 3 characters', 'wpamelia'),
            'zoom_user_tooltip'                     => __('Here you can select Zoom User,<br/>so once the appointment is scheduled,<br/>zoom meeting will be automatically created.', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getEmployeeStrings());
    }

    /**
     * Returns the array for the stripe
     *
     * @return array
     */
    public static function getStripeStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'stripe_connect'                   => __('Stripe Connect', 'wpamelia'),
            'stripe_preview'                   => __('Dashboard', 'wpamelia'),
            'stripe_account'                   => __('Stripe Account', 'wpamelia'),
            'stripe_account_standard'          => __('Standard Account', 'wpamelia'),
            'stripe_account_express'           => __('Express Account', 'wpamelia'),
            'use_charge_alert'                 => __('This charge type will not be be used when booking multiple appointments (cart feature or recurring feature) OR when booking event with multiple employees.', 'wpamelia'),
            'use_direct_payment'               => __('Direct charge', 'wpamelia'),
            'use_transfers_payment'            => __('Transfer', 'wpamelia'),
            'use_card_payment'                 => __('Card Payment', 'wpamelia'),
            'use_transfer_amount'              => __('Transfer Amount (%)', 'wpamelia'),
            'use_direct_amount'                => __('Application Fee Amount (%)', 'wpamelia'),
            'use_stripe_connect'               => __('Enable Stripe Connect', 'wpamelia'),
            'use_charge_type'                  => __('Charge type', 'wpamelia'),
            'use_charge_type_tooltip'          => __('Here you can define the charge type that will be used for employees with "Stripe Connected Account"', 'wpamelia'),
            'use_capabilities'                 => __('Express Account capabilities', 'wpamelia'),
            'use_capabilities_tooltip'         => __('Here you can define which capabilities will be requested when creating a "Stripe Connected Express Account"', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getStripeStrings());
    }

    /**
     * Returns the array for the customer page
     *
     * @return array
     */
    public static function getCustomerStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'all_customer_appointments'    => __('All customer appointments', 'wpamelia'),
            'click_add_customers'          => __('Start by clicking the Add Customer button or', 'wpamelia'),
            'customer_not_deleted'         => __('Customer can not be deleted because of the future booking', 'wpamelia'),
            'customer_not_imported'        => __('customers were not imported for missing First Name, Last Name, having invalid Email and Phone number or combination of these reasons.', 'wpamelia'),
            'customer_conflicts'           => __('customers with the same email address are already in your customer list. If you choose to overwrite with new records some data will be saved.', 'wpamelia'),
            'customers_not_deleted'        => __('Customers could not be deleted because of the future bookings', 'wpamelia'),
            'import_customers'             => __('Import customers', 'wpamelia'),
            'importing_customers'          => __('We are importing customers,<br>this will be completed in a few moments', 'wpamelia'),
            'last_appointment_date'        => __('Last appointment date', 'wpamelia'),
            'number_of_appointments'       => __('Number of appointments', 'wpamelia'),
            'note_internal'                => __('Note (Internal)', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getCustomerStrings());
    }

    /**
     * Returns the array for the import dialog
     *
     * @return array
     */
    public static function getImportStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'check_csv'                    => __('Please check your .csv file and try again', 'wpamelia'),
            'download_csv'                 => __('Download .csv', 'wpamelia'),
            'import_failed'                => __('Import failed', 'wpamelia'),
            'import_partially_successful'  => __('Import partially successful', 'wpamelia'),
            'none_of'                      => __('None of', 'wpamelia'),
            'missing_value'                => __('Missing required value:', 'wpamelia'),
            'more_than_one'                => __('More than one field of the same type has been selected for different values', 'wpamelia'),
            'overwrite_records'            => __('Overwrite records', 'wpamelia'),
            'prepared_csv'                 => __('We\'ve prepared a .csv document for you, with customers that were not imported. After fixing issues, you can try again.', 'wpamelia'),
            'skip_import'                  => __('Skip import', 'wpamelia'),
            'values_overwritten'           => __('Values that will be overwritten', 'wpamelia'),
            'values_saved'                 => __('Values that will be saved', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getImportStrings());
    }

    /**
     * Returns the array for the What's new page
     *
     * @return array
     */
    public static function getWhatsNewStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'need_help'                      => __('Need Help?', 'wpamelia'),
            'amelia_changelog'               => __('Amelia Changelog', 'wpamelia'),
            'included_plan_your'             => __('Included in Your Plan', 'wpamelia'),
            'included_plan_higher'           => __('Included in Higher Plans', 'wpamelia'),
            'current_version'                => __('You are currently using Version ', 'wpamelia'),
            'version'                        => __('Version ', 'wpamelia'),
            'version_subtitle'               => __('Update with a couple of improvements and bug fixes:', 'wpamelia'),
            'see_previous_versions'          => __('See Previous Versions', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getWhatsNewStrings());
    }

    /**
     * Returns the array for the lite vs premium page
     *
     * @return array
     */
    public static function getLiteVsPremiumStrings()
    {
        $labels = [];

        return array_merge($labels, LiteBackendStrings::getLiteVsPremiumStrings());
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getFinanceStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'confirm_delete_tax'                 => __('Are you sure you want to delete this tax?', 'wpamelia'),
            'confirm_duplicate_tax'              => __('Are you sure you want to duplicate this tax?', 'wpamelia'),
            'confirm_hide_tax'                   => __('Are you sure you want to hide this tax?', 'wpamelia'),
            'confirm_show_tax'                   => __('Are you sure you want to show this tax?', 'wpamelia'),
            'invoice_details'                    => __('Invoice details', 'wpamelia'),
            'tax_deleted'                        => __('Tax has been deleted', 'wpamelia'),
            'tax_hidden'                         => __('Your Tax is hidden', 'wpamelia'),
            'tax_not_deleted'                    => __('Tax has not been deleted', 'wpamelia'),
            'tax_saved'                          => __('Tax has been saved', 'wpamelia'),
            'tax_visible'                        => __('Your Tax is active', 'wpamelia'),
            'taxes_deleted'                      => __('Taxes have been deleted', 'wpamelia'),
            'taxes_lower'                        => __('taxes', 'wpamelia'),
            'taxes_not_deleted'                  => __('Taxes have not been deleted', 'wpamelia'),
            'edit_tax'                           => __('Edit Tax', 'wpamelia'),
            'finance_taxes_search_placeholder'   => __('Search Taxes', 'wpamelia'),
            'no_tax_amount'                      => __('Tax amount needs to have value', 'wpamelia'),
            'taxes'                              => __('Taxes', 'wpamelia'),
            'new_tax'                            => __('New Tax', 'wpamelia'),
            'no_taxes_yet'                       => __('You don\'t have any taxes here yet', 'wpamelia'),
            'code'                               => __('Code', 'wpamelia'),
            'code_tooltip'                       => __('Here you need to define a coupon code which customers will<br/>enter in their booking so they can get a discount.', 'wpamelia'),
            'confirm_delete_coupon'              => __('Are you sure you want to delete this coupon?', 'wpamelia'),
            'confirm_duplicate_coupon'           => __('Are you sure you want to duplicate this coupon?', 'wpamelia'),
            'confirm_hide_coupon'                => __('Are you sure you want to hide this coupon?', 'wpamelia'),
            'confirm_show_coupon'                => __('Are you sure you want to show this coupon?', 'wpamelia'),
            'coupon_deleted'                     => __('Coupon has been deleted', 'wpamelia'),
            'coupon_hidden'                      => __('Your Coupon is hidden', 'wpamelia'),
            'coupon_not_deleted'                 => __('Coupon has not been deleted', 'wpamelia'),
            'coupon_saved'                       => __('Coupon has been saved', 'wpamelia'),
            'coupon_usage_limit_validation'      => __('Coupon usage limit must be at least 1', 'wpamelia'),
            'coupon_visible'                     => __('Your Coupon is active', 'wpamelia'),
            'coupons'                            => __('Coupons', 'wpamelia'),
            'coupons_deleted'                    => __('Coupons have been deleted', 'wpamelia'),
            'coupons_lower'                      => __('coupons', 'wpamelia'),
            'coupons_not_deleted'                => __('Coupons have not been deleted', 'wpamelia'),
            'deduction'                          => __('Deduction', 'wpamelia'),
            'download'                           => __('Download', 'wpamelia'),
            'edit_coupon'                        => __('Edit Coupon', 'wpamelia'),
            'enter_coupon_code_warning'          => __('Please enter code', 'wpamelia'),
            'export_tooltip_coupons'             => __('You can use this option to export coupons in CSV file.', 'wpamelia'),
            'finance_coupons_search_placeholder' => __('Search Coupons', 'wpamelia'),
            'invoice_number'                     => __('Invoice Number', 'wpamelia'),
            'invoice'                            => __('Invoice', 'wpamelia'),
            'invoice_paid'                       => __('Paid', 'wpamelia'),
            'invoice_discount'                   => __('Discount', 'wpamelia'),
            'invoice_item'                       => __('Item', 'wpamelia'),
            'invoice_incl_tax'                   => __(' (Incl. Tax)', 'wpamelia'),
            'invoice_left_to_pay'                => __('Left to pay', 'wpamelia'),
            'invoice_payment_method'             => __('PAYMENT METHOD', 'wpamelia'),
            'invoice_subtotal'                   => __('Subtotal', 'wpamelia'),
            'invoice_tax'                        => __('Tax', 'wpamelia'),
            'invoice_tax_amount'                 => __('Tax amount', 'wpamelia'),
            'invoice_tax_rate'                   => __('Tax rate', 'wpamelia'),
            'invoice_to'                         => __('To', 'wpamelia'),
            'invoice_total'                      => __('Invoice total', 'wpamelia'),
            'invoice_total_item_price'           => __('Total price', 'wpamelia'),
            'invoice_unit_price'                 => __('Unit price', 'wpamelia'),
            'invoice_qty'                        => __('Qty', 'wpamelia'),
            'invoices'                           => __('Invoices', 'wpamelia'),
            'issue_date'                         => __('Issue date', 'wpamelia'),
            'issued'                             => __('Issued', 'wpamelia'),
            'limit'                              => __('Limit', 'wpamelia'),
            'new_coupon'                         => __('New Coupon', 'wpamelia'),
            'no_coupons_yet'                     => __('You don\'t have any coupons here yet', 'wpamelia'),
            'no_coupon_amount'                   => __('Coupon needs to have discount or deduction', 'wpamelia'),
            'no_entities_selected'               => __('Select at least one service or event', 'wpamelia'),
            'packages_tooltip'                   => __('Select the packages for which the coupon can be used.', 'wpamelia'),
            'paid'                               => __('Paid', 'wpamelia'),
            'partiallyPaid'                      => __('Partially Paid', 'wpamelia'),
            'pending'                            => __('Pending', 'wpamelia'),
            'preview'                            => __('Preview', 'wpamelia'),
            'refunded'                           => __('Refunded', 'wpamelia'),
            'send_invoice'                       => __('Send Invoice', 'wpamelia'),
            'send_invoice_no_email'              => __('The customer didn’t provide their email address so the invoice couldn’t be sent.', 'wpamelia'),
            'send_interval'                      => __('Notification interval', 'wpamelia'),
            'send_interval_tooltip'              => __('Here you can set the number of approved bookings after which the customer will automatically receive the coupon in notification.<br/>Please note that the coupon placeholder needs to be set in the notification template in order for this to work.', 'wpamelia'),
            'send_recurring'                     => __('Recurring notification', 'wpamelia'),
            'send_recurring_tooltip'             => __('Here you can define if notification interval will repeat.', 'wpamelia'),
            'select_all_extras'                  => __('Select All Extras', 'wpamelia'),
            'select_all_services'                => __('Select All Service', 'wpamelia'),
            'select_all_packages'                => __('Select All Packages', 'wpamelia'),
            'services_tooltip'                   => __('Select the services for which the coupon can be used.', 'wpamelia'),
            'select_all_events'                  => __('Select All Events', 'wpamelia'),
            'events_tooltip'                     => __('Select the events for which the coupon can be used.', 'wpamelia'),
            'times_used'                         => __('Times Used', 'wpamelia'),
            'usage_limit'                        => __('Usage Limit', 'wpamelia'),
            'usage_limit_tooltip'                => __('Here you need to define the number of coupons for use. After the<br/>limit is reached your coupon will become unavailable.', 'wpamelia'),
            'usage_customer_limit'               => __('Maximum Usage Per Customer', 'wpamelia'),
            'usage_customer_limit_tooltip'       => __('Here you can define the maximum number of coupons for use for single customer. After the<br/>limit is reached for single customer, your coupon will become unavailable for that customer.', 'wpamelia'),
            'used'                               => __('Used', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getFinanceStrings());
    }

    /**
     * Returns the array for the finance page
     *
     * @return array
     */
    public static function getPaymentStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'event_info'               => __('Event Info', 'wpamelia'),
            'confirm_refund_payment'   => __('Are you sure you want to refund this payment?', 'wpamelia'),
            'refund_payment_amount'    => __('The refund amount is', 'wpamelia'),
            'deduction'                => __('Deduction', 'wpamelia'),
            'deposit'                  => __('Deposit', 'wpamelia'),
            'expiration_date'          => __('Expiration date', 'wpamelia'),
            'invoice_sent'             => __('Invoice successfully sent', 'wpamelia'),
            'invoice_sending_failed'   => __('Invoice sending failed', 'wpamelia'),
            'online'                   => __('Online', 'wpamelia'),
            'package_deal'             => __('This booking is part of a package deal', 'wpamelia'),
            'package_purchased'        => __('Package Purchased', 'wpamelia'),
            'paid'                     => __('Paid', 'wpamelia'),
            'paid_deposit'             => __('Paid deposit', 'wpamelia'),
            'paid_remaining_amount'    => __('Paid remaining amount', 'wpamelia'),
            'payment_not_deleted'      => __('Payment has not been deleted', 'wpamelia'),
            'payment_refund_failed'    => __('Payment refund failed', 'wpamelia'),
            'payment_refunded'         => __('Payment refunded successfully', 'wpamelia'),
            'payments_not_deleted'     => __('Payments have not been deleted', 'wpamelia'),
            'plus_tax'                 => __('(+tax)', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getPaymentStrings());
    }

    /**
     * Returns the array for the appointment strings
     *
     * @return array
     */
    public static function getAppointmentStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'appointment_id'                    => __('Appointment ID', 'wpamelia'),
            'appointment_not_deleted'           => __('Appointment has not been deleted', 'wpamelia'),
            'appointments_not_deleted'          => __('Appointment have not been deleted', 'wpamelia'),
            'assigned'                          => __('Assigned', 'wpamelia'),
            'choose_a_group_service'            => __('Choose a group service', 'wpamelia'),
            'click_add_appointments'            => __('Start by clicking the New Appointment button', 'wpamelia'),
            'confirm_delete_package_purchase'   => __('Are you sure you want to delete this package purchase and it\'s appointments?', 'wpamelia'),
            'create_new'                        => __('Create New', 'wpamelia'),
            'customer_name'                     => __('Customer Name', 'wpamelia'),
            'customer_phone'                    => __('Customer Phone', 'wpamelia'),
            'customers'                         => __('Customers', 'wpamelia'),
            'linked'                            => __('Linked', 'wpamelia'),
            'minimum_number_of_persons'         => __('Minimum number of people for bookings to approve appointment is', 'wpamelia'),
            'mollie'                            => __('Mollie', 'wpamelia'),
            'multiple_emails'                   => __('Multiple Emails', 'wpamelia'),
            'no_appointments_yet'               => __('You don\'t have any appointments here yet...', 'wpamelia'),
            'no_selected_customers'             => __('There are no selected customers', 'wpamelia'),
            'no_selected_extras_requirements'   => __('Select customer, employee and service', 'wpamelia'),
            'no_selected_slot_requirements'     => __('Select date and time', 'wpamelia'),
            'no_selected_fields_requirements'   => __('Select customer and service', 'wpamelia'),
            'bookings_regular_tooltip'          => __('customers booked this appointment out of package deal', 'wpamelia'),
            'bookings_package_tooltip'          => __('customers booked this appointment as a part of package:', 'wpamelia'),
            'bookings_payment_package_tooltip'  => __('Payments for the package deal are not included in this paid amount', 'wpamelia'),
            'group_booking_message'             => __('By booking this time slot you will book appointment on top of existing group appointment!', 'wpamelia'),
            'recurring_changed_message'         => __('List of your appointments has changed. Take one more look and continue by clicking the Save button.', 'wpamelia'),
            'package_customer_deleted'          => __('Package purchase has been deleted', 'wpamelia'),
            'package_customer_not_deleted'      => __('Package purchase has not been deleted', 'wpamelia'),
            'package_customers_deleted'         => __('Package purchases have been deleted', 'wpamelia'),
            'package_customers_not_deleted'     => __('Package purchases have not been deleted', 'wpamelia'),
            'package_deal'                      => __('Package deal', 'wpamelia'),
            'price'                             => __('Price', 'wpamelia'),
            'price_changed_message'             => __('This change will lead to a price increase for certain bookings. Do you want payment links to be created?', 'wpamelia'),
            'pay_pal'                           => __('PayPal', 'wpamelia'),
            'razorpay'                          => __('Razorpay', 'wpamelia'),
            'select_customer_warning'           => __('Please select at least one customer', 'wpamelia'),
            'select_a_customer_warning'         => __('Please select customer', 'wpamelia'),
            'select_single_customer_warning'    => __('Please select customer', 'wpamelia'),
            'select_employee'                   => __('Select Employee', 'wpamelia'),
            'select_employee_warning'           => __('Please select employee', 'wpamelia'),
            'select_coupon'                     => __('Select Coupon', 'wpamelia'),
            'select_location'                   => __('Select Location', 'wpamelia'),
            'select_rows_settings'              => __('Choose how to export group appointments', 'wpamelia'),
            'select_rows_settings_event'        => __('Choose how to export event attendees', 'wpamelia'),
            'service_category'                  => __('Service Category', 'wpamelia'),
            'select_payment_method'             => __('Select Payment Method for link', 'wpamelia'),
            'stripe'                            => __('Stripe', 'wpamelia'),
            'exported_same_row'                 => __('Booking info from group appointment exported in the same row', 'wpamelia'),
            'exported_separate_rows'            => __('Booking info from group appointment exported in separate rows', 'wpamelia'),
            'exported_same_row_event'           => __('Booking info from attendees exported in the same row', 'wpamelia'),
            'exported_separate_rows_event'      => __('Booking info from attendees exported in separate rows', 'wpamelia'),
            'package_booking_unavailable'       => __('Booking is unavailable', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getAppointmentStrings());
    }

    /**
     * Returns the array for the bookable strings
     *
     * @return array
     */
    public static function getBookableStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'allow_customers_to_pay_total'       => __('Check this option if you want your<br> customers to have the option to choose<br> whether they will pay a full amount<br> or just a deposit. If unchecked,<br> customers will only have deposit<br> as a payment option.', 'wpamelia'),
            'deposit_by_the_number_of_people'    => __('Check this option if you want the deposit<br> amount to be multiplied by the number<br> of people that customers add in the<br> "Bringing anyone with you" section.', 'wpamelia'),
            'deposit_amount'                     => __('Deposit amount', 'wpamelia'),
            'deposit_payment'                    => __('Deposit type', 'wpamelia'),
            'deposit_payment_tooltip'            => __('Percentage deposit will be calculated on the total booking price<br>and fixed amount can be multiplied by the number of people or stay fixed on the total booking price.', 'wpamelia'),
            'deposit_info'                       => __('Remaining of total amount will be paid on site or through payment link.', 'wpamelia'),
            'deposit_info_fixed'                 => __('Remaining of total amount will be paid on site or through payment link. Extras are not included in deposit amount.', 'wpamelia'),
            'deposit_info_percentage'            => __('Remaining of total amount will be paid on site or through payment link. Extras are included in deposit amount.', 'wpamelia'),
            'deposit_per_person'                 => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'deposit_per_person_tooltip'         => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'allow_total_amount'                 => __('Allow customers to pay total appointment amount', 'wpamelia'),
            'allow_total_event_amount'           => __('Allow customers to pay total event amount', 'wpamelia'),
            'enter_positive_price_warning'       => __('Amount must be positive number', 'wpamelia'),
            'pricing_by_date_enabled'            => __('Pricing by Date range', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getBookableStrings());
    }

    /**
     * Returns the array for the event strings
     *
     * @return array
     */
    public static function getEventStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'apply_to_all'                => __('Apply this to all recurring events', 'wpamelia'),
            'click_add_events'            => __('Start by clicking the New Event button', 'wpamelia'),
            'confirm_delete_following'    => __('Do you want to delete following canceled events?', 'wpamelia'),
            'confirm_cancel_following'    => __('Do you want to cancel following events?', 'wpamelia'),
            'confirm_open_following'      => __('Do you want to open following events?', 'wpamelia'),
            'confirm_save_following'      => __('Do you want to update following events?', 'wpamelia'),
            'confirm_save_following_2'    => __('Tickets for events with attendees will not be updated', 'wpamelia'),
            'confirm_save_conflict'       => __('There is an event in Google/Outlook Calendar that overlaps this one for a specific employee, are you sure you want to create another one?', 'wpamelia'),
            'description'                 => __('Description', 'wpamelia'),
            'event'                       => __('Event', 'wpamelia'),
            'event_attendees_remove'      => __('Remove Selected', 'wpamelia'),
            'event_attendee_not_deleted'  => __('Attendee have not been deleted', 'wpamelia'),
            'event_attendees_not_deleted' => __('Attendees have not been deleted', 'wpamelia'),
            'event_capacity'              => __('Spots:', 'wpamelia'),
            'event_location'              => __('Location:', 'wpamelia'),
            'event_booking_closes_apply'  => __('If this option is not checked the plugin will calculate the time <br> for closing the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_apply'   => __('If this option is not checked the plugin will calculate the time <br> for opening the booking based on the selected time for the first event', 'wpamelia'),
            'event_recurring_period'      => __('Repeat Event', 'wpamelia'),
            'event_recurring_count'       => __('How many times?', 'wpamelia'),
            'event_recurring_until'       => __('Until when?', 'wpamelia'),
            'event_booking_deleted'       => __('Event booking has been deleted', 'wpamelia'),
            'event_booking_not_deleted'   => __('Event booking has not been deleted', 'wpamelia'),
            'event_schedule'              => __('Schedule', 'wpamelia'),
            'event_tags_create'           => __('No Tags. Create a new one.', 'wpamelia'),
            'custom_pricing_warning'      => __('Custom pricing spots will override Maximum allowed spots value.', 'wpamelia'),
            'custom_pricing_adjustment'   => __('Custom/regular pricing adjustments are not permitted for events with confirmed attendees.', 'wpamelia'),
            'custom_pricing_date_warning' => __('Set event period first to enable pricing by date range.', 'wpamelia'),
            'add_ticket_category'         => __('Add Pricing Category', 'wpamelia'),
            'event_date_range'            => __('Date Range', 'wpamelia'),
            'event_date_range_warning'    => __('Date Ranges that are not defined will use default price from ticket category.', 'wpamelia'),
            'event_add_date_range'        => __('Add Date Range', 'wpamelia'),
            'event_ticket_name'           => __('Ticket name', 'wpamelia'),
            'event_spots'                 => __('Spots', 'wpamelia'),
            'enter_event_name_warning'    => __('Please enter name', 'wpamelia'),
            'select_repeat_period'        => __('Select Repeat Period', 'wpamelia'),
            'select_repeat_interval'      => __('Select Repeat Interval', 'wpamelia'),
            'no_events_yet'               => __('You don\'t have any events here yet...', 'wpamelia'),
            'enter_address'               => __('Enter Address', 'wpamelia'),
            'select'                      => __('Select', 'wpamelia'),
            'save_single'                 => __('No, just this one', 'wpamelia'),
            'update_following'            => __('Update following', 'wpamelia'),
            'delete_following'            => __('Delete following', 'wpamelia'),
            'cancel_following'            => __('Cancel following', 'wpamelia'),
            'open_following'              => __('Open following', 'wpamelia'),
            'price_changed_message'       => __('This change will lead to a price increase in this bookings. Do you want payment links to be created?', 'wpamelia'),
            'cancel'                      => __('Cancel', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getEventStrings());
    }

    /**
     * Returns the array for the calendar strings
     *
     * @return array
     */
    public static function getCalendarStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_customer'                   => __('Add Customer', 'wpamelia'),
            'add_employee'                   => __('Add Employee', 'wpamelia'),
            'add_location'                   => __('Add Location', 'wpamelia'),
            'add_service'                    => __('Add Service', 'wpamelia'),
            'all_employees'                  => __('All employees', 'wpamelia'),
            'appointment_drag_breaks'        => __('Appointment can\'t be moved because of employee break in the selected period', 'wpamelia'),
            'appointment_drag_exist'         => __('There is already an appointment for this employee in selected time period', 'wpamelia'),
            'appointment_drag_out_schedule'  => __('Appointment can\'t be moved because the employee doesn\'t provide this service at the selected time', 'wpamelia'),
            'day'                            => __('Day', 'wpamelia'),
            'group_booking'                  => __('Group appointment', 'wpamelia'),
            'list'                           => __('List', 'wpamelia'),
            'month'                          => __('Month', 'wpamelia'),
            'no_appointments_to_display'     => __('No appointments to display', 'wpamelia'),
            'timeline'                       => __('Timeline', 'wpamelia'),
            'today'                          => __('Today', 'wpamelia'),
            'week'                           => __('Week', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getCalendarStrings());
    }

    /**
     * Returns the array for the Customize page
     *
     * @return array
     */
    public static function getCustomizeStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_appointment'                    => __('Add appointment', 'wpamelia'),
            'add_option'                         => __('Add Option', 'wpamelia'),
            'all_bookings'                       => __('All bookings', 'wpamelia'),
            'address_as_location'                => __('Google/Outlook Location', 'wpamelia'),
            'address_as_location_tooltip'        => __('Enable this option to set this custom field as the location in Google/Outlook calendar events, ICS files and "Add to calendar" events', 'wpamelia'),
            'address_disabled_tooltip'           => __('Set your Google Map API Key in General Settings', 'wpamelia'),
            'address_warning'                    => __('In order for this field to work correctly please add the Google Map API Key on the General Settings of our Settings page. Otherwise, the field will work just as a simple text field.', 'wpamelia'),
            'all_services'                       => __('All services', 'wpamelia'),
            'all_events'                         => __('All events', 'wpamelia'),
            'any_employee'                       => __('Any Employee', 'wpamelia'),
            'any_location'                       => __('Any Location', 'wpamelia'),
            'auto_fill_your_details'             => __('Auto-fill your details using:', 'wpamelia'),
            'btn_type_filled'                    => __('filled', 'wpamelia'),
            'btn_type_plain'                     => __('plain', 'wpamelia'),
            'btn_type_text'                      => __('text', 'wpamelia'),
            'number_of_additional_persons'       => __('Number of Additional People', 'wpamelia'),
            'one_person'                         => __('Person', 'wpamelia'),
            'one_persons'                        => __('People', 'wpamelia'),
            'extra_colon'                        => __('Extra', 'wpamelia'),
            'select_extra'                       => __('John Doe', 'wpamelia'),
            'select_extra2'                      => __('Jane Doe', 'wpamelia'),
            'qty_colon'                          => __('Qty', 'wpamelia'),
            'price_colon'                        => __('Price', 'wpamelia'),
            'colors_and_fonts'                   => __('Colors & Fonts', 'wpamelia'),
            'continue'                           => __('Continue', 'wpamelia'),
            'coupon_input_field'                 => __('Coupon Input Field', 'wpamelia'),
            'custom_field'                       => __('Custom Field', 'wpamelia'),
            'custom_fields_added'                => __('Custom field has been added', 'wpamelia'),
            'custom_fields_deleted'              => __('Custom field has been deleted', 'wpamelia'),
            'custom_fields_positions_saved_fail' => __('Unable to save custom fields positions', 'wpamelia'),
            'custom_field_saved'                 => __('Custom field has been saved', 'wpamelia'),
            'first_booking_only'                 => __('First booking only', 'wpamelia'),
            'visible_at'                         => __('Visible at', 'wpamelia'),
            'label'                              => __('Label', 'wpamelia'),
            'label_name'                         => __('Label name', 'wpamelia'),
            'notification_placeholder'           => __('Notification Placeholder', 'wpamelia'),
            'or_enter_details_below'             => __('Or enter details below', 'wpamelia'),
            'service'                            => __('Service', 'wpamelia'),
            'primary_gradient'                   => __('Primary Gradient', 'wpamelia'),
            'required'                           => __('Required', 'wpamelia'),
            'parts'                              => __('Parts', 'wpamelia'),
            'send_custom_fields_separately'      => __('Send custom fields info for each customer separately', 'wpamelia'),
            'send_custom_fields_tooltip'         => __('Enable this option if you want your employee to receive data from the custom fields only for the last customer when there is a group booking', 'wpamelia'),
            'global_customize_settings_notice'   => __('Global Settings apply only to the Event Calendar and Search Booking forms, to customize other booking forms use the settings on the right.', 'wpamelia'),
            'service_option'                     => __('Service', 'wpamelia'),
            'employee_option'                    => __('Employee', 'wpamelia'),
            'location_option'                    => __('Location', 'wpamelia'),
            'package_option'                     => __('Package', 'wpamelia'),
            'recurring_repeat'                   => __('Repeat:', 'wpamelia'),
            'repeat_daily'                       => __('Daily', 'wpamelia'),
            'repeat_weekly'                      => __('Weekly', 'wpamelia'),
            'repeat_monthly'                     => __('Monthly', 'wpamelia'),
            'recurring_day'                      => __('Day', 'wpamelia'),
            'recurring_days'                     => __('Days', 'wpamelia'),
            'recurring_week'                     => __('Week', 'wpamelia'),
            'recurring_weeks'                    => __('Weeks', 'wpamelia'),
            'recurring_month'                    => __('Month', 'wpamelia'),
            'recurring_months'                   => __('Months', 'wpamelia'),
            'recurring_every'                    => __('Every:', 'wpamelia'),
            'recurring_on'                       => __('On:', 'wpamelia'),
            'recurring_until'                    => __('Until:', 'wpamelia'),
            'recurring_times'                    => __('Time(s):', 'wpamelia'),
            'recurring_appointments'             => __('Recurring Appointments', 'wpamelia'),
            'recurring_edit'                     => __('You can edit or delete each appointment', 'wpamelia'),
            'date'                               => __('Date', 'wpamelia'),
            'time'                               => __('Time', 'wpamelia'),
            'employee'                           => __('Employee', 'wpamelia'),
            'date_colon'                         => __('Date:', 'wpamelia'),
            'time_colon'                         => __('Local Time:', 'wpamelia'),
            'location_colon'                     => __('Location:', 'wpamelia'),
            'location_name'                      => __('Location 1', 'wpamelia'),
            'every_day_until'                    => __('Every Day until', 'wpamelia'),
            'birthday_input_field'               => __('Birthday Input Field', 'wpamelia'),
            'confirm'                            => __('Confirm', 'wpamelia'),
            'recurring_string'                   => __('Every Day until', 'wpamelia'),
            'payment_method_colon'               => __('Payment Method:', 'wpamelia'),
            'payment_btn_on_site'                => __('On-Site', 'wpamelia'),
            'payment_btn_stripe'                 => __('Stripe', 'wpamelia'),
            'payment_btn_mollie'                 => __('Online', 'wpamelia'),
            'payment_type_colon'                 => __('Payment Type:', 'wpamelia'),
            'payment_on_site'                    => __('On-site', 'wpamelia'),
            'payment_paypal'                     => __('PayPal', 'wpamelia'),
            'payment_credit_card'                => __('Credit Card', 'wpamelia'),
            'credit_or_debit_card_colon'         => __('Credit or debit card:', 'wpamelia'),
            'payment_card_number'                => __('Card number', 'wpamelia'),
            'total_number_of_persons'            => __('Total Number of People:', 'wpamelia'),
            'base_price_colon'                   => __('Base Price:', 'wpamelia'),
            'discount_amount_colon'              => __('Discount', 'wpamelia'),
            'total_cost_colon'                   => __('Total Cost:', 'wpamelia'),
            'please_select_package'              => __('Please select package:', 'wpamelia'),
            'package_colon'                      => __('Package:', 'wpamelia'),
            'back'                               => __('Back', 'wpamelia'),
            'package_book_service'               => __('All services are booked separately.', 'wpamelia'),
            'package_min_book'                   => __('appointment is required to be booked now.', 'wpamelia'),
            'package_min_book_plural'            => __('appointments are required to be booked now.', 'wpamelia'),
            'no_selected_slot_requirements'      => __('Select date and time', 'wpamelia'),
            'package_list_overview'              => __('Overview', 'wpamelia'),
            'end_time_visibility'                => __('End Time Visibility:', 'wpamelia'),
            'any_employee_visibility'            => __('Any Employee Option Visibility:', 'wpamelia'),
            'event_capacity'                     => __('Capacity', 'wpamelia'),
            'event_date'                         => __('Event Date and Time', 'wpamelia'),
            'event_about'                        => __('About this Event', 'wpamelia'),
            'event_book'                         => __('Book this event', 'wpamelia'),
            'event_book_persons'                 => __('Number of people', 'wpamelia'),
            'categories'                         => __('Categories', 'wpamelia'),
            'services_lower'                     => __('services', 'wpamelia'),
            'service_images_thumbs'              => __('Image Thumbs', 'wpamelia'),
            'view_more'                          => __('View More', 'wpamelia'),
            'service_employees_list'             => __('Service employees list', 'wpamelia'),
            'package_badge'                      => __('Package Badge', 'wpamelia'),
            'package_price'                      => __('Package Price', 'wpamelia'),
            'package_services_list'              => __('Package Services List', 'wpamelia'),
            'h'                                  => __('h', 'wpamelia'),
            'min'                                => __('min', 'wpamelia'),
            'service_info'                       => __('Service Info', 'wpamelia'),
            'maximum_quantity_colon'             => __('Maximum Quantity:', 'wpamelia'),
            'description_colon'                  => __('Description:', 'wpamelia'),
            'category_colon'                     => __('Category:', 'wpamelia'),
            'capacity_colon'                     => __('Capacity:', 'wpamelia'),
            'weeks'                              => __('weeks', 'wpamelia'),
            'package_book_duration'              => __('The package is time-limited to', 'wpamelia'),
            'book_appointment'                   => __('Book Appointment', 'wpamelia'),
            'package_rules_description'          => __('Package rules and description', 'wpamelia'),
            'selected_services'                  => __('Selected services', 'wpamelia'),
            'manage_languages'                   => __('Manage languages', 'wpamelia'),
            'time_zone'                          => __('Time Zone', 'wpamelia'),
            'visibility'                         => __('Visibility', 'wpamelia'),
            'booking_completed_approved'         => __('Thank you! Your booking is completed.', 'wpamelia'),
            'booking_completed_pending'          => __('Thank you! Your booking is completed and now is pending confirmation.', 'wpamelia'),
            'select_calendar'                    => __('Select Calendar', 'wpamelia'),
            'form_colors'                        => __('Form colors', 'wpamelia'),
            'form_type_event_list'               => __('Event List Booking Form', 'wpamelia'),
            'form_type_event_calendar'           => __('Event Calendar Booking Form', 'wpamelia'),
            'event_employee'                     => __('Event Employee', 'wpamelia'),
            'event_today'                        => __('Today', 'wpamelia'),
            'event_upcoming_events'              => __('Upcoming events', 'wpamelia'),
            'event_spot'                         => __('Spot', 'wpamelia'),
            'event_spots_left'                   => __('Spots', 'wpamelia'),
            'event_no_spots'                     => __('No spots left', 'wpamelia'),
            'ev_spot'                            => __('Spot', 'wpamelia'),
            'ev_spots'                           => __('Spots', 'wpamelia'),
            'ev_no_spots'                        => __('No spots left', 'wpamelia'),
            'ev_spots_number'                    => __('Spots capacity', 'wpamelia'),
            'event_day'                          => __('Day', 'wpamelia'),
            'event_book_now'                     => __('Book now', 'wpamelia'),
            'event_upcoming_empty'               => __('There are no upcoming events for this period', 'wpamelia'),
            'upcoming_events_block'              => __('Upcoming events block', 'wpamelia'),
            'event_capacity_block'               => __('Capacity', 'wpamelia'),
            'event_location_block'               => __('Location', 'wpamelia'),
            'event_price_block'                  => __('Price', 'wpamelia'),
            'event_day_block'                    => __('Event Day', 'wpamelia'),
            'event_range_block'                  => __('Date range', 'wpamelia'),
            'event_show_more'                    => __('Show more', 'wpamelia'),
            'event_show_less'                    => __('Show less', 'wpamelia'),
            'event_schedule'                     => __('Schedule:', 'wpamelia'),
            'event_hosted_by'                    => __('Hosted by:', 'wpamelia'),
            'event_many_people'                  => __('How many people are coming?', 'wpamelia'),
            'form_type_catalog'                  => __('Catalog Booking Form', 'wpamelia'),
            'form_block_package'                 => __('Package', 'wpamelia'),
            'form_block_catalog'                 => __('Catalog', 'wpamelia'),
            'form_block_catalog_service'         => __('Catalog Service', 'wpamelia'),
            'form_block_catalog_package'         => __('Catalog Package', 'wpamelia'),
            'show_single_event'                  => __('Show single Event details on the page', 'wpamelia'),
            'payment_type_deposit_only'          => __('Deposit only', 'wpamelia'),
            'payment_type_full_amount'           => __('Whole amount', 'wpamelia'),
            'custom'                             => __('Custom', 'wpamelia'),
            'font_url'                           => __('Font URL', 'wpamelia'),
            'font_family'                        => __('Font Family', 'wpamelia'),
            'payment_method_view'                => __('"Payment Method" View', 'wpamelia'),

            'select_location'                    => __('Select Location', 'wpamelia'),
            'employee_colon'                     => __('Employee', 'wpamelia'),
            'select_employee'                    => __('Select Employee', 'wpamelia'),
            'please_select_employee'             => __('Please select employee', 'wpamelia'),
            'please_select_location'             => __('Please select location', 'wpamelia'),
            'bringing_anyone_title'              => __('Bringing anyone with you?', 'wpamelia'),
            'bringing_people'                    => __('Additional people', 'wpamelia'),
            'bringing_people_total'              => __('Total people', 'wpamelia'),
            'add_people'                         => __('Number of people that are coming with you.', 'wpamelia'),
            'add_people_total'                   => __('The total number of people for the booking.', 'wpamelia'),
            'bringing_yes'                       => __('Yes', 'wpamelia'),
            'bringing_no'                        => __('No', 'wpamelia'),

            'package_selection'                  => __('Package Selection', 'wpamelia'),
            'package_heading'                    => __('Hey, there are special packages with this service, check them out!', 'wpamelia'),
            'discount_save'                      => __('Save', 'wpamelia'),
            'separator_or'                       => __('Or', 'wpamelia'),
            'continue_without_package'           => __('Skip packages and continue with the selected service', 'wpamelia'),

            'package_info_step'                  => __('Package Info', 'wpamelia'),
            'package_info_discount'              => __('Save', 'wpamelia'),
            'expires_at'                         => __('Expires at', 'wpamelia'),
            'expires_after'                      => __('Expires after', 'wpamelia'),
            'expires_day'                        => __('day', 'wpamelia'),
            'expires_days'                       => __('days', 'wpamelia'),
            'expires_week'                       => __('week', 'wpamelia'),
            'expires_weeks'                      => __('weeks', 'wpamelia'),
            'expires_month'                      => __('month', 'wpamelia'),
            'expires_months'                     => __('months', 'wpamelia'),
            'without_expiration'                 => __('Without expiration', 'wpamelia'),
            'multiple_locations'                 => __('Multiple Locations', 'wpamelia'),
            'package_info_includes'              => __('includes', 'wpamelia'),
            'package_info_employees'             => __('Employees', 'wpamelia'),

            'package_appointment_step'            => __('Appointments', 'wpamelia'),
            'package_appointment_required'        => __('Number of appointments required for booking', 'wpamelia'),
            'package_appointment_remaining'       => __('The rest of the appointments can be booked later on the Customers panel.', 'wpamelia'),
            'package_appointment_employee'        => __('Employee', 'wpamelia'),
            'package_select_employee'             => __('Select Employee', 'wpamelia'),
            'package_appointment_location'        => __('Location', 'wpamelia'),
            'package_select_location'             => __('Select Location', 'wpamelia'),
            'package_appointments'                => __('Appointments', 'wpamelia'),
            'package_appointments_date'           => __('Date and Time', 'wpamelia'),
            'package_appointments_select'         => __('Select', 'wpamelia'),
            'package_appointments_selected'       => __('Selected', 'wpamelia'),
            'package_appointments_add_more'       => __('Add more Appointments', 'wpamelia'),
            'package_appointments_slots_selected' => __('All slots are selected', 'wpamelia'),

            'package_booking_overview'           => __('Booking Overview', 'wpamelia'),
            'package_overview_all_selected'      => __('All appointments are selected', 'wpamelia'),
            'package_overview_selected_later'    => __('All appointments will be selected later', 'wpamelia'),
            'package_overview_info'              => __('Appointment information', 'wpamelia'),
            'package_overview_date'              => __('Date', 'wpamelia'),
            'package_overview_time'              => __('Time', 'wpamelia'),
            'package_overview_employee'          => __('Employee', 'wpamelia'),
            'package_overview_location'          => __('Location', 'wpamelia'),

            'extras'                             => __('Extras', 'wpamelia'),
            'extras_available'                   => __('Extras available', 'wpamelia'),
            'min_req_extras_colon'               => __('Minimum required extras', 'wpamelia'),
            'extras_card_open'                   => __('Learn More', 'wpamelia'),
            'extras_card_close'                  => __('Hide', 'wpamelia'),
            'repeat_appointment'                 => __('Repeat Appointment', 'wpamelia'),
            'repeat_appointment_quest'           => __('Do you want to repeat this appointment?', 'wpamelia'),

            'recurring_step'                     => __('Recurring Appointment', 'wpamelia'),
            'recurrence'                         => __('Recurrence', 'wpamelia'),
            'recurrence_choosing_time'           => __('Choose time you want to repeat appointment', 'wpamelia'),
            'repeat_every'                       => __('Repeat every', 'wpamelia'),
            'recurrence_day'                     => __('day', 'wpamelia'),
            'recurrence_week'                    => __('week', 'wpamelia'),
            'recurrence_month'                   => __('month', 'wpamelia'),
            'recurrence_days'                    => __('days', 'wpamelia'),
            'recurrence_weeks'                   => __('weeks', 'wpamelia'),
            'recurrence_months'                  => __('months', 'wpamelia'),
            'recurrence_repeat_on'               => __('Repeat on', 'wpamelia'),
            'recurrence_specific_date'           => __('Specific date', 'wpamelia'),
            'recurrence_first'                   => __('First', 'wpamelia'),
            'recurrence_second'                  => __('Second', 'wpamelia'),
            'recurrence_third'                   => __('Third', 'wpamelia'),
            'recurrence_fourth'                  => __('Fourth', 'wpamelia'),
            'recurring_fifth'                    => __('Fifth', 'wpamelia'),
            'recurrence_last'                    => __('Last', 'wpamelia'),
            'recurrence_ends'                    => __('Ends', 'wpamelia'),
            'recurrence_choose_ends'             => __('Choose when the repeating ends', 'wpamelia'),
            'number_of_recurrences'              => __('Number of Recurrences:', 'wpamelia'),
            'recurrence_on'                      => __('On', 'wpamelia'),
            'recurrence_each'                    => __('Each', 'wpamelia'),
            'recurrence_select_date'             => __('Select Date', 'wpamelia'),
            'recurrence_after'                   => __('After', 'wpamelia'),
            'occurrences'                        => __('Occurrences', 'wpamelia'),
            'appointment_repeats'                => __('Appointment Repeats', 'wpamelia'),
            'recurrence_every'                   => __('Every', 'wpamelia'),
            'repeats_on'                         => __('on', 'wpamelia'),
            'repeats_at'                         => __('at', 'wpamelia'),
            'repeats_from'                       => __('from', 'wpamelia'),
            'ends_after'                         => __('Ends after', 'wpamelia'),
            'ends_on'                            => __('Ends on', 'wpamelia'),

            'recurring_summary'                  => __('Recurring Summary', 'wpamelia'),
            'recurring_unavailable_slots'        => __('Unavailable Time Slots', 'wpamelia'),
            'recurring_alert_content'            => __('slots you selected are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_chose_date'               => __('Choose Date and Time', 'wpamelia'),
            'recurring_delete'                   => __('Delete', 'wpamelia'),
            'recurring_slots_selected'           => __('All slots are selected', 'wpamelia'),

            'coupon'                             => __('Coupon', 'wpamelia'),
            'add_coupon_btn'                     => __('Add', 'wpamelia'),
            'summary_recurrence'                 => __('Recurrence', 'wpamelia'),
            'summary_recurrences'                => __('Recurrences', 'wpamelia'),
            'summary_extras'                     => __('Extras', 'wpamelia'),
            'summary_extras_subtotal'            => __('Extras Subtotal', 'wpamelia'),
            'summary_package'                    => __('Package', 'wpamelia'),
            'paying_now'                         => __('Paying now', 'wpamelia'),
            'paying_later'                       => __('Paying later', 'wpamelia'),
            'full_amount_consent'                => __('I want to pay full amount', 'wpamelia'),
            'card_number_colon'                  => __('Card number', 'wpamelia'),
            'expires_date_colon'                 => __('Expiration date', 'wpamelia'),
            'payment_protected_policy'           => __('Payment protected by policy and powered by', 'wpamelia'),
            'payment_wc_mollie_sentence'         => __('You will be redirected to the payment checkout.', 'wpamelia'),

            'congrats_package'                   => __('Package', 'wpamelia'),
            'congrats_panel'                     => __('Customer Panel', 'wpamelia'),

            'new_caps'                           => __('NEW', 'wpamelia'),
            'beta_caps'                          => __('BETA', 'wpamelia'),
            'primary'                            => __('Primary', 'wpamelia'),
            'warning'                            => __('Warning', 'wpamelia'),
            'main_content'                       => __('Main Content', 'wpamelia'),
            'placeholder'                        => __('Placeholder', 'wpamelia'),
            'employee_description'               => __('Employee Description Popup', 'wpamelia'),
            'employee_information'               => __('Employee Information', 'wpamelia'),
            'employee_information_package'       => __('Employee Information', 'wpamelia'),
            'select_this_employee'               => __('Select this employee', 'wpamelia'),
            'select_this_employee_package'       => __('Select this employee', 'wpamelia'),
            'layout'                             => __('Layout', 'wpamelia'),
            'fonts_and_colors'                   => __('Fonts and colors', 'wpamelia'),
            'change_colors'                      => __('Change Colors', 'wpamelia'),
            'sub_step_title'                     => __('Sub Step Title', 'wpamelia'),
            'heading_content'                    => __('Heading Content', 'wpamelia'),
            'step_heading'                       => __('Step Heading', 'wpamelia'),
            'input_field'                        => __('Input Field', 'wpamelia'),
            'cards_and_buttons'                  => __('Cards and Buttons', 'wpamelia'),
            'page_content'                       => __('Page Content', 'wpamelia'),
            'card_field'                         => __('Card Field', 'wpamelia'),
            'card_content'                       => __('Card Content', 'wpamelia'),
            'alert_content'                      => __('Alert Content', 'wpamelia'),
            'popup_title'                        => __('Popup Title', 'wpamelia'),
            'popup_content'                      => __('Popup Content', 'wpamelia'),
            'popup_buttons'                      => __('Popup Buttons', 'wpamelia'),
            'primary_btn_type'                   => __('Primary Button Type', 'wpamelia'),
            'secondary_btn_type'                 => __('Secondary Button Type', 'wpamelia'),
            'recurring_popup'                    => __('Recurring popup', 'wpamelia'),
            'button_type'                        => __('Button Type', 'wpamelia'),

            'cart_step'                          => __('Cart', 'wpamelia'),
            'cart_add_button'                    => __('Book another', 'wpamelia'),
            'cart_view_button'                   => __('View Cart', 'wpamelia'),
            'cart_title'                         => __('You can find below the appointments you selected for booking. If you want to book more, click on the button below.'),
            'total_price'                        => __('Total Price', 'wpamelia'),
            'back_to_cart_button_type'           => __('Cancel Cart Button Type', 'wpamelia'),
            'add_to_cart_button_type'            => __('Book Another Button Type', 'wpamelia'),
            'total_tax_colon'                    => __('VAT', 'wpamelia'),
            'incl_tax'                           => __('Incl. VAT', 'wpamelia'),
            'tax_visibility'                     => __('VAT Visibility', 'wpamelia'),

            /* csb - customize side bar */
            'csb_extras'                         => __('Extras Selection', 'wpamelia'),
            'csb_extras_content'                 => __('Set up visibility and labels', 'wpamelia'),
            'csb_cart'                           => __('Cart Selection', 'wpamelia'),
            'csb_cart_content'                   => __('Cart description', 'wpamelia'),
            'csb_recurring'                      => __('Recurring Appointments', 'wpamelia'),
            'csb_recurring_content'              => __('Set up visibility, button type and labels', 'wpamelia'),
            'scb_recurring_summary'              => __('Recurring Summary', 'wpamelia'),
            'scb_recurring_summary_content'      => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_layout_labels_content'          => __('Layout and labels options', 'wpamelia'),
            'csb_placeholder'                    => __('placeholder', 'wpamelia'),
            'csb_mandatory'                      => __('mandatory notice', 'wpamelia'),
            'csb_appointment_reschedule'         => __('Reschedule Appointment', 'wpamelia'),
            'csb_appointment_book'               => __('Book Appointment', 'wpamelia'),
            'csb_appointment_cancel'             => __('Cancel Appointment', 'wpamelia'),
            'csb_event_cancel'                   => __('Cancel Event', 'wpamelia'),
            'csb_package_cancel'                 => __('Cancel Package', 'wpamelia'),

            'cpb_package'                        => __('Package Selection', 'wpamelia'),
            'cpb_package_content'                => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_package_info'                   => __('Package Info', 'wpamelia'),
            'cpb_package_info_content'           => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_service_appointment'            => __('Services list, Appointments', 'wpamelia'),
            'cpb_appointments_preview'           => __('Booked Appointments Preview', 'wpamelia'),
            'cpb_appointments_preview_content'   => __('Set up Content, Buttons and Labels', 'wpamelia'),
            'cpb_booking_overview'               => __('Booking Overview', 'wpamelia'),
            'cpb_booking_overview_content'       => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_your_info_content'              => __('Registration, Telephone Number, Email', 'wpamelia'),
            'cpb_payment_content'                => __('Payment type, deposit payment...', 'wpamelia'),
            'cb_package_appointments_heading'    => __('Package Appointments', 'wpamelia'),
            'service_input_field'                => __('Service Input Field', 'wpamelia'),
            'location_input_field'               => __('Location Input Field', 'wpamelia'),
            'employee_input_field'               => __('Employee Input Field', 'wpamelia'),
            'primary_button_type'                => __('Primary Button Type', 'wpamelia'),
            'secondary_button_type'              => __('Secondary Button Type', 'wpamelia'),
            'location'                           => __('Location', 'wpamelia'),
            'heading'                            => __('Heading', 'wpamelia'),
            'info'                               => __('Info', 'wpamelia'),
            'popup_heading'                      => __('Popup Heading', 'wpamelia'),
            'extras_heading'                     => __('Extras Heading', 'wpamelia'),
            'extras_description'                 => __('Extras Description', 'wpamelia'),
            'extras_duration'                    => __('Extras Duration', 'wpamelia'),
            'csb_category_items'                 => __('Services and Packages Overview', 'wpamelia'),
            'csb_category_items_content'         => __('Set up Services and Packages view', 'wpamelia'),
            'csb_category_package'               => __('Package Details', 'wpamelia'),
            'csb_category_package_content'       => __('Set up Package detailed view', 'wpamelia'),
            // cl - categories list
            'cl_card'                            => __('Card', 'wpamelia'),
            'card_packages_number'               => __('Total Number of Packages', 'wpamelia'),
            // cli - category items list
            // keys only used on backend customize
            'cil_filter_buttons'                 => __('“All/Packages/Services” filter option', 'wpamelia'),
            'employee_btn_type'                  => __('"View Employee" Button Type', 'wpamelia'),
            'book_employee_btn_type'             => __('Book Option on Employee Dialog', 'wpamelia'),
            'employee_dialog'                    => __('Employee Dialog', 'wpamelia'),
            'employee_info'                      => __('Employee information', 'wpamelia'),
            'book_service'                       => __('Book This Service', 'wpamelia'),
            'book_package'                       => __('Book This Package', 'wpamelia'),
            'package_category'                   => __('Package Category', 'wpamelia'),
            'package_duration'                   => __('Package Duration', 'wpamelia'),
            'package_capacity'                   => __('Package Capacity', 'wpamelia'),
            'package_location'                   => __('Package Location', 'wpamelia'),
            'service_capacity'                   => __('Service Capacity', 'wpamelia'),
            'service_location'                   => __('Service Location', 'wpamelia'),
            'service_employees'                  => __('Employees', 'wpamelia'),
            'package_about'                      => __('About Package', 'wpamelia'),
            'package_employees'                  => __('Employees', 'wpamelia'),
            'package_block'                      => __('Packages Block', 'wpamelia'),
            'cil_filter_employee'                => __('“Filter by Employee” option', 'wpamelia'),
            'cil_filter_location'                => __('“Filter by Location” option', 'wpamelia'),

            // keys used on back and front
            'filter_employee'                    => __('Filter by Employee', 'wpamelia'),
            'filter_location'                    => __('Filter by Location', 'wpamelia'),
            'filter_all'                         => __('All', 'wpamelia'),
            'filter_packages'                    => __('Packages', 'wpamelia'),
            'filter_services'                    => __('Services', 'wpamelia'),
            'package'                            => __('Package', 'wpamelia'),
            'packages'                           => __('Packages', 'wpamelia'),
            'view_employees'                     => __('View Employees', 'wpamelia'),
            'save'                               => __('Save', 'wpamelia'),
            'in_package'                         => __('In Package', 'wpamelia'),
            'about_package'                      => __('About Package', 'wpamelia'),
            'service_available_in_package'       => __('This Service is available in a Package', 'wpamelia'),
            'more_packages'                      => __('View More Packages', 'wpamelia'),
            'less_packages'                      => __('View Less Packages', 'wpamelia'),
            'package_includes'                   => __('Package includes', 'wpamelia'),
            'employee_price'                     => __('Employee Price', 'wpamelia'),
            'tab_employees'                      => __('Employees', 'wpamelia'),
            'extras_costs_colon'                 => __('Extras Cost:', 'wpamelia'),
            'subtotal_colon'                     => __('Subtotal:', 'wpamelia'),
            'deposit'                            => __('Deposit', 'wpamelia'),
            'pay_now'                            => __('Paying now', 'wpamelia'),
            'pay_later'                          => __('Left to pay', 'wpamelia'),
            'recurring_costs_colon'              => __('Recurring Appointments:', 'wpamelia'),
            'csb_event_tickets'                  => __('Event Tickets', 'wpamelia'),
            'csb_event_tickets_content'          => __('Set up visibility and labels of ticket selection', 'wpamelia'),
            'event_calendar'                     => __('Calendar', 'wpamelia'),
            'event_select_tickets'               => __('Select Tickets', 'wpamelia'),
            'event_tickets_context'              => __('Select the number of tickets that you want to book for each ticket type', 'wpamelia'),
            'event_ticket_types'                 => __('Ticket Types', 'wpamelia'),
            'event_tickets_left'                 => __('tickets left', 'wpamelia'),
            'event_ticket_left'                  => __('ticket left', 'wpamelia'),
            'event_organizer'                    => __('Organizer', 'wpamelia'),
            'event_tickets'                      => __('Tickets', 'wpamelia'),
            'coupons_used'                       => __('Coupon Limit Reached', 'wpamelia'),
            'coupons_used_description'           => __('Number of appointments with applied coupon is', 'wpamelia'),
            'congrats_cart'                      => __('Total Services Booked', 'wpamelia'),

            // capc - Cabinet - panel customer
            // capc - keys used on back and front
            'toggle_sidebar'                         => __('Toggle Sidebar', 'wpamelia'),
            'log_out'                                => __('Log out', 'wpamelia'),
            'reschedule'                             => __('Reschedule', 'wpamelia'),
            'google_meet_link'                       => __('Google Meet Link', 'wpamelia'),
            'microsoft_teams_link'                   => __('Microsoft Teams Link', 'wpamelia'),
            'zoom_link'                              => __('Zoom Link', 'wpamelia'),
            'my_profile'                             => __('My Profile', 'wpamelia'),
            'personal_info'                          => __('Personal Information', 'wpamelia'),
            'password_tab'                           => __('Password', 'wpamelia'),
            'menu_title'                             => __('Menu', 'wpamelia'),
            'profile_data_success'                   => __('Profile data updated successfully', 'wpamelia'),
            'password_success'                       => __('Password changed successfully', 'wpamelia'),
            'services_dropdown'                      => __('Service', 'wpamelia'),
            'events_dropdown'                        => __('Event', 'wpamelia'),
            'packages_dropdown'                      => __('Package', 'wpamelia'),
            'providers_dropdown'                     => __('Employee', 'wpamelia'),
            'customers_dropdown'                     => __('Customer', 'wpamelia'),
            'locations_dropdown'                     => __('Location', 'wpamelia'),
            'filters'                                => __('Filters', 'wpamelia'),
            'cancel_appointment'                     => __('Cancel Appointment', 'wpamelia'),
            'confirm_cancel_appointment'             => __('Are you sure you want to cancel this appointment?', 'wpamelia'),
            'package_book_expiration'                => __('Duration:', 'wpamelia'),
            'package_book_unlimited'                 => __('Unlimited', 'wpamelia'),
            'timetable'                              => __('Timetable', 'wpamelia'),
            'event_ticket'                           => __('Ticket', 'wpamelia'),
            'cancel_event'                           => __('Cancel Event', 'wpamelia'),
            'confirm_cancel_event'                   => __('Are you sure you want to cancel your attendance?', 'wpamelia'),
            'appointments_booked'                    => __('Appointments booked', 'wpamelia'),
            'appointment_booked'                     => __('Appointment booked', 'wpamelia'),
            'package_book_expire'                    => __('Valid Until:', 'wpamelia'),
            'package_deal_expire_in'                 => __('This package deal will expire in', 'wpamelia'),
            'appointments_deal_expire'               => __('book appointments before the deal expires!', 'wpamelia'),
            'package_cancel'                         => __('Cancel', 'wpamelia'),
            'cancel_package'                         => __('Cancel Package', 'wpamelia'),
            'confirm_cancel_package'                 => __('Are you sure you want to cancel this package?', 'wpamelia'),
            'pay_now_btn'                            => __('Pay now', 'wpamelia'),
            'profile_deleted'                        => __('Profile deleted', 'wpamelia'),
            'welcome_back'                           => __('Welcome Back', 'wpamelia'),
            'enter_credentials'                      => __('Enter your credentials to access your account.', 'wpamelia'),
            'email_or_username'                      => __('Email or Username', 'wpamelia'),
            'enter_email_or_username_warning'        => __('Please enter email or username', 'wpamelia'),
            'enter_password_warning'                 => __('Please enter password', 'wpamelia'),
            'password'                               => __('Password', 'wpamelia'),
            'forgot_your_password'                   => __('Forgot your password?', 'wpamelia'),
            'reset_password'                         => __('Reset Password', 'wpamelia'),
            'sign_in'                                => __('Sign In', 'wpamelia'),
            'access_link_send'                       => __('Send Access Link', 'wpamelia'),
            'access_link_send_description'           => __('Enter your account email address and we will send you an access link to your inbox.', 'wpamelia'),
            'send'                                   => __('Send', 'wpamelia'),
            'access_link_send_check'                 => __('Check your email', 'wpamelia'),
            'access_link_send_click'                 => __('Click on the activation link in the e-mail we sent to', 'wpamelia'),
            'access_link_send_inbox'                 => __('Did not receive the email? Check your spam filter, or', 'wpamelia'),
            'access_link_send_retry'                 => __('try different email', 'wpamelia'),
            'provider_profile'                       => __('Employee Profile', 'wpamelia'),
            'time_slot_unavailable'                  => __('Time slot is unavailable', 'wpamelia'),
            'package_booking_unavailable'            => __('Booking is unavailable', 'wpamelia'),
            'booking_reschedule_exception'           => __('Appointment can\'t be rescheduled', 'wpamelia'),
            'event_staff'                            => __('Staff', 'wpamelia'),
            'appointment_price'                      => __('Appointment Price', 'wpamelia'),
            'appointment_rescheduled'                => __('Appointment has been rescheduled', 'wpamelia'),
            'appointment_canceled'                   => __('Appointment Canceled', 'wpamelia'),
            'booking_cancel_exception'               => __('Booking can\'t be canceled', 'wpamelia'),
            'event_canceled'                         => __('Event has been canceled', 'wpamelia'),
            'booking_added_success'                  => __('Successfully added booking', 'wpamelia'),
            'package_purchase_canceled'              => __('Purchase is canceled', 'wpamelia'),
            'customer_already_booked_app'  => __('You have already booked this appointment', 'wpamelia'),

            // capc - keys only used on backend customize
            'capc_form'                              => __('Customer Panel 2.0', 'wpamelia'),
            'redesigned_capc_form'                   => __('The Customer Panel 2.0 allows for efficient management of appointments and events, with customizable options for colors and labels to better serve user needs.', 'wpamelia'),
            'tab_title'                              => __('Tab Title', 'wpamelia'),
            'toggled_sidebar'                        => __('Toggle Sidebar', 'wpamelia'),
            'mobile_menu'                            => __('Mobile menu', 'wpamelia'),
            'delete_profile_button_type'             => __('Delete Button Type', 'wpamelia'),
            'save_changes_button_type'               => __('Save Changes Button Type', 'wpamelia'),
            'change_pass_button_type'                => __('Change Password Button Type', 'wpamelia'),
            'close_button_type'                      => __('Close Button Type', 'wpamelia'),
            'confirm_button_type'                    => __('Confirm Button Type', 'wpamelia'),
            'cancel_button_type'                     => __('Cancel Button Type', 'wpamelia'),
            'step_message'                           => __('Step Message', 'wpamelia'),
            'item_status'                            => __('Item Status', 'wpamelia'),
            'page_card'                              => __('Page Card', 'wpamelia'),
            'page_messages'                          => __('Page Messages', 'wpamelia'),
            'go_back_btn_type'                       => __('"Go Back" Button Type', 'wpamelia'),
            'pay_button_type'                        => __('"Paying now" Button Type', 'wpamelia'),
            'book_now_button_type'                   => __('"Book Now" Button Type', 'wpamelia'),
            'alert_message'                          => __('Alert Message', 'wpamelia'),
            'footer_content'                         => __('Footer Content', 'wpamelia'),
            'sign_in_button_type'                    => __('Sign In Button Type', 'wpamelia'),
            'send_button_type'                       => __('Send Button Type', 'wpamelia'),
            'new_pass_button_type'                   => __('Set Password Button Type', 'wpamelia'),

            // cape - keys only used on backend customize
            'cape_form'                              => __('Employee Panel 2.0', 'wpamelia'),
            'redesigned_cape_form'                   => __('The Employee Panel 2.0 allows for efficient management of appointments and events, with customizable options for colors.', 'wpamelia'),

            //  csb  - customize side bar
            //  cust - customer
            'csb_cust_profile'                       => __('Profile', 'wpamelia'),
            'csb_cust_profile_content'               => __('Field order, mandatory fields, labels and display options', 'wpamelia'),
            'csb_cust_appointments'                  => __('Appointments', 'wpamelia'),
            'csb_cust_appointments_content'          => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_events'                        => __('Events', 'wpamelia'),
            'csb_cust_events_content'                => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_packages_list'                 => __('Packages', 'wpamelia'),
            'csb_cust_packages_list_content'         => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_package_appointments'          => __('Packages Appointments', 'wpamelia'),
            'csb_cust_package_appointments_content'  => __('Set up display options and labels', 'wpamelia'),
            'csb_cust_filter_service'                => __('Service Filter', 'wpamelia'),
            'csb_cust_filter_employee'               => __('Employee Filter', 'wpamelia'),
            'csb_cust_filter_customer'               => __('Customer Filter', 'wpamelia'),
            'csb_cust_filter_location'               => __('Location Filter', 'wpamelia'),
            'csb_cust_filter_packages'               => __('Package Filter', 'wpamelia'),
            'csb_cust_filter_event'                  => __('Event Filter', 'wpamelia'),
            'csb_cust_appointment_employee'          => __('Appointment Employee', 'wpamelia'),
            'csb_cust_appointment_customer'          => __('Appointment Customer', 'wpamelia'),
            'csb_cust_appointment_customer_phone'    => __('Appointment Customer Phone', 'wpamelia'),
            'csb_cust_appointment_customer_email'    => __('Appointment Customer Email', 'wpamelia'),
            'csb_cust_event_employee'                => __('Event Employees', 'wpamelia'),
            'csb_cust_event_customer'                => __('Event Customer', 'wpamelia'),
            'csb_cust_event_customer_phone'          => __('Event Customer Phone', 'wpamelia'),
            'csb_cust_event_customer_email'          => __('Event Customer Email', 'wpamelia'),
            'csb_cust_sign_in'                       => __('Sign In', 'wpamelia'),
            'csb_cust_sign_in_content'               => __('Set up button type and labels', 'wpamelia'),
            'csb_cust_access_link'                   => __('Access Link', 'wpamelia'),
            'csb_cust_access_link_content'           => __('Set up button type and labels', 'wpamelia'),
            'csb_cust_access_link_success'           => __('Access Link Success', 'wpamelia'),
            'csb_cust_access_link_success_content'   => __('Set up labels', 'wpamelia'),
            'csb_cust_set_new_pass'                  => __('Set New Password', 'wpamelia'),
            'csb_cust_set_new_pass_content'          => __('Set up button type and labels', 'wpamelia'),

            'birthday'                               => __('Birthday', 'wpamelia'),
            'date_of_birth'                          => __('Date of Birth', 'wpamelia'),
            'enter_date_of_birth'                    => __('Enter date of birth', 'wpamelia'),
            'enter_date_of_birth_warning'            => __('Please enter date of birth', 'wpamelia'),
            'new_password_set'                       => __('Set Password', 'wpamelia'),
            'new_password_set_action'                => __('Set Password', 'wpamelia'),
            'new_password_set_description'           => __('Enter, and re-enter your new password to continue', 'wpamelia'),
            'new_password_colon'                     => __('New Password:', 'wpamelia'),
            'new_password_colon_retype'              => __('Re-type New Password:', 'wpamelia'),
            'new_password_required'                  => __('Please enter new password', 'wpamelia'),
            'new_password_length'                    => __('Password must be longer than 3 characters', 'wpamelia'),
            'new_password_changed'                   => __('Password Updated!', 'wpamelia'),
            'new_password_changed_description'       => __('Your password has been changed successfully. Use your new password to log in.', 'wpamelia'),
            'passwords_not_match'                    => __('Passwords do not match', 'wpamelia'),
            'delete_profile'                         => __('Delete profile', 'wpamelia'),
            'delete_profile_confirm'                 => __('Delete profile', 'wpamelia'),
            'delete_profile_description'             => __('Are you sure you want to delete your profile? You will lose access to all your bookings and access to the customer panel.', 'wpamelia'),
            'save_changes'                           => __('Save Changes', 'wpamelia'),
            'change_password'                        => __('Change Password', 'wpamelia'),

            'no_app_found'                           => __('No appointments found', 'wpamelia'),
            'have_no_app'                            => __('You don\'t have any appointments', 'wpamelia'),
            'no_pack_found'                          => __('No packages found', 'wpamelia'),
            'have_no_pack'                           => __('You don\'t have any packages', 'wpamelia'),
            'no_evt_found'                           => __('No events found', 'wpamelia'),
            'have_no_evt'                            => __('You don\'t have any events', 'wpamelia'),
            'cust_empty_state'                       => __('Empty State', 'wpamelia'),

            // strings used only on backend
            'step_tickets_tab'                   => __('Step Tickets Tab', 'wpamelia'),
            'customer_panel_btn'                 => __('Customer Panel Button', 'wpamelia'),
            'coupon_segment'                     => __('Coupon Segment', 'wpamelia'),
            'waiting_background'                 => __('Waiting Button Background Color', 'wpamelia'),
            'waiting_text'                       => __('Waiting Button Text Color', 'wpamelia'),

            // ecf - Event Calendar Form
            'ecf_booking_form'                   => __('Event Calendar Booking Form 2.0', 'wpamelia'),
            'redesigned_ecf_booking_form'        => __('Use the Event Calendar Booking Form 2.0 to display your events in a calendar, allowing customers to book directly, search for specific events, or view upcoming events.', 'wpamelia'),

            'csb_events_calendar'                => __('Events Calendar', 'wpamelia'),
            'csb_events_calendar_content'        => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'wpamelia'),
            'step_search'                        => __('Step Search', 'wpamelia'),
            'evt_empty_message'                  => __('There are no upcoming events for this period', 'wpamelia'),
            'join_waiting_list'                  => __('Join waiting list', 'wpamelia'),
            'people_waiting'                     => __('people waiting', 'wpamelia'),
            'person_waiting'                     => __('person waiting', 'wpamelia'),
            'waiting_list'                       => __('Waiting list', 'wpamelia'),
            'upcoming'                           => __('Upcoming', 'wpamelia'),
            'waiting'                            => __('Waiting', 'wpamelia'),
            'booking_waiting_btn'                => __('Join Waiting List Button', 'wpamelia'),
            'your_position_on_waiting_list'      => __('You are on the waiting list with position', 'wpamelia'),
            'waiting_list_notify_message'        => __('We\'ll notify you if a spot opens up and your booking is approved.', 'wpamelia'),
            'event_add_attendee'                 => __('Add Attendee', 'wpamelia'),
            'attendees'                          => __('Attendees', 'wpamelia'),
            'new_appointment'                    => __('New Appointment', 'wpamelia'),
            'new_event'                          => __('New Event', 'wpamelia'),
            'new_app_button_type'                => __('New Appointment Button Type', 'wpamelia'),
            'new_evt_button_type'                => __('New Event Button Type', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getCustomizeStrings());
    }

    /**
     * @return array
     */
    public static function getWordPressStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'notice_panel'                     => __('Notice: Please select at least one panel.', 'wpamelia'),
            'search'                           => __('Search', 'wpamelia'),
            'search_date'                      => __('Preselect Current Date', 'wpamelia'),
            'search_divi'                      => __('AM - Search view', 'wpamelia'),
            'customer_cabinet_divi'            => __('AM - Customer Panel', 'wpamelia'),
            'employee_cabinet_divi'            => __('AM - Employee Panel', 'wpamelia'),
            'search_gutenberg_block'           => [
                'title'       => __('Amelia - Search view', 'wpamelia'),
                'description' => __('Front-end Booking Search is shortcode that give your customers the possibility to search for appointment by selecting several filters so that they could find the best time slots and services for their needs.', 'wpamelia'),
            ],
            'customer_cabinet_gutenberg_block' => [
                'title'       => __('Amelia - Customer Panel', 'wpamelia'),
                'description' => __('Front-end Customer Panel is a shortcode that gives your customers the possibility to manage their bookings and profile information.', 'wpamelia'),
            ],
            'employee_cabinet_gutenberg_block' => [
                'title'       => __('Amelia - Employee Panel', 'wpamelia'),
                'description' => __('Front-end Employee Panel is a shortcode that gives your employees the possibility to manage their bookings, working hours, days off, assigned services and profile information.', 'wpamelia'),
            ],
            'choose_panel_version'            => __('Choose panel version', 'wpamelia'),
            'panel_version_old'               => __('Old version', 'wpamelia'),
            'panel_version_new'               => __('New version', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getWordPressStrings());
    }

    /**
     * @return array
     */
    public static function getBuddyBossStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'amelia_settings_profile'           => __('Amelia Profile Settings', 'wpamelia'),
            'amelia_settings_customers'         => __('Amelia Users Settings', 'wpamelia'),
            'enable_amelia'                     => __('Enable Amelia', 'wpamelia'),
            'enable_booking_tab'                => __('Enable Amelia Tabs on Profiles', 'wpamelia'),
            'booking_form_enabled'              => __('Booking form on customer profile enabled', 'wpamelia'),
            'bookingform_enabled'               => __('Booking form tab enabled', 'wpamelia'),
            'booking_form_employee_enabled'     => __('Booking form on employee profile enabled', 'wpamelia'),
            'booking_form_type'                 => __('Booking form type', 'wpamelia'),
            'booking_form_type_employee'        => __('Booking form type on employee profile page', 'wpamelia'),
            'booking_tab_name'                  => __('Booking tab name', 'wpamelia'),
            'book_subtab_name'                  => __('Book subtab name', 'wpamelia'),
            'panel_subtab_name'                 => __('Panel subtab name', 'wpamelia'),
            'booking_employee_tab_name'         => __('Booking on employee page tab name', 'wpamelia'),
            'booking_form_events_list'          => __('Events List', 'wpamelia'),
            'booking_form_events_calendar'      => __('Events Calendar', 'wpamelia'),
            'subscribers_transform'             => __('Automatically create Amelia Customers from WP Users ', 'wpamelia'),
            'subscribers_transform_text'        => __('After account activation, subscribers will be created as customers in Amelia ', 'wpamelia'),
            'create_providers_text'             => __('Create Employees from WP Users with Amelia Employee Role', 'wpamelia'),
            'create_providers'                  => __('Create Amelia Employees', 'wpamelia'),
            'create_customers'                  => __('Create Amelia Customers', 'wpamelia'),
            'create_customers_text'             => __('Create Customers from WP Users with Amelia Customer Role', 'wpamelia'),
            'guest_booking_enabled'             => __('Enable guest booking', 'wpamelia'),
            'guest_booking_enabled_text'        => __('Allow booking without a prior login', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getBuddyBossStrings());
    }

    /**
     * @return array
     */
    public static function getRecurringStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'recurring_sub_message1'   => __('Some of the desired slots are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_sub_message2'   => __('Number of adjusted time slots: ', 'wpamelia'),
            'recurring_active'         => __('Repeat this appointment', 'wpamelia'),
            'recurring_active_tooltip' => __('Check this option if you want to create recurring appointments', 'wpamelia'),
            'recurring_select_employee'=> __('(select Employee first)', 'wpamelia'),
            'recurring_type_daily'     => __('Daily', 'wpamelia'),
            'recurring_type_weekly'    => __('Weekly', 'wpamelia'),
            'recurring_type_monthly'   => __('Monthly', 'wpamelia'),
            'recurring_repeat'         => __('Repeat:', 'wpamelia'),
            'recurring_every'          => __('Every:', 'wpamelia'),
            'recurring_until'          => __('Until:', 'wpamelia'),
            'recurring_every_text'     => __('Every', 'wpamelia'),
            'recurring_until_text'     => __('until', 'wpamelia'),
            'recurring_on'             => __('On:', 'wpamelia'),
            'recurring_each'           => __('Each:', 'wpamelia'),
            'recurring_times'          => __('Time(s):', 'wpamelia'),
            'recurring_date_specific'  => __('Specific Date', 'wpamelia'),
            'recurring_date_first'     => __('First', 'wpamelia'),
            'recurring_date_second'    => __('Second', 'wpamelia'),
            'recurring_date_third'     => __('Third', 'wpamelia'),
            'recurring_date_fourth'    => __('Fourth', 'wpamelia'),
            'recurring_date_fifth'     => __('Fifth', 'wpamelia'),
            'recurring_date_last'      => __('Last', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteBackendStrings::getRecurringStrings());
    }
}
