<?php

namespace AmeliaStripe\Util;

class ObjectTypes
{
    /**
     * @var array Mapping from object types to resource classes
     */
    const mapping
        = [
            \AmeliaStripe\Collection::OBJECT_NAME => \AmeliaStripe\Collection::class,
            \AmeliaStripe\Issuing\CardDetails::OBJECT_NAME => \AmeliaStripe\Issuing\CardDetails::class,
            \AmeliaStripe\SearchResult::OBJECT_NAME => \AmeliaStripe\SearchResult::class,
            \AmeliaStripe\File::OBJECT_NAME_ALT => \AmeliaStripe\File::class,
            // object classes: The beginning of the section generated from our OpenAPI spec
            \AmeliaStripe\Account::OBJECT_NAME => \AmeliaStripe\Account::class,
            \AmeliaStripe\AccountLink::OBJECT_NAME => \AmeliaStripe\AccountLink::class,
            \AmeliaStripe\AccountSession::OBJECT_NAME => \AmeliaStripe\AccountSession::class,
            \AmeliaStripe\ApplePayDomain::OBJECT_NAME => \AmeliaStripe\ApplePayDomain::class,
            \AmeliaStripe\Application::OBJECT_NAME => \AmeliaStripe\Application::class,
            \AmeliaStripe\ApplicationFee::OBJECT_NAME => \AmeliaStripe\ApplicationFee::class,
            \AmeliaStripe\ApplicationFeeRefund::OBJECT_NAME => \AmeliaStripe\ApplicationFeeRefund::class,
            \AmeliaStripe\Apps\Secret::OBJECT_NAME => \AmeliaStripe\Apps\Secret::class,
            \AmeliaStripe\Balance::OBJECT_NAME => \AmeliaStripe\Balance::class,
            \AmeliaStripe\BalanceTransaction::OBJECT_NAME => \AmeliaStripe\BalanceTransaction::class,
            \AmeliaStripe\BankAccount::OBJECT_NAME => \AmeliaStripe\BankAccount::class,
            \AmeliaStripe\Billing\Alert::OBJECT_NAME => \AmeliaStripe\Billing\Alert::class,
            \AmeliaStripe\Billing\AlertTriggered::OBJECT_NAME => \AmeliaStripe\Billing\AlertTriggered::class,
            \AmeliaStripe\Billing\CreditBalanceSummary::OBJECT_NAME => \AmeliaStripe\Billing\CreditBalanceSummary::class,
            \AmeliaStripe\Billing\CreditBalanceTransaction::OBJECT_NAME => \AmeliaStripe\Billing\CreditBalanceTransaction::class,
            \AmeliaStripe\Billing\CreditGrant::OBJECT_NAME => \AmeliaStripe\Billing\CreditGrant::class,
            \AmeliaStripe\Billing\Meter::OBJECT_NAME => \AmeliaStripe\Billing\Meter::class,
            \AmeliaStripe\Billing\MeterEvent::OBJECT_NAME => \AmeliaStripe\Billing\MeterEvent::class,
            \AmeliaStripe\Billing\MeterEventAdjustment::OBJECT_NAME => \AmeliaStripe\Billing\MeterEventAdjustment::class,
            \AmeliaStripe\Billing\MeterEventSummary::OBJECT_NAME => \AmeliaStripe\Billing\MeterEventSummary::class,
            \AmeliaStripe\BillingPortal\Configuration::OBJECT_NAME => \AmeliaStripe\BillingPortal\Configuration::class,
            \AmeliaStripe\BillingPortal\Session::OBJECT_NAME => \AmeliaStripe\BillingPortal\Session::class,
            \AmeliaStripe\Capability::OBJECT_NAME => \AmeliaStripe\Capability::class,
            \AmeliaStripe\Card::OBJECT_NAME => \AmeliaStripe\Card::class,
            \AmeliaStripe\CashBalance::OBJECT_NAME => \AmeliaStripe\CashBalance::class,
            \AmeliaStripe\Charge::OBJECT_NAME => \AmeliaStripe\Charge::class,
            \AmeliaStripe\Checkout\Session::OBJECT_NAME => \AmeliaStripe\Checkout\Session::class,
            \AmeliaStripe\Climate\Order::OBJECT_NAME => \AmeliaStripe\Climate\Order::class,
            \AmeliaStripe\Climate\Product::OBJECT_NAME => \AmeliaStripe\Climate\Product::class,
            \AmeliaStripe\Climate\Supplier::OBJECT_NAME => \AmeliaStripe\Climate\Supplier::class,
            \AmeliaStripe\ConfirmationToken::OBJECT_NAME => \AmeliaStripe\ConfirmationToken::class,
            \AmeliaStripe\ConnectCollectionTransfer::OBJECT_NAME => \AmeliaStripe\ConnectCollectionTransfer::class,
            \AmeliaStripe\CountrySpec::OBJECT_NAME => \AmeliaStripe\CountrySpec::class,
            \AmeliaStripe\Coupon::OBJECT_NAME => \AmeliaStripe\Coupon::class,
            \AmeliaStripe\CreditNote::OBJECT_NAME => \AmeliaStripe\CreditNote::class,
            \AmeliaStripe\CreditNoteLineItem::OBJECT_NAME => \AmeliaStripe\CreditNoteLineItem::class,
            \AmeliaStripe\Customer::OBJECT_NAME => \AmeliaStripe\Customer::class,
            \AmeliaStripe\CustomerBalanceTransaction::OBJECT_NAME => \AmeliaStripe\CustomerBalanceTransaction::class,
            \AmeliaStripe\CustomerCashBalanceTransaction::OBJECT_NAME => \AmeliaStripe\CustomerCashBalanceTransaction::class,
            \AmeliaStripe\CustomerSession::OBJECT_NAME => \AmeliaStripe\CustomerSession::class,
            \AmeliaStripe\Discount::OBJECT_NAME => \AmeliaStripe\Discount::class,
            \AmeliaStripe\Dispute::OBJECT_NAME => \AmeliaStripe\Dispute::class,
            \AmeliaStripe\Entitlements\ActiveEntitlement::OBJECT_NAME => \AmeliaStripe\Entitlements\ActiveEntitlement::class,
            \AmeliaStripe\Entitlements\ActiveEntitlementSummary::OBJECT_NAME => \AmeliaStripe\Entitlements\ActiveEntitlementSummary::class,
            \AmeliaStripe\Entitlements\Feature::OBJECT_NAME => \AmeliaStripe\Entitlements\Feature::class,
            \AmeliaStripe\EphemeralKey::OBJECT_NAME => \AmeliaStripe\EphemeralKey::class,
            \AmeliaStripe\Event::OBJECT_NAME => \AmeliaStripe\Event::class,
            \AmeliaStripe\ExchangeRate::OBJECT_NAME => \AmeliaStripe\ExchangeRate::class,
            \AmeliaStripe\File::OBJECT_NAME => \AmeliaStripe\File::class,
            \AmeliaStripe\FileLink::OBJECT_NAME => \AmeliaStripe\FileLink::class,
            \AmeliaStripe\FinancialConnections\Account::OBJECT_NAME => \AmeliaStripe\FinancialConnections\Account::class,
            \AmeliaStripe\FinancialConnections\AccountOwner::OBJECT_NAME => \AmeliaStripe\FinancialConnections\AccountOwner::class,
            \AmeliaStripe\FinancialConnections\AccountOwnership::OBJECT_NAME => \AmeliaStripe\FinancialConnections\AccountOwnership::class,
            \AmeliaStripe\FinancialConnections\Session::OBJECT_NAME => \AmeliaStripe\FinancialConnections\Session::class,
            \AmeliaStripe\FinancialConnections\Transaction::OBJECT_NAME => \AmeliaStripe\FinancialConnections\Transaction::class,
            \AmeliaStripe\Forwarding\Request::OBJECT_NAME => \AmeliaStripe\Forwarding\Request::class,
            \AmeliaStripe\FundingInstructions::OBJECT_NAME => \AmeliaStripe\FundingInstructions::class,
            \AmeliaStripe\Identity\VerificationReport::OBJECT_NAME => \AmeliaStripe\Identity\VerificationReport::class,
            \AmeliaStripe\Identity\VerificationSession::OBJECT_NAME => \AmeliaStripe\Identity\VerificationSession::class,
            \AmeliaStripe\Invoice::OBJECT_NAME => \AmeliaStripe\Invoice::class,
            \AmeliaStripe\InvoiceItem::OBJECT_NAME => \AmeliaStripe\InvoiceItem::class,
            \AmeliaStripe\InvoiceLineItem::OBJECT_NAME => \AmeliaStripe\InvoiceLineItem::class,
            \AmeliaStripe\InvoicePayment::OBJECT_NAME => \AmeliaStripe\InvoicePayment::class,
            \AmeliaStripe\InvoiceRenderingTemplate::OBJECT_NAME => \AmeliaStripe\InvoiceRenderingTemplate::class,
            \AmeliaStripe\Issuing\Authorization::OBJECT_NAME => \AmeliaStripe\Issuing\Authorization::class,
            \AmeliaStripe\Issuing\Card::OBJECT_NAME => \AmeliaStripe\Issuing\Card::class,
            \AmeliaStripe\Issuing\Cardholder::OBJECT_NAME => \AmeliaStripe\Issuing\Cardholder::class,
            \AmeliaStripe\Issuing\Dispute::OBJECT_NAME => \AmeliaStripe\Issuing\Dispute::class,
            \AmeliaStripe\Issuing\PersonalizationDesign::OBJECT_NAME => \AmeliaStripe\Issuing\PersonalizationDesign::class,
            \AmeliaStripe\Issuing\PhysicalBundle::OBJECT_NAME => \AmeliaStripe\Issuing\PhysicalBundle::class,
            \AmeliaStripe\Issuing\Token::OBJECT_NAME => \AmeliaStripe\Issuing\Token::class,
            \AmeliaStripe\Issuing\Transaction::OBJECT_NAME => \AmeliaStripe\Issuing\Transaction::class,
            \AmeliaStripe\LineItem::OBJECT_NAME => \AmeliaStripe\LineItem::class,
            \AmeliaStripe\LoginLink::OBJECT_NAME => \AmeliaStripe\LoginLink::class,
            \AmeliaStripe\Mandate::OBJECT_NAME => \AmeliaStripe\Mandate::class,
            \AmeliaStripe\PaymentIntent::OBJECT_NAME => \AmeliaStripe\PaymentIntent::class,
            \AmeliaStripe\PaymentLink::OBJECT_NAME => \AmeliaStripe\PaymentLink::class,
            \AmeliaStripe\PaymentMethod::OBJECT_NAME => \AmeliaStripe\PaymentMethod::class,
            \AmeliaStripe\PaymentMethodConfiguration::OBJECT_NAME => \AmeliaStripe\PaymentMethodConfiguration::class,
            \AmeliaStripe\PaymentMethodDomain::OBJECT_NAME => \AmeliaStripe\PaymentMethodDomain::class,
            \AmeliaStripe\Payout::OBJECT_NAME => \AmeliaStripe\Payout::class,
            \AmeliaStripe\Person::OBJECT_NAME => \AmeliaStripe\Person::class,
            \AmeliaStripe\Plan::OBJECT_NAME => \AmeliaStripe\Plan::class,
            \AmeliaStripe\Price::OBJECT_NAME => \AmeliaStripe\Price::class,
            \AmeliaStripe\Product::OBJECT_NAME => \AmeliaStripe\Product::class,
            \AmeliaStripe\ProductFeature::OBJECT_NAME => \AmeliaStripe\ProductFeature::class,
            \AmeliaStripe\PromotionCode::OBJECT_NAME => \AmeliaStripe\PromotionCode::class,
            \AmeliaStripe\Quote::OBJECT_NAME => \AmeliaStripe\Quote::class,
            \AmeliaStripe\Radar\EarlyFraudWarning::OBJECT_NAME => \AmeliaStripe\Radar\EarlyFraudWarning::class,
            \AmeliaStripe\Radar\ValueList::OBJECT_NAME => \AmeliaStripe\Radar\ValueList::class,
            \AmeliaStripe\Radar\ValueListItem::OBJECT_NAME => \AmeliaStripe\Radar\ValueListItem::class,
            \AmeliaStripe\Refund::OBJECT_NAME => \AmeliaStripe\Refund::class,
            \AmeliaStripe\Reporting\ReportRun::OBJECT_NAME => \AmeliaStripe\Reporting\ReportRun::class,
            \AmeliaStripe\Reporting\ReportType::OBJECT_NAME => \AmeliaStripe\Reporting\ReportType::class,
            \AmeliaStripe\ReserveTransaction::OBJECT_NAME => \AmeliaStripe\ReserveTransaction::class,
            \AmeliaStripe\Review::OBJECT_NAME => \AmeliaStripe\Review::class,
            \AmeliaStripe\SetupAttempt::OBJECT_NAME => \AmeliaStripe\SetupAttempt::class,
            \AmeliaStripe\SetupIntent::OBJECT_NAME => \AmeliaStripe\SetupIntent::class,
            \AmeliaStripe\ShippingRate::OBJECT_NAME => \AmeliaStripe\ShippingRate::class,
            \AmeliaStripe\Sigma\ScheduledQueryRun::OBJECT_NAME => \AmeliaStripe\Sigma\ScheduledQueryRun::class,
            \AmeliaStripe\Source::OBJECT_NAME => \AmeliaStripe\Source::class,
            \AmeliaStripe\SourceMandateNotification::OBJECT_NAME => \AmeliaStripe\SourceMandateNotification::class,
            \AmeliaStripe\SourceTransaction::OBJECT_NAME => \AmeliaStripe\SourceTransaction::class,
            \AmeliaStripe\Subscription::OBJECT_NAME => \AmeliaStripe\Subscription::class,
            \AmeliaStripe\SubscriptionItem::OBJECT_NAME => \AmeliaStripe\SubscriptionItem::class,
            \AmeliaStripe\SubscriptionSchedule::OBJECT_NAME => \AmeliaStripe\SubscriptionSchedule::class,
            \AmeliaStripe\Tax\Calculation::OBJECT_NAME => \AmeliaStripe\Tax\Calculation::class,
            \AmeliaStripe\Tax\CalculationLineItem::OBJECT_NAME => \AmeliaStripe\Tax\CalculationLineItem::class,
            \AmeliaStripe\Tax\Registration::OBJECT_NAME => \AmeliaStripe\Tax\Registration::class,
            \AmeliaStripe\Tax\Settings::OBJECT_NAME => \AmeliaStripe\Tax\Settings::class,
            \AmeliaStripe\Tax\Transaction::OBJECT_NAME => \AmeliaStripe\Tax\Transaction::class,
            \AmeliaStripe\Tax\TransactionLineItem::OBJECT_NAME => \AmeliaStripe\Tax\TransactionLineItem::class,
            \AmeliaStripe\TaxCode::OBJECT_NAME => \AmeliaStripe\TaxCode::class,
            \AmeliaStripe\TaxDeductedAtSource::OBJECT_NAME => \AmeliaStripe\TaxDeductedAtSource::class,
            \AmeliaStripe\TaxId::OBJECT_NAME => \AmeliaStripe\TaxId::class,
            \AmeliaStripe\TaxRate::OBJECT_NAME => \AmeliaStripe\TaxRate::class,
            \AmeliaStripe\Terminal\Configuration::OBJECT_NAME => \AmeliaStripe\Terminal\Configuration::class,
            \AmeliaStripe\Terminal\ConnectionToken::OBJECT_NAME => \AmeliaStripe\Terminal\ConnectionToken::class,
            \AmeliaStripe\Terminal\Location::OBJECT_NAME => \AmeliaStripe\Terminal\Location::class,
            \AmeliaStripe\Terminal\Reader::OBJECT_NAME => \AmeliaStripe\Terminal\Reader::class,
            \AmeliaStripe\TestHelpers\TestClock::OBJECT_NAME => \AmeliaStripe\TestHelpers\TestClock::class,
            \AmeliaStripe\Token::OBJECT_NAME => \AmeliaStripe\Token::class,
            \AmeliaStripe\Topup::OBJECT_NAME => \AmeliaStripe\Topup::class,
            \AmeliaStripe\Transfer::OBJECT_NAME => \AmeliaStripe\Transfer::class,
            \AmeliaStripe\TransferReversal::OBJECT_NAME => \AmeliaStripe\TransferReversal::class,
            \AmeliaStripe\Treasury\CreditReversal::OBJECT_NAME => \AmeliaStripe\Treasury\CreditReversal::class,
            \AmeliaStripe\Treasury\DebitReversal::OBJECT_NAME => \AmeliaStripe\Treasury\DebitReversal::class,
            \AmeliaStripe\Treasury\FinancialAccount::OBJECT_NAME => \AmeliaStripe\Treasury\FinancialAccount::class,
            \AmeliaStripe\Treasury\FinancialAccountFeatures::OBJECT_NAME => \AmeliaStripe\Treasury\FinancialAccountFeatures::class,
            \AmeliaStripe\Treasury\InboundTransfer::OBJECT_NAME => \AmeliaStripe\Treasury\InboundTransfer::class,
            \AmeliaStripe\Treasury\OutboundPayment::OBJECT_NAME => \AmeliaStripe\Treasury\OutboundPayment::class,
            \AmeliaStripe\Treasury\OutboundTransfer::OBJECT_NAME => \AmeliaStripe\Treasury\OutboundTransfer::class,
            \AmeliaStripe\Treasury\ReceivedCredit::OBJECT_NAME => \AmeliaStripe\Treasury\ReceivedCredit::class,
            \AmeliaStripe\Treasury\ReceivedDebit::OBJECT_NAME => \AmeliaStripe\Treasury\ReceivedDebit::class,
            \AmeliaStripe\Treasury\Transaction::OBJECT_NAME => \AmeliaStripe\Treasury\Transaction::class,
            \AmeliaStripe\Treasury\TransactionEntry::OBJECT_NAME => \AmeliaStripe\Treasury\TransactionEntry::class,
            \AmeliaStripe\WebhookEndpoint::OBJECT_NAME => \AmeliaStripe\WebhookEndpoint::class,
            // object classes: The end of the section generated from our OpenAPI spec
        ];

    /**
     * @var array Mapping from v2 object types to resource classes
     */
    const v2Mapping = [
        // v2 object classes: The beginning of the section generated from our OpenAPI spec
        \AmeliaStripe\V2\Billing\MeterEvent::OBJECT_NAME => \AmeliaStripe\V2\Billing\MeterEvent::class,
        \AmeliaStripe\V2\Billing\MeterEventAdjustment::OBJECT_NAME => \AmeliaStripe\V2\Billing\MeterEventAdjustment::class,
        \AmeliaStripe\V2\Billing\MeterEventSession::OBJECT_NAME => \AmeliaStripe\V2\Billing\MeterEventSession::class,
        \AmeliaStripe\V2\Event::OBJECT_NAME => \AmeliaStripe\V2\Event::class,
        \AmeliaStripe\V2\EventDestination::OBJECT_NAME => \AmeliaStripe\V2\EventDestination::class,
        // v2 object classes: The end of the section generated from our OpenAPI spec
    ];
}
