<?php
/**
 * Currency Switcher Locale Functions
 *
 * @version 2.5.0
 * @since   2.5.0
 * @author  Tom Anbinder
 */

if ( ! function_exists( 'alg_wc_cc_get_currency_locales' ) ) {
	/**
	 * alg_wc_cc_get_currency_locales.
	 *
	 * @version 2.5.0
	 * @since   2.5.0
	 * @todo    not finished (~116 locales not assigned)
	 */
	function alg_wc_cc_get_currency_locales() {
		return array(
			'AFN' => array( 'fa_AF', 'ps_AF', 'uz_Arab_AF' ),
			'ALL' => array( 'sq', 'sq_AL' ),
			'DZD' => array( 'ar_DZ', 'kab_DZ' ),
			'USD' => array( 'chr_US', 'en_AS', 'en_GU', 'en_MH', 'en_MP', 'en_UM', 'en_US', 'en_VI', 'es_PR', 'es_US', 'haw_US' ),
			'EUR' => array( 'ca_ES', 'de', 'de_AT', 'de_BE', 'de_DE', 'de_LU', 'el', 'el_CY', 'el_GR', 'en_BE', 'en_IE', 'en_MT', 'es_ES', 'et', 'et_EE', 'eu_ES', 'fi', 'fi_FI', 'fr', 'fr_BE', 'fr_FR', 'fr_GP', 'fr_LU', 'fr_MC', 'fr_MQ', 'fr_RE', 'ga', 'ga_IE', 'gl_ES', 'it', 'it_IT', 'lt', 'lt_LT', 'lv', 'lv_LV', 'mt_MT', 'nl', 'nl_BE', 'nl_NL', 'pt_PT', 'sk', 'sk_SK', 'sl', 'sl_SI', 'sr_Cyrl_ME', 'sr_Latn_ME', 'sv_FI' ),
			'AOA' => array(),
			'XCD' => array(),
			'ARS' => array( 'es_AR' ),
			'AMD' => array( 'hy', 'hy_AM' ),
			'AWG' => array(),
			'AUD' => array( 'en_AU' ),
			'AZN' => array( 'az', 'az_Cyrl', 'az_Cyrl_AZ', 'az_Latn', 'az_Latn_AZ' ),
			'BSD' => array(),
			'BHD' => array( 'ar_BH' ),
			'BDT' => array( 'bn_BD' ),
			'BBD' => array(),
			'BYR' => array( 'be', 'be_BY' ),
			'BZD' => array( 'en_BZ' ),
			'XOF' => array( 'bm_ML', 'ee_TG', 'ff_SN', 'fr_BF', 'fr_BJ', 'fr_ML', 'fr_NE', 'fr_SN', 'fr_TG', 'ha_Latn_NE', 'khq_ML', 'ses_ML' ),
			'BMD' => array(),
			'BTN' => array(),
			'BOB' => array( 'es_BO' ),
			'BAM' => array( 'bs_BA', 'sr_Cyrl_BA', 'sr_Latn_BA' ),
			'BWP' => array( 'en_BW' ),
			'NOK' => array( 'nb', 'nb_NO', 'nn', 'nn_NO' ),
			'BRL' => array( 'pt_BR' ),
			'BND' => array( 'ms_BN' ),
			'BGN' => array( 'bg', 'bg_BG' ),
			'BIF' => array( 'fr_BI' ),
			'KHR' => array( 'km_KH' ),
			'XAF' => array( 'es_GQ', 'fr_CF', 'fr_CG', 'fr_CM', 'fr_GA', 'fr_GQ', 'fr_TD', 'sg_CF' ),
			'CAD' => array( 'en_CA', 'fr_CA' ),
			'CVE' => array( 'kea_CV' ),
			'KYD' => array(),
			'CLP' => array( 'es_CL' ),
			'CNY' => array( 'bo_CN', 'ii_CN', 'zh', 'zh_Hans', 'zh_Hans_CN', 'zh_Hant' ),
			'RMB' => array(),
			'HKD' => array( 'en_HK', 'zh_Hans_HK', 'zh_Hant_HK' ),
			'COP' => array( 'es_CO' ),
			'KMF' => array( 'fr_KM' ),
			'CDF' => array( 'fr_CD' ),
			'NZD' => array( 'en_NZ' ),
			'CRC' => array( 'es_CR' ),
			'HRK' => array( 'hr_HR' ),
			'CUP' => array(),
			'CUC' => array(),
			'CZK' => array( 'cs', 'cs_CZ' ),
			'DKK' => array( 'da', 'da_DK', 'fo_FO', 'kl_GL' ),
			'DJF' => array( 'fr_DJ', 'so_DJ' ),
			'DOP' => array( 'es_DO' ),
			'ECS' => array( 'es_EC' ),
			'EGP' => array( 'ar_EG' ),
			'SVC' => array( 'es_SV' ),
			'ERN' => array( 'ti_ER' ),
			'ETB' => array( 'am_ET', 'om_ET', 'so_ET', 'ti_ET' ),
			'FKP' => array(),
			'FJD' => array(),
			'GMD' => array(),
			'GEL' => array( 'ka_GE' ),
			'GHS' => array( 'ak_GH', 'ee_GH', 'ha_Latn_GH' ),
			'GIP' => array(),
			'QTQ' => array( 'es_GT' ),
			'GTQ' => array(),
			'GGP' => array(),
			'GNF' => array( 'fr_GN' ),
			'GWP' => array( 'pt_GW' ),
			'GYD' => array(),
			'HTG' => array(),
			'HNL' => array( 'es_HN' ),
			'HUF' => array( 'hu', 'hu_HU' ),
			'ISK' => array( 'is', 'is_IS' ),
			'INR' => array( 'as_IN', 'bn_IN', 'bo_IN', 'en_IN', 'gu_IN', 'hi_IN', 'kn_IN', 'kok_IN', 'ml_IN', 'mr_IN', 'ne_IN', 'or_IN', 'pa_Guru_IN', 'ta_IN', 'te_IN', 'ur_IN' ),
			'IDR' => array( 'id_ID' ),
			'IRR' => array( 'fa_IR' ),
			'IQD' => array( 'ar_IQ' ),
			'GBP' => array( 'cy_GB', 'en_GB', 'gv_GB', 'kw_GB' ),
			'ILS' => array( 'he', 'he_IL' ),
			'JMD' => array( 'en_JM' ),
			'JPY' => array( 'ja', 'ja_JP' ),
			'JOD' => array( 'ar_JO' ),
			'KZT' => array( 'kk', 'kk_Cyrl', 'kk_Cyrl_KZ' ),
			'KES' => array( 'dav_KE', 'ebu_KE', 'guz_KE', 'kam_KE', 'ki_KE', 'kln_KE', 'luo_KE', 'luy_KE', 'mas_KE', 'mer_KE', 'om_KE', 'saq_KE', 'so_KE', 'sw_KE', 'teo_KE' ),
			'KPW' => array(),
			'KRW' => array( 'ko', 'ko_KR' ),
			'KWD' => array( 'ar_KW' ),
			'KGS' => array(),
			'LAK' => array(),
			'KIP' => array(),
			'LBP' => array( 'ar_LB' ),
			'LSL' => array(),
			'LRD' => array(),
			'LYD' => array( 'ar_LY' ),
			'CHF' => array( 'de_CH', 'de_LI', 'fr_CH', 'gsw_CH', 'it_CH', 'rm_CH' ),
			'MKD' => array( 'mk_MK' ),
			'MGF' => array( 'fr_MG', 'mg_MG' ),
			'MGA' => array(),
			'MWK' => array(),
			'MYR' => array( 'ms_MY' ),
			'MVR' => array(),
			'MRO' => array(),
			'MUR' => array( 'en_MU', 'mfe_MU' ),
			'MXN' => array( 'es_MX' ),
			'MDL' => array( 'ro_MD', 'ru_MD' ),
			'MNT' => array(),
			'MAD' => array( 'ar_MA', 'shi_Latn_MA', 'shi_Tfng_MA', 'tzm_Latn_MA' ),
			'MZN' => array( 'pt_MZ', 'seh_MZ' ),
			'MZM' => array(),
			'MMK' => array( 'my_MM' ),
			'NAD' => array( 'af_NA', 'en_NA', 'naq_NA' ),
			'NPR' => array( 'ne_NP' ),
			'ANG' => array(),
			'XPF' => array(),
			'NIO' => array( 'es_NI' ),
			'NGN' => array( 'ha_Latn_NG', 'ig_NG', 'yo_NG' ),
			'OMR' => array( 'ar_OM' ),
			'PKR' => array( 'en_PK', 'pa_Arab_PK', 'ur_PK' ),
			'PAB' => array( 'es_PA' ),
			'PGK' => array(),
			'PYG' => array( 'es_PY' ),
			'PEN' => array( 'es_PE' ),
			'PHP' => array( 'en_PH', 'fil_PH' ),
			'PLN' => array( 'pl', 'pl_PL' ),
			'QAR' => array( 'ar_QA' ),
			'RON' => array( 'ro_RO' ),
			'RUB' => array( 'ru', 'ru_RU' ),
			'RWF' => array( 'fr_RW', 'rw_RW' ),
			'SHP' => array(),
			'WST' => array(),
			'STD' => array(),
			'SAR' => array( 'ar_SA' ),
			'RSD' => array( 'sr_Cyrl', 'sr_Cyrl_RS', 'sr_Latn', 'sr_Latn_RS' ),
			'SCR' => array(),
			'SLL' => array(),
			'SGD' => array( 'en_SG', 'zh_Hans_SG' ),
			'SBD' => array(),
			'SOS' => array( 'so_SO' ),
			'ZAR' => array( 'af_ZA', 'en_ZA', 'zu_ZA' ),
			'SSP' => array(),
			'LKR' => array( 'si_LK', 'ta_LK' ),
			'SDG' => array( 'ar_SD' ),
			'SRD' => array(),
			'SZL' => array(),
			'SEK' => array( 'sv_SE' ),
			'SYP' => array( 'ar_SY' ),
			'TWD' => array( 'zh_Hant_TW' ),
			'TJS' => array(),
			'TZS' => array( 'asa_TZ', 'bez_TZ', 'jmc_TZ', 'kde_TZ', 'lag_TZ', 'mas_TZ', 'rof_TZ', 'rwk_TZ', 'sw_TZ', 'vun_TZ' ),
			'THB' => array( 'th_TH' ),
			'TOP' => array( 'to_TO' ),
			'TTD' => array( 'en_TT' ),
			'TND' => array( 'ar_TN' ),
			'TRY' => array( 'tr_TR' ),
			'TMT' => array(),
			'TMM' => array(),
			'UGX' => array( 'cgg_UG', 'lg_UG', 'nyn_UG', 'teo_UG', 'xog_UG' ),
			'UAH' => array( 'ru_UA', 'uk', 'uk_UA' ),
			'AED' => array( 'ar_AE' ),
			'UYU' => array( 'es_UY' ),
			'UZS' => array( 'uz', 'uz_Arab', 'uz_Cyrl', 'uz_Cyrl_UZ', 'uz_Latn', 'uz_Latn_UZ' ),
			'VUV' => array(),
			'VEF' => array( 'es_VE' ),
			'VND' => array( 'vi_VN' ),
			'YER' => array( 'ar_YE' ),
			'ZMW' => array( 'bem_ZM' ),
			'ZMK' => array(),
			'ZWD' => array( 'en_ZW', 'nd_ZW', 'sn_ZW' ),
			'GQE' => array(),
			'MOP' => array( 'zh_Hans_MO', 'zh_Hant_MO' ),
			'LTL' => array(),
			'LVL' => array(),
			'EEK' => array(),
			'SKK' => array(),
			// Former currencies
			'LTL' => array(),
			'LVL' => array(),
			'EEK' => array(),
			'SKK' => array(),
		);
	}
}

if ( ! function_exists( 'alg_wc_cc_get_all_locales' ) ) {
	/**
	 * alg_wc_cc_get_all_locales.
	 *
	 * @version 2.5.0
	 * @since   2.5.0
	 * @todo    check WPML / Polylang for similar function
	 */
	function alg_wc_cc_get_all_locales() {
		return array(
			'af_NA'       => __( 'Afrikaans (Namibia)', 'currency-switcher-woocommerce' ),
			'af_ZA'       => __( 'Afrikaans (South Africa)', 'currency-switcher-woocommerce' ),
			'af'          => __( 'Afrikaans', 'currency-switcher-woocommerce' ),
			'ak_GH'       => __( 'Akan (Ghana)', 'currency-switcher-woocommerce' ),
			'ak'          => __( 'Akan', 'currency-switcher-woocommerce' ),
			'sq_AL'       => __( 'Albanian (Albania)', 'currency-switcher-woocommerce' ),
			'sq'          => __( 'Albanian', 'currency-switcher-woocommerce' ),
			'am_ET'       => __( 'Amharic (Ethiopia)', 'currency-switcher-woocommerce' ),
			'am'          => __( 'Amharic', 'currency-switcher-woocommerce' ),
			'ar_DZ'       => __( 'Arabic (Algeria)', 'currency-switcher-woocommerce' ),
			'ar_BH'       => __( 'Arabic (Bahrain)', 'currency-switcher-woocommerce' ),
			'ar_EG'       => __( 'Arabic (Egypt)', 'currency-switcher-woocommerce' ),
			'ar_IQ'       => __( 'Arabic (Iraq)', 'currency-switcher-woocommerce' ),
			'ar_JO'       => __( 'Arabic (Jordan)', 'currency-switcher-woocommerce' ),
			'ar_KW'       => __( 'Arabic (Kuwait)', 'currency-switcher-woocommerce' ),
			'ar_LB'       => __( 'Arabic (Lebanon)', 'currency-switcher-woocommerce' ),
			'ar_LY'       => __( 'Arabic (Libya)', 'currency-switcher-woocommerce' ),
			'ar_MA'       => __( 'Arabic (Morocco)', 'currency-switcher-woocommerce' ),
			'ar_OM'       => __( 'Arabic (Oman)', 'currency-switcher-woocommerce' ),
			'ar_QA'       => __( 'Arabic (Qatar)', 'currency-switcher-woocommerce' ),
			'ar_SA'       => __( 'Arabic (Saudi Arabia)', 'currency-switcher-woocommerce' ),
			'ar_SD'       => __( 'Arabic (Sudan)', 'currency-switcher-woocommerce' ),
			'ar_SY'       => __( 'Arabic (Syria)', 'currency-switcher-woocommerce' ),
			'ar_TN'       => __( 'Arabic (Tunisia)', 'currency-switcher-woocommerce' ),
			'ar_AE'       => __( 'Arabic (United Arab Emirates)', 'currency-switcher-woocommerce' ),
			'ar_YE'       => __( 'Arabic (Yemen)', 'currency-switcher-woocommerce' ),
			'ar'          => __( 'Arabic', 'currency-switcher-woocommerce' ),
			'hy_AM'       => __( 'Armenian (Armenia)', 'currency-switcher-woocommerce' ),
			'hy'          => __( 'Armenian', 'currency-switcher-woocommerce' ),
			'as_IN'       => __( 'Assamese (India)', 'currency-switcher-woocommerce' ),
			'as'          => __( 'Assamese', 'currency-switcher-woocommerce' ),
			'asa_TZ'      => __( 'Asu (Tanzania)', 'currency-switcher-woocommerce' ),
			'asa'         => __( 'Asu', 'currency-switcher-woocommerce' ),
			'az_Cyrl'     => __( 'Azerbaijani (Cyrillic)', 'currency-switcher-woocommerce' ),
			'az_Cyrl_AZ'  => __( 'Azerbaijani (Cyrillic, Azerbaijan)', 'currency-switcher-woocommerce' ),
			'az_Latn'     => __( 'Azerbaijani (Latin)', 'currency-switcher-woocommerce' ),
			'az_Latn_AZ'  => __( 'Azerbaijani (Latin, Azerbaijan)', 'currency-switcher-woocommerce' ),
			'az'          => __( 'Azerbaijani', 'currency-switcher-woocommerce' ),
			'bm_ML'       => __( 'Bambara (Mali)', 'currency-switcher-woocommerce' ),
			'bm'          => __( 'Bambara', 'currency-switcher-woocommerce' ),
			'eu_ES'       => __( 'Basque (Spain)', 'currency-switcher-woocommerce' ),
			'eu'          => __( 'Basque', 'currency-switcher-woocommerce' ),
			'be_BY'       => __( 'Belarusian (Belarus)', 'currency-switcher-woocommerce' ),
			'be'          => __( 'Belarusian', 'currency-switcher-woocommerce' ),
			'bem_ZM'      => __( 'Bemba (Zambia)', 'currency-switcher-woocommerce' ),
			'bem'         => __( 'Bemba', 'currency-switcher-woocommerce' ),
			'bez_TZ'      => __( 'Bena (Tanzania)', 'currency-switcher-woocommerce' ),
			'bez'         => __( 'Bena', 'currency-switcher-woocommerce' ),
			'bn_BD'       => __( 'Bengali (Bangladesh)', 'currency-switcher-woocommerce' ),
			'bn_IN'       => __( 'Bengali (India)', 'currency-switcher-woocommerce' ),
			'bn'          => __( 'Bengali', 'currency-switcher-woocommerce' ),
			'bs_BA'       => __( 'Bosnian (Bosnia and Herzegovina)', 'currency-switcher-woocommerce' ),
			'bs'          => __( 'Bosnian', 'currency-switcher-woocommerce' ),
			'bg_BG'       => __( 'Bulgarian (Bulgaria)', 'currency-switcher-woocommerce' ),
			'bg'          => __( 'Bulgarian', 'currency-switcher-woocommerce' ),
			'my_MM'       => __( 'Burmese (Myanmar [Burma])', 'currency-switcher-woocommerce' ),
			'my'          => __( 'Burmese', 'currency-switcher-woocommerce' ),
			'ca_ES'       => __( 'Catalan (Spain)', 'currency-switcher-woocommerce' ),
			'ca'          => __( 'Catalan', 'currency-switcher-woocommerce' ),
			'tzm_Latn'    => __( 'Central Morocco Tamazight (Latin)', 'currency-switcher-woocommerce' ),
			'tzm_Latn_MA' => __( 'Central Morocco Tamazight (Latin, Morocco)', 'currency-switcher-woocommerce' ),
			'tzm'         => __( 'Central Morocco Tamazight', 'currency-switcher-woocommerce' ),
			'chr_US'      => __( 'Cherokee (United States)', 'currency-switcher-woocommerce' ),
			'chr'         => __( 'Cherokee', 'currency-switcher-woocommerce' ),
			'cgg_UG'      => __( 'Chiga (Uganda)', 'currency-switcher-woocommerce' ),
			'cgg'         => __( 'Chiga', 'currency-switcher-woocommerce' ),
			'zh_Hans'     => __( 'Chinese (Simplified Han)', 'currency-switcher-woocommerce' ),
			'zh_Hans_CN'  => __( 'Chinese (Simplified Han, China)', 'currency-switcher-woocommerce' ),
			'zh_Hans_HK'  => __( 'Chinese (Simplified Han, Hong Kong SAR China)', 'currency-switcher-woocommerce' ),
			'zh_Hans_MO'  => __( 'Chinese (Simplified Han, Macau SAR China)', 'currency-switcher-woocommerce' ),
			'zh_Hans_SG'  => __( 'Chinese (Simplified Han, Singapore)', 'currency-switcher-woocommerce' ),
			'zh_Hant'     => __( 'Chinese (Traditional Han)', 'currency-switcher-woocommerce' ),
			'zh_Hant_HK'  => __( 'Chinese (Traditional Han, Hong Kong SAR China)', 'currency-switcher-woocommerce' ),
			'zh_Hant_MO'  => __( 'Chinese (Traditional Han, Macau SAR China)', 'currency-switcher-woocommerce' ),
			'zh_Hant_TW'  => __( 'Chinese (Traditional Han, Taiwan)', 'currency-switcher-woocommerce' ),
			'zh'          => __( 'Chinese', 'currency-switcher-woocommerce' ),
			'kw_GB'       => __( 'Cornish (United Kingdom)', 'currency-switcher-woocommerce' ),
			'kw'          => __( 'Cornish', 'currency-switcher-woocommerce' ),
			'hr_HR'       => __( 'Croatian (Croatia)', 'currency-switcher-woocommerce' ),
			'hr'          => __( 'Croatian', 'currency-switcher-woocommerce' ),
			'cs_CZ'       => __( 'Czech (Czech Republic)', 'currency-switcher-woocommerce' ),
			'cs'          => __( 'Czech', 'currency-switcher-woocommerce' ),
			'da_DK'       => __( 'Danish (Denmark)', 'currency-switcher-woocommerce' ),
			'da'          => __( 'Danish', 'currency-switcher-woocommerce' ),
			'nl_BE'       => __( 'Dutch (Belgium)', 'currency-switcher-woocommerce' ),
			'nl_NL'       => __( 'Dutch (Netherlands)', 'currency-switcher-woocommerce' ),
			'nl'          => __( 'Dutch', 'currency-switcher-woocommerce' ),
			'ebu_KE'      => __( 'Embu (Kenya)', 'currency-switcher-woocommerce' ),
			'ebu'         => __( 'Embu', 'currency-switcher-woocommerce' ),
			'en_AS'       => __( 'English (American Samoa)', 'currency-switcher-woocommerce' ),
			'en_AU'       => __( 'English (Australia)', 'currency-switcher-woocommerce' ),
			'en_BE'       => __( 'English (Belgium)', 'currency-switcher-woocommerce' ),
			'en_BZ'       => __( 'English (Belize)', 'currency-switcher-woocommerce' ),
			'en_BW'       => __( 'English (Botswana)', 'currency-switcher-woocommerce' ),
			'en_CA'       => __( 'English (Canada)', 'currency-switcher-woocommerce' ),
			'en_GU'       => __( 'English (Guam)', 'currency-switcher-woocommerce' ),
			'en_HK'       => __( 'English (Hong Kong SAR China)', 'currency-switcher-woocommerce' ),
			'en_IN'       => __( 'English (India)', 'currency-switcher-woocommerce' ),
			'en_IE'       => __( 'English (Ireland)', 'currency-switcher-woocommerce' ),
			'en_JM'       => __( 'English (Jamaica)', 'currency-switcher-woocommerce' ),
			'en_MT'       => __( 'English (Malta)', 'currency-switcher-woocommerce' ),
			'en_MH'       => __( 'English (Marshall Islands)', 'currency-switcher-woocommerce' ),
			'en_MU'       => __( 'English (Mauritius)', 'currency-switcher-woocommerce' ),
			'en_NA'       => __( 'English (Namibia)', 'currency-switcher-woocommerce' ),
			'en_NZ'       => __( 'English (New Zealand)', 'currency-switcher-woocommerce' ),
			'en_MP'       => __( 'English (Northern Mariana Islands)', 'currency-switcher-woocommerce' ),
			'en_PK'       => __( 'English (Pakistan)', 'currency-switcher-woocommerce' ),
			'en_PH'       => __( 'English (Philippines)', 'currency-switcher-woocommerce' ),
			'en_SG'       => __( 'English (Singapore)', 'currency-switcher-woocommerce' ),
			'en_ZA'       => __( 'English (South Africa)', 'currency-switcher-woocommerce' ),
			'en_TT'       => __( 'English (Trinidad and Tobago)', 'currency-switcher-woocommerce' ),
			'en_UM'       => __( 'English (U.S. Minor Outlying Islands)', 'currency-switcher-woocommerce' ),
			'en_VI'       => __( 'English (U.S. Virgin Islands)', 'currency-switcher-woocommerce' ),
			'en_GB'       => __( 'English (United Kingdom)', 'currency-switcher-woocommerce' ),
			'en_US'       => __( 'English (United States)', 'currency-switcher-woocommerce' ),
			'en_ZW'       => __( 'English (Zimbabwe)', 'currency-switcher-woocommerce' ),
			'en'          => __( 'English', 'currency-switcher-woocommerce' ),
			'eo'          => __( 'Esperanto', 'currency-switcher-woocommerce' ),
			'et_EE'       => __( 'Estonian (Estonia)', 'currency-switcher-woocommerce' ),
			'et'          => __( 'Estonian', 'currency-switcher-woocommerce' ),
			'ee_GH'       => __( 'Ewe (Ghana)', 'currency-switcher-woocommerce' ),
			'ee_TG'       => __( 'Ewe (Togo)', 'currency-switcher-woocommerce' ),
			'ee'          => __( 'Ewe', 'currency-switcher-woocommerce' ),
			'fo_FO'       => __( 'Faroese (Faroe Islands)', 'currency-switcher-woocommerce' ),
			'fo'          => __( 'Faroese', 'currency-switcher-woocommerce' ),
			'fil_PH'      => __( 'Filipino (Philippines)', 'currency-switcher-woocommerce' ),
			'fil'         => __( 'Filipino', 'currency-switcher-woocommerce' ),
			'fi_FI'       => __( 'Finnish (Finland)', 'currency-switcher-woocommerce' ),
			'fi'          => __( 'Finnish', 'currency-switcher-woocommerce' ),
			'fr_BE'       => __( 'French (Belgium)', 'currency-switcher-woocommerce' ),
			'fr_BJ'       => __( 'French (Benin)', 'currency-switcher-woocommerce' ),
			'fr_BF'       => __( 'French (Burkina Faso)', 'currency-switcher-woocommerce' ),
			'fr_BI'       => __( 'French (Burundi)', 'currency-switcher-woocommerce' ),
			'fr_CM'       => __( 'French (Cameroon)', 'currency-switcher-woocommerce' ),
			'fr_CA'       => __( 'French (Canada)', 'currency-switcher-woocommerce' ),
			'fr_CF'       => __( 'French (Central African Republic)', 'currency-switcher-woocommerce' ),
			'fr_TD'       => __( 'French (Chad)', 'currency-switcher-woocommerce' ),
			'fr_KM'       => __( 'French (Comoros)', 'currency-switcher-woocommerce' ),
			'fr_CG'       => __( 'French (Congo - Brazzaville)', 'currency-switcher-woocommerce' ),
			'fr_CD'       => __( 'French (Congo - Kinshasa)', 'currency-switcher-woocommerce' ),
			'fr_CI'       => __( 'French (Côte d’Ivoire)', 'currency-switcher-woocommerce' ),
			'fr_DJ'       => __( 'French (Djibouti)', 'currency-switcher-woocommerce' ),
			'fr_GQ'       => __( 'French (Equatorial Guinea)', 'currency-switcher-woocommerce' ),
			'fr_FR'       => __( 'French (France)', 'currency-switcher-woocommerce' ),
			'fr_GA'       => __( 'French (Gabon)', 'currency-switcher-woocommerce' ),
			'fr_GP'       => __( 'French (Guadeloupe)', 'currency-switcher-woocommerce' ),
			'fr_GN'       => __( 'French (Guinea)', 'currency-switcher-woocommerce' ),
			'fr_LU'       => __( 'French (Luxembourg)', 'currency-switcher-woocommerce' ),
			'fr_MG'       => __( 'French (Madagascar)', 'currency-switcher-woocommerce' ),
			'fr_ML'       => __( 'French (Mali)', 'currency-switcher-woocommerce' ),
			'fr_MQ'       => __( 'French (Martinique)', 'currency-switcher-woocommerce' ),
			'fr_MC'       => __( 'French (Monaco)', 'currency-switcher-woocommerce' ),
			'fr_NE'       => __( 'French (Niger)', 'currency-switcher-woocommerce' ),
			'fr_RW'       => __( 'French (Rwanda)', 'currency-switcher-woocommerce' ),
			'fr_RE'       => __( 'French (Réunion)', 'currency-switcher-woocommerce' ),
			'fr_BL'       => __( 'French (Saint Barthélemy)', 'currency-switcher-woocommerce' ),
			'fr_MF'       => __( 'French (Saint Martin)', 'currency-switcher-woocommerce' ),
			'fr_SN'       => __( 'French (Senegal)', 'currency-switcher-woocommerce' ),
			'fr_CH'       => __( 'French (Switzerland)', 'currency-switcher-woocommerce' ),
			'fr_TG'       => __( 'French (Togo)', 'currency-switcher-woocommerce' ),
			'fr'          => __( 'French', 'currency-switcher-woocommerce' ),
			'ff_SN'       => __( 'Fulah (Senegal)', 'currency-switcher-woocommerce' ),
			'ff'          => __( 'Fulah', 'currency-switcher-woocommerce' ),
			'gl_ES'       => __( 'Galician (Spain)', 'currency-switcher-woocommerce' ),
			'gl'          => __( 'Galician', 'currency-switcher-woocommerce' ),
			'lg_UG'       => __( 'Ganda (Uganda)', 'currency-switcher-woocommerce' ),
			'lg'          => __( 'Ganda', 'currency-switcher-woocommerce' ),
			'ka_GE'       => __( 'Georgian (Georgia)', 'currency-switcher-woocommerce' ),
			'ka'          => __( 'Georgian', 'currency-switcher-woocommerce' ),
			'de_AT'       => __( 'German (Austria)', 'currency-switcher-woocommerce' ),
			'de_BE'       => __( 'German (Belgium)', 'currency-switcher-woocommerce' ),
			'de_DE'       => __( 'German (Germany)', 'currency-switcher-woocommerce' ),
			'de_LI'       => __( 'German (Liechtenstein)', 'currency-switcher-woocommerce' ),
			'de_LU'       => __( 'German (Luxembourg)', 'currency-switcher-woocommerce' ),
			'de_CH'       => __( 'German (Switzerland)', 'currency-switcher-woocommerce' ),
			'de'          => __( 'German', 'currency-switcher-woocommerce' ),
			'el_CY'       => __( 'Greek (Cyprus)', 'currency-switcher-woocommerce' ),
			'el_GR'       => __( 'Greek (Greece)', 'currency-switcher-woocommerce' ),
			'el'          => __( 'Greek', 'currency-switcher-woocommerce' ),
			'gu_IN'       => __( 'Gujarati (India)', 'currency-switcher-woocommerce' ),
			'gu'          => __( 'Gujarati', 'currency-switcher-woocommerce' ),
			'guz_KE'      => __( 'Gusii (Kenya)', 'currency-switcher-woocommerce' ),
			'guz'         => __( 'Gusii', 'currency-switcher-woocommerce' ),
			'ha_Latn'     => __( 'Hausa (Latin)', 'currency-switcher-woocommerce' ),
			'ha_Latn_GH'  => __( 'Hausa (Latin, Ghana)', 'currency-switcher-woocommerce' ),
			'ha_Latn_NE'  => __( 'Hausa (Latin, Niger)', 'currency-switcher-woocommerce' ),
			'ha_Latn_NG'  => __( 'Hausa (Latin, Nigeria)', 'currency-switcher-woocommerce' ),
			'ha'          => __( 'Hausa', 'currency-switcher-woocommerce' ),
			'haw_US'      => __( 'Hawaiian (United States)', 'currency-switcher-woocommerce' ),
			'haw'         => __( 'Hawaiian', 'currency-switcher-woocommerce' ),
			'he_IL'       => __( 'Hebrew (Israel)', 'currency-switcher-woocommerce' ),
			'he'          => __( 'Hebrew', 'currency-switcher-woocommerce' ),
			'hi_IN'       => __( 'Hindi (India)', 'currency-switcher-woocommerce' ),
			'hi'          => __( 'Hindi', 'currency-switcher-woocommerce' ),
			'hu_HU'       => __( 'Hungarian (Hungary)', 'currency-switcher-woocommerce' ),
			'hu'          => __( 'Hungarian', 'currency-switcher-woocommerce' ),
			'is_IS'       => __( 'Icelandic (Iceland)', 'currency-switcher-woocommerce' ),
			'is'          => __( 'Icelandic', 'currency-switcher-woocommerce' ),
			'ig_NG'       => __( 'Igbo (Nigeria)', 'currency-switcher-woocommerce' ),
			'ig'          => __( 'Igbo', 'currency-switcher-woocommerce' ),
			'id_ID'       => __( 'Indonesian (Indonesia)', 'currency-switcher-woocommerce' ),
			'id'          => __( 'Indonesian', 'currency-switcher-woocommerce' ),
			'ga_IE'       => __( 'Irish (Ireland)', 'currency-switcher-woocommerce' ),
			'ga'          => __( 'Irish', 'currency-switcher-woocommerce' ),
			'it_IT'       => __( 'Italian (Italy)', 'currency-switcher-woocommerce' ),
			'it_CH'       => __( 'Italian (Switzerland)', 'currency-switcher-woocommerce' ),
			'it'          => __( 'Italian', 'currency-switcher-woocommerce' ),
			'ja_JP'       => __( 'Japanese (Japan)', 'currency-switcher-woocommerce' ),
			'ja'          => __( 'Japanese', 'currency-switcher-woocommerce' ),
			'kea_CV'      => __( 'Kabuverdianu (Cape Verde)', 'currency-switcher-woocommerce' ),
			'kea'         => __( 'Kabuverdianu', 'currency-switcher-woocommerce' ),
			'kab_DZ'      => __( 'Kabyle (Algeria)', 'currency-switcher-woocommerce' ),
			'kab'         => __( 'Kabyle', 'currency-switcher-woocommerce' ),
			'kl_GL'       => __( 'Kalaallisut (Greenland)', 'currency-switcher-woocommerce' ),
			'kl'          => __( 'Kalaallisut', 'currency-switcher-woocommerce' ),
			'kln_KE'      => __( 'Kalenjin (Kenya)', 'currency-switcher-woocommerce' ),
			'kln'         => __( 'Kalenjin', 'currency-switcher-woocommerce' ),
			'kam_KE'      => __( 'Kamba (Kenya)', 'currency-switcher-woocommerce' ),
			'kam'         => __( 'Kamba', 'currency-switcher-woocommerce' ),
			'kn_IN'       => __( 'Kannada (India)', 'currency-switcher-woocommerce' ),
			'kn'          => __( 'Kannada', 'currency-switcher-woocommerce' ),
			'kk_Cyrl'     => __( 'Kazakh (Cyrillic)', 'currency-switcher-woocommerce' ),
			'kk_Cyrl_KZ'  => __( 'Kazakh (Cyrillic, Kazakhstan)', 'currency-switcher-woocommerce' ),
			'kk'          => __( 'Kazakh', 'currency-switcher-woocommerce' ),
			'km_KH'       => __( 'Khmer (Cambodia)', 'currency-switcher-woocommerce' ),
			'km'          => __( 'Khmer', 'currency-switcher-woocommerce' ),
			'ki_KE'       => __( 'Kikuyu (Kenya)', 'currency-switcher-woocommerce' ),
			'ki'          => __( 'Kikuyu', 'currency-switcher-woocommerce' ),
			'rw_RW'       => __( 'Kinyarwanda (Rwanda)', 'currency-switcher-woocommerce' ),
			'rw'          => __( 'Kinyarwanda', 'currency-switcher-woocommerce' ),
			'kok_IN'      => __( 'Konkani (India)', 'currency-switcher-woocommerce' ),
			'kok'         => __( 'Konkani', 'currency-switcher-woocommerce' ),
			'ko_KR'       => __( 'Korean (South Korea)', 'currency-switcher-woocommerce' ),
			'ko'          => __( 'Korean', 'currency-switcher-woocommerce' ),
			'khq_ML'      => __( 'Koyra Chiini (Mali)', 'currency-switcher-woocommerce' ),
			'khq'         => __( 'Koyra Chiini', 'currency-switcher-woocommerce' ),
			'ses_ML'      => __( 'Koyraboro Senni (Mali)', 'currency-switcher-woocommerce' ),
			'ses'         => __( 'Koyraboro Senni', 'currency-switcher-woocommerce' ),
			'lag_TZ'      => __( 'Langi (Tanzania)', 'currency-switcher-woocommerce' ),
			'lag'         => __( 'Langi', 'currency-switcher-woocommerce' ),
			'lv_LV'       => __( 'Latvian (Latvia)', 'currency-switcher-woocommerce' ),
			'lv'          => __( 'Latvian', 'currency-switcher-woocommerce' ),
			'lt_LT'       => __( 'Lithuanian (Lithuania)', 'currency-switcher-woocommerce' ),
			'lt'          => __( 'Lithuanian', 'currency-switcher-woocommerce' ),
			'luo_KE'      => __( 'Luo (Kenya)', 'currency-switcher-woocommerce' ),
			'luo'         => __( 'Luo', 'currency-switcher-woocommerce' ),
			'luy_KE'      => __( 'Luyia (Kenya)', 'currency-switcher-woocommerce' ),
			'luy'         => __( 'Luyia', 'currency-switcher-woocommerce' ),
			'mk_MK'       => __( 'Macedonian (Macedonia)', 'currency-switcher-woocommerce' ),
			'mk'          => __( 'Macedonian', 'currency-switcher-woocommerce' ),
			'jmc_TZ'      => __( 'Machame (Tanzania)', 'currency-switcher-woocommerce' ),
			'jmc'         => __( 'Machame', 'currency-switcher-woocommerce' ),
			'kde_TZ'      => __( 'Makonde (Tanzania)', 'currency-switcher-woocommerce' ),
			'kde'         => __( 'Makonde', 'currency-switcher-woocommerce' ),
			'mg_MG'       => __( 'Malagasy (Madagascar)', 'currency-switcher-woocommerce' ),
			'mg'          => __( 'Malagasy', 'currency-switcher-woocommerce' ),
			'ms_BN'       => __( 'Malay (Brunei)', 'currency-switcher-woocommerce' ),
			'ms_MY'       => __( 'Malay (Malaysia)', 'currency-switcher-woocommerce' ),
			'ms'          => __( 'Malay', 'currency-switcher-woocommerce' ),
			'ml_IN'       => __( 'Malayalam (India)', 'currency-switcher-woocommerce' ),
			'ml'          => __( 'Malayalam', 'currency-switcher-woocommerce' ),
			'mt_MT'       => __( 'Maltese (Malta)', 'currency-switcher-woocommerce' ),
			'mt'          => __( 'Maltese', 'currency-switcher-woocommerce' ),
			'gv_GB'       => __( 'Manx (United Kingdom)', 'currency-switcher-woocommerce' ),
			'gv'          => __( 'Manx', 'currency-switcher-woocommerce' ),
			'mr_IN'       => __( 'Marathi (India)', 'currency-switcher-woocommerce' ),
			'mr'          => __( 'Marathi', 'currency-switcher-woocommerce' ),
			'mas_KE'      => __( 'Masai (Kenya)', 'currency-switcher-woocommerce' ),
			'mas_TZ'      => __( 'Masai (Tanzania)', 'currency-switcher-woocommerce' ),
			'mas'         => __( 'Masai', 'currency-switcher-woocommerce' ),
			'mer_KE'      => __( 'Meru (Kenya)', 'currency-switcher-woocommerce' ),
			'mer'         => __( 'Meru', 'currency-switcher-woocommerce' ),
			'mfe_MU'      => __( 'Morisyen (Mauritius)', 'currency-switcher-woocommerce' ),
			'mfe'         => __( 'Morisyen', 'currency-switcher-woocommerce' ),
			'naq_NA'      => __( 'Nama (Namibia)', 'currency-switcher-woocommerce' ),
			'naq'         => __( 'Nama', 'currency-switcher-woocommerce' ),
			'ne_IN'       => __( 'Nepali (India)', 'currency-switcher-woocommerce' ),
			'ne_NP'       => __( 'Nepali (Nepal)', 'currency-switcher-woocommerce' ),
			'ne'          => __( 'Nepali', 'currency-switcher-woocommerce' ),
			'nd_ZW'       => __( 'North Ndebele (Zimbabwe)', 'currency-switcher-woocommerce' ),
			'nd'          => __( 'North Ndebele', 'currency-switcher-woocommerce' ),
			'nb_NO'       => __( 'Norwegian Bokmål (Norway)', 'currency-switcher-woocommerce' ),
			'nb'          => __( 'Norwegian Bokmål', 'currency-switcher-woocommerce' ),
			'nn_NO'       => __( 'Norwegian Nynorsk (Norway)', 'currency-switcher-woocommerce' ),
			'nn'          => __( 'Norwegian Nynorsk', 'currency-switcher-woocommerce' ),
			'nyn_UG'      => __( 'Nyankole (Uganda)', 'currency-switcher-woocommerce' ),
			'nyn'         => __( 'Nyankole', 'currency-switcher-woocommerce' ),
			'or_IN'       => __( 'Oriya (India)', 'currency-switcher-woocommerce' ),
			'or'          => __( 'Oriya', 'currency-switcher-woocommerce' ),
			'om_ET'       => __( 'Oromo (Ethiopia)', 'currency-switcher-woocommerce' ),
			'om_KE'       => __( 'Oromo (Kenya)', 'currency-switcher-woocommerce' ),
			'om'          => __( 'Oromo', 'currency-switcher-woocommerce' ),
			'ps_AF'       => __( 'Pashto (Afghanistan)', 'currency-switcher-woocommerce' ),
			'ps'          => __( 'Pashto', 'currency-switcher-woocommerce' ),
			'fa_AF'       => __( 'Persian (Afghanistan)', 'currency-switcher-woocommerce' ),
			'fa_IR'       => __( 'Persian (Iran)', 'currency-switcher-woocommerce' ),
			'fa'          => __( 'Persian', 'currency-switcher-woocommerce' ),
			'pl_PL'       => __( 'Polish (Poland)', 'currency-switcher-woocommerce' ),
			'pl'          => __( 'Polish', 'currency-switcher-woocommerce' ),
			'pt_BR'       => __( 'Portuguese (Brazil)', 'currency-switcher-woocommerce' ),
			'pt_GW'       => __( 'Portuguese (Guinea-Bissau)', 'currency-switcher-woocommerce' ),
			'pt_MZ'       => __( 'Portuguese (Mozambique)', 'currency-switcher-woocommerce' ),
			'pt_PT'       => __( 'Portuguese (Portugal)', 'currency-switcher-woocommerce' ),
			'pt'          => __( 'Portuguese', 'currency-switcher-woocommerce' ),
			'pa_Arab'     => __( 'Punjabi (Arabic)', 'currency-switcher-woocommerce' ),
			'pa_Arab_PK'  => __( 'Punjabi (Arabic, Pakistan)', 'currency-switcher-woocommerce' ),
			'pa_Guru'     => __( 'Punjabi (Gurmukhi)', 'currency-switcher-woocommerce' ),
			'pa_Guru_IN'  => __( 'Punjabi (Gurmukhi, India)', 'currency-switcher-woocommerce' ),
			'pa'          => __( 'Punjabi', 'currency-switcher-woocommerce' ),
			'ro_MD'       => __( 'Romanian (Moldova)', 'currency-switcher-woocommerce' ),
			'ro_RO'       => __( 'Romanian (Romania)', 'currency-switcher-woocommerce' ),
			'ro'          => __( 'Romanian', 'currency-switcher-woocommerce' ),
			'rm_CH'       => __( 'Romansh (Switzerland)', 'currency-switcher-woocommerce' ),
			'rm'          => __( 'Romansh', 'currency-switcher-woocommerce' ),
			'rof_TZ'      => __( 'Rombo (Tanzania)', 'currency-switcher-woocommerce' ),
			'rof'         => __( 'Rombo', 'currency-switcher-woocommerce' ),
			'ru_MD'       => __( 'Russian (Moldova)', 'currency-switcher-woocommerce' ),
			'ru_RU'       => __( 'Russian (Russia)', 'currency-switcher-woocommerce' ),
			'ru_UA'       => __( 'Russian (Ukraine)', 'currency-switcher-woocommerce' ),
			'ru'          => __( 'Russian', 'currency-switcher-woocommerce' ),
			'rwk_TZ'      => __( 'Rwa (Tanzania)', 'currency-switcher-woocommerce' ),
			'rwk'         => __( 'Rwa', 'currency-switcher-woocommerce' ),
			'saq_KE'      => __( 'Samburu (Kenya)', 'currency-switcher-woocommerce' ),
			'saq'         => __( 'Samburu', 'currency-switcher-woocommerce' ),
			'sg_CF'       => __( 'Sango (Central African Republic)', 'currency-switcher-woocommerce' ),
			'sg'          => __( 'Sango', 'currency-switcher-woocommerce' ),
			'seh_MZ'      => __( 'Sena (Mozambique)', 'currency-switcher-woocommerce' ),
			'seh'         => __( 'Sena', 'currency-switcher-woocommerce' ),
			'sr_Cyrl'     => __( 'Serbian (Cyrillic)', 'currency-switcher-woocommerce' ),
			'sr_Cyrl_BA'  => __( 'Serbian (Cyrillic, Bosnia and Herzegovina)', 'currency-switcher-woocommerce' ),
			'sr_Cyrl_ME'  => __( 'Serbian (Cyrillic, Montenegro)', 'currency-switcher-woocommerce' ),
			'sr_Cyrl_RS'  => __( 'Serbian (Cyrillic, Serbia)', 'currency-switcher-woocommerce' ),
			'sr_Latn'     => __( 'Serbian (Latin)', 'currency-switcher-woocommerce' ),
			'sr_Latn_BA'  => __( 'Serbian (Latin, Bosnia and Herzegovina)', 'currency-switcher-woocommerce' ),
			'sr_Latn_ME'  => __( 'Serbian (Latin, Montenegro)', 'currency-switcher-woocommerce' ),
			'sr_Latn_RS'  => __( 'Serbian (Latin, Serbia)', 'currency-switcher-woocommerce' ),
			'sr'          => __( 'Serbian', 'currency-switcher-woocommerce' ),
			'sn_ZW'       => __( 'Shona (Zimbabwe)', 'currency-switcher-woocommerce' ),
			'sn'          => __( 'Shona', 'currency-switcher-woocommerce' ),
			'ii_CN'       => __( 'Sichuan Yi (China)', 'currency-switcher-woocommerce' ),
			'ii'          => __( 'Sichuan Yi', 'currency-switcher-woocommerce' ),
			'si_LK'       => __( 'Sinhala (Sri Lanka)', 'currency-switcher-woocommerce' ),
			'si'          => __( 'Sinhala', 'currency-switcher-woocommerce' ),
			'sk_SK'       => __( 'Slovak (Slovakia)', 'currency-switcher-woocommerce' ),
			'sk'          => __( 'Slovak', 'currency-switcher-woocommerce' ),
			'sl_SI'       => __( 'Slovenian (Slovenia)', 'currency-switcher-woocommerce' ),
			'sl'          => __( 'Slovenian', 'currency-switcher-woocommerce' ),
			'xog_UG'      => __( 'Soga (Uganda)', 'currency-switcher-woocommerce' ),
			'xog'         => __( 'Soga', 'currency-switcher-woocommerce' ),
			'so_DJ'       => __( 'Somali (Djibouti)', 'currency-switcher-woocommerce' ),
			'so_ET'       => __( 'Somali (Ethiopia)', 'currency-switcher-woocommerce' ),
			'so_KE'       => __( 'Somali (Kenya)', 'currency-switcher-woocommerce' ),
			'so_SO'       => __( 'Somali (Somalia)', 'currency-switcher-woocommerce' ),
			'so'          => __( 'Somali', 'currency-switcher-woocommerce' ),
			'es_AR'       => __( 'Spanish (Argentina)', 'currency-switcher-woocommerce' ),
			'es_BO'       => __( 'Spanish (Bolivia)', 'currency-switcher-woocommerce' ),
			'es_CL'       => __( 'Spanish (Chile)', 'currency-switcher-woocommerce' ),
			'es_CO'       => __( 'Spanish (Colombia)', 'currency-switcher-woocommerce' ),
			'es_CR'       => __( 'Spanish (Costa Rica)', 'currency-switcher-woocommerce' ),
			'es_DO'       => __( 'Spanish (Dominican Republic)', 'currency-switcher-woocommerce' ),
			'es_EC'       => __( 'Spanish (Ecuador)', 'currency-switcher-woocommerce' ),
			'es_SV'       => __( 'Spanish (El Salvador)', 'currency-switcher-woocommerce' ),
			'es_GQ'       => __( 'Spanish (Equatorial Guinea)', 'currency-switcher-woocommerce' ),
			'es_GT'       => __( 'Spanish (Guatemala)', 'currency-switcher-woocommerce' ),
			'es_HN'       => __( 'Spanish (Honduras)', 'currency-switcher-woocommerce' ),
			'es_419'      => __( 'Spanish (Latin America)', 'currency-switcher-woocommerce' ),
			'es_MX'       => __( 'Spanish (Mexico)', 'currency-switcher-woocommerce' ),
			'es_NI'       => __( 'Spanish (Nicaragua)', 'currency-switcher-woocommerce' ),
			'es_PA'       => __( 'Spanish (Panama)', 'currency-switcher-woocommerce' ),
			'es_PY'       => __( 'Spanish (Paraguay)', 'currency-switcher-woocommerce' ),
			'es_PE'       => __( 'Spanish (Peru)', 'currency-switcher-woocommerce' ),
			'es_PR'       => __( 'Spanish (Puerto Rico)', 'currency-switcher-woocommerce' ),
			'es_ES'       => __( 'Spanish (Spain)', 'currency-switcher-woocommerce' ),
			'es_US'       => __( 'Spanish (United States)', 'currency-switcher-woocommerce' ),
			'es_UY'       => __( 'Spanish (Uruguay)', 'currency-switcher-woocommerce' ),
			'es_VE'       => __( 'Spanish (Venezuela)', 'currency-switcher-woocommerce' ),
			'es'          => __( 'Spanish', 'currency-switcher-woocommerce' ),
			'sw_KE'       => __( 'Swahili (Kenya)', 'currency-switcher-woocommerce' ),
			'sw_TZ'       => __( 'Swahili (Tanzania)', 'currency-switcher-woocommerce' ),
			'sw'          => __( 'Swahili', 'currency-switcher-woocommerce' ),
			'sv_FI'       => __( 'Swedish (Finland)', 'currency-switcher-woocommerce' ),
			'sv_SE'       => __( 'Swedish (Sweden)', 'currency-switcher-woocommerce' ),
			'sv'          => __( 'Swedish', 'currency-switcher-woocommerce' ),
			'gsw_CH'      => __( 'Swiss German (Switzerland)', 'currency-switcher-woocommerce' ),
			'gsw'         => __( 'Swiss German', 'currency-switcher-woocommerce' ),
			'shi_Latn'    => __( 'Tachelhit (Latin)', 'currency-switcher-woocommerce' ),
			'shi_Latn_MA' => __( 'Tachelhit (Latin, Morocco)', 'currency-switcher-woocommerce' ),
			'shi_Tfng'    => __( 'Tachelhit (Tifinagh)', 'currency-switcher-woocommerce' ),
			'shi_Tfng_MA' => __( 'Tachelhit (Tifinagh, Morocco)', 'currency-switcher-woocommerce' ),
			'shi'         => __( 'Tachelhit', 'currency-switcher-woocommerce' ),
			'dav_KE'      => __( 'Taita (Kenya)', 'currency-switcher-woocommerce' ),
			'dav'         => __( 'Taita', 'currency-switcher-woocommerce' ),
			'ta_IN'       => __( 'Tamil (India)', 'currency-switcher-woocommerce' ),
			'ta_LK'       => __( 'Tamil (Sri Lanka)', 'currency-switcher-woocommerce' ),
			'ta'          => __( 'Tamil', 'currency-switcher-woocommerce' ),
			'te_IN'       => __( 'Telugu (India)', 'currency-switcher-woocommerce' ),
			'te'          => __( 'Telugu', 'currency-switcher-woocommerce' ),
			'teo_KE'      => __( 'Teso (Kenya)', 'currency-switcher-woocommerce' ),
			'teo_UG'      => __( 'Teso (Uganda)', 'currency-switcher-woocommerce' ),
			'teo'         => __( 'Teso', 'currency-switcher-woocommerce' ),
			'th_TH'       => __( 'Thai (Thailand)', 'currency-switcher-woocommerce' ),
			'th'          => __( 'Thai', 'currency-switcher-woocommerce' ),
			'bo_CN'       => __( 'Tibetan (China)', 'currency-switcher-woocommerce' ),
			'bo_IN'       => __( 'Tibetan (India)', 'currency-switcher-woocommerce' ),
			'bo'          => __( 'Tibetan', 'currency-switcher-woocommerce' ),
			'ti_ER'       => __( 'Tigrinya (Eritrea)', 'currency-switcher-woocommerce' ),
			'ti_ET'       => __( 'Tigrinya (Ethiopia)', 'currency-switcher-woocommerce' ),
			'ti'          => __( 'Tigrinya', 'currency-switcher-woocommerce' ),
			'to_TO'       => __( 'Tonga (Tonga)', 'currency-switcher-woocommerce' ),
			'to'          => __( 'Tonga', 'currency-switcher-woocommerce' ),
			'tr_TR'       => __( 'Turkish (Turkey)', 'currency-switcher-woocommerce' ),
			'tr'          => __( 'Turkish', 'currency-switcher-woocommerce' ),
			'uk_UA'       => __( 'Ukrainian (Ukraine)', 'currency-switcher-woocommerce' ),
			'uk'          => __( 'Ukrainian', 'currency-switcher-woocommerce' ),
			'ur_IN'       => __( 'Urdu (India)', 'currency-switcher-woocommerce' ),
			'ur_PK'       => __( 'Urdu (Pakistan)', 'currency-switcher-woocommerce' ),
			'ur'          => __( 'Urdu', 'currency-switcher-woocommerce' ),
			'uz_Arab'     => __( 'Uzbek (Arabic)', 'currency-switcher-woocommerce' ),
			'uz_Arab_AF'  => __( 'Uzbek (Arabic, Afghanistan)', 'currency-switcher-woocommerce' ),
			'uz_Cyrl'     => __( 'Uzbek (Cyrillic)', 'currency-switcher-woocommerce' ),
			'uz_Cyrl_UZ'  => __( 'Uzbek (Cyrillic, Uzbekistan)', 'currency-switcher-woocommerce' ),
			'uz_Latn'     => __( 'Uzbek (Latin)', 'currency-switcher-woocommerce' ),
			'uz_Latn_UZ'  => __( 'Uzbek (Latin, Uzbekistan)', 'currency-switcher-woocommerce' ),
			'uz'          => __( 'Uzbek', 'currency-switcher-woocommerce' ),
			'vi_VN'       => __( 'Vietnamese (Vietnam)', 'currency-switcher-woocommerce' ),
			'vi'          => __( 'Vietnamese', 'currency-switcher-woocommerce' ),
			'vun_TZ'      => __( 'Vunjo (Tanzania)', 'currency-switcher-woocommerce' ),
			'vun'         => __( 'Vunjo', 'currency-switcher-woocommerce' ),
			'cy_GB'       => __( 'Welsh (United Kingdom)', 'currency-switcher-woocommerce' ),
			'cy'          => __( 'Welsh', 'currency-switcher-woocommerce' ),
			'yo_NG'       => __( 'Yoruba (Nigeria)', 'currency-switcher-woocommerce' ),
			'yo'          => __( 'Yoruba', 'currency-switcher-woocommerce' ),
			'zu_ZA'       => __( 'Zulu (South Africa)', 'currency-switcher-woocommerce' ),
			'zu'          => __( 'Zulu', 'currency-switcher-woocommerce' ),
		);
	}
}
