<?php
$nonce=!empty($_REQUEST['sp_nonce'])?filter_var($_REQUEST['sp_nonce']): null;
if ($nonce) {

	if ( ! wp_verify_nonce( $nonce, 'sp_nonce' ) ) {
		die( esc_html__( 'Security check', 'textdomain' ) ); 
	}
	if (!empty($_POST)) {
		update_option('sp.backorder', isset($_POST['backorder']) ? 'enable' : '');
	}
}
require_once __DIR__ . '/admin_page_header.php';
require_once __DIR__ . '/../header.php';
?>
<div class="sp-admin-overlay">
	<div class="sp-admin-container">
		<?php require __DIR__ . '/../left_sidebar.php'; ?>
		<!-- main-content opened -->
		<div class="main-content horizontal-content">
			<div class="page">
				<?php require __DIR__ . '/../page_header.php'; ?>
				<!-- container opened -->
				<div class="ml-40 mr-40">
					<?php require SP_PLUGIN_DIR_PATH . 'pages/header_js.php'; ?>
					<style>
						.sp-settings-form p {
							margin-top: 3%;
							font-size: inherit;
						}

						.sphd-p {
							font-size: 16px;
						}
					</style>
					<h2 class="purchase-or-title"><?php echo esc_html(__('Backorder', 'inventory-management-woocommerce')); ?></h2>
					<span class='purchase-or-subtitle'><?php echo esc_html(__('Enable buy products if they not in stock', 'inventory-management-woocommerce')); ?></span>
					<div class="d-flex nav-link-line" style="margin-top: 40px;">
						<a class="nav-link-page <?php echo esc_attr('shelf_planner_settings_store' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_settings_store')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Store Settings', 'inventory-management-woocommerce')); ?></span></a>
						<a class="nav-link-page <?php echo esc_attr('shelf_planner_settings_forecast' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_settings_forecast')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Forecast Settings', 'inventory-management-woocommerce')); ?></span></a>
						<a class="nav-link-page <?php echo esc_attr('shelf_planner_settings_product' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_settings_product')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Product Settings', 'inventory-management-woocommerce')); ?></span></a>
						<a class="nav-link-page <?php echo esc_attr('shelf_planner_settings_po' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_settings_po')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('PO Settings', 'inventory-management-woocommerce')); ?></span></a>
						<a class="nav-link-page <?php echo esc_attr('shelf_planner_backorder' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_backorder')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Backorder', 'inventory-management-woocommerce')); ?></span></a>
					</div>
					<?php do_action('after_page_header'); ?>
					<?php 
					if (display_admin_part() == true) {
require SP_PLUGIN_DIR_PATH . 'pages/settings/tabs.php';} 
					?>
					<div>
						<div class="mt-30" style="margin-top: 50px">
							<form method="post">
							<input type="hidden" name="sp_nonce" value="<?php echo  esc_html(wp_create_nonce('sp_nonce')); ?>">
								<h4 style="margin-bottom: 1em"><?php echo esc_html(__('Allow Back Order Splitting', 'inventory-management-woocommerce')); ?></h4>
								<p style='display:inline-block;width:400px;'>Splitting of back orders allows you to partially fulfil backorders.<br>For partially fulfilled orders, a 'child' backorder is created.
					</p>
								<p style="display:inline-block;width:100px;"><label class="switch"><input type="checkbox" id="id-backorder" name="backorder" <?php echo esc_attr(( get_option('sp.backorder', false) ? 'checked' : '' )); ?>><span class="slider round"></span></label> </p>
								<p class="mg-b-20"></p>
								<input style="margin-top: 2em" type="submit" class="button-settings-po" value="<?php echo esc_attr(__('Save Settings', 'inventory-management-woocommerce')); ?>" name="save-store-settings" />
							</form>
						</div>
					</div>
				</div>
				<?php require __DIR__ . '/../popups.php'; ?>
			</div>
		</div>
	</div>
</div>
