<?php

require_once __DIR__ . '/admin_page_header.php';
require_once __DIR__ . '/../header.php';

// it allows us to use wp_handle_upload() function
if (!function_exists('wp_generate_attachment_metadata')) {
  require_once ABSPATH . 'wp-admin/includes/image.php';
  require_once ABSPATH . 'wp-admin/includes/file.php';
  require_once ABSPATH . 'wp-admin/includes/media.php';
}

if (isset($_FILES['sp_avatar_account'])) {
  $upload = wp_handle_upload(
	$_FILES['sp_avatar_account'],
	array('test_form' => false)
  );

  $_POST['sp_avatar_account'] = $upload['url'];
}

$nonce =!empty($_REQUEST['sp_nonce'])?filter_var($_REQUEST['sp_nonce']): null;
if ($nonce) {

	if ( ! wp_verify_nonce( $nonce, 'sp_nonce' ) ) {
		die( esc_html__( 'Security check', 'textdomain' ) ); 
	}
	if (isset($_POST)) {
	$my_account_settings = get_option('sp_my_account_settings') ? array_merge(unserialize(get_option('sp_my_account_settings')), $_POST) : $_POST;
	update_option('sp_my_account_settings', serialize($my_account_settings));
	}
}

$my_account_settings = unserialize(get_option('sp_my_account_settings'));

?>
<style>
  .wp-core-ui select {
	width: 22%;
	max-width: unset;
	border: 1px solid #DEDEDF;
	color: #B5B5B5;
	font-size: 14px;
	line-height: 17px;
	font-weight: 500;
	height: 38px;
  }

  .wp-core-ui select:focus,
  .wp-core-ui select:active,
  .wp-core-ui select:hover {
	outline: none;
	border-color: #DEDEDF;
	box-shadow: none;
	color: #B5B5B5;
  }

  input.form-control {
	width: 22%;
  }

  input.form-control:focus {
	border-color: #DEDEDF !important;
  }

  label {
	opacity: 0.9;
  }

  .small-form-control {
	width: 18% !important;
  }

  .image-upload img {
	width: 100px;
	height: 100px;
  }
</style>
<div class="sp-admin-overlay">
  <div class="sp-admin-container">
	<?php require __DIR__ . '/../left_sidebar.php'; ?>
	<!-- main-content opened -->
	<div class="main-content horizontal-content">
	  <div class="page">
		<?php require __DIR__ . '/../page_header.php'; ?>

		<!-- container opened -->
		<div class="ml-40 mr-40">
		  <?php require SP_PLUGIN_DIR_PATH . 'pages/header_js.php'; ?>
		  <h2 class="purchase-or-title"><?php echo esc_html(__('Welcome to your account,', 'inventory-management-woocommerce')); ?> <?php 
			if (isset($my_account_settings['first_name'])) {
																													echo esc_html($my_account_settings['first_name']);
			} 
			?>
																												  </h2>
		  <div class="d-flex nav-link-line" style="margin-top: 40px;">
			<a class="nav-link-page <?php echo esc_attr('shelf_planner_my_account' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_my_account')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Overview', 'inventory-management-woocommerce')); ?></span></a>
			<a class="nav-link-page <?php echo esc_attr('shelf_planner_plans_payments' == sanitize_text_field(empty($_GET['page']) ? '' : $_GET['page']) ? 'active nav-link-page_active' : ''); ?>" href="<?php echo esc_url(admin_url('admin.php?page=shelf_planner_plans_payments')); ?>"><span class="side-menu__label"> <?php echo esc_html(__('Plans & Payment', 'inventory-management-woocommerce')); ?></span></a>
		  </div>
		  <?php do_action('after_page_header'); ?>
		  <?php 
			if (display_admin_part() == true) {
require SP_PLUGIN_DIR_PATH . 'pages/settings/tabs.php';} 
			?>
		  <div style="position: relative;">
			<div class="mt-30" style="margin-top: 50px">
			  <form method="post" enctype="multipart/form-data">
			  <input type="hidden" name="sp_nonce" value="<?php echo  esc_html(wp_create_nonce('sp_nonce')); ?>">
				<div class="image-upload">
				  <label for="file-input">
					<img class="circle-gal" src="
					<?php 
					if (isset($my_account_settings['sp_avatar_account'])) {
													echo esc_url($my_account_settings['sp_avatar_account']);
					} else {
					   echo esc_url(plugin_dir_url(__FILE__)) . '../assets/img/circle-gal.png';
					} 
					?>
												  ">
				  </label>
				  <input id="file-input" name="sp_avatar_account" type="file" />
				</div>
				<h4 class="purchase-or-title" style="margin-bottom: 1em; margin-top: 40px;"><?php echo esc_html(__('Your Account', 'inventory-management-woocommerce')); ?></h4>
				<div class="mb-2">
					<?php sp_get_inputtextfield('first_name', true, ( isset($my_account_settings['first_name']) )?$my_account_settings['first_name']:'', 'First Name', true); ?>
				</div>
				<div class="mb-3">
					<?php sp_get_inputtextfield('last_name', true, ( isset($my_account_settings['last_name']) )?$my_account_settings['last_name']:'', 'Last Name', true); ?>
				</div>
				<div class="mb-3">
					<?php sp_get_inputtextfield('email_address', true, ( isset($my_account_settings['email_address']) )?$my_account_settings['email_address']:'', 'Primary Email Address (Shelf Planner ID)', true); ?>
				</div>
				<div class="mb-3">
					<?php sp_get_inputtextfield('secondary_email', true, ( isset($my_account_settings['secondary_email']) )?$my_account_settings['secondary_email']:'', 'Secondary Email Address', true); ?>
				</div>
				<div>
				  <h2 class="purchase-or-title mb-40">
					Company Information
				  </h2>
				  <div class="mb-3">
					<?php sp_get_inputtextfield('company_name', true, ( isset($my_account_settings['company_name']) )?$my_account_settings['company_name']:'', 'Company Name', true); ?>
				  </div>
				  <div class="d-flex flex-column">
					<label><?php echo esc_html(__('Country', 'inventory-management-woocommerce')); ?></label>
					<select name="sp_countries_list">
					  <option value="XX">Select Country</option>
					  <?php
					  global $sp_countries_normilized;
						?>
					  <?php foreach ($sp_countries_normilized as $country_code => $country_name) { ?>
						<option value="<?php echo esc_attr($country_code); ?>" 
												  <?php 
													if (isset($my_account_settings['sp_countries_list']) && $my_account_settings['sp_countries_list'] == $country_code) {
																				  echo esc_attr('selected');
													} 
													?>
																				><?php echo esc_html($country_name); ?></option>
					  <?php } ?>
					</select>
				  </div>
				</div>
				<input type="submit" style="width: 78px; height: 38px;" class="new-des-btn mt-40" value="Save" />
			  </form>
			</div>
		  </div>
		</div>
	  </div>
	  <?php require __DIR__ . '/../popups.php'; ?>
	</div>
  </div>
</div>
