<?php

if ( ! class_exists( 'ITSEC_Malware_Scheduling_Setup' ) ) {
	class ITSEC_Malware_Scheduling_Setup {
		public function __construct() {

			add_action( 'itsec_modules_do_plugin_activation',   array( $this, 'execute_activate'   )          );
			add_action( 'itsec_modules_do_plugin_deactivation', array( $this, 'execute_deactivate' )          );
			add_action( 'itsec_modules_do_plugin_uninstall',    array( $this, 'execute_uninstall'  )          );
			add_action( 'itsec_modules_do_plugin_upgrade',      array( $this, 'execute_upgrade'    ), null, 2 );

		}

		/**
		 * Execute module activation.
		 *
		 * @since 4.0
		 *
		 * @return void
		 */
		public function execute_activate() {
		}

		/**
		 * Execute module deactivation
		 *
		 * @return void
		 */
		public function execute_deactivate() {
			global $wpdb;

			$wpdb->query( "DELETE FROM `" . $wpdb->base_prefix . "options` WHERE `option_name` LIKE ('%itsec_malware_scheduling_last_scans%')" );
		}

		/**
		 * Execute module uninstall
		 *
		 * @return void
		 */
		public function execute_uninstall() {
			$this->execute_deactivate();

			delete_site_option( 'itsec_malware_scheduling' );
			delete_site_option( 'itsec_malware_scheduling_report_queue' );
		}

		/**
		 * Execute module upgrade
		 *
		 * @return void
		 */
		public function execute_upgrade( $itsec_old_version ) {
			if ( $itsec_old_version < 4041 ) {
				$current_options = get_site_option( 'itsec_malware_scheduling' );

				// If there are no current options, go with the new defaults by not saving anything
				if ( is_array( $current_options ) ) {
					// Make sure the new module is properly activated or deactivated
					if ( $current_options['enabled'] ) {
						ITSEC_Modules::activate( 'malware-scheduling' );
					} else {
						ITSEC_Modules::deactivate( 'malware-scheduling' );
					}

					$defaults = ITSEC_Modules::get_defaults( 'malware-scheduling' );
					$options = $defaults;

					foreach ( $defaults as $name => $value ) {
						if ( isset( $current_options[$name] ) ) {
							$options[$name] = $current_options[$name];
						}
					}

					// Module needs to be loaded to save, in order to handle adjusting schedule
					if ( ! class_exists( 'ITSEC_Malware_Scheduling' ) ) {
						require_once( 'class-itsec-malware-scheduling.php' );
					}

					ITSEC_Modules::set_settings( 'malware-scheduling', $options );

					delete_site_option( 'itsec_malware_scheduling_report_queue' );
					delete_site_option( 'itsec_malware_scheduling_last_scan' );
				}
			}
		}
	}
}

new ITSEC_Malware_Scheduling_Setup();
