---
to: includes/cpt/<%=name%>.php
unless_exists: true
---
<% Names = h.inflection.pluralize(Name).replace('-', ' ') -%>
<% Name = h.inflection.humanize(Name).replace('-', ' ') -%>
<% _name = name.replace('-', '_') -%>
<% _textdomain = h.textdomain.replace('-', '_') -%>
<?php

// Register '<%=name%>' post type
add_action( 'init', '<%=_textdomain%>_<%=_name%>_register_post_type' );
function <%=_textdomain%>_<%=_name%>_register_post_type() {
	register_post_type( '<%=name%>', array(
		'labels'                => array(
			'name'                     => __( "<%=Names%>", '<%=h.textdomain%>' ),
			'menu_name'                => __( "<%=Names%>", '<%=h.textdomain%>' ),
			'singular_name'            => __( "<%=Name%>", '<%=h.textdomain%>' ),
			'add_new'                  => __( "Add New", '<%=h.textdomain%>' ),
			'add_new_item'             => __( "Add New <%=Name%>", '<%=h.textdomain%>' ),
			'new_item'                 => __( "New <%=Name%>", '<%=h.textdomain%>' ),
			'edit_item'                => __( "Edit <%=Name%>", '<%=h.textdomain%>' ),
			'view_item'                => __( "View <%=Name%>", '<%=h.textdomain%>' ),
			'view_items'               => __( "View <%=Names%>", '<%=h.textdomain%>' ),
			'search_items'             => __( "Search <%=Names%>", '<%=h.textdomain%>' ),
			'not_found'                => __( "No <%=Names%> found", '<%=h.textdomain%>' ),
			'not_found_in_trash'       => __( "No <%=Names%> found in trash", '<%=h.textdomain%>' ),
			'parent_item_colon'        => __( "Parent <%=Name%>:", '<%=h.textdomain%>' ),
			'all_items'                => __( "All <%=Names%>", '<%=h.textdomain%>' ),
			'archives'                 => __( "<%=Name%> Archives", '<%=h.textdomain%>' ),
			'attributes'               => __( "<%=Name%> Attributes", '<%=h.textdomain%>' ),
			'insert_into_item'         => __( "Insert into <%=Name%>", '<%=h.textdomain%>' ),
			'uploaded_to_this_item'    => __( "Uploaded to this <%=Name%>", '<%=h.textdomain%>' ),
			'featured_image'           => __( "Featured Image", '<%=h.textdomain%>' ),
			'set_featured_image'       => __( "Set featured image", '<%=h.textdomain%>' ),
			'remove_featured_image'    => __( "Remove featured image", '<%=h.textdomain%>' ),
			'use_featured_image'       => __( "Use as featured image", '<%=h.textdomain%>' ),
			'filter_items_list'        => __( "Filter <%=Names%> list", '<%=h.textdomain%>' ),
			'items_list_navigation'    => __( "<%=Names%> list navigation", '<%=h.textdomain%>' ),
			'items_list'               => __( "<%=Names%> list", '<%=h.textdomain%>' ),
			'item_published'           => __( "<%=Name%> published.", '<%=h.textdomain%>' ),
			'item_published_privately' => __( "<%=Name%> published privately.", '<%=h.textdomain%>' ),
			'item_reverted_to_draft'   => __( "<%=Name%> reverted to draft.", '<%=h.textdomain%>' ),
			'item_scheduled'           => __( "<%=Name%> scheduled.", '<%=h.textdomain%>' ),
			'item_updated'             => __( "<%=Name%> updated.", '<%=h.textdomain%>' ),
		),
		'public'                => <%= args.includes('public') ? 'true' : 'false' %>,
		'hierarchical'          => <%= args.includes('hierarchical') ? 'true' : 'false' %>,
		'show_ui'               => <%= args.includes('show_ui') ? 'true' : 'false' %>,
		'show_in_nav_menus'     => <%= args.includes('show_in_nav_menus') ? 'true' : 'false' %>,
		'supports'              => array(<%-supports%> ),
		'has_archive'           => <%= args.includes('has_archive') ? 'true' : 'false' %>,
		'rewrite'               => true,
		'query_var'             => true,
		'menu_icon'             => 'dashicons-<%=dashicon%>',
		'show_in_rest'          => true,
		'rest_base'             => '<%=name%>',
		'rest_controller_class' => 'WP_REST_Posts_Controller',
	) );
}

// Custom '<%=name%>' post updated messages
add_filter( 'post_updated_messages', '<%=_textdomain%>_<%=_name%>_post_updated_messages' );
function <%=_textdomain%>_<%=_name%>_post_updated_messages( $messages ) {
	global $post;
	$permalink                = get_permalink( $post );
	$preview_post_link_html   = sprintf( ' <a target="_blank" href="%1$s">%2$s</a>', esc_url( get_preview_post_link( $post ) ), __( "Preview <%=Name%>", '<%=h.textdomain%>' ) );
	$scheduled_post_link_html = sprintf( ' <a target="_blank" href="%1$s">%2$s</a>', esc_url( $permalink ), __( "Preview <%=Name%>", '<%=h.textdomain%>' ) );
	$scheduled_date           = date_i18n( __( "M j, Y @ H:i", '<%=h.textdomain%>' ), strtotime( $post->post_date ) );
	$view_post_link_html      = sprintf( ' <a href="%1$s">%2$s</a>', esc_url( $permalink ), __( "View <%=Name%>", '<%=h.textdomain%>' ) );
	$messages['<%=name%>']    = array(
		0  => '',
		1  => __( "<%=Name%> updated.", '<%=h.textdomain%>' ) . $view_post_link_html,
		2  => __( "Custom field updated.", '<%=h.textdomain%>' ),
		3  => __( "Custom field deleted.", '<%=h.textdomain%>' ),
		4  => __( "<%=Name%> updated.", '<%=h.textdomain%>' ),
		5  => isset( $_GET['revision'] ) ? sprintf( __( "<%=Name%> restored to revision from %s", '<%=h.textdomain%>' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6  => __( "<%=Name%> published.", '<%=h.textdomain%>' ) . $view_post_link_html,
		7  => __( "<%=Name%> saved.", '<%=h.textdomain%>' ),
		8  => __( "<%=Name%> submitted.", '<%=h.textdomain%>' ) . $preview_post_link_html,
		9  => sprintf( __( '<%=Name%> scheduled for: %s.' ), '<strong>' . $scheduled_date . '</strong>' ) . $scheduled_post_link_html,
		10 => __( '<%=Name%> draft updated.' ) . $preview_post_link_html,
	);

	return $messages;
}
