<?php

// Setup Kaliroots
add_action( 'after_setup_theme', 'kaliroots_after_setup_theme' );
function kaliroots_after_setup_theme() {
	// Load textdomain
	load_theme_textdomain( 'kaliroots', get_template_directory() . '/languages' );

	// Set PHP locale
	setlocale( LC_COLLATE, 'fr_CA.UTF-8' );
}

// Remove admin bar logo
add_action( 'wp_before_admin_bar_render', 'kaliroots_remove_adminbar_logo' );
function kaliroots_remove_adminbar_logo() {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu( 'wp-logo' );
}

// Remove admin footer text
add_filter( 'admin_footer_text', '__return_false' );

// Remove unnecessary code from wp_head()
function kaliroots_disable_feeds() {
	// Redirects all feeds to home page.
	$url = site_url();
	wp_redirect( $url );
}

// Disables feeds.
add_action( 'do_feed', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rdf', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rss', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rss2', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_atom', 'kaliroots_disable_feeds', 1 );

// Disables comments feeds.
add_action( 'do_feed_rss2_comments', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_atom_comments', 'dkaliroots_disable_feeds', 1 );

remove_action( 'wp_head', 'wp_generator' );                           // Removes WordPress version.
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10 );               // Removes shortlink.
remove_action( 'wp_head', 'rsd_link' );                               // Removes Really Simple Discovery link.
remove_action( 'wp_head', 'feed_links', 2 );                          // Removes RSS feed links.
remove_action( 'wp_head', 'feed_links_extra', 3 );                    // Removes all extra RSS feed links.
remove_action( 'wp_head', 'wlwmanifest_link' );                       // Removes wlwmanifest.xml.
remove_action( 'wp_head', 'wp_resource_hints', 2 );                   // Removes meta rel=dns-prefetch href=//s.w.org
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10 );    // Removes relational links for the posts.

// Removes Emoji icons.
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );

// Removes oEmbeds.
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
