<?php

// Load generic template
function kaliroots_generic_template( $template_path ) {
	if ( empty( $template = kaliroots_locate_template( $template_path ) ) ) {
		return '';
	}
	ob_start();
	load_template( $template, false );

	return ob_get_clean();
}

// Load HTML template
function kaliroots_html_template( $template_name ) {
	return kaliroots_generic_template( "templates/html/${template_name}-{base}" );
}

// Load site template
function kaliroots_site_template( $template_name ) {
	return kaliroots_generic_template( "templates/site/${template_name}-{base}" );
}

// Load content template
function kaliroots_content_template( $template_name ) {
	return kaliroots_generic_template( "templates/content/${template_name}-{base}" );
}

// Load loop template
function kaliroots_loop_template( $template_name ) {
	return kaliroots_generic_template( "templates/content/loops/${template_name}-{post_type}" );
}

// Load shortcode template
function kaliroots_shortcode_template( $template_name ) {
	return kaliroots_generic_template( "templates/shortcodes/${template_name}" );
}

// Load widget template
function kaliroots_widget_template( $template_name ) {
	return kaliroots_generic_template( "templates/widgets/${template_name}" );
}

// Responsive image
function kaliroots_responsive_image( $image_id = null, $args = array() ) {
	if ( empty( $image_id ) && empty( $image_id = get_post_thumbnail_id() ) ) {
		return '';
	}
	$args = wp_parse_args( $args, array(
		'class' => '',
		'size'  => '2048x2048'
	) );
	ob_start();
	?>
	<img class="<?= esc_attr( $args['class'] ) ?>"
	     src="<?= esc_attr( wp_get_attachment_image_url( $image_id, $args['size'] ) ) ?>"
	     srcset="<?= esc_attr( wp_get_attachment_image_srcset( $image_id ) ) ?>"
	     sizes="<?= esc_attr( wp_get_attachment_image_sizes( $image_id, $args['size'] ) ) ?>"
	     alt="<?= esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) ?>">
	<?php
	return ob_get_clean();
}

// Pagination links
function kaliroots_pagination_links( $args = array() ) {
	global $wp_query;
	$current = get_query_var( 'paged' ) > 1 ? get_query_var( 'paged' ) : 1;
	$url     = explode( '?', get_pagenum_link( 999999999, false ) );
	$args    = wp_parse_args( $args, array(
		'base'       => esc_url_raw( str_replace( 999999999, '%#%', $url[0] ) ),
		'format'     => '',
		'total'      => $wp_query->max_num_pages,
		'current'    => $current,
		'show_all'   => false,
		'type'       => 'array',
		'prev_text'  => '«',
		'next_text'  => '»',
		'link_class' => '',

	) );
	if ( ! is_array( $links = paginate_links( $args ) ) ) {
		return array();
	}

	return array_map( function ( $link ) use ( $args ) {
		return str_replace( 'page-numbers', $args['link_class'], $link );
	}, $links );
}
