<?php

// Replace partial meta_key in posts WHERE clause
add_filter( 'posts_where', 'kaliroots_posts_where_meta_key_like', 10, 2 );
function kaliroots_posts_where_meta_key_like( $where, WP_Query $query ) {
	global $wpdb;
	if ( ! $query->get( 'meta_key_like' ) ) {
		return $where;
	}
	$where = preg_replace( "/(meta_key)\s=\s(\'.*?[%].*?\')/i", '${1} LIKE ${2}', $wpdb->remove_placeholder_escape( $where ) );

	return $where;
}

// Replace partial meta_key in users WHERE clause
add_filter( 'pre_user_query', 'kaliroots_pre_user_query_meta_key_like', 10, 2 );
function kaliroots_pre_user_query_meta_key_like( WP_User_Query $query ) {
	global $wpdb;
	if ( ! $query->get( 'meta_key_like' ) ) {
		return $query;
	}
	$query->query_where = str_replace( 'meta_key =', 'meta_key LIKE', $wpdb->remove_placeholder_escape( $query->query_where ) );

	return $query;
}
