<?php

/**
 * Get navigation menu items hierarchy
 *
 * @param $menu_location
 *
 * @return array
 */
function kaliroots_get_nav_menu_items( $menu_location ) {
	$locations = get_nav_menu_locations();
	$items     = array();

	if ( ! isset( $locations[ $menu_location ] ) || empty( $menu = wp_get_nav_menu_object( $locations[ $menu_location ] ) ) ) {
		return $items;
	}
	if ( empty( $nav_items = wp_get_nav_menu_items( $menu ) ) ) {
		return $items;
	}

	foreach ( $nav_items as $nav_item ) {
		if ( $current = isset( $nav_item->object_id ) ? $nav_item->object_id == get_queried_object_id() : false ) {
			$nav_item->classes[] = 'current';
		}
		$items[] = array(
			'id'          => $nav_item->ID,
			'title'       => $nav_item->title,
			'description' => $nav_item->description,
			'url'         => $nav_item->url,
			'parent_id'   => $nav_item->menu_item_parent,
			'current'     => $current,
			'class'       => implode( ' ', $nav_item->classes ),
			'children'    => array(),
		);
	}

	return buildHierarchy( $items );
}

function buildHierarchy( array &$items, $parent_id = 0 ) {
	$branch = array();
	foreach ( $items as &$item ) {
		if ( $item['parent_id'] == $parent_id ) {
			$children = buildHierarchy( $items, $item['id'] );
			if ( $children ) {
				$item['children'] = $children;
				if ( ! empty( array_filter( array_column( $children, 'current' ) ) ) ) {
					$item['current'] = true;
				}
			}
			$branch[] = $item;
			unset( $item );
		}
	}

	return $branch;
}