<?php

// Wrap base templates in HTML / site templates using template_include filter
add_filter( 'template_include', 'kaliroots_wrap_base_template', 100 );
function kaliroots_wrap_base_template( $template_path ) {
	return kaliroots_locate_template( 'templates/html/wrap-{base}' );
}

// Locate the highest priority template file from $template_path
function kaliroots_locate_template( $template_path ) {
	$templates = array_map( function ( $template ) {
		return $template . '.php';
	}, apply_filters( 'kaliroots_locate_templates', array( $template_path ) ) );

	return locate_template( array_unique( $templates ) );
}

// Replace {base} placeholder in $templates
add_filter( 'kaliroots_locate_templates', 'kaliroots_replace_base_placeholder', 10 );
function kaliroots_replace_base_placeholder( $templates ) {
	$replaced = array();
	foreach ( $templates as $i => $template ) {
		if ( strpos( $template, '{base}' ) !== false ) {
			foreach ( kaliroots_base_placeholders() as $base ) {
				$replaced[] = trim( preg_replace( '/{base}/', $base, $template ), '-' );
			}
			if ( $template === '{base}' ) {
				$replaced[] = 'index';
			} else {
				$replaced[] = trim( preg_replace( '/{base}-?/', '', $template ), '-' );
			}
		} else {
			$replaced[] = $template;
		}
	}

	return $replaced;
}

// Replace {post_type} placeholder in $templates
add_filter( 'kaliroots_locate_templates', 'kaliroots_replace_post_type_placeholder', 20 );
function kaliroots_replace_post_type_placeholder( $templates ) {
	$replaced = array();
	foreach ( $templates as $i => $template ) {
		if ( strpos( $template, '{post_type}' ) !== false ) {
			if ( $post_type = get_post_type() ) {
				$replaced[] = trim( preg_replace( '/{post_type}/', $post_type, $template ), '-' );
			}
			$replaced[] = trim( preg_replace( '/{post_type}-?/', '', $template ), '-' );
		} else {
			$replaced[] = $template;
		}
	}

	return $replaced;
}

// Determine possible values for {base} placeholder by priority
function kaliroots_base_placeholders() {
	$post_types = array_filter( (array) get_query_var( 'post_type' ) );
	$post_type  = count( $post_types ) === 1 ? reset( $post_types ) : false;

	$templates = [];

	if ( is_embed() ) {
		if ( $post_type ) {
			$templates[] = "embed-{$post_type}";
		}
		$templates[] = "embed";

		return $templates;
	} elseif ( is_search() ) {
		$templates[] = "search";

		return $templates;
	} elseif ( is_404() ) {
		$templates[] = "404";

		return $templates;
	} elseif ( is_front_page() ) {
		// "Page on front" or "Latest posts"
		$templates[] = "front-page";
	}
	if ( is_home() ) {
		// "Latest posts" or "Posts page"
		$templates[] = "home";
	}
	if ( is_singular() ) {
		$id       = get_queried_object_id();
		$template = basename( get_page_template_slug(), '.php' );
		$object   = get_queried_object();
		if ( is_page() ) {
			$pagename = get_query_var( 'pagename' );
			if ( ! $pagename && $id ) {
				if ( $object ) {
					$pagename = $object->post_name;
				}
			}
			if ( $template && 0 === validate_file( $template ) ) {
				$templates[] = $template;
			}
			if ( $pagename ) {
				$pagename_decoded = urldecode( $pagename );
				if ( $pagename_decoded !== $pagename ) {
					$templates[] = "page-{$pagename_decoded}";
				}
				$templates[] = "page-{$pagename}";
			}
			if ( $id ) {
				$templates[] = "page-{$id}";
			}
			$templates[] = "page";
		} else {
			// is_single()
			if ( is_attachment() ) {
				if ( $object ) {
					if ( false !== strpos( $object->post_mime_type, '/' ) ) {
						list( $type, $subtype ) = explode( '/', $object->post_mime_type );
					} else {
						list( $type, $subtype ) = array( $object->post_mime_type, '' );
					}
					if ( ! empty( $subtype ) ) {
						$templates[] = "{$type}-{$subtype}";
						$templates[] = "{$subtype}";
					}
					$templates[] = "{$type}";
				}
				$templates[] = "attachment";
			} elseif ( ! empty( $object->post_type ) ) {
				if ( $template && 0 === validate_file( $template ) ) {
					$templates[] = $template;
				}
				$name_decoded = urldecode( $object->post_name );
				if ( $name_decoded !== $object->post_name ) {
					$templates[] = "single-{$object->post_type}-{$name_decoded}";
				}
				$templates[] = "single-{$object->post_type}-{$object->post_name}";
				$templates[] = "single-{$object->post_type}";
			}
			$templates[] = "single";
		}
		$templates[] = "singular";
	} elseif ( is_archive() ) {
		if ( function_exists( 'is_shop' ) && is_shop() ) {
			$templates[] = 'archive-product';
		}
		if ( is_author() ) {
			$author = get_queried_object();
			if ( $author instanceof WP_User ) {
				$templates[] = "author-{$author->user_nicename}";
				$templates[] = "author-{$author->ID}";
			}
			$templates[] = 'author';
		} elseif ( is_date() ) {
			$template[] = "date";
		} elseif ( is_category() ) {
			$category = get_queried_object();
			if ( ! empty( $category->slug ) ) {
				$slug_decoded = urldecode( $category->slug );
				if ( $slug_decoded !== $category->slug ) {
					$templates[] = "category-{$slug_decoded}";
				}
				$templates[] = "category-{$category->slug}";
				$templates[] = "category-{$category->term_id}";
			}
			$templates[] = 'category';
		} elseif ( is_tag() ) {
			$tag = get_queried_object();
			if ( ! empty( $tag->slug ) ) {
				$slug_decoded = urldecode( $tag->slug );
				if ( $slug_decoded !== $tag->slug ) {
					$templates[] = "tag-{$slug_decoded}";
				}
				$templates[] = "tag-{$tag->slug}";
				$templates[] = "tag-{$tag->term_id}";
			}
			$templates[] = 'tag';
		} elseif ( is_tax() ) {
			$term = get_queried_object();
			if ( ! empty( $term->slug ) ) {
				$taxonomy     = $term->taxonomy;
				$slug_decoded = urldecode( $term->slug );
				if ( $slug_decoded !== $term->slug ) {
					$templates[] = "taxonomy-$taxonomy-{$slug_decoded}";
				}
				$templates[] = "taxonomy-$taxonomy-{$term->slug}";
				$templates[] = "taxonomy-$taxonomy";
			}
			$templates[] = 'taxonomy';
		}
		if ( $post_type ) {
			$templates[] = "archive-{$post_type}";
		}
		$templates[] = "archive";
	}

	return $templates;
}
