<?php

const PURGECSS_WHITELIST_PATH = 'includes/vendor/purgecss-whitelist.php';

// Generate PurgeCSS whitelist automatically from post_content
add_action( 'save_post', 'kaliroots_purgecss_whitelist_save_post', 10, 3 );
function kaliroots_purgecss_whitelist_save_post( $post_id, $post, $update ) {
	$whitelist = kaliroots_load_purgecss_whitelist();

	// Nav menu item
	if ( $post->post_type === 'nav_menu_item' && ! empty( $_POST['menu-item-classes'][ $post->ID ] ) ) {
		$whitelist = array_merge( $whitelist, explode( ' ', $_POST['menu-item-classes'][ $post->ID ] ) );
	}

	// Post content
	if ( preg_match_all( '/class=\"(.*?)\"/', $post->post_content, $matches ) > 0 ) {
		foreach ( $matches[1] as $match ) {
			$whitelist = array_merge( $whitelist, explode( ' ', $match ) );
		}
	}

	// Update whitelist
	$whitelist = array_map( function ( $class ) {
		return str_replace( array( '`{`', '`}`' ), array( '[', ']' ), $class );
	}, array_unique( $whitelist ) );
	sort( $whitelist );
	kaliroots_save_purgecss_whitelist( $whitelist );
}

// Helper: Load PurgeCSS whitelist
function kaliroots_load_purgecss_whitelist() {
	$whitelist      = array();
	$whitelist_path = get_theme_file_path( PURGECSS_WHITELIST_PATH );
	if ( ! file_exists( $whitelist_path ) ) {
		return $whitelist;
	}

	if ( preg_match( '/\/\*(.*)\*\//', file_get_contents( $whitelist_path ), $matches ) > 0 ) {
		$whitelist = explode( ' ', $matches[1] );
	}

	return array_filter( $whitelist );
}

// Helper: Save PurgeCSS whitelist
function kaliroots_save_purgecss_whitelist( $whitelist ) {
	$whitelist_path = get_theme_file_path( PURGECSS_WHITELIST_PATH );
	touch( $whitelist_path );
	$content = "<?php\n" . '/* ' . implode( ' ', $whitelist ) . ' */';
	file_put_contents( $whitelist_path, $content );
}

// Allow ':', '[' and ']' characters in HTML class attribute
add_filter( 'sanitize_html_class', 'kaliroots_sanitize_html_class', 10, 3 );
function kaliroots_sanitize_html_class( $sanitized, $class, $fallback ) {
	if ( $sanitized !== $class ) {
		$sanitized = preg_replace( '/[^A-Za-z0-9:\[\]_-]/', '', $class );
	}

	return $sanitized;
}
