<?php

// Helper: Create or update taxonomy term
function kaliroots_upsert_term( $args = array() ) {
	if ( ! taxonomy_exists( $args['taxonomy'] ?: '' ) ) {
		return false;
	}
	$term = get_term_by( 'slug', $args['slug'] ?: '', $args['taxonomy'] );
	if ( $term ) {
		$result = wp_update_term( $term->term_id, $args['taxonomy'], wp_parse_args( $args, (array) $term ) );
	} else {
		$result = wp_insert_term( $args['name'], $args['taxonomy'], $args );
	}
	if ( is_wp_error( $result ) ) {
		return false;
	}

	return get_term_by( 'id', $result['term_id'] );
}
