module.exports = {
  prompt: async ({ inquirer }) => {
    const answers = await inquirer.prompt([
      {
        type: 'input',
        name: 'name',
        message: 'Existing shortcode slug',
        validate: (name) => {
          return /^[a-z\-]+$/.test(name) || 'Only lowercase characters and dashes are allowed';
        },
      },
    ]);

    let keepGoing = true;
    let fields = [];
    while (keepGoing) {
      const field = await inquirer.prompt([
        {
          type: 'input',
          name: 'param_name',
          message: 'Field name',
        },
        {
          type: 'input',
          name: 'heading',
          message: 'Field title',
        },
        {
          type: 'input',
          name: 'description',
          message: 'Field description',
        },
        {
          type: 'select',
          name: 'type',
          message: 'Field type',
          choices: [
            'textfield',
            'textarea',
            'dropdown',
            'checkbox',
            'attach_image',
            'attach_images',
            'vc_link',
          ],
        },
        {
          type: 'confirm',
          name: 'addAnotherField',
          message: 'Add another field ?',
        },
      ]);

      keepGoing = field.addAnotherField;
      delete field.addAnotherField;

      fields.push(field);
    }

    return { ...answers, fields };
  },
};
