---
to: includes/shortcodes/<%=name%>.php
unless_exists: true
---
<% Name = h.inflection.humanize(Name).replace('-', ' ') -%>
<% _name = name.replace('-', '_') -%>
<% _textdomain = h.textdomain.replace('-', '_') -%>
<?php

// Register '<%=_name%>' shortcode
add_shortcode( '<%=_name%>', '<%=_textdomain%>_<%=_name%>_shortcode' );
function <%=_textdomain%>_<%=_name%>_shortcode( $atts<% if (content) { %>, $content<% } %> ) {
	$atts = kaliroots_get_shortcode_atts( '<%=_name%>', $atts );
<% if (css) { -%>
	$atts['css'] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $atts['css'], ' ' ), '<%=_name%>', $atts );
<% } -%>
	foreach ( $atts as $key => $value ) {
		set_query_var( $key, $value );
	}
<% if (content) { -%>
    set_query_var( 'content', wpautop( $content ) );
<% } -%>

	return kaliroots_shortcode_template( '<%=name%>' );
}

// Map '<%=_name%>' shortcode in Visual Composer
// @see https://kb.wpbakery.com/docs/inner-api/vc_map/
add_action( 'vc_after_init', '<%=_textdomain%>_<%=_name%>_vc_map' );
function <%=_textdomain%>_<%=_name%>_vc_map() {
	try {
		vc_map( array(
			'name'          => __( "<%=Name%>", '<%=h.textdomain%>' ),
			'base'          => '<%=_name%>',
			'category'      => '<%=h.description%>',
			'params'        => array( // Shortcode params
			<% if (content) { -%>
        array(
          'heading'    => __( "Content", '<%=h.textdomain%>' ),
          'type'       => 'textarea_html',
          'holder'     => 'div',
          'param_name' => 'content',
        ),
      <% } -%>
      <% if (css) { -%>
        array(
          'heading'    => __( "CSS", '<%=h.textdomain%>' ),
          'type'       => 'css_editor',
          'param_name' => 'css',
          'group'      => __( "Design options", '<%=h.textdomain%>' ),
        ),
      <% } -%>
			),
    ) );
	} catch ( Exception $e ) {
		error_log( sprintf( "Could not map shortcode (<%=_name%>): %s", $e->getMessage() ) );
	}
}
