<?php

// array_splice for associative arrays
function array_splice_assoc( $array, $values, $offset ) {
	return array_slice( $array, 0, $offset, true ) + $values + array_slice( $array, $offset, null, true );
}

// Echo  without buffering
function echo_flush( $text, $linebreak = false ) {
	echo $text;
	if ( $linebreak ) {
		echo '<br/>';
	}
	@wp_ob_end_flush_all();
	@flush();
}

// Helper: Load CSV from URL
function kaliroots_load_csv( $url ) {
	$rows = array();
	if ( empty( $csv = fopen( $url, 'r' ) ) ) {
		return false;
	}
	if ( empty( $header = fgetcsv( $csv ) ) ) {
		return false;
	}
	while ( $row = fgetcsv( $csv ) ) {
		$rows[] = array_combine( $header, $row );
	}
	fclose( $csv );

	return $rows;
}