<?php

// Helper: Get Gutenberg block classes
function kaliroots_block_class( $block ) {
	$classes = apply_filters( 'kaliroots_block_class', array(), $block );

	return implode( ' ', $classes );
}

// Block type class (i.e. block-acf-name)
add_filter( 'kaliroots_blocks_class', 'kaliroots_block_type_class', 10, 2 );
function kaliroots_block_type_class( $classes, $block ) {
	$classes[] = 'block-' . str_replace( '/', '-', $block['name'] );

	return $classes;
}

// Block extra class
add_filter( 'kaliroots_blocks_class', 'kaliroots_block_extra_class', 10, 2 );
function kaliroots_block_extra_class( $classes, $block ) {
	if ( ! empty( $block['className'] ) ) {
		$classes[] = $block['className'];
	}

	return $classes;
}
