<?php

// Setup Kaliroots
add_action( 'after_setup_theme', 'kaliroots_after_setup_theme' );
function kaliroots_after_setup_theme() {
	// Set PHP locale
	setlocale( LC_COLLATE, 'fr_CA.UTF-8' );
}

// Remove admin bar logo
add_action( 'wp_before_admin_bar_render', 'kaliroots_remove_adminbar_logo' );
function kaliroots_remove_adminbar_logo() {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu( 'wp-logo' );
}

// Remove admin footer text
add_filter( 'admin_footer_text', '__return_false' );

// Remove dashboard widgets
add_action( 'wp_dashboard_setup', 'kaliroots_dashboard_setup', 100 );
function kaliroots_dashboard_setup() {
	global $wp_meta_boxes;
	unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity'] );
	unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now'] );
	unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_primary'] );
	unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press'] );

	return;
}

// Remove Welcome panel
remove_action( 'welcome_panel', 'wp_welcome_panel' );

// Remove customizer sections
add_action( 'customize_register', 'kaliroots_customize_register' );
function kaliroots_customize_register( WP_Customize_Manager $wp_customize ) {
	$wp_customize->remove_section( 'custom_css' );
	$wp_customize->remove_section( 'colors' );
}

// Remove unnecessary code from wp_head()
function kaliroots_disable_feeds() {
	// Redirects all feeds to home page.
	$url = site_url();
	wp_redirect( $url );
}

// Disables feeds.
add_action( 'do_feed', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rdf', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rss', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_rss2', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_atom', 'kaliroots_disable_feeds', 1 );

// Disables comments feeds.
add_action( 'do_feed_rss2_comments', 'kaliroots_disable_feeds', 1 );
add_action( 'do_feed_atom_comments', 'dkaliroots_disable_feeds', 1 );

remove_action( 'wp_head', 'wp_generator' );                           // Removes WordPress version.
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10 );               // Removes shortlink.
remove_action( 'wp_head', 'rsd_link' );                               // Removes Really Simple Discovery link.
remove_action( 'wp_head', 'feed_links', 2 );                          // Removes RSS feed links.
remove_action( 'wp_head', 'feed_links_extra', 3 );                    // Removes all extra RSS feed links.
remove_action( 'wp_head', 'wlwmanifest_link' );                       // Removes wlwmanifest.xml.
remove_action( 'wp_head', 'wp_resource_hints', 2 );                   // Removes meta rel=dns-prefetch href=//s.w.org
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10 );    // Removes relational links for the posts.

// Removes Emoji icons.
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );

// Removes oEmbeds.
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
add_action( 'wp_footer', 'kaliroots_disable_embed_script' );
function kaliroots_disable_embed_script() {
	wp_deregister_script( 'wp-embed' );
}

// Disable avatars
add_filter( 'bp_core_fetch_avatar', '__return_empty_string' );
add_filter( 'get_avatar', '__return_empty_string' );
add_filter( 'bp_get_signup_avatar', '__return_empty_string' );
