<?php

// Abstract ACF location type (never display)
if ( class_exists( 'ACF_Location' ) && function_exists( 'acf_register_location_type' ) ) {
	class ACF_Location_Abstract extends ACF_Location {
		function initialize() {
			$this->name        = 'abstract';
			$this->category    = 'kaliroots';
			$this->object_type = '';
			$this->label       = __( "Abstract", 'kaliroots' );
		}

		public static function get_operators( $rule ) {
			return array();
		}

		function match( $rule, $screen, $field_group ) {
			return false;
		}
	}

	acf_register_location_type( 'ACF_Location_Abstract' );
}

// Helper: Determine if current page is ACF administration
function kaliroots_is_acf_admin() {
	if ( isset( $_REQUEST['post_type'] ) && $_REQUEST['post_type'] === 'acf-field-group' ) {
		return true;
	}
	if ( isset( $_REQUEST['post'] ) && get_post_type( $_REQUEST['post'] ) === 'acf-field-group' ) {
		return true;
	}
	if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] === 'rename_field_groups' ) {
		return true;
	}
	return false;
}
