<?php

// Disable Gutenberg
if ( apply_filters( 'kaliroots_disable_gutenberg', true ) ) {
	add_action( 'after_setup_theme', 'kaliroots_disable_gutenberg' );
	add_action( 'wp_enqueue_scripts', 'kaliroots_disable_gutenberg_styles', 100 );
	add_filter( 'use_widgets_block_editor', '__return_false' );
}

function kaliroots_disable_gutenberg() {
	remove_action( 'try_gutenberg_panel', 'wp_try_gutenberg_panel' );
	add_filter( 'use_block_editor_for_post_type', '__return_false', 100 );
}

function kaliroots_disable_gutenberg_styles() {
	wp_dequeue_style( 'wp-block-library' );
}

// Helper: Get Gutenberg block classes
function kaliroots_block_class( $block ) {
	$classes = apply_filters( 'kaliroots_block_class', array(), $block );

	return implode( ' ', $classes );
}

// Block type class (i.e. block-acf-name)
add_filter( 'kaliroots_blocks_class', 'kaliroots_block_type_class', 10, 2 );
function kaliroots_block_type_class( $classes, $block ) {
	$classes[] = 'block-' . str_replace( '/', '-', $block['name'] );

	return $classes;
}

// Block extra class
add_filter( 'kaliroots_blocks_class', 'kaliroots_block_extra_class', 10, 2 );
function kaliroots_block_extra_class( $classes, $block ) {
	if ( ! empty( $block['className'] ) ) {
		$classes[] = $block['className'];
	}

	return $classes;
}
