module.exports = [
  {
    type: 'input',
    name: 'name',
    message: 'Post type slug',
    validate: (name) => {
      return /^[a-z\-]+$/.test(name) || 'Only lowercase characters and dashes are allowed';
    },
  },
  {
    type: 'select',
    multiple: true,
    name: 'args',
    message: 'Post type arguments',
    choices: [ 'public', 'hierarchical', 'show_ui', 'show_in_nav_menus', 'has_archive' ],
    initial: [ 'public', 'show_ui' ],
  },
  {
    type: 'select',
    multiple: true,
    name: 'supports',
    message: 'Post type supports',
    choices: [ 'title', 'thumbnail', 'author', 'editor', 'excerpt', 'revisions', 'page-attributes', 'comments' ],
    initial: [ 'title', 'thumbnail' ],
    result: (supports) => supports.map(((support) => ` '${support}'`)),
  },
  {
    type: 'select',
    name: 'dashicon',
    message: 'Post type dashicon',
    choices: [ 'admin-post', 'lightbulb', 'location', 'calendar' ],
  },
];
