<?php

// Encode link array to imploded value
function vc_encode_link( array $link ) {
	$link        = wp_parse_args( $link, array(
		'url'    => '',
		'title'  => '',
		'target' => '',
		'rel'    => '',
	) );
	$link['url'] = rawurlencode( $link['url'] );
	array_walk( $link, function ( &$value, $key ) {
		if ( ! empty( $value ) ) {
			$value = "$key:$value";
		}
	} );

	return implode( '|', array_filter( $link ) );
}

// Custom admin style
add_action( 'admin_head', 'kaliroots_js_composer_admin_head' );
function kaliroots_js_composer_admin_head() {
	?>
	<style>
    .wpb_el_type_checkbox .edit_form_line {
      display: flex;
      flex-direction: column;
      gap: 6px;
    }
	</style>
	<?php
}