module.exports = [
  {
    type: 'input',
    name: 'name',
    message: 'Taxonomy type slug',
    validate: (name) => {
      return /^[a-z\-]+$/.test(name) || 'Only lowercase characters and dashes are allowed';
    },
  },
  {
    type: 'select',
    multiple: true,
    name: 'args',
    message: 'Taxonomy arguments',
    choices: [ 'public', 'hierarchical', 'show_ui', 'show_in_menu', 'show_in_nav_menus', 'show_admin_column' ],
    initial: [ 'public', 'show_ui', 'show_admin_column' ],
  },
];
