<?php

/**
 * Helper: Acquire mutex lock
 *
 * @see WP_Upgrader::create_lock()
 *
 * @param $lock_name
 * @param $release_timeout
 *
 * @return bool
 */
function kaliroots_acquire_lock( $lock_name, $release_timeout = null ) {
	global $wpdb;
	if ( ! $release_timeout ) {
		$release_timeout = HOUR_IN_SECONDS;
	}
	$lock_option = $lock_name . '.lock';
	$lock_result = $wpdb->query( $wpdb->prepare( "INSERT IGNORE INTO `$wpdb->options` ( `option_name`, `option_value`, `autoload` ) VALUES (%s, %s, 'no') /* LOCK */", $lock_option, time() ) );
	if ( ! $lock_result ) {
		$lock_result = get_option( $lock_option );
		if ( ! $lock_result ) {
			return false;
		}
		if ( $lock_result > ( time() - $release_timeout ) ) {
			return false;
		}
		kaliroots_release_lock( $lock_name );
		return kaliroots_acquire_lock( $lock_name, $release_timeout );
	}
	update_option( $lock_option, time() );
	return true;
}

/**
 * Helper: Release mutex lock
 *
 * @see WP_Upgrader::release_lock()
 *
 * @param $lock_name
 *
 * @return bool
 */
function kaliroots_release_lock( $lock_name ) {
	return delete_option( $lock_name . '.lock' );
}
