<?php

// Replace partial meta_key in posts WHERE clause
add_filter( 'posts_where', 'kaliroots_posts_where_meta_key_like', 10, 2 );
function kaliroots_posts_where_meta_key_like( $where, WP_Query $query ) {
	global $wpdb;
	if ( ! $query->get( 'meta_key_like' ) ) {
		return $where;
	}
	return preg_replace( "/(meta_key)\s=\s(\'.*?[%].*?\')/i", '${1} LIKE ${2}', $wpdb->remove_placeholder_escape( $where ) );
}

// Replace partial meta_key in users WHERE clause
add_filter( 'pre_user_query', 'kaliroots_pre_user_query_meta_key_like', 10, 2 );
function kaliroots_pre_user_query_meta_key_like( WP_User_Query $query ) {
	global $wpdb;
	if ( ! $query->get( 'meta_key_like' ) ) {
		return $query;
	}
	$query->query_where = str_replace( 'meta_key =', 'meta_key LIKE', $wpdb->remove_placeholder_escape( $query->query_where ) );

	return $query;
}

// Find single post
function kaliroots_find_single_post( $query_args = array( 'post_type' => 'post' ) ) {
	$post_ids = get_posts( wp_parse_args( array(
		'posts_per_page' => 1,
		'fields'         => 'ids',
	), $query_args ) );

	return array_unshift( $post_ids );
}
