<?php

// Load generic template
function kaliroots_generic_template( $template_path, $vars = array(), $args = array() ) {
	$args = wp_parse_args( $args, array( 'cache' => false, 'expiration' => 3600 ) );

	// Locate template file
	if ( empty( $template = kaliroots_locate_template( $template_path ) ) ) {
		return '';
	}

	// Return cached template if available
	$cache_key = 'part_' . md5( $template ) . '/' . md5( wp_json_encode( $vars ) );
	if ( $args['cache'] && ! empty( $output = get_transient( $cache_key ) ) ) {
		return $output;
	}

	// Inject vars
	foreach ( $vars as $name => $value ) {
		set_query_var( $name, $value );
	}

	// Get template output
	ob_start();
	load_template( $template, false );
	$output = ob_get_clean();

	// Cache template if necessary
	if ( $args['cache'] ) {
		set_transient( $cache_key, $output, $args['expiration'] );
	}

	return $output;
}

// Load HTML template
function kaliroots_html_template( $template_name, $vars = array(), $args = array() ) {
	return kaliroots_generic_template( "templates/html/$template_name-{base}", $vars, $args );
}

// Load site template
function kaliroots_site_template( $template_name, $vars = array(), $args = array() ) {
	return kaliroots_generic_template( "templates/site/$template_name-{base}", $vars, $args );
}

// Load content template
function kaliroots_content_template( $template_name, $vars = array(), $args = array() ) {
	$vars = wp_parse_args( $vars, array( 'post_id' => get_the_ID() ) );

	return kaliroots_generic_template( "templates/content/$template_name-{base}", $vars, $args );
}

// Load loop template
function kaliroots_loop_template( $template_name, $vars = array(), $args = array() ) {
	return kaliroots_generic_template( "templates/content/loops/$template_name-{post_type}", $vars, $args );
}

// Load section template
function kaliroots_section_template( $template_name, $vars = array(), $args = array() ) {
	return kaliroots_generic_template( "templates/sections/$template_name", $vars, $args );
}

// Load shortcode template
function kaliroots_shortcode_template( $template_name, $vars = array(), $args = array() ) {
	return kaliroots_generic_template( "templates/shortcodes/$template_name", $vars, $args );
}

// Load widget template
function kaliroots_widget_template( $template_name, $vars = array(), $args = array() ) {
	$vars = wp_parse_args( $vars, array( 'widget_id' => get_query_var( 'widget_id' ) ) );
	return kaliroots_generic_template( "templates/widgets/$template_name", $vars, $args );
}

// Responsive image
function kaliroots_responsive_image( $image_id = null, $args = array() ) {
	if ( empty( $image_id ) && empty( $image_id = get_post_thumbnail_id() ) ) {
		return '';
	}
	$args = wp_parse_args( $args, array(
		'class' => '',
		'size'  => '2048x2048',
		'style' => kaliroots_get_image_position_style( $image_id ),
	) );
	ob_start();
	?>
	<img class="<?= esc_attr( $args['class'] ) ?>"
	     src="<?= esc_attr( wp_get_attachment_image_url( $image_id, $args['size'] ) ) ?>"
	     srcset="<?= esc_attr( wp_get_attachment_image_srcset( $image_id ) ) ?>"
	     sizes="<?= esc_attr( wp_get_attachment_image_sizes( $image_id, $args['size'] ) ) ?>"
	     alt="<?= esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) ?>"
	     style="<?= esc_attr( $args['style'] ) ?>"/>
	<?php
	return ob_get_clean();
}

// Inline SVG
function kaliroots_inline_svg( $filename, $args = array() ) {
	$args = wp_parse_args( $args, array(
		'class' => 'fill-current',
	) );
	$svg  = file_get_contents( $filename );
	if ( $svg === false ) {
		return '';
	}
	$dom = new DOMDocument();
	$dom->loadXML( $svg );
	foreach ( $dom->getElementsByTagName( 'svg' ) as $element ) {
		$element->setAttribute( 'class', $args['class'] );
	}

	return $dom->saveXML();
}

// Pagination links
function kaliroots_pagination_links( $args = array() ) {
	global $wp_query;
	$current = get_query_var( 'paged' ) > 1 ? get_query_var( 'paged' ) : 1;
	$url     = explode( '?', get_pagenum_link( 999999999, false ) );
	$args    = wp_parse_args( $args, array(
		'base'       => esc_url_raw( str_replace( 999999999, '%#%', $url[0] ) ),
		'format'     => '',
		'total'      => $wp_query->max_num_pages,
		'current'    => $current,
		'show_all'   => false,
		'type'       => 'array',
		'prev_text'  => '«',
		'next_text'  => '»',
		'link_class' => '',

	) );
	if ( ! is_array( $links = paginate_links( $args ) ) ) {
		return array();
	}

	return array_map( function ( $link ) use ( $args ) {
		return preg_replace( '/class="(.*?)page-numbers/', 'class="' . $args['link_class'] . ' $1', $link );
	}, $links );
}

// Get data attributes
function kaliroots_data_attributes( $args = array() ) {
	$attrs = apply_filters( 'kaliroots_data_attributes', array(), $args );
	$html  = '';
	foreach ( $attrs as $key => $value ) {
		$html .= sprintf( ' %s="%s"', esc_attr( $key ), esc_attr( $value ) );
	}

	return $html;
}
