<?php

// Register custom location types
add_action( 'acf/init', 'kaliroots_acf_init_location_types' );
function kaliroots_acf_init_location_types() {
	if ( function_exists( 'acf_register_location_type' ) ) {
		require_once __DIR__ . '/acf-location-abstract.php';
		require_once __DIR__ . '/acf-location-taxonomy-term-type.php';
		acf_register_location_type( 'ACF_Location_Abstract' );
		acf_register_location_type( 'ACF_Location_Term_Type' );
	}
}

// Helper: Determine if current page is ACF administration
function kaliroots_is_acf_admin() {
	if ( isset( $_REQUEST['post_type'] ) && $_REQUEST['post_type'] === 'acf-field-group' ) {
		return true;
	}
	if ( isset( $_REQUEST['post'] ) && get_post_type( $_REQUEST['post'] ) === 'acf-field-group' ) {
		return true;
	}
	if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] === 'rename_field_groups' ) {
		return true;
	}
	return false;
}
