<?php

// Format date range
function kaliroots_format_date_range( $start_date = '', $end_date = '' ) {
	$date_range = '';
	// TODO: Take $locale into account

	// If only one date, or dates are the same set to FULL verbose date
	if ( empty( $start_date ) || empty( $end_date ) || ( date( 'Ymd', $start_date ) === date( 'Ymd', $end_date ) ) ) {
		$start_date_pretty = date_i18n( 'j F Y', $start_date );
		$end_date_pretty   = date_i18n( 'j F Y', $end_date );
	} else {
		// Setup basic dates
		$start_date_pretty = date_i18n( 'j', $start_date );
		$end_date_pretty   = date_i18n( 'j F Y', $end_date );

		// If months differ add suffix and year to end_date
		if ( date( 'F', $start_date ) != date( 'F', $end_date ) ) {
			$start_date_pretty .= date_i18n( ' F', $start_date );
		}

		// If years differ add suffix and year to start_date
		if ( date( 'Y', $start_date ) != date( 'Y', $end_date ) ) {
			$start_date_pretty .= date_i18n( ' Y', $start_date );
		}
	}

	// Build date_range return string
	if ( ! empty( $start_date ) ) {
		$date_range .= $start_date_pretty;
	}

	// Check if there is an end date and append if not identical
	if ( ! empty( $end_date ) ) {
		if ( $end_date_pretty != $start_date_pretty ) {
			$date_range .= ' → ' . $end_date_pretty;
		}
	}

	return $date_range;
}

// Timezone-aware strototime
function strtotime_tz( $datetime ) {
	$dt = new DateTime( $datetime, new DateTimeZone( get_option( 'timezone_string' ) ) );
	return $dt->format( 'U' );
}
