<?php

/**
 * Get navigation menu items hierarchy
 *
 * @param $menu_location
 *
 * @return array
 */
function kaliroots_get_nav_menu_items( $menu_location ) {
	$locations = get_nav_menu_locations();
	$items     = array();

	if ( ! isset( $locations[ $menu_location ] ) || empty( $menu = wp_get_nav_menu_object( $locations[ $menu_location ] ) ) ) {
		return $items;
	}
	if ( empty( $nav_items = wp_get_nav_menu_items( $menu ) ) ) {
		return $items;
	}

	foreach ( $nav_items as $nav_item ) {
		// Determine if nav_item is currently being displayed
		switch ( $nav_item->type ) {
			case 'post_type_archive':
				$current = is_post_type_archive( $nav_item->object );
				break;
			case 'post_type':
				$current = $nav_item->object_id == get_queried_object_id();
				break;
			default:
				if ( ! empty( $nav_item_url = parse_url( $nav_item->url ) ) && isset( $nav_item_url['path'] ) ) {
					$current = parse_url( $_SERVER['REQUEST_URI'] )['path'] === ( $nav_item_url['path'] ?: '' );
				} else {
					$current = false;
				}
				break;
		}
		if ( $current ) {
			$nav_item->classes[] = 'current';
		}
		$menu_item = array(
			'id'          => $nav_item->ID,
			'title'       => $nav_item->title,
			'description' => $nav_item->description,
			'url'         => $nav_item->url,
			'target'      => $nav_item->target,
			'parent_id'   => $nav_item->menu_item_parent,
			'current'     => $current,
			'class'       => implode( ' ', array_filter( is_array( $nav_item->classes ) ? $nav_item->classes : array( $nav_item->classes ) ) ),
			'children'    => array(),
		);
		$items[]   = apply_filters( 'kaliroots_get_nav_menu_item', $menu_item, $nav_item );
	}

	return buildHierarchy( $items );
}

function buildHierarchy( array &$items, $parent_id = 0 ) {
	$branch = array();
	foreach ( $items as &$item ) {
		if ( $item['parent_id'] == $parent_id ) {
			$children = buildHierarchy( $items, $item['id'] );
			if ( $children ) {
				$item['children'] = $children;
				if ( ! empty( array_filter( array_column( $children, 'current' ) ) ) ) {
					$item['current'] = true;
				}
			}
			$branch[] = $item;
			unset( $item );
		}
	}

	return $branch;
}
