<?php

// Get navigation menu items hierarchy
function kaliroots_get_nav_menu_items( $menu_location ) {
	$locations = get_nav_menu_locations();
	$items     = array();

	if ( ! isset( $locations[ $menu_location ] ) || empty( $menu = wp_get_nav_menu_object( $locations[ $menu_location ] ) ) ) {
		return $items;
	}
	if ( empty( $nav_items = wp_get_nav_menu_items( $menu ) ) ) {
		return $items;
	}

	foreach ( $nav_items as $nav_item ) {
		// Determine if nav_item is currently being displayed
		switch ( $nav_item->type ) {
			case 'post_type_archive':
				$current = is_post_type_archive( $nav_item->object );
				break;
			case 'post_type':
				$current = (int) $nav_item->object_id === (int) get_queried_object_id();
				break;
			default:
				if ( ! empty( $nav_item_url = wp_parse_url( $nav_item->url ) ) && isset( $nav_item_url['path'] ) ) {
					$current = wp_parse_url( $_SERVER['REQUEST_URI'] )['path'] === ( $nav_item_url['path'] ?? '' );
				} else {
					$current = false;
				}
				break;
		}
		if ( $current ) {
			$nav_item->classes[] = 'current';
		}
		$menu_item = array(
			'id'          => (int) $nav_item->ID,
			'title'       => $nav_item->title,
			'description' => $nav_item->description,
			'url'         => $nav_item->url,
			'target'      => $nav_item->target,
			'parent_id'   => (int) $nav_item->menu_item_parent,
			'current'     => (bool) $current,
			'class'       => implode( ' ', array_filter( is_array( $nav_item->classes ) ? $nav_item->classes : array( $nav_item->classes ) ) ),
			'children'    => array(),
		);
		$items[]   = apply_filters( 'kaliroots_get_nav_menu_item', $menu_item, $nav_item );
	}

	return _build_hierarchy( $items );
}

function _build_hierarchy( array &$items, $parent_id = 0 ) {
	$branch = array();
	foreach ( $items as &$item ) {
		if ( (int) $item['parent_id'] === (int) $parent_id ) {
			$children = _build_hierarchy( $items, $item['id'] );
			if ( $children ) {
				$item['children'] = $children;
				if ( ! empty( array_filter( array_column( $children, 'current' ) ) ) ) {
					$item['current'] = true;
				}
			}
			$branch[] = $item;
			unset( $item );
		}
	}

	return $branch;
}

// Helper: Get menu item from post
function kaliroots_get_menu_item( WP_Post $post, $args = array() ) {
	$args = kaliroots_parse_args(
		$args,
		array(
			'ID'               => 1000000 + $post->ID,
			'db_id'            => $post->ID,
			'title'            => $post->post_title,
			'description'      => '',
			'url'              => get_permalink( $post->ID ),
			'target'           => '',
			'menu_item_parent' => 0,
			'menu_order'       => 0,
			'classes'          => array(),
			'type'             => 'post_type',
			'object'           => $post->post_type,
			'object_id'        => $post->ID,
		)
	);
	return (object) $args;
}
