<?php

// array_splice for associative arrays
function array_splice_assoc( $input_array, $values, $offset ) {
	return array_slice( $input_array, 0, $offset, true ) + $values + array_slice( $input_array, $offset, null, true );
}

// Recursive wp_parse_args
function kaliroots_parse_args( array $args, array $defaults ) {
	$result = $defaults;
	foreach ( $args as $k => $v ) {
		if ( is_array( $v ) && isset( $result[ $k ] ) ) {
			$result[ $k ] = kaliroots_parse_args( $v, $result[ $k ] );
		} else {
			$result[ $k ] = $v;
		}
	}
	return $result;
}

// Helper: Load CSV from URL
function kaliroots_load_csv( $url ) {
	$rows = array();
	if ( empty( $csv = fopen( $url, 'r' ) ) ) {
		return false;
	}
	if ( empty( $header = fgetcsv( $csv ) ) ) {
		return false;
	}
	while ( $row = fgetcsv( $csv ) ) {
		$rows[] = array_combine( $header, $row );
	}
	fclose( $csv );

	return $rows;
}

// Helper: Encode JSON attribute
function json_attr( $attributes ) {
	return esc_attr( wp_json_encode( $attributes ) );
}

// Helper: Validate and fix URL
function kaliroots_validate_url( $url ) {
	if ( ! preg_match( '/^https?:\/\//', $url ) ) {
		$value = 'https://' . $url;
	}
	if ( ! filter_var( $url, FILTER_VALIDATE_URL ) ) {
		return false;
	}
	return esc_url( $url );
}

// Echo without buffering
function echo_flush( $text, $linebreak = false ) {
	echo $text;
	if ( $linebreak ) {
		echo '<br/>';
	}
	wp_ob_end_flush_all();
	flush();
}

// Helper: Return 'yes' string
function __return_yes() { // phpcs:ignore
	return 'yes';
}

// Helper: Return 'no' string
function __return_no() { // phpcs:ignore
	return 'no';
}
