<?php
// Responsive image
function kaliroots_responsive_image( $image_id = null, $args = array() ) {
	if ( empty( $image_id ) && empty( $image_id = get_post_thumbnail_id() ) ) {
		return '';
	}
	$args = wp_parse_args(
		$args,
		array(
			'class' => '',
			'size'  => '2048x2048',
			'style' => kaliroots_get_image_position_style( $image_id ),
		)
	);
	ob_start();
	?>
	<img class="<?= esc_attr( $args['class'] ); ?>"
		src="<?= esc_attr( wp_get_attachment_image_url( $image_id, $args['size'] ) ); ?>"
		srcset="<?= esc_attr( wp_get_attachment_image_srcset( $image_id ) ); ?>"
		sizes="<?= esc_attr( wp_get_attachment_image_sizes( $image_id, $args['size'] ) ); ?>"
		alt="<?= esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); ?>"
		style="<?= esc_attr( $args['style'] ); ?>"/>
	<?php
	return ob_get_clean();
}

// Inline SVG
function kaliroots_inline_svg( $filename, $args = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'class' => 'fill-current',
		)
	);
	$svg  = file_get_contents( $filename );
	if ( $svg === false ) {
		return '';
	}
	$dom = new DOMDocument();
	$dom->loadXML( $svg );
	foreach ( $dom->getElementsByTagName( 'svg' ) as $element ) {
		$element->setAttribute( 'class', $args['class'] );
	}

	return $dom->saveXML();
}

// Helper: Determine image center from Theia Smart Thumbnails coordinates
function kaliroots_get_image_position( $image_id ) {
	$image_position = '50% 50%';
	if ( empty( $image_id ) && empty( $image_id = get_post_thumbnail_id() ) ) {
		return $image_position;
	}
	if ( ! empty( $position = get_post_meta( $image_id, 'theiaSmartThumbnails_position', true ) ) ) {
		$image_position = implode( ' ', array( round( $position[0], 4 ) * 100 . '%', round( $position[1], 4 ) * 100 . '%' ) );
	}
	return $image_position;
}

// Helper: Generate CSS style property for positioned background image
function kaliroots_get_image_bg_style( $image_id = null, $args = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'size' => '2048x2048',
		)
	);
	if ( empty( $image_url = wp_get_attachment_image_url( $image_id ?: get_post_thumbnail_id(), $args['size'] ) ) ) {
		return '';
	}
	$styles   = array();
	$styles[] = "background-image: url($image_url)";
	$styles[] = "background-position: " . kaliroots_get_image_position( $image_id );
	return implode( ';', $styles );
}

// Helper: Generate CSS style property for mask image
function kaliroots_get_image_mask_style( $image_id = null, $args = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'size' => '2048x2048',
		)
	);
	if ( empty( $image_url = wp_get_attachment_image_url( $image_id ?: get_post_thumbnail_id(), $args['size'] ) ) ) {
		return '';
	}
	return "mask-image: url($image_url);";
}

// Helper: Generate CSS style property for positioned image
function kaliroots_get_image_position_style( $image_id = null ) {
	$image_id = $image_id ?: get_post_thumbnail_id();
	return $image_id ? "object-position: " . kaliroots_get_image_position( $image_id ) : '';
}
