---
to: includes/taxonomies/<%=name%>.php
unless_exists: true
---
<% Names = h.inflection.pluralize(Name).replace('-', ' ') -%>
<% Name = h.inflection.humanize(Name).replace('-', ' ') -%>
<% _name = name.replace('-', '_') -%>
<% _textdomain = h.textdomain.replace('-', '_') -%>
<?php

// Register '<%=name%>' taxonomy
add_action( 'init', '<%=_textdomain%>_<%=_name%>_register_taxonomy' );
function <%=_textdomain%>_<%=_name%>_register_taxonomy() {
	register_taxonomy( '<%=name%>', array( 'post' ), array(
		'labels'                => array(
			'name'                       => __( "<%=h.inflection.pluralize(Name)%>", '<%=h.textdomain%>' ),
			'singular_name'              => __( "<%=Name%>", '<%=h.textdomain%>' ),
			'search_items'               => __( "Search <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'popular_items'              => __( "Popular <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'all_items'                  => __( "All <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'parent_item'                => __( "Parent <%=name%>", '<%=h.textdomain%>' ),
			'parent_item_colon'          => __( "Parent <%=name%>:", '<%=h.textdomain%>' ),
			'edit_item'                  => __( "Edit <%=name%>", '<%=h.textdomain%>' ),
			'update_item'                => __( "Update <%=name%>", '<%=h.textdomain%>' ),
			'view_item'                  => __( "View <%=name%>", '<%=h.textdomain%>' ),
			'add_new_item'               => __( "New <%=name%>", '<%=h.textdomain%>' ),
			'new_item_name'              => __( "New <%=name%>", '<%=h.textdomain%>' ),
			'separate_items_with_commas' => __( "Separate <%=h.inflection.pluralize(name)%> with commas", '<%=h.textdomain%>' ),
			'add_or_remove_items'        => __( "Add or remove <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'choose_from_most_used'      => __( "Choose from the most used <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'not_found'                  => __( "No <%=h.inflection.pluralize(name)%> found.", '<%=h.textdomain%>' ),
			'no_terms'                   => __( "No <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
			'menu_name'                  => __( "<%=h.inflection.pluralize(Name)%>", '<%=h.textdomain%>' ),
			'items_list_navigation'      => __( "<%=h.inflection.pluralize(Name)%> list navigation", '<%=h.textdomain%>' ),
			'items_list'                 => __( "<%=h.inflection.pluralize(Name)%> list", '<%=h.textdomain%>' ),
			'most_used'                  => __( "Most used", '<%=h.textdomain%>' ),
			'back_to_items'              => __( "&larr; Back to <%=h.inflection.pluralize(name)%>", '<%=h.textdomain%>' ),
		),
    'public'                => <%= args.includes('public') ? 'true' : 'false' %>,
    'hierarchical'          => <%= args.includes('hierarchical') ? 'true' : 'false' %>,
    'show_ui'               => <%= args.includes('show_ui') ? 'true' : 'false' %>,
    'show_in_menu'          => <%= args.includes('show_in_menu') ? 'true' : 'false' %>,
    'show_in_nav_menus'     => <%= args.includes('show_in_nav_menus') ? 'true' : 'false' %>,
    'show_admin_column'     => <%= args.includes('show_admin_column') ? 'true' : 'false' %>,
    'rewrite'               => true,
    'query_var'             => true,
		'show_in_rest'          => true,
		'rest_base'             => '<%=name%>',
		'rest_controller_class' => 'WP_REST_Terms_Controller',
	) );
}

// Custom '<%=name%>' term updated messages
add_filter( 'term_updated_messages', '<%=_textdomain%>_<%=_name%>_term_updated_messages' );
function <%=_textdomain%>_<%=_name%>_term_updated_messages( $messages ) {
	$messages['<%=name%>'] = array(
		0 => '',
		1 => __( "<%=Name%> added.", '<%=h.textdomain%>' ),
		2 => __( "<%=Name%> deleted.", '<%=h.textdomain%>' ),
		3 => __( "<%=Name%> updated.", '<%=h.textdomain%>' ),
		4 => __( "<%=Name%> not added.", '<%=h.textdomain%>' ),
		5 => __( "<%=Name%> not updated.", '<%=h.textdomain%>' ),
		6 => __( "<%=h.inflection.pluralize(Name)%> deleted.", '<%=h.textdomain%>' ),
	);

	return $messages;
}
