<?php

// Helper: Clean HTML based on allowed tags / properties
function kaliroots_clean_html( $html ) {
	// Allowed tags
	$allowed_tags = apply_filters(
		'kaliroots_clean_html_allowed_tags',
		array(
			'a',
			'b',
			'em',
			'h1',
			'h2',
			'h3',
			'h4',
			'img',
			'li',
			'ol',
			'p',
			'strong',
			'ul',
		)
	);
	$allowed_tags = array_map(
		function ( $tag ) {
			return "<$tag>";
		},
		$allowed_tags
	);

	// Allowed properties
	$allowed_properties = apply_filters(
		'kaliroots_clean_html_allowed_properties',
		array(
			'alt',
			'class',
			'href',
			'id',
			'rel',
			'src',
			'target',
		)
	);

	// Initialize DOMDocument / DOMXPath
	$doc = new DOMDocument();
	$doc->loadHTML( '<?xml encoding="UTF-8">' . strip_tags( $html, $allowed_tags ) );
	$xpath = new DOMXPath( $doc );

	// Clean HTML
	$tags = $xpath->query( '//*' );
	foreach ( $tags as $tag ) {
		$attributes = _get_attributes( $tag );
		foreach ( $attributes as $attribute ) {
			if ( ! in_array( $attribute, $allowed_properties ) ) {
				$tag->removeAttribute( $attribute );
			}
		}
	}
	return strip_tags( html_entity_decode( $doc->saveHTML() ), $allowed_tags );
}

// Helper: Get DOMNode attributes
function _get_attributes( DOMNode $tag ) {
	$result = array();
	for ( $i = 0; $i < $tag->attributes->length; $i++ ) {
		$result[] = $tag->attributes->item( $i )->nodeName;
	}
	return ( $result );
}
