<?php

class ACF_Location_Term_Type extends ACF_Location {
	public function initialize() {
		$this->name        = 'taxonomy_term_type';
		$this->category    = 'kaliroots';
		$this->object_type = '';
		$this->label       = __( "Taxonomy term type", 'kaliroots' );
	}

	public function rule_values( $choices, $rule ) {
		return array(
			'top_level' => __( 'Top-level (no parent)', 'kaliroots' ),
			'parent'    => __( 'Parent term (has children)', 'kaliroots' ),
			'child'     => __( 'Child term (has parent)', 'kaliroots' ),
		);
	}

	public function rule_match( $result, $rule, $screen ) {
		$taxonomy = acf_maybe_get( $screen, 'taxonomy' );
		$term_id  = $_GET['tag_ID'] ?: null;
		// Bail early
		if ( ! $taxonomy || ! $term_id ) {
			return false;
		}
		$term_parent = get_term_field( 'parent', $term_id );
		// Top Level
		if ( $rule['value'] === 'top_level' ) {
			$result = ( (int) $term_parent === 0 );
			// Parent
		} elseif ( $rule['value'] === 'parent' ) {
			$term_childs = acf_get_terms(
				array(
					'parent'   => $term_id,
					'taxonomy' => $taxonomy,
					'fields'   => 'ids',
				)
			);
			$result      = ! empty( $term_childs );
			// Child
		} elseif ( $rule['value'] === 'child' ) {
			$result = ( $term_parent > 0 );
		}
		// Reverse
		if ( $rule['operator'] === '!=' ) {
			$result = ! $result;
		}
		return $result;
	}
}
