<?php

// Helper: Determine image center from Theia Smart Thumbnails coordinates
function kaliroots_get_image_position( $image_id ) {
	$image_position = '50% 50%';
	if ( empty( $image_id ) && empty( $image_id = get_post_thumbnail_id() ) ) {
		return $image_position;
	}
	if ( ! empty( $position = get_post_meta( $image_id, 'theiaSmartThumbnails_position', true ) ) ) {
		$image_position = implode( ' ', array( round( $position[0], 4 ) * 100 . '%', round( $position[1], 4 ) * 100 . '%' ) );
	}

	return $image_position;
}

// Helper: Generate CSS style property for positioned background image
function kaliroots_get_image_bg_style( $image_id = null, $args = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'size' => '2048x2048',
		)
	);
	if ( empty( $image_url = wp_get_attachment_image_url( $image_id ?: get_post_thumbnail_id(), $args['size'] ) ) ) {
		return '';
	}
	$styles   = array();
	$styles[] = "background-image: url($image_url)";
	$styles[] = "background-position: " . kaliroots_get_image_position( $image_id );

	return implode( ';', $styles );
}

// Helper: Generate CSS style property for positioned image
function kaliroots_get_image_position_style( $image_id = null ) {
	$image_id = $image_id ?: get_post_thumbnail_id();

	return $image_id ? "object-position: " . kaliroots_get_image_position( $image_id ) : '';
}
