<?php

// Helper: Register script
function kaliroots_register_script( $handle, $relative_src, $deps = array(), $in_footer = true ) {
	if ( ! file_exists( $absolute_src = get_theme_file_path( $relative_src ) ) ) {
		return;
	}
	if ( empty( $version = filemtime( $absolute_src ) ) ) {
		return;
	}
	wp_register_script( $handle, get_theme_file_uri( $relative_src ), $deps, $version, $in_footer );
}

// Helper: Register style
function kaliroots_register_style( $handle, $relative_src, $deps = array(), $media = 'all' ) {
	if ( ! file_exists( $absolute_src = get_theme_file_path( $relative_src ) ) ) {
		return;
	}
	if ( empty( $version = filemtime( $absolute_src ) ) ) {
		return;
	}
	wp_register_style( $handle, get_theme_file_uri( $relative_src ), $deps, $version, $media );
}
