<?php

// Helper: Create or update taxonomy term
function kaliroots_upsert_term( $args = array() ) {
	if ( ! taxonomy_exists( $args['taxonomy'] ?: '' ) ) {
		return false;
	}
	if ( empty( $args['name'] ) ) {
		return false;
	}

	if ( ! empty( $args['slug'] ) ) {
		// Find existing term by slug
		$terms = get_terms(
			array(
				'taxonomy'   => $args['taxonomy'],
				'slug'       => $args['slug'],
				'hide_empty' => false,
			)
		);
	} else {
		// Find existing term by name / parent
		$terms = get_terms(
			array(
				'taxonomy'   => $args['taxonomy'],
				'name'       => $args['name'],
				'parent'     => $args['parent'],
				'hide_empty' => false,
			)
		);
	}

	if ( ! empty( $terms ) ) {
		$result = wp_update_term( $terms[0]->term_id, $args['taxonomy'], wp_parse_args( $args, (array) $terms[0] ) );
	} else {
		$result = wp_insert_term( $args['name'], $args['taxonomy'], $args );
	}
	if ( is_wp_error( $result ) ) {
		return false;
	}

	return get_term_by( 'id', $result['term_id'], $args['taxonomy'] );
}
