<?php

// Import file from URL
function kaliroots_import_file( $url, $options = false ) {
	global $wpdb;

	require_once ABSPATH . 'wp-admin/includes/file.php';
	require_once ABSPATH . 'wp-admin/includes/image.php';

	// Validate options
	if ( empty( $url ) ) {
		return false;
	}
	if ( ! is_array( $options ) ) {
		$options = array();
	}
	$options = wp_parse_args(
		$options,
		array(
			'check_existing'  => false,
			'update_existing' => false,
			'file_name'       => str_replace( array( '-scaled', '-rotated' ), '', basename( $url ) ),
		)
	);

	// Attachment postdata
	$attachment = array();

	// Check for existing file
	$file_name = $options['file_name'];
	$guid      = '%' . str_replace( '.', '%.', $file_name );
	if ( $options['check_existing'] && ! empty( $existing  = $wpdb->get_results( $wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE guid LIKE %s;", $guid ), ARRAY_A ) ) ) {
		$attachment['ID'] = reset( $existing )['ID'];
		if ( ! $options['update_existing'] ) {
			return $attachment['ID'];
		}
		// Download file
		if ( is_wp_error( $temp_file = download_url( $url ) ) ) {
			return false;
		}
		// Overwrite existing file in uploads
		if ( ! $file_path = get_attached_file( $attachment['ID'], true ) ) {
			wp_delete_file( $temp_file );

			return false;
		}
		if ( ! rename( $temp_file, $file_path ) ) {
			return false;
		}
		$attachment = get_post( $attachment['ID'], ARRAY_A );
	} else {
		// Download file
		if ( is_wp_error( $temp_file = download_url( $url ) ) ) {
			return false;
		}
		// Move file to uploads
		$file_type = wp_check_filetype( $file_name );
		$file      = array(
			'name'     => $file_name,
			'type'     => $file_type['type'],
			'tmp_name' => $temp_file,
			'error'    => 0,
			'size'     => filesize( $temp_file ),
		);
		$result    = wp_handle_sideload( $file, array( 'test_form' => false ) );
		if ( isset( $result['error'] ) ) {
			return false;
		}
		$file_path = $result['file'];
		// Attachment postdata
		$attachment['post_title']     = sanitize_text_field( pathinfo( $url, PATHINFO_FILENAME ) );
		$attachment['post_mime_type'] = $result['type'];
		$attachment['guid']           = $result['url'];
	}

	// Update attachment metadata
	$id = wp_insert_attachment( $attachment, $file_path, 0, true );
	if ( ! is_wp_error( $id ) ) {
		wp_update_attachment_metadata( $id, wp_generate_attachment_metadata( $id, $file_path ) );
	}

	return $id;
}
