<?php
/**
 * Localization Tab.
 *
 * @package Lower Price
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( class_exists( 'MMP_Localization_Tab' ) ) {
	return new MMP_Localization_Tab();
}

/**
 * MMP_Localization_Tab.
 */
class MMP_Localization_Tab extends MMP_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'localization';
		$this->label = esc_html__( 'Localization', 'lower-price-for-woocommerce' );

		parent::__construct();
	}

	/**
	 * Output the Localization Tab content.
	 */
	public function localization_section_array() {
		return array(
			array(
				'type'  => 'title',
				'title' => __( 'Price List Table', 'lower-price-for-woocommerce' ),
				'id'    => 'mmp_localization_section',
			),
			array(
				'title'   => __( 'Price List My Account Endpoint', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'price_list_endpoint' ),
				'type'    => 'text',
				'default' => 'mmp_price_list',
			),
			array(
				'title'   => __( 'Price List Customization', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'my_account_label' ),
				'type'    => 'text',
				'default' => 'Price List',
			),
			array(
				'title'   => __( 'Product Name', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'pro_name' ),
				'type'    => 'text',
				'default' => 'Product Name',
			),
			array(
				'title'   => __( 'Original Price', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'org_price' ),
				'type'    => 'text',
				'default' => 'Original Price',
			),
			array(
				'title'   => __( 'Reported Price', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'report_price' ),
				'type'    => 'text',
				'default' => 'Reported Price',
			),
			array(
				'title'   => __( 'Offered Price', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'offered_price' ),
				'type'    => 'text',
				'default' => 'Offered Price',
			),
			array(
				'title'   => __( 'Status', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'status' ),
				'type'    => 'text',
				'default' => 'Status',
			),
			array(
				'title'   => __( 'Coupon  Code', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'coupon_code' ),
				'type'    => 'text',
				'default' => 'Coupon Code',
			),
			array(
				'title'   => __( 'Coupon Expiry Date', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'expiry_date' ),
				'type'    => 'text',
				'default' => 'Coupon Expiry Date',
			),
			array(
				'title'   => __( 'Last Activity Date', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'lst_activity' ),
				'type'    => 'text',
				'default' => 'Last Activity Date',
			),
			array(
				'type' => 'sectionend',
				'id'   => 'mmp_localization_section',
			),
			array(
				'type'  => 'title',
				'title' => __( 'Form Customization', 'lower-price-for-woocommerce' ),
				'id'    => 'mmp_form_localization_section',
			),
			array(
				'title'   => __( 'Form Label', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'form_title' ),
				'type'    => 'text',
				'default' => 'Lower Price Form',
			),
			array(
				'title'   => __( 'Summary', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'form_Description' ),
				'type'    => 'text',
				'default' => 'You can report the price details & where you have seen this product by filling the required information given in this form.',
			),
			array(
				'title'   => __( 'Submit Label', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'form_submit' ),
				'type'    => 'text',
				'default' => 'Submit',
			),
			array(
				'type' => 'sectionend',
				'id'   => 'mmp_form_localization_section',
			),
		);
	}
}

return new MMP_Localization_Tab();
