<?php

/**
 * Messages Tab.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'MMP_Messages_Tab' ) ) {
	return new MMP_Messages_Tab() ;
}

/**
 * MMP_Messages_Tab.
 */
class MMP_Messages_Tab extends MMP_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() { 
		$this->id    = 'messages' ;  
		$this->label = esc_html__( 'Messages', 'lower-price-for-woocommerce' ) ;

		parent::__construct() ;
	}

	/**
	 * Output the Messages Tab content.
	 */
	public function messages_section_array() {

		return array(
			array(
				'type'   => 'title',
				'title'  => __( 'Pop-Up Messages', 'lower-price-for-woocommerce' ),
				'id'     => 'mmp_popup_section',
			),
			array(
				'title'      => __( 'Lower Price Link Notice', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'link_msg' ),
				'type'       => 'text',
				'default'    => 'Would you like to tell us about a lower price?',
			),
			array(
				'title'      => __( 'Acknowledgment Message - Feedback Mode', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'ack_msg' ),
				'type'       => 'text',
				'default'    => 'Thanks for your feedback about the price information for this product.',
			),
			array(
				'title'      => __( 'Acknowledgment Message - Coupon Mode', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'ack_coupon_msg' ),
				'type'       => 'text',
				'default'    => 'Thanks for your suggestion about the price information for this product. You will be notified by email once we review the information you have provided.',
			),
			array(
				'title'      => __( 'Request Submitted Message', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'req_submitted_msg' ),
				'type'       => 'text',
				'default'    => 'Your request is under review for this product.',
			),
			array(
				'title'      => __( 'Admin Approved Message', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'req_approved_msg' ),
				'type'       => 'text',
				'default'    => 'Your request has been accepted by the admin. Please check your email for your reference.',
			),
			array(
				'type'   => 'sectionend',
				'id'     => 'mmp_popup_section',
			),
			array(
				'type'   => 'title',
				'title'  => __( 'Restriction Messages', 'lower-price-for-woocommerce' ),
				'id'     => 'mmp_restriction_section',
			),
			array(
				'title'      => __( 'Per Product Restriction Message', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'per_pro_restriction_msg' ),
				'type'       => 'text',
				'default'    => 'You have already submitted the price match request for this product. Hence you cannot submit no more price differences for this product.',
			),
			array(
				'title'      => __( 'Restriction Per User Message', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'overall_pro_restriction_msg' ),
				'type'       => 'text',
				'default'    => 'Since you have reached the maximum count for notifying Price Difference, you cannot Notify anymore Price Differences.',
			),
			array(
				'type'   => 'sectionend',
				'id'     => 'mmp_restriction_section',
			),
				) ;
	}
}

return new MMP_Messages_Tab() ;
