<?php
/**
 * Lower Price for WooCommerce Main Class
 *
 * @package Lower Price
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Guarntee_For_Woocommerce' ) ) {

	/**
	 * Main Class.
	 * */
	final class MMP_Guarntee_For_Woocommerce {

		/**
		 * Version.
		 *
		 * @var String
		 * */
		private $version = '3.2.0';

		/**
		 * Plugin prefix.
		 *
		 * @var String
		 */
		public $prefix = '_wc_mmp_';

		/**
		 * The single instance of the class.
		 *
		 * @var Object
		 * */
		protected static $instance = null;

		/**
		 * WC minimum version.
		 *
		 * @var string
		 */
		public static $wc_minimum_version = '3.5';

		/**
		 * WP minimum version.
		 *
		 * @var string
		 */
		public static $wp_minimum_version = '4.6';

		/**
		 * Auto-load in-accessible properties on demand.
		 *
		 * @param mixed $key Key name.
		 * @return mixed
		 */
		public function __get( $key ) {
			if ( in_array( $key, array( 'mailer' ), true ) ) {
				return $this->$key();
			}
		}

		/**
		 * Load MMP_Guarntee_For_Woocommerce Class in Single Instance.
		 */
		public static function instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Cloning has been forbidden
		 * */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, 'You are not allowed to perform this action!!!', '1.0' );
		}

		/**
		 * Unserialize the class data has been forbidden.
		 * */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, 'You are not allowed to perform this action!!!', '1.0' );
		}

		/**
		 * Constructor.
		 * */
		public function __construct() {
			/* Include once will help to avoid fatal error by load the files when you call init hook */
			include_once ABSPATH . 'wp-admin/includes/plugin.php';

			$this->header_already_sent_problem();
			$this->define_constants();
			$this->load_plugin_textdomain();
			$this->include_files();
			$this->init_hooks();
		}

		/**
		 * Function to prevent header error that says you have already sent the header.
		 */
		private function header_already_sent_problem() {
			ob_start();
		}

		/**
		 * Prepare the constants value array.
		 * */
		private function define_constants() {
			$constant_array = array(
				'MMP_VERSION'          => $this->version,
				'MMP_LOCALE'           => 'lower-price-for-woocommerce',
				'MMP_FOLDER_NAME'      => 'lower-price-for-woocommerce',
				'MMP_ABSPATH'          => dirname( MMP_PLUGIN_FILE ) . '/',
				'MMP_ADMIN_URL'        => admin_url( 'admin.php' ),
				'MMP_ADMIN_AJAX_URL'   => admin_url( 'admin-ajax.php' ),
				'MMP_PLUGIN_SLUG'      => plugin_basename( MMP_PLUGIN_FILE ),
				'MMP_PLUGIN_PATH'      => untrailingslashit( plugin_dir_path( MMP_PLUGIN_FILE ) ),
				'MMP_PLUGIN_URL'       => untrailingslashit( plugins_url( '/', MMP_PLUGIN_FILE ) ),
				'WC_MMP_PREFIX'        => $this->prefix,
				'WC_MMP_TEMPLATE_PATH' => plugin_dir_path( MMP_PLUGIN_FILE ) . 'templates/',
				'WC_MMP_BASENAME'      => plugin_basename( MMP_PLUGIN_FILE ),
				'WC_MMP_BASENAME_DIR'  => dirname( plugin_basename( MMP_PLUGIN_FILE ) ),
			);

			/**
			 * Define constants.
			 *
			 * @since 1.0
			 */
			$constant_array = apply_filters( 'mmp_define_constants', $constant_array );

			if ( is_array( $constant_array ) && ! empty( $constant_array ) ) {
				foreach ( $constant_array as $name => $value ) {
					$this->define_constant( $name, $value );
				}
			}
		}

		/**
		 * Define the Constants value.
		 *
		 * @since 1.0.0
		 * @param string $name Name of the Constants.
		 * @param mixed  $value Value of the Constants.
		 * */
		private function define_constant( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		/**
		 * Load plugin the translate files.
		 * */
		private function load_plugin_textdomain() {
			if ( function_exists( 'determine_locale' ) ) {
				$locale = determine_locale();
			} else {
				// @todo Remove when start supporting WP 5.0 or later.
				$locale = is_admin() ? get_user_locale() : get_locale();
			}
			/**
			 * Lower price for woocommerce.
			 *
			 * @since 1.0
			 */
			$locale = apply_filters( 'plugin_locale', $locale, 'lower-price-for-woocommerce' );

			unload_textdomain( 'lower-price-for-woocommerce' );
			load_textdomain( 'lower-price-for-woocommerce', WP_LANG_DIR . '/lower-price-for-woocommerce/lower-price-for-woocommerce-' . $locale . '.mo' );
			load_plugin_textdomain( 'lower-price-for-woocommerce', false, dirname( plugin_basename( MMP_PLUGIN_FILE ) ) . '/languages' );
		}

		/**
		 * Include the files.
		 * */
		private function include_files() {
			include_once MMP_ABSPATH . 'inc/class-mmp-install.php';
			include_once MMP_ABSPATH . 'inc/class-mmp-query.php';
			include_once MMP_ABSPATH . 'inc/class-wc-mmp-emails.php';
			include_once MMP_ABSPATH . 'inc/class-mmp-date-time.php';

			include_once MMP_ABSPATH . 'inc/abstracts/class-mmp-settings-page.php';
			include_once MMP_ABSPATH . 'inc/abstracts/class-mmp-post.php';

			include_once MMP_ABSPATH . 'inc/compatibility/class-mmp-compatibility-instances.php';

			include_once MMP_ABSPATH . 'inc/class-mmp-register-post-types.php';
			include_once MMP_ABSPATH . 'inc/class-mmp-register-post-status.php';

			include_once MMP_ABSPATH . 'inc/entity/class-mmp-list.php';
			include_once MMP_ABSPATH . 'inc/entity/class-mmp-form-fields-list.php';
			include_once MMP_ABSPATH . 'inc/class-mmp-order-update.php';

			include_once MMP_ABSPATH . 'inc/mmp-layout-functions.php';
			include_once MMP_ABSPATH . 'inc/mmp-common-functions.php';
			include_once MMP_ABSPATH . 'inc/mmp-post-functions.php';
			include_once MMP_ABSPATH . 'inc/admin/class-mmp-admin-ajax.php';
			include_once MMP_ABSPATH . 'inc/privacy/class-mmp-privacy.php';

			if ( is_admin() ) {
				$this->include_admin_files();
			}

			if ( ! is_admin() || defined( 'DOING_AJAX' ) ) {
				$this->include_frontend_files();
			}
		}

		/**
		 * Include required files.
		 * */
		private function include_admin_files() {
			include_once MMP_ABSPATH . 'inc/admin/class-mmp-admin-assets.php';
			include_once MMP_ABSPATH . 'inc/admin/menu/class-mmp-menu-management.php';
			include_once MMP_ABSPATH . 'inc/admin/class-mmp-post-table.php';
			include_once MMP_ABSPATH . 'inc/admin/class-mmp-form-fields-post-table.php';
		}

		/**
		 * Include admin files.
		 * */
		private function include_frontend_files() {
			include_once MMP_ABSPATH . 'inc/frontend/class-mmp-frontend-assets.php';
			include_once MMP_ABSPATH . 'inc/frontend/class-mmp-handler.php';
			include_once MMP_ABSPATH . 'inc/frontend/class-mmp-restrictions.php';
			include_once MMP_ABSPATH . 'inc/frontend/class-mmp-my-account-handler.php';
		}

		/**
		 * Define the hooks.
		 *
		 * @since 1.0.0
		 * */
		public function init_hooks() {
			// Compatibility with WC HPOS.
			add_action( 'before_woocommerce_init', array( $this, 'declare_compatibility_with_wc_hpos' ) );

			add_action( 'init', array( $this, 'init' ) );

			add_action('plugins_loaded', array( $this, 'plugins_loaded' ));

			// Register the plugin.
			register_activation_hook( MMP_PLUGIN_FILE, array( 'MMP_Install', 'install' ) );
		}

		/**
		 * Declare compatibility with WC HPOS.
		 *
		 * @since 2.6.0
		 * @return void
		 * */
		public function declare_compatibility_with_wc_hpos() {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', MMP_PLUGIN_FILE, true );
			}
		}

		/**
		 * Define the hooks.
		 * */
		public function init() {
			// Load mailer.
			$this->mailer->init();
			WC()->mailer();
		}

		/**
		 * Plugins Loaded.
		 * 
		 * @since 3.2.0
		 * */
		public function plugins_loaded() {
			/**
			 * This hook is used to do extra action before plugin loaded.
			 *
			 * @since 3.2.0
			 */
			do_action('mmp_before_plugin_loaded');

			MMP_Compatibility_Instances::instance();

			/**
			 * This hook is used to do extra action after plugin loaded.
			 *
			 * @since 3.2.0
			 */
			do_action('mmp_after_plugin_loaded');
		}

		/**
		 * Templates.
		 * */
		public function templates() {
			return MMP_PLUGIN_PATH . '/templates/';
		}

		/**
		 * Email Class.
		 *
		 * @return WC_CS_Emails
		 */
		public function mailer() {
			return WC_MMP_Emails::instance();
		}
	}

}
