<?php
/**
 * WPML Compatibility.
 * 
 * @package Lower Price/WPML Compatibility
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_WPML_Compatibility' ) ) {

	/**
	 * Class MMP_WPML_Compatibility.
	 */
	class MMP_WPML_Compatibility extends MMP_Abstract_Compatibility {

		/**
		 * Context
		 *
		 * @var string
		 */
		private $context = 'lower-price-for-woocommerce';

		/**
		 * Class Constructor.
		 */
		public function __construct() {
			$this->id = 'wpml';

			parent::__construct();
		}

		/**
		 * Is plugin enabled?.
		 *
		 * @since 3.2.0
		 * @return bool
		 * */
		public function is_plugin_enabled() {
			return class_exists( 'SitePress' );
		}

		/**
		 * Action
		 */
		public function admin_actions() {
			add_filter( 'mmp_form_field_post_join_query', array( $this, 'inner_join' ));
			add_filter( 'mmp_form_field_post_where_query', array( $this, 'where_query' ));
		}
		
		/**
		 * Action
		 */
		public function actions() {
			// WPML Post Status Add.
			add_filter( 'wpml_tm_dashboard_post_statuses', array( $this, 'add_post_status' ), 10, 3 );
			add_filter( 'wpml_tm_dashboard_post_query_args', array( $this, 'add_post_query' ), 9, 2);
			// Duplicate Post Meta.
			add_action( 'icl_make_duplicate', array( $this, 'sync_form_field_data' ), 10, 4 );
		}

		/**
		 * Add Post Status
		 *
		 * @since 3.2.0
		 * @param Array $post_statuses Post Statuses.
		 * @return Boolean
		 */
		public function inner_join( $join ) {
			global $wpdb;
			$wpdb_ref       = &$wpdb;

			$join .= " INNER JOIN {$wpdb_ref->prefix}icl_translations ON ($wpdb->posts.ID = {$wpdb_ref->prefix}icl_translations.element_id)";

			return $join;
		}

		/**
		 * Add Post Status
		 *
		 * @since 3.2.0
		 * @param Array $post_statuses Post Statuses.
		 * @return Boolean
		 */
		public function where_query( $where ) {
			global $wpdb, $sitepress;
			$wpdb_ref       = &$wpdb;

			$where .= " AND {$wpdb_ref->prefix}icl_translations.language_code = '" . $sitepress->get_current_language() . "'";

			return $where;
		}

		/**
		 * Add Post Status
		 *
		 * @since 3.2.0
		 * @param Array $post_statuses Post Statuses.
		 * @return Boolean
		 */
		public function add_post_status( $post_statuses ) {
			$post_statuses['mmp_disabled']   = esc_html__( 'Disabled', 'lower-price-for-woocommerce' );
			$post_statuses['mmp_enabled'] = esc_html__( 'Enabled', 'lower-price-for-woocommerce' );

			return $post_statuses;
		}

		/**
		 * Add Post Query
		 *
		 * @since 3.2.0
		 * @param Array $post_statuses Post Statuses.
		 * @return Boolean
		 */
		public function add_post_query( $post_args ) {
			$form_field_statuses  = array( 'mmp_disabled', 'mmp_enabled' );
			$all_statuses             = ( isset( $post_args['post_status'] ) ) ? $post_args['post_status'] : array();
			$post_args['post_status'] = array_merge( $all_statuses, $form_field_statuses );

			return $post_args;
		}

		/**
		 * Add Post Query
		 *
		 * @since 3.2.0
		 * @param Array $post_statuses Post Statuses.
		 * @return Boolean
		 */
		public function sync_form_field_data( $master_post_id, $lang, $post_array, $id ) {
			$meta_keys = array( 'mmp_field_name', 'mmp_field_type', 'mmp_field_mandatory' );

			foreach ($meta_keys as $meta_key) {
				update_post_meta( $id, $meta_key, get_post_meta( $master_post_id, $meta_key, true ) );
			}
		}
	}
}
