<?php
/**
 * Customer Acknowledge Email.
 *
 * @package Lower Price for Woocommerce
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WC_MMP_Customer_Ack', false ) ) {

	/**
	 * Account Customer Ack Email.
	 *
	 * @class WC_MMP_Customer_Ack
	 * @package class
	 * @extends WC_MMP_Abstract_Email
	 */
	class WC_MMP_Customer_Ack extends WC_MMP_Abstract_Email {

		/**
		 * List ID.
		 *
		 * @var Integer
		 */
		public $list_id;

		/**
		 * List Obj.
		 *
		 * @var Object
		 */
		public $list_obj;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = WC_MMP_PREFIX . 'customer_ack';
			$this->customer_email = true;
			$this->title          = __( 'Customer Ack', 'lower-price-for-woocommerce' );
			$this->template_html  = 'emails/customer-ack.php';
			$this->template_plain = 'emails/plain/customer-ack.php';
			$this->subject        = __( '{site_title} - Lower Price Request Submitted', 'lower-price-for-woocommerce' );
			$this->heading        = __( 'Customer Acknowledgement', 'lower-price-for-woocommerce' );
			$this->description    = __( 'Customers will receive an email notification when they submit the lower price request & shows the requested details.', 'lower-price-for-woocommerce' );

			// Triggers for this email.
			add_action( 'wc_mmp_customer_ack_notification', array( $this, 'trigger' ) );

			// Call parent constructor.
			parent::__construct();
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args               = parent::get_content_args();
			$content_args['list_id']    = $this->list_id;
			$content_args['list_obj']   = $this->list_obj;
			$content_args['user_name']  = $this->list_obj->get_name();
			$content_args['mmp_pro_id'] = $this->list_obj->get_pro_id();

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @since 1.0.0
		 * @param Integer $entry_id Entry ID.
		 */
		public function trigger( $entry_id ) {
			$list_obj        = mmp_get_entry( $entry_id );
			$this->list_id   = $entry_id;
			$this->list_obj  = $list_obj;
			$this->recipient = $list_obj->get_mail();

			$this->maybe_trigger();
		}
	}

}

return new WC_MMP_Customer_Ack();
