<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WC_MMP_Customer_Sending_Coupon', false ) ) {

	/**
	 * Account Customer Sending Coupon Email.
	 *
	 * @class WC_MMP_Customer_Sending_Coupon
	 * @package class
	 * @extends WC_MMP_Abstract_Email
	 */
	class WC_MMP_Customer_Sending_Coupon extends WC_MMP_Abstract_Email {

		/**
		 * List ID.
		 *
		 * @var Integer
		 */
		public $list_id;

		/**
		 * List Object.
		 *
		 * @var Object
		 */
		public $list_obj;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = WC_MMP_PREFIX . 'customer_sending_coupon';
			$this->customer_email = true;
			$this->title          = __( 'Send Coupon', 'lower-price-for-woocommerce' );
			$this->template_html  = 'emails/customer-sending-coupon.php';
			$this->template_plain = 'emails/plain/customer-sending-coupon.php';
			$this->subject        = __( '{site_title} - Lower Price Request Accepted', 'lower-price-for-woocommerce' );
			$this->heading        = __( 'Sending Coupon', 'lower-price-for-woocommerce' );
			$this->description    = __( 'Customers will receive an email notification with a coupon code when the site admin accepts their submitted request.', 'lower-price-for-woocommerce' );

			// Triggers for this email.
			add_action( 'wc_mmp_customer_sending_coupon_notification', array( $this, 'trigger' ) );

			// Call parent constructor.
			parent::__construct();
		}

		public function get_content_args() {
			$content_args               = parent::get_content_args();
			$content_args['list_id']    = $this->list_id;
			$content_args['list_obj']   = $this->list_obj;
			$content_args['user_name']  = $this->list_obj->get_name();
			$content_args['mmp_pro_id'] = $this->list_obj->get_pro_id();

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 */
		public function trigger( $entry_id ) {
			$list_obj        = mmp_get_entry( $entry_id );
			$this->list_id   = $entry_id;
			$this->list_obj  = $list_obj;
			$this->recipient = $list_obj->get_mail();

			$this->maybe_trigger();
		}
	}

}

return new WC_MMP_Customer_Sending_Coupon();
